/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.api.dto.BaseDTO;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDemandDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.bidding.enumerate.BusinessBillTypeEnum;
import com.els.modules.bidding.service.PurchaseClarificationInfoService;
import com.els.modules.bidding.service.impl.PurchaseClarificationInfoServiceImpl;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.enumerate.EnquiryScopeEnum;
import com.els.modules.enquiry.vo.PurchaseEnquiryItemCheckVO;
import com.els.modules.enquiry.vo.PurchaseEnquiryMessageVO;
import com.els.modules.inquiry.enumerate.EnquiryItemEvaluationStatusEnum;
import com.els.modules.inquiry.enumerate.PricingNoticeEnum;
import com.els.modules.inquiry.enumerate.QualificationReviewEnum;
import com.els.modules.inquiry.enumerate.QuotaWayEnum;
import com.els.modules.inquiry.enumerate.RegretFlagEnum;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.enumerate.SrmPublicScopeEnum;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.enumerate.ReviewStatusEnum;
import com.els.modules.inquiry.qualification.service.PurchaseExecuteReviewService;
import com.els.modules.inquiry.qualification.service.PurchaseQualificationReviewService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMessageRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.logisticspurchase.base.entity.LineDifferenceHead;
import com.els.modules.logisticspurchase.base.entity.SubjectFileHead;
import com.els.modules.logisticspurchase.base.entity.SubjectFileItem;
import com.els.modules.logisticspurchase.base.enumerate.LineSourceTypeEnum;
import com.els.modules.logisticspurchase.base.service.LineDifferenceHeadService;
import com.els.modules.logisticspurchase.base.service.LineDifferenceItemService;
import com.els.modules.logisticspurchase.base.service.SubjectFileHeadService;
import com.els.modules.logisticspurchase.base.service.SubjectFileItemService;
import com.els.modules.logisticspurchase.ebidding.enumerate.EbiddingLpStatusEnum;
import com.els.modules.logisticspurchase.enquiry.entity.EnquirySupplierListLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryItemHisLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.enumerate.EnquiryLpStatusEnum;
import com.els.modules.logisticspurchase.enquiry.mapper.PurchaseEnquiryHeadLpMapper;
import com.els.modules.logisticspurchase.enquiry.mapper.PurchaseEnquiryItemHisLpMapper;
import com.els.modules.logisticspurchase.enquiry.service.EnquirySupplierListLpService;
import com.els.modules.logisticspurchase.enquiry.service.PublicEnquiryLpService;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryItemLpService;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryItemLpService;
import com.els.modules.logisticspurchase.enquiry.service.impl.PublicEnquiryLpServiceImpl;
import com.els.modules.logisticspurchase.enquiry.utils.LpEnquiryJobUtil;
import com.els.modules.logisticspurchase.enquiry.vo.PurchaseEnquiryHeadLpVO;
import com.els.modules.logisticspurchase.enquiry.vo.PurchaseEnquiryPrintLpVO;
import com.els.modules.logisticspurchase.inquiry.entity.PurchaseAwardOpinionLp;
import com.els.modules.logisticspurchase.inquiry.service.PurchaseAwardOpinionLpService;
import com.els.modules.material.api.dto.PurchaseMaterialRelationDTO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.enumerate.PriceRecordTypeEnum;
import com.els.modules.price.api.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.api.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationManageHeadService;
import com.els.modules.rocketMq.util.InitTableMqUtil;
import com.els.modules.rpc.service.InquiryInvokeContractService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.dto.SupplierOrgInfoDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PurchaseEnquiryHeadLpServiceImpl
extends BaseServiceImpl<PurchaseEnquiryHeadLpMapper, PurchaseEnquiryHeadLp>
implements PurchaseEnquiryHeadLpService,
PurchaseExecuteReviewService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEnquiryHeadLpServiceImpl.class);
    @Autowired
    private EnquirySupplierListLpService enquirySupplierListService;
    @Autowired
    private PurchaseEnquiryItemLpService purchaseEnquiryItemService;
    @Autowired
    private SaleEnquiryHeadLpService saleEnquiryHeadService;
    @Autowired
    private SaleEnquiryItemLpService saleEnquiryItemService;
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private PurchaseAwardOpinionLpService purchaseAwardOpinionService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;
    @Autowired
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;
    @Autowired
    @Lazy
    private PurchaseQualificationReviewService purchaseQualificationReviewService;
    @Autowired
    private PurchasePriceEvaluationManageHeadService purchasePriceEvaluationManageHeadService;
    @Autowired
    private InquiryInvokeMessageRpcService inquiryInvokeMessageRpcService;
    @Autowired
    private PurchaseEnquiryItemHisLpMapper purchaseEnquiryItemHisMapper;
    @Autowired
    private InquiryInvokeContractService inquiryInvokeContractService;
    @Autowired
    private LineDifferenceItemService lineDifferenceItemService;
    @Autowired
    private LineDifferenceHeadService lineDifferenceHeadService;
    @Autowired
    private SubjectFileHeadService subjectFileHeadService;
    @Autowired
    private SubjectFileItemService subjectFileItemService;
    private Integer rankCounts = 8;
    @Resource(name="srmPoolExecutor")
    private ThreadPoolExecutor executor;
    private static final String ENQUIRY_QUOTE_END_KEY = "sys:enquiry_quote:end";
    @Autowired
    private RedisUtil redis;

    private void checkMaterialNumber(PurchaseEnquiryHeadLp head, List<PurchaseEnquiryItemLp> itemList) {
        List materialNumbers = itemList.stream().map(PurchaseEnquiryItemLp::getMaterialNumber).collect(Collectors.toList());
        List collect = materialNumbers.stream().filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return;
        }
        List materialNumberList = collect.stream().distinct().collect(Collectors.toList());
        itemList.forEach(item -> {
            if ("1".equals(head.getIsEvaluation())) {
                item.setEvaluationStatus(EnquiryItemEvaluationStatusEnum.WAIT_SUBMIT.getValue());
            } else {
                item.setEvaluationStatus(EnquiryItemEvaluationStatusEnum.NO_EVALUATION.getValue());
            }
        });
    }

    public static void setHeadParamAndCheck(PurchaseEnquiryHeadLpVO headVO, boolean isPublish) {
        String elsAccount = TenantContext.getTenant();
        headVO.setElsAccount(elsAccount);
        headVO.setBusAccount(elsAccount);
        headVO.setEnquiryStatus(isPublish ? EnquiryLpStatusEnum.QUOTING.getValue() : EnquiryLpStatusEnum.NEW.getValue());
        headVO.setResultAuditStatus("1".equals(headVO.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        headVO.setOpenBidStatus("0");
        if (StrUtil.isBlank((CharSequence)headVO.getAccessCategoryFilter())) {
            headVO.setAccessCategoryFilter("0");
        }
        if (isPublish) {
            List<PurchaseAttachmentDemandDTO> demandList;
            int count;
            if (headVO.getEnquiryScope().equals(EnquiryScopeEnum.INVITE.getValue())) {
                headVO.setApplyEndTime(null);
                headVO.setQualificationReview(null);
            }
            if (headVO.getOpenBidBefore().equals("0")) {
                headVO.setOpenBidWord(null);
            }
            Date currentDate = new Date();
            headVO.setPublishTime(currentDate);
            LoginUserDTO user = SysUtil.getLoginUser();
            headVO.setPublishUser(user.getSubAccount() + "_" + user.getRealname());
            headVO.setEnquiryDate(headVO.getEnquiryDate() == null ? currentDate : headVO.getEnquiryDate());
            headVO.setAllowDelay(StrUtil.isBlank((CharSequence)headVO.getAllowDelay()) ? "1" : headVO.getAllowDelay());
            headVO.setEnquiryScope(StrUtil.isBlank((CharSequence)headVO.getEnquiryScope()) ? EnquiryScopeEnum.INVITE.getValue() : headVO.getEnquiryScope());
            Assert.notNull((Object)headVO.getQuoteEndTime(), (String)I18nUtil.translate((String)"i18n_alert_suyRKIxOLV_95472738", (String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((boolean)headVO.getQuoteEndTime().after(currentDate), (String)I18nUtil.translate((String)"i18n_alert_suyRKIlTfUAPKI_7f71245d", (String)"\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
            if (headVO.getQuoteConfirmTime() != null) {
                Assert.isTrue((boolean)headVO.getQuoteConfirmTime().after(currentDate), (String)I18nUtil.translate((String)"i18n_alert_suRLyRKIlTfUAPKI_b336cfd3", (String)"\u62a5\u4ef7\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
                Assert.isTrue((boolean)headVO.getQuoteConfirmTime().before(headVO.getQuoteEndTime()), (String)I18nUtil.translate((String)"i18n__suRLyRKIlTXUsuyRKI_2054aebb", (String)"\u62a5\u4ef7\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4"));
            }
            if (EnquiryScopeEnum.PUBLIC.getValue().equals(headVO.getEnquiryScope())) {
                Assert.notNull((Object)headVO.getApplyEndTime(), (String)I18nUtil.translate((String)"i18n_alert_sRyRKIxOLV_a953b64e", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isTrue((boolean)headVO.getApplyEndTime().after(currentDate), (String)I18nUtil.translate((String)"i18n_alert_sRyRKIlTfUAPKI_8dd43873", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4"));
                Assert.isTrue((boolean)headVO.getApplyEndTime().before(headVO.getQuoteEndTime()), (String)I18nUtil.translate((String)"i18n_alert_sRyRKIlTXUsuyRKI_c93a6f5b", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4"));
                if (headVO.getQuoteConfirmTime() != null) {
                    Assert.isTrue((boolean)headVO.getApplyEndTime().before(headVO.getQuoteConfirmTime()), (String)I18nUtil.translate((String)"i18n_alert_sRyRKIlTXUsuRLyRKI_2748b011", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u62a5\u4ef7\u786e\u8ba4\u622a\u6b62\u65f6\u95f4"));
                }
            }
            if ("1".equals(headVO.getOpenBidBefore())) {
                Assert.hasText((String)headVO.getOpenBidWord(), (String)I18nUtil.translate((String)"i18n_alert_vBwoxOLV_e5606b52", (String)"\u5f00\u6807\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            Assert.notEmpty(headVO.getPurchaseEnquiryItemList(), (String)I18nUtil.translate((String)"i18n_alert_cdIxOLV_e4453e71", (String)"\u884c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a"));
            ArrayList checkLadderList = new ArrayList();
            ArrayList checkCostList = new ArrayList();
            headVO.getPurchaseEnquiryItemList().forEach(item -> {
                PurchaseEnquiryHeadLpServiceImpl.headToItem(headVO, item);
                Assert.notNull((Object)item.getQuotePriceWay(), (String)I18nUtil.translate((String)"i18n_alert_suCKxOLV_4d9cccf8", (String)"\u62a5\u4ef7\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a"));
                if ("1".equals(headVO.getMustMaterialNumber())) {
                    Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_alert_SLAoxOLV_f1cdd68b", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                }
                if (!"1".equals(headVO.getSupplierTaxRate())) {
                    Assert.hasText((String)item.getTaxCode(), (String)I18nUtil.translate((String)"i18n_alert_cVHfoxOLV_76b200bd", (String)"\u884c\u4fe1\u606f\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                    Assert.hasText((String)item.getTaxRate(), (String)I18nUtil.translate((String)"i18n_alert_cVHfIxOLV_379cc943", (String)"\u884c\u4fe1\u606f\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a"));
                }
                if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay()) && StrUtil.isBlank((CharSequence)item.getLadderPriceJson())) {
                    checkLadderList.add(item.getItemNumber());
                } else if (EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay()) && StrUtil.isBlank((CharSequence)item.getCostFormJson())) {
                    checkCostList.add(item.getItemNumber());
                }
                item.setQuoteFlag(headVO.getQuoteConfirmTime() == null ? "1" : "0");
                BigDecimal purchaseCycle = StrUtil.isBlank((CharSequence)item.getPurchaseCycle()) ? null : new BigDecimal(item.getPurchaseCycle());
                Assert.isTrue((purchaseCycle == null || purchaseCycle.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_nRsAlTLiW_d97980b4", (String)"\u91c7\u8d2d\u5468\u671f\u5fc5\u987b\u4e3a\u6b63\u6570"));
                Assert.notNull((Object)item.getRequireQuantity(), (String)I18nUtil.translate((String)"i18n_alert_TVWRxOLV_da85d2b1", (String)"\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
            });
            Assert.isTrue((boolean)CollectionUtil.isEmpty(checkLadderList), (String)I18nUtil.translate((String)"i18n_alert_nWWWWWWcsuCKLyDsuWVGRyDsuWWWW_29e46309", (String)"\u7b2c[${0}]\u884c\u62a5\u4ef7\u65b9\u5f0f\u4e3a\u9636\u68af\u62a5\u4ef7\uff0c\u8bf7\u8bbe\u7f6e\u9636\u68af\u62a5\u4ef7JSON", (String[])new String[]{String.join((CharSequence)",", checkLadderList)}));
            Assert.isTrue((boolean)CollectionUtil.isEmpty(checkCostList), (String)I18nUtil.translate((String)"i18n_alert_nWWWWWWcsuCKLLvsuWVGRLvsuWWWW_15e4ff4f", (String)"\u7b2c[${0}]\u884c\u62a5\u4ef7\u65b9\u5f0f\u4e3a\u6210\u672c\u62a5\u4ef7\uff0c\u8bf7\u8bbe\u7f6e\u6210\u672c\u62a5\u4ef7JSON", (String[])new String[]{String.join((CharSequence)",", checkLadderList)}));
            if (EnquiryScopeEnum.INVITE.getValue().equals(headVO.getEnquiryScope())) {
                Assert.notEmpty(headVO.getEnquirySupplierListList(), (String)I18nUtil.translate((String)"i18n_alert_RdXxOLV_4ed7d39d", (String)"\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a"));
                if (headVO.getParticipateQuantity() != null) {
                    Assert.isTrue((headVO.getEnquirySupplierListList().size() >= headVO.getParticipateQuantity() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_diRdXWRlTfUEUsUWR_fa3da170", (String)"\u6240\u9009\u4f9b\u5e94\u5546\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u53c2\u4e0e\u6570\u91cf"));
                }
            } else {
                Assert.hasText((String)headVO.getEnquiryScope(), (String)I18nUtil.translate((String)"i18n_alert_huvLxOLV_a70c5376", (String)"\u8be2\u4ef7\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a"));
            }
            if ("1".equals(headVO.getAccessCategoryFilter())) {
                Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)headVO.getPurchaseOrg()), (String)I18nUtil.translate((String)"i18n_alert_pSLzARIvRvAKWnRVRlS_ec146c92", (String)"\u6309\u7269\u6599\u5206\u7c7b\u8fc7\u6ee4\u5f00\u5173\u5f00\u542f\u65f6\uff0c\u91c7\u8d2d\u7ec4\u7ec7\u5fc5\u586b"));
            }
            if ("1".equals(headVO.getAccessCategoryFilter()) && CollectionUtil.isNotEmpty(headVO.getEnquirySupplierListList()) && (count = (int)headVO.getPurchaseEnquiryItemList().stream().filter(item -> StrUtil.isBlank((CharSequence)item.getCateCode())).count()) == 0) {
                ArrayList<String> orgDataKeyList = new ArrayList<String>();
                List toElsAccountList = headVO.getEnquirySupplierListList().stream().map(EnquirySupplierListLp::getToElsAccount).distinct().collect(Collectors.toList());
                for (String toElsAccount : toElsAccountList) {
                    orgDataKeyList.add(headVO.getElsAccount() + "&&" + toElsAccount + "&&" + headVO.getPurchaseOrg());
                }
                InquiryInvokeSupplierRpcService bean = (InquiryInvokeSupplierRpcService)SpringContextUtils.getBean(InquiryInvokeSupplierRpcService.class);
                List<SupplierOrgInfoDTO> selectSupplierOrgInfoList = bean.selectSupplierOrgInfoList(orgDataKeyList);
                Map<String, List<SupplierOrgInfoDTO>> supplierOrgInfoMap = selectSupplierOrgInfoList.stream().collect(Collectors.groupingBy(BaseDTO::getElsAccount));
                StringBuilder temp = new StringBuilder();
                List cateCodes = headVO.getPurchaseEnquiryItemList().stream().map(PurchaseEnquiryItemLp::getCateCode).distinct().collect(Collectors.toList());
                int x = 0;
                for (EnquirySupplierListLp enquirySupplierList : headVO.getEnquirySupplierListList()) {
                    List<SupplierOrgInfoDTO> supplierOrgInfoDTOS = supplierOrgInfoMap.get(enquirySupplierList.getToElsAccount());
                    if (supplierOrgInfoDTOS == null || supplierOrgInfoDTOS.size() == 0) {
                        temp.append(x++ == 0 ? " " : "\u3001").append(enquirySupplierList.getSupplierName());
                        continue;
                    }
                    List<String> collect = supplierOrgInfoDTOS.stream().map(SupplierOrgInfoDTO::getAccessCategory).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
                    ArrayList accessCategorys = new ArrayList();
                    collect.forEach(item -> accessCategorys.add(item.contains("_") ? item.split("_")[0] : item));
                    int count1 = (int)accessCategorys.stream().filter(cateCodes::contains).count();
                    if (count1 != 0) continue;
                    temp.append(x++ == 0 ? " " : "\u3001").append(enquirySupplierList.getSupplierName());
                }
                String supplierName = temp.toString();
                if (StrUtil.isNotBlank((CharSequence)supplierName)) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_DJKmWLIAjWprNNARIWWMKRdXShzEuhucWVImhucSLzAURdXjRHWRdXNIWWWWWW_accd07ea", (String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u60a8\u5df2\u542f\u7528\u201c\u6309\u51c6\u5165\u54c1\u7c7b\u8fc7\u6ee4\u201d\uff0c\u5b58\u5728\u4f9b\u5e94\u5546\u65e0\u6cd5\u5206\u914d\u5230\u8be2\u4ef7\u884c\u3002\u8bf7\u68c0\u67e5\u8be2\u4ef7\u884c\u7269\u6599\u5206\u7c7b\u4e0e\u4f9b\u5e94\u5546\u7684\u5173\u7cfb\u3002\u4f9b\u5e94\u5546\u5982\u4e0b\uff1a${0}\u3002", (String[])new String[]{supplierName}));
                }
            }
            if (CollectionUtil.isNotEmpty(demandList = headVO.getPurchaseAttachmentDemandList())) {
                List distinctList = demandList.stream().map(demand -> demand.getFileType() + "_" + demand.getStageType()).distinct().collect(Collectors.toList());
                Assert.isTrue((demandList.size() == distinctList.size() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_eIyOMKVBBITV_8f02f557", (String)"\u540c\u4e00\u9636\u6bb5\u5b58\u5728\u91cd\u590d\u9644\u4ef6\u9700\u6c42"));
                for (PurchaseAttachmentDemandDTO purchaseAttachmentDemandDTO : demandList) {
                    Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)purchaseAttachmentDemandDTO.getFileType()), (String)I18nUtil.translate((String)"i18n_alert_QIAcxOLV_fb9b198f", (String)"\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
                    Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)purchaseAttachmentDemandDTO.getStageType()), (String)I18nUtil.translate((String)"i18n_alert_yOAcxOLV_dd33e77f", (String)"\u9636\u6bb5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
                }
            }
        }
    }

    private static void headToItem(PurchaseEnquiryHeadLp head, PurchaseEnquiryItemLp item) {
        item.setTaxRate(StrUtil.isBlank((CharSequence)item.getTaxRate()) ? head.getTaxRate() : item.getTaxRate());
        item.setTaxCode(StrUtil.isBlank((CharSequence)item.getTaxCode()) ? head.getTaxCode() : item.getTaxCode());
        item.setCurrency(StrUtil.isBlank((CharSequence)item.getCurrency()) ? head.getCurrency() : item.getCurrency());
        item.setEffectiveDate(item.getEffectiveDate() == null ? head.getEffectiveDate() : item.getEffectiveDate());
        item.setExpiryDate(item.getExpiryDate() == null ? head.getExpiryDate() : item.getExpiryDate());
    }

    public void goBackDemand(List<PurchaseEnquiryItemLp> itemList, String status) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            ArrayList<String> idList = new ArrayList<String>();
            List<String> idList1 = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId()) && SourceTypeEnum.REQUEST.getValue().equals(item.getSourceType())).map(PurchaseEnquiryItemLp::getSourceItemId).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(idList1)) {
                idList1.forEach(str -> idList.addAll(Arrays.stream(str.split(",")).collect(Collectors.toList())));
            }
            if (PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue().equals(status) && CollectionUtil.isNotEmpty(idList)) {
                List<String> headIdList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getHeadId())).map(PurchaseEnquiryItemLp::getHeadId).distinct().collect(Collectors.toList());
                List<PurchaseEnquiryItemLp> list = this.purchaseEnquiryItemService.findBySourceItemId(headIdList, idList);
                if (!CollectionUtils.isEmpty(list)) {
                    Map<String, List> collect = list.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId())).collect(Collectors.toMap(PurchaseEnquiryItemLp::getSourceItemId, p -> {
                        ArrayList<PurchaseEnquiryItemLp> enquiryItems = new ArrayList<PurchaseEnquiryItemLp>();
                        enquiryItems.add((PurchaseEnquiryItemLp)((Object)p));
                        return enquiryItems;
                    }, (value1, value2) -> {
                        value1.addAll(value2);
                        return value1;
                    }));
                    Set<String> strings = collect.keySet();
                    ArrayList<String> ListDauctionsBuilt = new ArrayList<String>();
                    ArrayList<String> ListCompletionOfTheAuction = new ArrayList<String>();
                    for (String string : strings) {
                        List purchaseEnquiryItems = collect.get(string);
                        if (purchaseEnquiryItems.isEmpty()) continue;
                        List collect1 = purchaseEnquiryItems.stream().filter(item -> EnquiryLpStatusEnum.ACCEPT.getValue().equals(item.getItemStatus()) && (AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(item.getAuditStatus()) || AuditStatusEnum.AUDIT_FINISH.getValue().equals(item.getAuditStatus()))).collect(Collectors.toList());
                        if (collect1.isEmpty()) {
                            ListDauctionsBuilt.addAll(Arrays.stream(string.split(",")).collect(Collectors.toList()));
                            continue;
                        }
                        ListCompletionOfTheAuction.addAll(Arrays.stream(string.split(",")).collect(Collectors.toList()));
                    }
                    idList.removeAll(ListDauctionsBuilt);
                    idList.removeAll(ListCompletionOfTheAuction);
                    if (!ListDauctionsBuilt.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(ListDauctionsBuilt, PurchaseRequestStatusItemEnum.INQUIRY_BUILT.getValue());
                    }
                    if (!ListCompletionOfTheAuction.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(ListCompletionOfTheAuction, PurchaseRequestStatusItemEnum.INQUIRY_COMPLETED.getValue());
                    }
                    if (!idList.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(idList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                    }
                } else {
                    this.purchaseRequestItemService.updateStatusById(idList, status);
                }
            } else {
                this.purchaseRequestItemService.updateStatusById(idList, status);
            }
        }
    }

    public void goBackDemandUseForDel(List<PurchaseEnquiryItemLp> itemList, String status) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            ArrayList<String> idList = new ArrayList<String>();
            List<String> idList1 = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId()) && SourceTypeEnum.REQUEST.getValue().equals(item.getSourceType())).map(PurchaseEnquiryItemLp::getSourceItemId).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(idList1)) {
                idList1.forEach(str -> idList.addAll(Arrays.stream(str.split(",")).collect(Collectors.toList())));
            }
            if (PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue().equals(status) && CollectionUtil.isNotEmpty(idList)) {
                List<String> headIdList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getHeadId())).map(PurchaseEnquiryItemLp::getHeadId).distinct().collect(Collectors.toList());
                List<PurchaseEnquiryItemLp> list = this.purchaseEnquiryItemService.findBySourceItemId(headIdList, idList);
                if (!CollectionUtils.isEmpty(list)) {
                    Map<String, List> collect = list.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId())).collect(Collectors.toMap(PurchaseEnquiryItemLp::getSourceItemId, p -> {
                        ArrayList<PurchaseEnquiryItemLp> enquiryItems = new ArrayList<PurchaseEnquiryItemLp>();
                        enquiryItems.add((PurchaseEnquiryItemLp)((Object)p));
                        return enquiryItems;
                    }, (value1, value2) -> {
                        value1.addAll(value2);
                        return value1;
                    }));
                    Set<String> strings = collect.keySet();
                    ArrayList<String> ListDauctionsBuilt = new ArrayList<String>();
                    ArrayList<String> ListCompletionOfTheAuction = new ArrayList<String>();
                    for (String string : strings) {
                        List purchaseEnquiryItems = collect.get(string);
                        if (purchaseEnquiryItems.isEmpty()) continue;
                        List collect1 = purchaseEnquiryItems.stream().filter(item -> EnquiryLpStatusEnum.ACCEPT.getValue().equals(item.getItemStatus()) && (AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(item.getAuditStatus()) || AuditStatusEnum.AUDIT_FINISH.getValue().equals(item.getAuditStatus()))).collect(Collectors.toList());
                        if (collect1.isEmpty()) {
                            ListDauctionsBuilt.addAll(Arrays.stream(string.split(",")).collect(Collectors.toList()));
                            continue;
                        }
                        ListCompletionOfTheAuction.addAll(Arrays.stream(string.split(",")).collect(Collectors.toList()));
                    }
                    idList.removeAll(ListDauctionsBuilt);
                    idList.removeAll(ListCompletionOfTheAuction);
                    if (!ListDauctionsBuilt.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(ListDauctionsBuilt, PurchaseRequestStatusItemEnum.INQUIRY_BUILT.getValue());
                    }
                    if (!ListCompletionOfTheAuction.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(ListCompletionOfTheAuction, PurchaseRequestStatusItemEnum.INQUIRY_COMPLETED.getValue());
                    }
                    if (!idList.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(idList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                    }
                } else {
                    ArrayList<PurchaseRequestItem> purchaseRequestItemList = new ArrayList<PurchaseRequestItem>();
                    for (String id : idList) {
                        PurchaseRequestItem purchaseRequestItem = (PurchaseRequestItem)((Object)this.purchaseRequestItemService.getById((Serializable)((Object)id)));
                        purchaseRequestItemList.add(purchaseRequestItem);
                    }
                    if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
                        this.purchaseRequestHeadService.matchPrice(purchaseRequestItemList);
                    }
                }
            } else {
                this.purchaseRequestItemService.updateStatusById(idList, status);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        PurchaseEnquiryHeadLp dbHead = (PurchaseEnquiryHeadLp)((Object)((PurchaseEnquiryHeadLpMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        List<PurchaseEnquiryItemLp> purchaseEnquiryItems = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId());
        this.goBackDemandUseForDel(purchaseEnquiryItems, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        if (StrUtil.isNotBlank((CharSequence)dbHead.getDocumentId())) {
            this.invokeBaseRpcService.delIntegratedDocumentMain("inqueryHeadId", dbHead.getDocumentId(), dbHead.getDocumentParentId(), dbHead.getId());
        }
        this.purchaseEnquiryItemService.deleteByMainId(id);
        this.enquirySupplierListService.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(id);
        ((PurchaseEnquiryHeadLpMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        idList.forEach(this::delMain);
    }

    private void enquiryPublic(PurchaseEnquiryHeadLp head, List<PurchaseEnquiryItemLp> itemList) {
        if (EnquiryScopeEnum.PUBLIC.getValue().equals(head.getEnquiryScope())) {
            String publicScope;
            String string = publicScope = head.getPublicScope() == null ? "" : head.getPublicScope();
            if (publicScope.equals(SrmPublicScopeEnum.SRM.getValue()) || publicScope.equals(SrmPublicScopeEnum.ALL.getValue())) {
                PublicEnquiryLpService publicEnquiryLpService = (PublicEnquiryLpService)SpringContextUtils.getBean(PublicEnquiryLpServiceImpl.class);
            }
        }
    }

    private void handleEnquirySupplierList(PurchaseEnquiryHeadLp head, List<EnquirySupplierListLp> supplierList) {
        if (!CollectionUtils.isEmpty(supplierList)) {
            List<String> toElsAccountList = supplierList.stream().map(EnquirySupplierListLp::getToElsAccount).distinct().collect(Collectors.toList());
            List<SupplierMasterDataDTO> supplierMasterDataDTOS = this.inquiryInvokeSupplierRpcService.selectSupplerList(head.getElsAccount(), toElsAccountList);
            supplierList.forEach(e -> supplierMasterDataDTOS.forEach(a -> {
                if (e.getToElsAccount().equals(a.getToElsAccount())) {
                    e.setNeedCoordination(a.getNeedCoordination());
                }
            }));
        }
    }

    private void updatePurchaseEnquiryHeadLp(PurchaseEnquiryHeadLp head) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(ParentEntity::getId, (Object)head.getId());
        updateWrapper.set(PurchaseEnquiryHeadLp::getApplyEndTime, (Object)head.getApplyEndTime());
        updateWrapper.set(PurchaseEnquiryHeadLp::getQualificationReview, (Object)head.getQualificationReview());
        ((PurchaseEnquiryHeadLpMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    private void insertInitTable(String headId, List<PurchaseEnquiryItemLp> itemList) {
        JSONObject object = new JSONObject();
        object.put("elsAccount", (Object)TenantContext.getTenant());
        object.put("relationId", (Object)headId);
        object.put("businessInfoJson", (Object)JSON.toJSONString(itemList));
        InitTableMqUtil.sendInitMsg(object.toJSONString());
    }

    @Override
    public AttachmentSendDTO publishEnquiry(PurchaseEnquiryHeadLp head, List<PurchaseEnquiryItemLp> itemList, List<EnquirySupplierListLp> supplierList, List<PurchaseAttachmentDemandDTO> demandList, String enterpriseName, String loginSubAccount, boolean isPublic) {
        List<String> toElsAccountList = supplierList.stream().map(EnquirySupplierListLp::getToElsAccount).distinct().collect(Collectors.toList());
        List<String> materialNumberList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getMaterialNumber())).map(PurchaseEnquiryItemLp::getMaterialNumber).distinct().collect(Collectors.toList());
        Map<String, PurchaseMaterialRelationDTO> relationMap = this.inquiryInvokeMainDataRpcService.findByMaterialAndAccount(materialNumberList, toElsAccountList);
        ArrayList<PurchaseEnquiryItemLp> insertItemList = new ArrayList<PurchaseEnquiryItemLp>();
        LoginUserDTO user = SysUtil.getLoginUser();
        Map<Object, Object> supplierOrgInfoMap = new HashMap();
        boolean isAccessCategoryFilter = "1".equals(head.getAccessCategoryFilter());
        if (isAccessCategoryFilter && !isPublic) {
            ArrayList orgDataKeyList = new ArrayList();
            for (String toElsAccount : toElsAccountList) {
                orgDataKeyList.add(head.getElsAccount() + "&&" + toElsAccount + "&&" + head.getPurchaseOrg());
            }
            List<SupplierOrgInfoDTO> selectSupplierOrgInfoList = this.inquiryInvokeSupplierRpcService.selectSupplierOrgInfoList(orgDataKeyList);
            supplierOrgInfoMap = selectSupplierOrgInfoList.stream().collect(Collectors.groupingBy(BaseDTO::getElsAccount));
        }
        for (EnquirySupplierListLp supplier : supplierList) {
            List<Object> assessCategorys = new ArrayList();
            if (CollectionUtil.isNotEmpty(supplierOrgInfoMap)) {
                List supplierOrgInfoDTOS = Optional.ofNullable((List)supplierOrgInfoMap.get(supplier.getToElsAccount())).orElse(new ArrayList());
                assessCategorys = supplierOrgInfoDTOS.stream().map(SupplierOrgInfoDTO::getAccessCategory).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
            }
            supplier.setId(IdWorker.getIdStr());
            supplier.setHeadId(head.getId());
            SysUtil.setSysParam((BaseEntity)supplier, (BaseEntity)head);
            int itemNumber = 1;
            for (PurchaseEnquiryItemLp item2 : itemList) {
                int number = itemNumber++;
                if (!isPublic && isAccessCategoryFilter && StrUtil.isNotBlank((CharSequence)item2.getCateCode())) {
                    boolean flag = false;
                    for (String string : assessCategorys) {
                        String string2 = string.contains("_") ? string.split("_")[0] : string;
                        if (!string2.equals(item2.getCateCode())) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                }
                PurchaseEnquiryItemLp insertItem = new PurchaseEnquiryItemLp();
                BeanUtils.copyProperties((Object)((Object)item2), (Object)((Object)insertItem));
                insertItem.setId(null);
                insertItem.setRelationId(IdWorker.getIdStr());
                insertItem.setHeadId(head.getId());
                insertItem.setSupplierId(supplier.getId());
                insertItem.setEnquiryNumber(head.getEnquiryNumber());
                insertItem.setItemNumber(String.valueOf(number));
                insertItem.setItemStatus(EnquiryLpStatusEnum.QUOTING.getValue());
                insertItem.setAuditStatus("1".equals(head.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                insertItem.setPurchaseName(user.getEnterpriseName());
                insertItem.setToElsAccount(supplier.getToElsAccount());
                insertItem.setSupplierName(supplier.getSupplierName());
                insertItem.setSupplierCode(supplier.getSupplierCode());
                insertItem.setNeedCoordination(supplier.getNeedCoordination());
                if (EnquiryQuoteWayEnum.NORMAL.getValue().equals(item2.getQuotePriceWay())) {
                    insertItem.setLadderPriceJson(null);
                    insertItem.setCostFormJson(null);
                } else if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item2.getQuotePriceWay())) {
                    insertItem.setCostFormJson(null);
                } else {
                    insertItem.setLadderPriceJson(null);
                }
                insertItem.setSendStatus("0");
                if (StrUtil.isNotBlank((CharSequence)item2.getMaterialNumber())) {
                    PurchaseMaterialRelationDTO relation = relationMap.get(item2.getMaterialNumber() + supplier.getToElsAccount());
                    insertItem.setSaleMaterialNumber(relation == null ? null : relation.getSaleMaterialNumber());
                }
                insertItem.setQuoteFlag(head.getQuoteConfirmTime() == null ? "1" : "0");
                insertItem.setQuoteEndTime(head.getQuoteEndTime());
                SysUtil.setSysParam((BaseEntity)insertItem, (BaseEntity)head);
                insertItemList.add(insertItem);
            }
        }
        this.purchaseEnquiryItemService.saveBatch(insertItemList, 2000);
        this.enquirySupplierListService.saveBatch(supplierList, 2000);
        Map<String, SaleEnquiryHeadLp> supplierMap = this.saleEnquiryHeadService.add(head, insertItemList, supplierList, enterpriseName, loginSubAccount);
        HashMap<String, String> idMap = new HashMap<String, String>();
        supplierMap.forEach((key, value) -> idMap.put((String)key, value.getId()));
        this.invokeBaseRpcService.sendPurchaseAttachmentDemandDemand(demandList, head.getId(), "enquiry", idMap);
        AttachmentSendDTO sendDTO = new AttachmentSendDTO();
        sendDTO.setElsAccount(TenantContext.getTenant());
        sendDTO.setHeadId(head.getId());
        HashMap toSend = new HashMap();
        idMap.forEach((key, value) -> toSend.put(value, key));
        sendDTO.setToSend(toSend);
        this.invokeBaseRpcService.sendPurchaseFile(sendDTO, false);
        this.updateQuotedSupplier(head.getId());
        Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(supplierMap);
        super.sendMessage(head.getElsAccount(), "enquiry", "publish", head.getId(), "enquiryLpBusDataServiceImpl", toElsAccountList);
        return sendDTO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishNewSupplier(PurchaseEnquiryHeadLp dbHead, List<EnquirySupplierListLp> chooseSupplierList) {
        String headId = dbHead.getId();
        List hadList = this.enquirySupplierListService.selectByMainId(headId).stream().map(EnquirySupplierListLp::getToElsAccount).distinct().collect(Collectors.toList());
        List<EnquirySupplierListLp> supplierList = chooseSupplierList.stream().filter(supplier -> !hadList.contains(supplier.getToElsAccount())).collect(Collectors.toList());
        Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_APiFjRdOIOhxRrWSTKmhx_fda6d18a", (String)"\u5f53\u524d\u9009\u62e9\u7684\u4f9b\u5e94\u90fd\u5df2\u7ecf\u53d1\u5e03\u8fc7\u4e86\uff0c\u65e0\u9700\u518d\u6b21\u53d1\u5e03"));
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId);
        List itemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEnquiryItemLp.class);
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId);
        LoginUserDTO user = SysUtil.getLoginUser();
        AttachmentSendDTO sendDTO = this.publishEnquiry(dbHead, itemList, supplierList, demandList, user.getEnterpriseName(), user.getSubAccount(), false);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        for (EnquirySupplierListLp supplier2 : supplierList) {
            purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.ENQUIRY.getValue(), dbHead.getEnquiryNumber(), supplier2.getToElsAccount(), supplier2.getSupplierName());
        }
        this.invokeBaseRpcService.sendPurchaseFile(sendDTO, true);
    }

    @Override
    public void updateQuotedSupplier(String headId) {
        List<PurchaseEnquiryItemLp> itemList = this.purchaseEnquiryItemService.selectByMainId(headId);
        long supplierCount = itemList.stream().map(PurchaseEnquiryItemLp::getToElsAccount).distinct().count();
        Map<String, String> itemStatusMap = itemList.stream().collect(Collectors.toMap(PurchaseEnquiryItemLp::getToElsAccount, PurchaseEnquiryItemLp::getItemStatus, (newVal, oldVal) -> EnquiryLpStatusEnum.QUOTED.getValue().equals(newVal) ? newVal : oldVal));
        int quotedCount = 0;
        for (Map.Entry<String, String> entry : itemStatusMap.entrySet()) {
            if (!EnquiryLpStatusEnum.QUOTED.getValue().equals(entry.getValue())) continue;
            ++quotedCount;
        }
        PurchaseEnquiryHeadLp head = new PurchaseEnquiryHeadLp();
        head.setId(headId);
        head.setQuotedSupplier(quotedCount + "/" + supplierCount);
        this.updateById((Object)head);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateQuoteEntTime(PurchaseEnquiryHeadLp dbHead, Date quoteEndTime) {
        PurchaseEnquiryHeadLp updateHead = new PurchaseEnquiryHeadLp();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)updateHead));
        updateHead.setQuoteEndTime(quoteEndTime);
        updateHead.setEnquiryStatus(EnquiryLpStatusEnum.QUOTING.getValue());
        this.updateById((Object)updateHead);
        List<PurchaseEnquiryItemLp> itemList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId());
        itemList.forEach(item -> {
            item.setQuoteEndTime(quoteEndTime);
            if (EnquiryLpStatusEnum.NO_QUOTE.getValue().equals(item.getItemStatus())) {
                item.setItemStatus(EnquiryLpStatusEnum.QUOTING.getValue());
            }
        });
        this.purchaseEnquiryItemService.updateBatchById(itemList);
        List<SaleEnquiryHeadLp> saleHeadList = this.saleEnquiryHeadService.updateQuoteEntTime(dbHead.getId(), quoteEndTime, itemList);
        LpEnquiryJobUtil.updateOrCreateJob(dbHead, quoteEndTime);
        Map<String, SaleEnquiryHeadLp> supplierMap = saleHeadList.stream().collect(Collectors.toMap(ParentEntity::getElsAccount, Function.identity()));
        Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(supplierMap);
        List<EnquirySupplierListLp> supplierList = this.enquirySupplierListService.selectByMainId(dbHead.getId());
        List toElsAccountList = supplierList.stream().map(EnquirySupplierListLp::getToElsAccount).distinct().collect(Collectors.toList());
        super.sendMessage(dbHead.getElsAccount(), "enquiry", "change", dbHead.getId(), "enquiryLpBusDataServiceImpl", toElsAccountList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void openBid(PurchaseEnquiryHeadLp dbHead, boolean isJob) {
        if (!this.redis.tryGetDistributedLock(ENQUIRY_QUOTE_END_KEY, dbHead.getId(), 3600000L)) {
            throw new ELSBootException("\u7cfb\u7edf\u6b63\u5728\u5904\u7406\u8be2\u4ef7\u62a5\u4ef7\u622a\u6b62\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c");
        }
        List<Object> toElsAccountList = new ArrayList();
        List LineDifferenceHeads = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lineDifferenceHeadService.lambdaQuery().eq(LineDifferenceHead::getSourceType, (Object)LineSourceTypeEnum.ENQUIRY_SOURCE.getValue())).eq(LineDifferenceHead::getSourceNumber, (Object)dbHead.getEnquiryNumber())).orderByAsc(LineDifferenceHead::getTotalNetAmount)).list().stream().limit(3L).toList();
        if (!CollectionUtils.isEmpty(LineDifferenceHeads)) {
            toElsAccountList = LineDifferenceHeads.stream().map(LineDifferenceHead::getToElsAccount).collect(Collectors.toList());
        }
        List<SubjectFileItem> SubjectFileItemDTOList = this.subjectFileItemService.selectBySubjectNumber(dbHead.getSubjectNumber(), dbHead.getSubjectYear());
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        if (ObjectUtil.isEmpty((Object)loginUser)) {
            loginUser = new LoginUserDTO();
            loginUser.setElsAccount(dbHead.getElsAccount());
            loginUser.setSubAccount("1001");
        }
        List<Object> finalToElsAccountList = toElsAccountList;
        LoginUserDTO finalLoginUser = loginUser;
        this.executor.execute(() -> {
            LoginUserContext.setUser((LoginUserDTO)finalLoginUser);
            TenantContext.setTenant((String)finalLoginUser.getElsAccount());
            try {
                for (SubjectFileItem SubjectFileItemDTO : SubjectFileItemDTOList) {
                    List purchaseEnquiryItems = this.purchaseEnquiryItemService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"head_id", (Object)dbHead.getId())).eq((Object)"section_number", (Object)SubjectFileItemDTO.getSectionNumber()));
                    Map<String, List<PurchaseEnquiryItemLp>> itemMap = purchaseEnquiryItems.stream().collect(Collectors.groupingBy(item -> item.getSectionNumber() + "_" + item.getArriveProvince()));
                    for (Map.Entry<String, List<PurchaseEnquiryItemLp>> itemListEntry : itemMap.entrySet()) {
                        List<PurchaseEnquiryItemLp> enquiryItemList = itemListEntry.getValue();
                        this.lineDifferenceItemService.generateLineDifferenceItems(dbHead, enquiryItemList, (List<String>)finalToElsAccountList);
                    }
                }
            }
            catch (Exception e) {
                log.error("enquiry_quote_end_failed:", (Throwable)e);
                PurchaseEnquiryHeadLp updateHead = new PurchaseEnquiryHeadLp();
                updateHead.setId(dbHead.getId());
                updateHead.setFbk3(e.getMessage());
                updateHead.setFbk4("0");
                this.updateById((Object)updateHead);
            }
            finally {
                this.redis.releaseDistributedLock(ENQUIRY_QUOTE_END_KEY, dbHead.getId());
                LoginUserContext.clear();
                TenantContext.clear();
            }
        });
        dbHead.setEnquiryStatus(EnquiryLpStatusEnum.BARGAIN.getValue());
        dbHead.setOpenBidStatus("1");
        dbHead.setFbk4("1");
        this.updateById((Object)dbHead);
        this.saleEnquiryHeadService.openBid(dbHead.getId(), null);
        LpEnquiryJobUtil.deleteJob(dbHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void oneAward(PurchaseEnquiryHeadLp dbHead, String optType) {
        ArrayList<PurchaseEnquiryItemLp> awardList = new ArrayList<PurchaseEnquiryItemLp>();
        List<PurchaseEnquiryItemLp> dbItemList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId());
        List<String> statusList = Arrays.asList(EnquiryLpStatusEnum.QUOTED.getValue(), EnquiryLpStatusEnum.RE_QUOTE.getValue(), EnquiryLpStatusEnum.CAN_NOT_QUOTE.getValue(), EnquiryLpStatusEnum.NO_QUOTE.getValue(), EnquiryLpStatusEnum.REGRET.getValue());
        for (PurchaseEnquiryItemLp purchaseEnquiryItemLp : dbItemList) {
            Assert.isTrue((boolean)statusList.contains(purchaseEnquiryItemLp.getItemStatus()), (String)I18nUtil.translate((String)"i18n_alert_tkKmWnWWWWczExiTmtk_e441875f", (String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u7b2c${0}\u884c\u72b6\u6001\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c", (String[])new String[]{purchaseEnquiryItemLp.getItemNumber()}));
            if (!EnquiryLpStatusEnum.REGRET.getValue().equals(purchaseEnquiryItemLp.getItemStatus())) continue;
            Assert.isTrue((boolean)RegretFlagEnum.RE_PRICED.getValue().equals(purchaseEnquiryItemLp.getRegretFlag()), (String)I18nUtil.translate((String)"i18n_alert_tkKmWnWWWWczExiTmtk_e441875f", (String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u7b2c${0}\u884c\u72b6\u6001\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c", (String[])new String[]{purchaseEnquiryItemLp.getItemNumber()}));
        }
        if ("minPrice".equals(optType)) {
            itemMap = dbItemList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemLp::getItemNumber));
            for (Map.Entry<String, List<PurchaseEnquiryItemLp>> entry : itemMap.entrySet()) {
                List<PurchaseEnquiryItemLp> itemList = entry.getValue();
                List needSortList = itemList.stream().filter(item -> item.getPrice() != null && item.getQuoteTime() != null).collect(Collectors.toList());
                List<PurchaseEnquiryItemLp> sortList = needSortList.stream().sorted(Comparator.comparing(PurchaseEnquiryItemLp::getPrice).thenComparing(PurchaseEnquiryItemLp::getQuoteTime)).collect(Collectors.toList());
                this.setItemStatus(sortList, itemList, false);
                awardList.addAll(itemList);
            }
        } else if ("minNetPrice".equals(optType)) {
            itemMap = dbItemList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemLp::getItemNumber));
            for (Map.Entry<String, List<PurchaseEnquiryItemLp>> entry : itemMap.entrySet()) {
                List<PurchaseEnquiryItemLp> itemList = entry.getValue();
                List needSortList = itemList.stream().filter(item -> item.getNetPrice() != null && item.getQuoteTime() != null).collect(Collectors.toList());
                List<PurchaseEnquiryItemLp> sortList = needSortList.stream().sorted(Comparator.comparing(PurchaseEnquiryItemLp::getNetPrice).thenComparing(PurchaseEnquiryItemLp::getQuoteTime)).collect(Collectors.toList());
                this.setItemStatus(sortList, itemList, false);
                awardList.addAll(itemList);
            }
        } else if ("minPackagePrice".equals(optType)) {
            ArrayList packageList = new ArrayList();
            Map<String, List<PurchaseEnquiryItemLp>> map = dbItemList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemLp::getToElsAccount));
            map.forEach((key, value) -> {
                long noQuoteCount = value.stream().filter(item -> item.getQuoteTime() == null || "0".equals(item.getQuotePrice())).count();
                if ((long)value.size() != noQuoteCount) {
                    packageList.addAll(value);
                }
            });
            Map<String, PurchaseEnquiryItemLp> map2 = packageList.stream().collect(Collectors.toMap(PurchaseEnquiryItemLp::getToElsAccount, item -> {
                Assert.notNull((Object)item.getQuoteTime(), (String)I18nUtil.translate((String)"i18n_alert_MKLsuWFWxqfslB_fc032395", (String)"\u5b58\u5728\u672a\u62a5\u4ef7\u6570\u636e\uff0c\u4e0d\u53ef\u6253\u5305\u6388\u6807"));
                Assert.isTrue((boolean)"1".equals(item.getQuotePrice()), (String)I18nUtil.translate((String)"i18n_alert_MKxOsuWFWxqfslB_fafdd6cf", (String)"\u5b58\u5728\u4e0d\u80fd\u62a5\u4ef7\u6570\u636e\uff0c\u4e0d\u53ef\u6253\u5305\u6388\u6807"));
                return item;
            }, (oldVal, newVal) -> {
                Assert.notNull((Object)newVal.getQuoteTime(), (String)I18nUtil.translate((String)"i18n_alert_MKLsuWFWxqfslB_fc032395", (String)"\u5b58\u5728\u672a\u62a5\u4ef7\u6570\u636e\uff0c\u4e0d\u53ef\u6253\u5305\u6388\u6807"));
                Assert.isTrue((boolean)"1".equals(newVal.getQuotePrice()), (String)I18nUtil.translate((String)"i18n_alert_MKxOsuWFWxqfslB_fafdd6cf", (String)"\u5b58\u5728\u4e0d\u80fd\u62a5\u4ef7\u6570\u636e\uff0c\u4e0d\u53ef\u6253\u5305\u6388\u6807"));
                BigDecimal newTaxAmount = newVal.getTaxAmount();
                BigDecimal oldTaxAmount = oldVal.getTaxAmount();
                oldVal.setTaxAmount(oldTaxAmount.add(newTaxAmount));
                return oldVal;
            }));
            ArrayList needSortList = new ArrayList();
            map2.forEach((key, value) -> needSortList.add(value));
            List<PurchaseEnquiryItemLp> sortList = needSortList.stream().sorted(Comparator.comparing(PurchaseEnquiryItemLp::getTaxAmount).thenComparing(PurchaseEnquiryItemLp::getQuoteTime)).collect(Collectors.toList());
            this.setItemStatus(sortList, dbItemList, true);
            awardList.addAll(dbItemList);
        }
        List<String> acceptAccountList = awardList.stream().filter(item -> EnquiryLpStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).map(PurchaseEnquiryItemLp::getToElsAccount).distinct().collect(Collectors.toList());
        this.checkReview(dbHead, acceptAccountList);
        this.purchaseEnquiryItemService.updateBatchById(awardList);
        this.saleEnquiryItemService.oneAward(awardList);
    }

    private void setItemStatus(List<PurchaseEnquiryItemLp> sortList, List<PurchaseEnquiryItemLp> itemList, boolean isPackage) {
        if (CollectionUtil.isNotEmpty(sortList)) {
            PurchaseEnquiryItemLp min = sortList.get(0);
            for (PurchaseEnquiryItemLp item2 : itemList) {
                item2.setRevokeItemStatus(item2.getItemStatus());
                if (isPackage && min.getToElsAccount().equals(item2.getToElsAccount()) || !isPackage && min.getId().equals(item2.getId())) {
                    item2.setQuotaQuantity(item2.getRequireQuantity());
                    item2.setQuotaScale(BigDecimal.valueOf(100L));
                    item2.setItemStatus(EnquiryLpStatusEnum.ACCEPT.getValue());
                    continue;
                }
                item2.setQuotaQuantity(item2.getQuotaQuantity() == null ? null : BigDecimal.ZERO);
                item2.setQuotaScale(item2.getQuotaScale() == null ? null : BigDecimal.ZERO);
                item2.setItemStatus(EnquiryLpStatusEnum.REJECT.getValue());
            }
        } else {
            itemList.forEach(item -> {
                item.setRevokeItemStatus(item.getItemStatus());
                item.setItemStatus(EnquiryLpStatusEnum.REJECT.getValue());
                item.setQuotaQuantity(item.getQuotaQuantity() == null ? null : BigDecimal.ZERO);
                item.setQuotaScale(item.getQuotaScale() == null ? null : BigDecimal.ZERO);
            });
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void accept(PurchaseEnquiryHeadLpVO headVO) {
        List<PurchaseEnquiryItemLp> acceptList;
        PurchaseEnquiryHeadLp dbHead = (PurchaseEnquiryHeadLp)((Object)((PurchaseEnquiryHeadLpMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Assert.isTrue((!EnquiryLpStatusEnum.QUOTING.getValue().equals(dbHead.getEnquiryStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_suLyRWxqtk_598b4d4d", (String)"\u62a5\u4ef7\u672a\u622a\u6b62\uff0c\u4e0d\u53ef\u64cd\u4f5c"));
        List<PurchaseEnquiryItemLp> webList = headVO.getPurchaseEnquiryItemList();
        if (headVO.getPackageOpt().booleanValue()) {
            PurchaseEnquiryItemLp webItem = webList.get(0);
            acceptList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId()).stream().filter(item -> item.getToElsAccount().equals(webItem.getToElsAccount())).collect(Collectors.toList());
            acceptList.forEach(item -> item.setQuotaScale(webItem.getQuotaScale()));
        } else {
            acceptList = webList;
        }
        ArrayList<String> acceptAccountList = new ArrayList<String>();
        acceptList.forEach(item -> {
            acceptAccountList.add(item.getToElsAccount());
            Assert.notNull((Object)item.getPrice(), (String)I18nUtil.translate((String)"i18n_alert_xqylLsujc_6c506190", (String)"\u4e0d\u53ef\u63a5\u53d7\u672a\u62a5\u4ef7\u7684\u884c"));
            List<String> statusList = Arrays.asList(EnquiryLpStatusEnum.QUOTED.getValue(), EnquiryLpStatusEnum.RE_QUOTE.getValue(), EnquiryLpStatusEnum.REGRET.getValue());
            Assert.isTrue((boolean)statusList.contains(item.getItemStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjIsuWssuSIMBncWFqyl_b5d007a9", (String)"\u53ea\u6709\u5df2\u62a5\u4ef7\u3001\u91cd\u62a5\u4ef7\u6216\u5df2\u6094\u6807\u7684\u884c\u6570\u636e\u53ef\u63a5\u53d7"));
            if (EnquiryLpStatusEnum.REGRET.getValue().equals(item.getItemStatus())) {
                Assert.isTrue((boolean)RegretFlagEnum.RE_PRICED.getValue().equals(item.getRegretFlag()), (String)I18nUtil.translate((String)"i18n_alert_RjMBAcLVVIujcWFqyl_7fa156a3", (String)"\u53ea\u6709\u6094\u6807\u7c7b\u578b\u4e3a\u91cd\u65b0\u5b9a\u4ef7\u7684\u884c\u6570\u636e\u53ef\u63a5\u53d7"));
            }
            if (headVO.getPackageOpt().booleanValue() || QuotaWayEnum.SCALE.getValue().equals(dbHead.getQuotaWay())) {
                Assert.notNull((Object)item.getQuotaScale(), (String)I18nUtil.translate((String)"i18n_alert_VSMvzmzl_92ce23e7", (String)"\u8bf7\u586b\u5199\u62c6\u5206\u767e\u5206\u6bd4"));
                if (item.getQuotaScale().compareTo(BigDecimal.ZERO) == 0) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n__vzlvlTfUW_c0c419dc", (String)"\u62c6\u5206\u6bd4\u4f8b\u5fc5\u987b\u5927\u4e8e0"));
                }
                item.setQuotaQuantity(item.getRequireQuantity().multiply(item.getQuotaScale().divide(BigDecimal.valueOf(100L), 2, 4)));
            } else {
                Assert.notNull((Object)item.getQuotaQuantity(), (String)I18nUtil.translate((String)"i18n_alert_VSMvzWRWR_c024a870", (String)"\u8bf7\u586b\u5199\u62c6\u5206\u6570\u91cf\u6570\u503c"));
                if (item.getQuotaQuantity().compareTo(BigDecimal.ZERO) == 0) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_vzWRlTfUW_c553f6b4", (String)"\u62c6\u5206\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
                }
                item.setQuotaScale(item.getQuotaQuantity().divide(item.getRequireQuantity(), 4, 4).multiply(BigDecimal.valueOf(100L)));
            }
            item.setRevokeItemStatus(item.getItemStatus());
            item.setItemStatus(EnquiryLpStatusEnum.ACCEPT.getValue());
        });
        this.checkQuotaNumber(dbHead, webList);
        this.checkReview(dbHead, acceptAccountList);
        this.purchaseEnquiryItemService.updateBatchById(acceptList);
        this.saleEnquiryItemService.accept(acceptList);
    }

    private void checkQuotaNumber(PurchaseEnquiryHeadLp dbHead, List<PurchaseEnquiryItemLp> webList) {
        BigDecimal quotaScale;
        List itemList = this.purchaseEnquiryItemService.list((Wrapper)new QueryWrapper().lambda().eq(PurchaseEnquiryItemLp::getHeadId, (Object)dbHead.getId())).stream().filter(item -> EnquiryLpStatusEnum.ACCEPT.getValue().equals(item.getItemStatus()) && item.getItemNumber().equals(((PurchaseEnquiryItemLp)((Object)((Object)webList.get(0)))).getItemNumber())).collect(Collectors.toList());
        String quotaWay = dbHead.getQuotaWay();
        if (QuotaWayEnum.SCALE.getValue().equals(quotaWay)) {
            if (CollectionUtil.isEmpty(itemList) && (quotaScale = webList.get(0).getQuotaScale()).compareTo(BigDecimal.valueOf(100L)) > 0) {
                String message = I18nUtil.translate((String)"i18n__tkKmWWWWWvzmzlRnBRWWW_5ca1680f", (String)"\u64cd\u4f5c\u5931\u8d25\uff0c${0}\u62c6\u5206\u767e\u5206\u6bd4\u4e4b\u548c\u8d85\u8fc7100", (String[])new String[]{webList.get(0).getMaterialName()});
                throw new ELSBootException(message);
            }
            BigDecimal scaleSum = itemList.stream().filter(item -> item.getQuotaScale() != null).map(PurchaseEnquiryItemLp::getQuotaScale).reduce(BigDecimal.ZERO, BigDecimal::add);
            if ((scaleSum = scaleSum.add(webList.get(0).getQuotaScale())).compareTo(BigDecimal.valueOf(100L)) > 0) {
                String message = I18nUtil.translate((String)"i18n__tkKmWWWWWvzmzlRnBRWWW_5ca1680f", (String)"\u64cd\u4f5c\u5931\u8d25\uff0c${0}\u62c6\u5206\u767e\u5206\u6bd4\u4e4b\u548c\u8d85\u8fc7100", (String[])new String[]{webList.get(0).getMaterialName()});
                throw new ELSBootException(message);
            }
        }
        if (QuotaWayEnum.QUANTITY.getValue().equals(quotaWay)) {
            if (CollectionUtil.isEmpty(itemList)) {
                quotaScale = webList.get(0).getQuotaScale();
                if (quotaScale.compareTo(BigDecimal.valueOf(100L)) > 0) {
                    String message = I18nUtil.translate((String)"i18n_alert_WWWWvzWRRnlTEUTVWR_2f18aa80", (String)"\u64cd\u4f5c\u5931\u8d25\uff0c${0}\u62c6\u5206\u6570\u91cf\u4e4b\u548c\u8d85\u8fc7\u9700\u6c42\u6570\u91cf", (String[])new String[]{webList.get(0).getMaterialName()});
                    throw new ELSBootException(message);
                }
            } else {
                BigDecimal quantitySum = itemList.stream().filter(item -> item.getQuotaQuantity() != null).map(PurchaseEnquiryItemLp::getQuotaQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                if ((quantitySum = quantitySum.add(webList.get(0).getQuotaQuantity())).compareTo(webList.get(0).getRequireQuantity()) > 0) {
                    String message = I18nUtil.translate((String)"i18n_alert_WWWWvzWRRnlTEUTVWR_2f18aa80", (String)"\u64cd\u4f5c\u5931\u8d25\uff0c${0}\u62c6\u5206\u6570\u91cf\u4e4b\u548c\u8d85\u8fc7\u9700\u6c42\u6570\u91cf", (String[])new String[]{webList.get(0).getMaterialName()});
                    throw new ELSBootException(message);
                }
            }
        }
    }

    private void checkReview(PurchaseEnquiryHeadLp dbHead, List<String> acceptAccountList) {
        if (EnquiryScopeEnum.PUBLIC.getValue().equals(dbHead.getEnquiryScope()) && QualificationReviewEnum.BEFORE_QUOTE.getValue().equals(dbHead.getQualificationReview())) {
            List<PurchaseQualificationReview> reviewList = this.purchaseQualificationReviewService.selectByMainId(dbHead.getId());
            Map<String, String> reviewMap = reviewList.stream().collect(Collectors.toMap(PurchaseQualificationReview::getToElsAccount, PurchaseQualificationReview::getReviewStatus, (newVal, oldVal) -> newVal));
            for (String acceptAccount : acceptAccountList) {
                String reviewStatus = reviewMap.get(acceptAccount);
                if (reviewStatus == null) continue;
                if (ReviewStatusEnum.NEW.getValue().equals(reviewStatus)) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWJRLUJWxqylsu_57d83bcc", (String)"${0}\u8d44\u8d28\u672a\u5ba1\u67e5\uff0c\u4e0d\u53ef\u63a5\u53d7\u62a5\u4ef7", (String[])new String[]{acceptAccount}));
                }
                if (!ReviewStatusEnum.REJECT.getValue().equals(reviewStatus)) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWWWJRUJLeRWxqylsu_dc0b3e87", (String)"${0}\u8d44\u8d28\u5ba1\u67e5\u672a\u901a\u8fc7\uff0c\u4e0d\u53ef\u63a5\u53d7\u62a5\u4ef7", (String[])new String[]{acceptAccount}));
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void reject(PurchaseEnquiryHeadLpVO headVO) {
        PurchaseEnquiryHeadLp dbHead = (PurchaseEnquiryHeadLp)((Object)((PurchaseEnquiryHeadLpMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Assert.isTrue((!EnquiryLpStatusEnum.QUOTING.getValue().equals(dbHead.getEnquiryStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_suLyRWxqtk_598b4d4d", (String)"\u62a5\u4ef7\u672a\u622a\u6b62\uff0c\u4e0d\u53ef\u64cd\u4f5c"));
        List<PurchaseEnquiryItemLp> webList = headVO.getPurchaseEnquiryItemList();
        List<PurchaseEnquiryItemLp> rejectList = headVO.getPackageOpt() != false ? this.purchaseEnquiryItemService.selectByMainId(dbHead.getId()).stream().filter(item -> item.getToElsAccount().equals(((PurchaseEnquiryItemLp)((Object)((Object)webList.get(0)))).getToElsAccount())).collect(Collectors.toList()) : webList;
        for (PurchaseEnquiryItemLp item2 : rejectList) {
            List<String> statusList = Arrays.asList(EnquiryLpStatusEnum.QUOTED.getValue(), EnquiryLpStatusEnum.RE_QUOTE.getValue(), EnquiryLpStatusEnum.CAN_NOT_QUOTE.getValue(), EnquiryLpStatusEnum.NO_QUOTE.getValue(), EnquiryLpStatusEnum.REGRET.getValue());
            Assert.isTrue((boolean)statusList.contains(item2.getItemStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjIsuWssuWxOsuWLsuSIMBncWFqFK_79a5934a", (String)"\u53ea\u6709\u5df2\u62a5\u4ef7\u3001\u91cd\u62a5\u4ef7\u3001\u4e0d\u80fd\u62a5\u4ef7\u3001\u672a\u62a5\u4ef7\u6216\u5df2\u6094\u6807\u7684\u884c\u6570\u636e\u53ef\u62d2\u7edd"));
            if (EnquiryLpStatusEnum.REGRET.getValue().equals(item2.getItemStatus())) {
                Assert.isTrue((boolean)RegretFlagEnum.RE_PRICED.getValue().equals(item2.getRegretFlag()), (String)I18nUtil.translate((String)"i18n_alert_RjMBAcLVVIujcWFqFK_7fa1681c", (String)"\u53ea\u6709\u6094\u6807\u7c7b\u578b\u4e3a\u91cd\u65b0\u5b9a\u4ef7\u7684\u884c\u6570\u636e\u53ef\u62d2\u7edd"));
            }
            item2.setQuotaScale(item2.getQuotaScale() == null ? null : BigDecimal.ZERO);
            item2.setQuotaQuantity(item2.getQuotaQuantity() == null ? null : BigDecimal.ZERO);
            item2.setRevokeItemStatus(item2.getItemStatus());
            item2.setItemStatus(EnquiryLpStatusEnum.REJECT.getValue());
        }
        this.purchaseEnquiryItemService.updateBatchById(rejectList);
        this.saleEnquiryItemService.reject(rejectList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void revoke(PurchaseEnquiryHeadLpVO headVO) {
        PurchaseEnquiryHeadLp dbHead = (PurchaseEnquiryHeadLp)((Object)((PurchaseEnquiryHeadLpMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        Assert.isTrue((!EnquiryLpStatusEnum.QUOTING.getValue().equals(dbHead.getEnquiryStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_suLyRWxqtk_598b4d4d", (String)"\u62a5\u4ef7\u672a\u622a\u6b62\uff0c\u4e0d\u53ef\u64cd\u4f5c"));
        List<String> status = Arrays.asList(EnquiryLpStatusEnum.QUOTING.getValue(), EnquiryLpStatusEnum.BARGAIN.getValue(), EnquiryLpStatusEnum.REGRET.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEnquiryStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjsusWIusWIMBntFnqqX_2e0e1c58", (String)"\u53ea\u6709\u62a5\u4ef7\u4e2d\u3001\u8bae\u4ef7\u4e2d\u3001\u5df2\u6094\u6807\u7684\u5355\u636e\u624d\u53ef\u64a4\u9500"));
        List<PurchaseEnquiryItemLp> webList = headVO.getPurchaseEnquiryItemList();
        List<PurchaseEnquiryItemLp> revokeList = headVO.getPackageOpt() != false ? this.purchaseEnquiryItemService.selectByMainId(dbHead.getId()).stream().filter(item -> item.getToElsAccount().equals(((PurchaseEnquiryItemLp)((Object)((Object)webList.get(0)))).getToElsAccount())).collect(Collectors.toList()) : webList;
        revokeList.forEach(item -> {
            String itemStatus = item.getItemStatus();
            boolean flag = EnquiryLpStatusEnum.ACCEPT.getValue().equals(itemStatus) || EnquiryLpStatusEnum.REJECT.getValue().equals(itemStatus);
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"i18n_alert_RqqXylSFKjcVH_8799a284", (String)"\u53ea\u53ef\u64a4\u9500\u63a5\u53d7\u6216\u62d2\u7edd\u7684\u884c\u4fe1\u606f"));
            item.setItemStatus(item.getRevokeItemStatus());
        });
        this.purchaseEnquiryItemService.updateBatchById(revokeList);
        this.saleEnquiryItemService.revoke(revokeList);
    }

    private void updateQuotaAmount(List<PurchaseEnquiryItemLp> itemList) {
        for (PurchaseEnquiryItemLp purchaseEnquiryItem : itemList) {
            if (!EnquiryLpStatusEnum.ACCEPT.getValue().equals(purchaseEnquiryItem.getItemStatus()) || purchaseEnquiryItem.getQuotaQuantity() == null) continue;
            BigDecimal netmultiply = purchaseEnquiryItem.getQuotaQuantity().multiply(purchaseEnquiryItem.getNetPrice());
            BigDecimal taxmultiply = purchaseEnquiryItem.getQuotaQuantity().multiply(purchaseEnquiryItem.getPrice());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseEnquiryItemService.lambdaUpdate().set(PurchaseEnquiryItemLp::getQuotaNetAmount, (Object)netmultiply)).set(PurchaseEnquiryItemLp::getQuotaTaxAmount, (Object)taxmultiply)).eq(ParentEntity::getId, (Object)purchaseEnquiryItem.getId())).update((Object)new PurchaseEnquiryItemLp());
        }
    }

    private void checkQuotaWay(List<PurchaseEnquiryItemLp> itemList, PurchaseEnquiryHeadLp dbHead) {
        Map<String, List<PurchaseEnquiryItemLp>> acceptMap = itemList.stream().filter(item -> EnquiryLpStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).collect(Collectors.groupingBy(PurchaseEnquiryItemLp::getItemNumber));
        ArrayList errorList = new ArrayList();
        acceptMap.forEach((key, value) -> {
            PurchaseEnquiryItemCheckVO vo = new PurchaseEnquiryItemCheckVO();
            BigDecimal quantitySum = value.stream().filter(item -> item.getQuotaQuantity() != null).map(PurchaseEnquiryItemLp::getQuotaQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal scaleSum = value.stream().filter(item -> item.getQuotaScale() != null).map(PurchaseEnquiryItemLp::getQuotaScale).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal requireQuantity = ((PurchaseEnquiryItemLp)((Object)((Object)value.get(0)))).getRequireQuantity();
            BeanUtils.copyProperties(value.get(0), (Object)((Object)vo));
            vo.setQuantitySum(quantitySum);
            vo.setScaleSum(scaleSum);
            if (quantitySum.compareTo(requireQuantity) != 0 && scaleSum.compareTo(BigDecimal.valueOf(100L)) != 0) {
                errorList.add(vo);
            }
        });
        String quotaWay = dbHead.getQuotaWay();
        if (CollectionUtil.isEmpty(errorList)) {
            return;
        }
        if (QuotaWayEnum.SCALE.getValue().equals(quotaWay)) {
            StringBuffer buffer = new StringBuffer();
            errorList.forEach(e -> {
                if (e.getScaleSum().compareTo(BigDecimal.valueOf(100L)) < 0) {
                    buffer.append(I18nUtil.translate((String)"i18n__tkKmWWWWWvzmzlRnXUWWW_85fcd972", (String)"\u64cd\u4f5c\u5931\u8d25\uff0c${0}\u62c6\u5206\u767e\u5206\u6bd4\u4e4b\u548c\u5c0f\u4e8e100", (String[])new String[]{e.getMaterialName()})).append("\r\n");
                } else {
                    buffer.append(I18nUtil.translate((String)"i18n__tkKmWWWWWvzmzlRnBRWWW_5ca1680f", (String)"\u64cd\u4f5c\u5931\u8d25\uff0c${0}\u62c6\u5206\u767e\u5206\u6bd4\u4e4b\u548c\u8d85\u8fc7100", (String[])new String[]{e.getMaterialName()})).append("\r\n");
                }
            });
            String message = buffer.toString();
            throw new ELSBootException(message);
        }
        if (QuotaWayEnum.QUANTITY.getValue().equals(quotaWay)) {
            StringBuffer buffer = new StringBuffer();
            errorList.forEach(e -> {
                if (e.getQuantitySum().compareTo(e.getRequireQuantity()) < 0) {
                    buffer.append(I18nUtil.translate((String)"i18n__tkKm0vzWRRnXUTVWR_7a81248d", (String)"\u64cd\u4f5c\u5931\u8d25\uff0c${0}\u62c6\u5206\u6570\u91cf\u4e4b\u548c\u5c0f\u4e8e\u9700\u6c42\u6570\u91cf", (String[])new String[]{e.getMaterialName()})).append("\r\n");
                } else {
                    buffer.append(I18nUtil.translate((String)"i18n__tkKm0vzWRRnBRTVWR_786e6990", (String)"\u64cd\u4f5c\u5931\u8d25\uff0c${0}\u62c6\u5206\u6570\u91cf\u4e4b\u548c\u8d85\u8fc7\u9700\u6c42\u6570\u91cf", (String[])new String[]{e.getMaterialName()})).append("\r\n");
                }
            });
            String message = buffer.toString();
            throw new ELSBootException(message);
        }
    }

    @Override
    public void priced(PurchaseEnquiryHeadLp dbHead, List<PurchaseEnquiryItemLp> pricedList) {
        Date pricedTime = new Date();
        pricedList.forEach(item -> {
            item.setPricedFlag("1");
            item.setPricedTime(pricedTime);
        });
        this.purchaseEnquiryItemService.updateBatchById(pricedList);
        List<PurchaseEnquiryItemLp> allList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId());
        long pricedCount = allList.stream().filter(item -> "1".equals(item.getPricedFlag())).count();
        dbHead.setEnquiryStatus(pricedCount == (long)allList.size() ? EnquiryLpStatusEnum.PRICED.getValue() : dbHead.getEnquiryStatus());
        if (dbHead.getEnquiryStatus().equals(EnquiryLpStatusEnum.PRICED.getValue())) {
            this.inquiryInvokeMessageRpcService.delNotice(dbHead.getId());
        }
        BigDecimal enquiryAmount = allList.stream().filter(item -> EnquiryLpStatusEnum.ACCEPT.getValue().equals(item.getItemStatus()) && item.getTaxAmount() != null).map(PurchaseEnquiryItemLp::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        dbHead.setEnquiryAmount(enquiryAmount);
        dbHead.setSavingAmount(dbHead.getProjectBudget().subtract(enquiryAmount));
        if (BigDecimal.ZERO.compareTo(dbHead.getProjectBudget()) != 0) {
            dbHead.setSavingRate(dbHead.getSavingAmount().divide(dbHead.getProjectBudget(), 2, 4).multiply(BigDecimal.valueOf(100L)));
        }
        ((PurchaseEnquiryHeadLpMapper)this.baseMapper).updateById((Object)dbHead);
        this.saleEnquiryHeadService.priced(dbHead, pricedList);
        ArrayList<PurchaseEnquiryItemLp> sendMsgList = new ArrayList<PurchaseEnquiryItemLp>();
        if (PricingNoticeEnum.ALL.getValue().equals(dbHead.getPricingNotice())) {
            sendMsgList.addAll(pricedList);
        } else if (PricingNoticeEnum.WIN.getValue().equals(dbHead.getPricingNotice())) {
            sendMsgList.addAll(pricedList.stream().filter(item -> EnquiryLpStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).collect(Collectors.toList()));
        }
        sendMsgList.forEach(item -> item.setKeyWord(SysUtil.getLoginUser().getCompanyName()));
        List<SaleEnquiryHeadLp> saleEnquiryHeads = this.saleEnquiryHeadService.selectByMainId(dbHead.getId());
        Map<String, SaleEnquiryHeadLp> supplierMap = saleEnquiryHeads.stream().collect(Collectors.toMap(ParentEntity::getElsAccount, Function.identity()));
        Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(supplierMap);
        log.info("PurchaseEnquiryHeadLpServiceImpl \u8be2\u4ef7\u5b9a\u4ef7\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff0c\u6570\u91cf:{}", (Object)sendMsgList.size());
        for (PurchaseEnquiryItemLp item2 : sendMsgList) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(item2.getToElsAccount());
            if (EnquiryLpStatusEnum.ACCEPT.getValue().equals(item2.getItemStatus())) {
                super.sendMessage(dbHead.getElsAccount(), "enquiry", "confirm", dbHead.getId(), "enquiryLpBusDataServiceImpl", arrayList);
                continue;
            }
            super.sendMessage(dbHead.getElsAccount(), "enquiry", "quote", dbHead.getId(), "enquiryLpBusDataServiceImpl", arrayList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void reQuote(PurchaseEnquiryHeadLpVO headVO) {
        List<PurchaseEnquiryItemLp> reQuoteList;
        PurchaseEnquiryHeadLp dbHead = (PurchaseEnquiryHeadLp)((Object)this.getById((Serializable)((Object)headVO.getId())));
        Assert.isTrue((!EnquiryLpStatusEnum.QUOTING.getValue().equals(dbHead.getEnquiryStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_suLyRWxqtk_598b4d4d", (String)"\u62a5\u4ef7\u672a\u622a\u6b62\uff0c\u4e0d\u53ef\u64cd\u4f5c"));
        if ("user".equals(headVO.getReQuoteWay())) {
            webItemList = headVO.getPurchaseEnquiryItemList();
            reQuoteList = headVO.getPackageOpt().booleanValue() ? this.purchaseEnquiryItemService.selectByMainId(headVO.getId()).stream().filter(item -> item.getToElsAccount().equals(((PurchaseEnquiryItemLp)((Object)((Object)webItemList.get(0)))).getToElsAccount())).collect(Collectors.toList()) : webItemList;
        } else if ("material".equals(headVO.getReQuoteWay())) {
            webItemList = headVO.getPurchaseEnquiryItemList();
            Assert.notEmpty(webItemList, (String)I18nUtil.translate((String)"i18n_alert_SLVHxOLV_1771ce0e", (String)"\u7269\u6599\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
            List itemNumberList = webItemList.stream().map(PurchaseEnquiryItemLp::getItemNumber).distinct().collect(Collectors.toList());
            reQuoteList = this.purchaseEnquiryItemService.selectByMainId(headVO.getId()).stream().filter(item -> itemNumberList.contains(item.getItemNumber())).collect(Collectors.toList());
        } else if ("supplier".equals(headVO.getReQuoteWay())) {
            List<EnquirySupplierListLp> supplierList = headVO.getEnquirySupplierListList();
            Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_RdXxOLV_4ed7d39d", (String)"\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a"));
            List toElsAccountList = supplierList.stream().map(EnquirySupplierListLp::getToElsAccount).distinct().collect(Collectors.toList());
            reQuoteList = this.purchaseEnquiryItemService.selectByMainId(headVO.getId()).stream().filter(item -> toElsAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
        } else {
            reQuoteList = this.purchaseEnquiryItemService.selectByMainId(headVO.getId());
        }
        Assert.notEmpty(reQuoteList, (String)I18nUtil.translate((String)"i18n_alert_ssujWFcxOLV_e3533a99", (String)"\u91cd\u62a5\u4ef7\u7684\u6570\u636e\u884c\u4e0d\u80fd\u4e3a\u7a7a"));
        reQuoteList.forEach(item -> {
            List<String> statusList = Arrays.asList(EnquiryLpStatusEnum.QUOTED.getValue(), EnquiryLpStatusEnum.CAN_NOT_QUOTE.getValue(), EnquiryLpStatusEnum.NO_QUOTE.getValue(), EnquiryLpStatusEnum.REGRET.getValue());
            Assert.isTrue((boolean)statusList.contains(item.getItemStatus()), (String)I18nUtil.translate((String)"i18n_alert_tkKmWnWWWWczExiTmtk_e441875f", (String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u7b2c${0}\u884c\u72b6\u6001\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c", (String[])new String[]{item.getItemNumber()}));
            if (EnquiryLpStatusEnum.REGRET.getValue().equals(item.getItemStatus())) {
                Assert.isTrue((boolean)RegretFlagEnum.RE_PRICED.getValue().equals(item.getRegretFlag()), (String)I18nUtil.translate((String)"i18n_alert_tkKmWnWWWWczExiTmtk_e441875f", (String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u7b2c${0}\u884c\u72b6\u6001\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c", (String[])new String[]{item.getItemNumber()}));
            }
            item.setItemStatus(EnquiryLpStatusEnum.RE_QUOTE.getValue());
            item.setQuoteEndTime(headVO.getQuoteEndTime());
        });
        this.purchaseEnquiryItemService.updateBatchById(reQuoteList);
        if (EnquiryLpStatusEnum.NO_QUOTE.getValue().equals(dbHead.getEnquiryStatus())) {
            dbHead.setEnquiryStatus(EnquiryLpStatusEnum.BARGAIN.getValue());
            this.updateById((Object)dbHead);
        }
        Map<String, SaleEnquiryHeadLp> supplierMap = this.saleEnquiryHeadService.reQuote(dbHead, reQuoteList);
        List toElsAccount = reQuoteList.stream().map(PurchaseEnquiryItemLp::getToElsAccount).distinct().collect(Collectors.toList());
        Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(supplierMap);
        PurchaseEnquiryMessageVO messageVO = new PurchaseEnquiryMessageVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)messageVO));
        messageVO.setPurchaseCompanyName(SysUtil.getLoginUser().getCompanyName());
        messageVO.setQuoteEndTime(headVO.getQuoteEndTime());
        super.sendMessage(dbHead.getElsAccount(), "enquiry", "reply", dbHead.getId(), "enquiryLpBusDataServiceImpl", toElsAccount);
    }

    private Map<String, JSONObject> getReceiveParamMap(Map<String, SaleEnquiryHeadLp> supplierMap) {
        ConcurrentHashMap<String, JSONObject> receiveParamMap = new ConcurrentHashMap<String, JSONObject>();
        if (CollectionUtil.isNotEmpty(supplierMap)) {
            supplierMap.forEach((key, value) -> {
                JSONObject object = new JSONObject();
                object.put("id", (Object)value.getId());
                object.put("templateNumber", (Object)value.getTemplateNumber());
                object.put("templateVersion", (Object)value.getTemplateVersion());
                object.put("templateAccount", (Object)value.getTemplateAccount());
                object.put("busAccount", (Object)value.getBusAccount());
                object.put("supplierTaxRate", (Object)value.getSupplierTaxRate());
                receiveParamMap.put((String)key, object);
            });
        }
        return receiveParamMap;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancel(PurchaseEnquiryHeadLp dbHead) {
        dbHead.setEnquiryStatus(EnquiryLpStatusEnum.CANCEL.getValue());
        ((PurchaseEnquiryHeadLpMapper)this.baseMapper).updateById((Object)dbHead);
        this.purchaseEnquiryItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEnquiryItemLp::getHeadId, (Object)dbHead.getId())).set(PurchaseEnquiryItemLp::getItemStatus, (Object)EnquiryLpStatusEnum.CANCEL.getValue()));
        this.saleEnquiryHeadService.cancel(dbHead.getId());
        List<PurchaseEnquiryItemLp> itemList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId());
        LpEnquiryJobUtil.deleteJob(dbHead);
        this.inquiryInvokeMessageRpcService.delNotice(dbHead.getId());
        List<SubjectFileHead> subjectFileHeads = this.subjectFileHeadService.selectBySubjectNumber(dbHead.getSubjectNumber(), dbHead.getSubjectYear());
        if (subjectFileHeads.size() > 0) {
            for (SubjectFileHead subjectFileHead : subjectFileHeads) {
                subjectFileHead.setStatus("1");
                this.subjectFileHeadService.updateById((Object)subjectFileHead);
            }
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lineDifferenceHeadService.lambdaUpdate().eq(LineDifferenceHead::getSourceNumber, (Object)dbHead.getEnquiryNumber())).eq(LineDifferenceHead::getSourceType, (Object)LineSourceTypeEnum.ENQUIRY_SOURCE.getValue())).set(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_1)).update();
        this.lineDifferenceItemService.deleteBatchBySourceId(dbHead.getId(), LineSourceTypeEnum.ENQUIRY_SOURCE.getValue());
        this.sendMessage(dbHead, "cancel");
    }

    private void sendMessage(PurchaseEnquiryHeadLp dbHead, String operateType) {
        List<SaleEnquiryHeadLp> saleHeadList = this.saleEnquiryHeadService.selectByMainId(dbHead.getId());
        Map<String, SaleEnquiryHeadLp> supplierMap = saleHeadList.stream().collect(Collectors.toMap(ParentEntity::getElsAccount, Function.identity()));
        Map<String, JSONObject> receiveParamMap = this.getReceiveParamMap(supplierMap);
        List<EnquirySupplierListLp> supplierList = this.enquirySupplierListService.selectByMainId(dbHead.getId());
        List toElsAccountList = supplierList.stream().map(EnquirySupplierListLp::getToElsAccount).distinct().collect(Collectors.toList());
        super.sendMessage(dbHead.getElsAccount(), "enquiry", operateType, dbHead.getId(), "enquiryLpBusDataServiceImpl", toElsAccountList);
    }

    private void regret(PurchaseEnquiryHeadLp dbHead, List<PurchaseEnquiryItemLp> webList, String regretFlag) {
        webList.forEach(item -> {
            item.setItemStatus(EnquiryLpStatusEnum.REGRET.getValue());
            item.setRegretFlag(regretFlag);
            item.setQuotaQuantity(item.getQuotaQuantity() == null ? null : BigDecimal.ZERO);
            item.setQuotaScale(item.getQuotaScale() == null ? null : BigDecimal.ZERO);
            item.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            item.setPricedFlag("0");
            item.setSendStatus("0");
        });
        this.purchaseEnquiryItemService.updateBatchById(webList);
        dbHead.setEnquiryStatus(EnquiryLpStatusEnum.REGRET.getValue());
        ((PurchaseEnquiryHeadLpMapper)this.baseMapper).updateById((Object)dbHead);
        this.saleEnquiryHeadService.regret(dbHead, webList);
        String sourceNumber = dbHead.getEnquiryNumber();
        List<String> itemNumberList = webList.stream().map(PurchaseEnquiryItemLp::getItemNumber).distinct().collect(Collectors.toList());
        this.inquiryInvokeMainDataRpcService.cancelPurchaseInformationBySourceNumber(PriceSourceTypeEnum.ENQUIRY.getValue(), sourceNumber, itemNumberList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void generatePriceRecord(PurchaseEnquiryHeadLp dbHead, List<PurchaseEnquiryItemLp> acceptList) {
        if (CollectionUtil.isNotEmpty(acceptList)) {
            ArrayList<PurchaseInformationRecordsDTO> recordsList = new ArrayList<PurchaseInformationRecordsDTO>();
            for (PurchaseEnquiryItemLp item : acceptList) {
                PurchaseInformationRecordsDTO records = new PurchaseInformationRecordsDTO();
                BeanUtils.copyProperties((Object)((Object)item), (Object)records);
                records.setPurchaseGroup(dbHead.getPurchaseGroup());
                records.setPurchaseOrg(dbHead.getPurchaseOrg());
                records.setCompany(dbHead.getCompany());
                records.setPurchaseUnit(item.getPurchaseUnit());
                records.setSourceId(dbHead.getId());
                records.setSourceItemId(item.getId());
                records.setSourceType(PriceSourceTypeEnum.ENQUIRY.getValue());
                records.setSourceNumber(dbHead.getEnquiryNumber());
                records.setSourceItemNumber(item.getItemNumber());
                records.setRecordType(PriceRecordTypeEnum.STANDARD.getValue());
                records.setCurrencyCode(item.getCurrency());
                records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
                records.setCurrencyCode(item.getCurrency());
                recordsList.add(records);
            }
            this.inquiryInvokeMainDataRpcService.cutOffPriceDates(recordsList);
            this.inquiryInvokeMainDataRpcService.addBatch(recordsList);
            ArrayList<PurchaseEnquiryItemLp> updateList = new ArrayList<PurchaseEnquiryItemLp>();
            for (PurchaseEnquiryItemLp item : acceptList) {
                PurchaseEnquiryItemLp update = new PurchaseEnquiryItemLp();
                update.setId(item.getId());
                update.setSendStatus("1");
                updateList.add(update);
            }
            this.purchaseEnquiryItemService.updateBatchById(updateList);
        }
    }

    @Override
    public void pricingNotice(String headId, String pricingNotice) {
        PurchaseEnquiryHeadLp updateHead = new PurchaseEnquiryHeadLp();
        updateHead.setId(headId);
        updateHead.setPricingNotice(pricingNotice);
        this.updateById((Object)updateHead);
    }

    @Override
    public JSONObject getEnquiryDataById(String id) {
        PurchaseEnquiryHeadLpVO headVO = new PurchaseEnquiryHeadLpVO();
        PurchaseEnquiryHeadLp dbHead = (PurchaseEnquiryHeadLp)((Object)((PurchaseEnquiryHeadLpMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseEnquiryItemLp> dbItemList = this.purchaseEnquiryItemService.selectByMainId(id);
        headVO.setPurchaseEnquiryItemList(dbItemList);
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)headVO, new DictTranslateAspectParam());
        return jsonObject;
    }

    @Override
    public JSONArray getEnquiryDataById(List<String> idList) {
        JSONArray array = new JSONArray();
        for (String id : idList) {
            array.add((Object)this.getEnquiryDataById(id));
        }
        return array;
    }

    @Override
    public void executeReview(PurchaseQualificationReview review) {
        String headId = review.getRelationId();
        PurchaseEnquiryHeadLp dbHead = (PurchaseEnquiryHeadLp)((Object)this.getById((Serializable)((Object)headId)));
        Assert.isTrue((boolean)dbHead.getQuoteEndTime().after(new Date()), (String)I18nUtil.translate((String)"i18n_alert_UJKIIRWxqUJ_b9732d1b", (String)"\u5ba1\u67e5\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u53ef\u5ba1\u67e5"));
        if (QualificationReviewEnum.BEFORE_QUOTE.getValue().equals(dbHead.getQualificationReview())) {
            return;
        }
        LoginUserDTO user = SysUtil.getLoginUser();
        this.executeReview(dbHead, review, user.getEnterpriseName(), user.getSubAccount());
    }

    @Override
    public void executeReview(PurchaseEnquiryHeadLp dbHead, PurchaseQualificationReview review, String enterpriseName, String loginSubAccount) {
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(dbHead.getId());
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseEnquiryItemLp.class);
        ArrayList supplierList = Lists.newArrayList();
        EnquirySupplierListLp supplier = new EnquirySupplierListLp();
        supplier.setToElsAccount(review.getToElsAccount());
        supplier.setSupplierCode(review.getSupplierCode());
        supplier.setSupplierName(review.getSupplierName());
        supplier.setNeedCoordination(review.getNeedCoordination());
        supplierList.add(supplier);
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(dbHead.getId());
        List itemStatusList = this.purchaseEnquiryItemService.selectByMainId(dbHead.getId()).stream().filter(item -> EnquiryLpStatusEnum.NEW.getValue().equals(item.getItemStatus())).map(PurchaseEnquiryItemLp::getItemStatus).distinct().collect(Collectors.toList());
        if (itemStatusList.contains(EbiddingLpStatusEnum.NEW.getValue())) {
            // empty if block
        }
        dbHead.setEnquiryStatus(EnquiryLpStatusEnum.QUOTING.getValue());
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(review.getId());
        purchaseAttachmentList.forEach(attachment -> {
            attachment.setId(null);
            attachment.setHeadId(dbHead.getId());
            attachment.setBusinessType("enquiry");
        });
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        log.info("executeReview->demandList:{}", (Object)JSONObject.toJSONString((Object)demandList));
        AttachmentSendDTO sendVO = this.publishEnquiry(dbHead, initItemList, supplierList, demandList, enterpriseName, loginSubAccount, true);
        this.saveSaleAttachment(purchaseAttachmentList, sendVO);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.ENQUIRY.getValue(), dbHead.getEnquiryNumber(), supplier.getToElsAccount(), supplier.getSupplierName());
    }

    @Override
    public void submitEvaluationPrice(PurchaseEnquiryHeadLpVO headVO) {
        PurchaseEnquiryHeadLp enquiryHead = (PurchaseEnquiryHeadLp)((Object)this.getById((Serializable)((Object)headVO.getId())));
        List<PurchaseEnquiryItemLp> purchaseEnquiryItems = this.purchaseEnquiryItemService.selectByMainId(headVO.getId());
        List purchaseAcceptEnquiryItem = purchaseEnquiryItems.stream().filter(item -> EnquiryLpStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(purchaseAcceptEnquiryItem)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_DJnuKmWhucsBjzELyljc_9e2a2986", (String)"\u63d0\u4ea4\u6838\u4ef7\u5931\u8d25\uff0c\u8be2\u4ef7\u884c\u4e2d\u6ca1\u6709\u72b6\u6001\u4e3a\u63a5\u53d7\u7684\u884c"));
        }
        List waitSubmitItem = purchaseAcceptEnquiryItem.stream().filter(item -> EnquiryItemEvaluationStatusEnum.WAIT_SUBMIT.getValue().equals(item.getEvaluationStatus()) || EnquiryItemEvaluationStatusEnum.EVALUATION_REFUSE.getValue().equals(item.getEvaluationStatus())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(waitSubmitItem)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_DJnuKmWhucsBjnuzEKoDJWnuFKzEjc_8ddd4d95", (String)"\u63d0\u4ea4\u6838\u4ef7\u5931\u8d25\uff0c\u8be2\u4ef7\u884c\u4e2d\u6ca1\u6709\u6838\u4ef7\u72b6\u6001\u662f\u5f85\u63d0\u4ea4/\u6838\u4ef7\u62d2\u7edd\u72b6\u6001\u7684\u884c"));
        }
    }

    private void saveSaleAttachment(List<PurchaseAttachmentDTO> purchaseAttachmentList, AttachmentSendDTO sendVO) {
        ArrayList saleAttachmentDTOList = new ArrayList();
        String saleHeadId = sendVO.getToSend().keySet().stream().findFirst().map(Object::toString).orElse("");
        purchaseAttachmentList.forEach(e -> {
            SaleAttachmentDTO saleAttachmentDTO = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)e, (Object)saleAttachmentDTO);
            saleAttachmentDTO.setHeadId(saleHeadId);
            saleAttachmentDTO.setId(null);
            saleAttachmentDTO.setSendStatus("1");
            saleAttachmentDTOList.add(saleAttachmentDTO);
        });
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentDTOList);
    }

    @Override
    public PurchaseEnquiryPrintLpVO print(String id) {
        PurchaseEnquiryHeadLpVO purchaseEnquiryHeadVO = this.queryById(id);
        PurchaseEnquiryPrintLpVO printVO = new PurchaseEnquiryPrintLpVO();
        BeanUtils.copyProperties((Object)((Object)purchaseEnquiryHeadVO), (Object)((Object)printVO));
        List<PurchaseEnquiryItemLp> purchaseEnquiryItemList = printVO.getPurchaseEnquiryItemList();
        List itemHisList = this.purchaseEnquiryItemHisMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PurchaseEnquiryItemHisLp::getHeadId, (Object)id)).eq(PurchaseEnquiryItemHisLp::getQuoteCount, (Object)1));
        itemHisList = itemHisList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEnquiryItemHisLp>(Comparator.comparing(o -> o.getMaterialNumber() + o.getMaterialDesc() + o.getFactory() + o.getToElsAccount()))), ArrayList::new));
        Map<String, PurchaseEnquiryItemHisLp> enquiryItemHisMap = itemHisList.stream().collect(Collectors.toMap(item -> item.getMaterialNumber() + item.getMaterialDesc() + item.getFactory() + item.getToElsAccount(), Function.identity()));
        List<PurchaseAwardOpinionLp> purchaseAwardOpinionList = printVO.getPurchaseAwardOpinionList();
        StringBuilder pricingInstructions = new StringBuilder();
        for (int i = 0; i < purchaseAwardOpinionList.size(); ++i) {
            pricingInstructions.append(i + 1 + "\u3001" + purchaseAwardOpinionList.get(i).getAwardOpinion() + "\uff1b");
        }
        printVO.setPricingInstructions(pricingInstructions.toString());
        this.assignment(purchaseEnquiryItemList, enquiryItemHisMap);
        this.ranking(purchaseEnquiryItemList);
        printVO.setPurchaseEnquiryItemList(purchaseEnquiryItemList);
        List<EnquirySupplierListLp> enquirySupplierListList = printVO.getEnquirySupplierListList();
        printVO.setSupplierCounts(enquirySupplierListList.size());
        if (!ObjectUtils.isEmpty((Object)printVO.getResultFlowId())) {
            // empty if block
        }
        return printVO;
    }

    @Override
    public void checkEnquirySameMaterial(List<PurchaseEnquiryItemLp> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        Map<String, List<PurchaseEnquiryItemLp>> groupMap = itemList.stream().collect(Collectors.groupingBy(item -> {
            String materialNumber = StrUtil.isNotBlank((CharSequence)item.getMaterialNumber()) ? item.getMaterialNumber() : "";
            String factory = StrUtil.isNotBlank((CharSequence)item.getFactory()) ? item.getFactory() : "";
            String storageLocation = StrUtil.isNotBlank((CharSequence)item.getStorageLocation()) ? item.getStorageLocation() : "";
            return materialNumber + "_" + factory + "_" + storageLocation;
        }));
        groupMap.forEach((key, values) -> {
            if (values.size() > 1) {
                List itemNumber = values.stream().map(PurchaseEnquiryItemLp::getItemNumber).collect(Collectors.toList());
                String msg = "\u884c\u53f7\uff1a${0}\uff0c\u540c\u4e00\u4e2a\u7269\u6599\u540c\u5de5\u5382\u540c\u5e93\u5b58\u5730\u70b9\uff0c\u65e0\u6cd5\u540c\u65f6\u8be2\u4ef7\uff01";
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_Ey0eImSLeRHeGMnCSheKhu_d09d727f", (String)msg, (String[])new String[]{"{" + StrUtil.join((CharSequence)"}\u3001{", itemNumber) + "}"}));
            }
        });
    }

    @Override
    public List<PurchaseEnquiryHeadLpVO> overallRanking() {
        QueryWrapper enquiryHeadQueryWrapper = new QueryWrapper();
        enquiryHeadQueryWrapper.eq((Object)"enquiry_status", (Object)EnquiryLpStatusEnum.BARGAIN.getValue());
        List purchaseEnquiryHeadList = this.list((Wrapper)enquiryHeadQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)purchaseEnquiryHeadList)) {
            throw new ELSBootException("\u672a\u627e\u5230\u6709\u6548\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        List ids = purchaseEnquiryHeadList.stream().map(ParentEntity::getId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"head_id", ids);
        List enquirySupplierListList = this.enquirySupplierListService.list((Wrapper)queryWrapper);
        ArrayList<PurchaseEnquiryHeadLpVO> purchaseEnquiryHeadVOList = new ArrayList<PurchaseEnquiryHeadLpVO>();
        for (PurchaseEnquiryHeadLp purchaseEnquiryHead : purchaseEnquiryHeadList) {
            PurchaseEnquiryHeadLpVO purchaseEnquiryHeadVO = new PurchaseEnquiryHeadLpVO();
            BeanUtils.copyProperties((Object)((Object)purchaseEnquiryHead), (Object)((Object)purchaseEnquiryHeadVO));
            List enquirySupplierLists = enquirySupplierListList.stream().filter(item -> item.getHeadId().equals(purchaseEnquiryHead.getId())).collect(Collectors.toList());
            List supplierListList = enquirySupplierLists.stream().sorted(Comparator.comparing(EnquirySupplierListLp::getTotalNetAmount)).collect(Collectors.toList());
            ArrayList<EnquirySupplierListLp> rankSupplierList = new ArrayList<EnquirySupplierListLp>();
            int i = 1;
            for (EnquirySupplierListLp enquirySupplierList : supplierListList) {
                enquirySupplierList.setFbk1(String.valueOf(i));
                rankSupplierList.add(enquirySupplierList);
                if (++i <= this.rankCounts) continue;
                break;
            }
            purchaseEnquiryHeadVO.setEnquirySupplierListList(rankSupplierList);
            purchaseEnquiryHeadVOList.add(purchaseEnquiryHeadVO);
        }
        return purchaseEnquiryHeadVOList;
    }

    private PurchaseEnquiryHeadLpVO queryById(String headId) {
        PurchaseEnquiryHeadLp dbHead = (PurchaseEnquiryHeadLp)((Object)this.getById((Serializable)((Object)headId)));
        PurchaseEnquiryHeadLpVO headVO = new PurchaseEnquiryHeadLpVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseEnquiryItemLp> itemList = this.purchaseEnquiryItemService.selectByMainId(headId);
        if (!EnquiryLpStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            this.purchaseEnquiryItemService.hideQuotePrice(dbHead, itemList);
        }
        headVO.setPurchaseEnquiryItemList(itemList);
        List<EnquirySupplierListLp> supplierList = this.enquirySupplierListService.selectByMainId(headId);
        headVO.setEnquirySupplierListList(supplierList);
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId);
        headVO.setPurchaseAttachmentDemandList(demandList);
        List<PurchaseAwardOpinionLp> awardOpinionList = this.purchaseAwardOpinionService.selectByMainId(headId);
        headVO.setPurchaseAwardOpinionList(awardOpinionList);
        return headVO;
    }

    private void ranking(List<PurchaseEnquiryItemLp> purchaseEnquiryItemList) {
        Map<String, List<PurchaseEnquiryItemLp>> materialMap = purchaseEnquiryItemList.stream().collect(Collectors.groupingBy(item -> item.getMaterialNumber() + item.getMaterialDesc() + item.getFactory()));
        purchaseEnquiryItemList.clear();
        materialMap.forEach((k, v) -> {
            List itemList = v.stream().sorted(Comparator.comparing(PurchaseEnquiryItemLp::getNetPrice, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
            for (int i = 0; i < itemList.size(); ++i) {
                PurchaseEnquiryItemLp item = (PurchaseEnquiryItemLp)((Object)((Object)itemList.get(i)));
                if (item == null) continue;
                if (item.getNetPrice() != null) {
                    item.setQuoteRank(i + 1);
                }
                purchaseEnquiryItemList.add(item);
            }
        });
    }

    private void assignment(List<PurchaseEnquiryItemLp> purchaseEnquiryItemList, Map<String, PurchaseEnquiryItemHisLp> enquiryItemHisMap) {
        purchaseEnquiryItemList.forEach(item -> {
            PurchaseEnquiryItemHisLp purchaseEnquiryItemHis = (PurchaseEnquiryItemHisLp)((Object)((Object)enquiryItemHisMap.get(item.getMaterialNumber() + item.getMaterialDesc() + item.getFactory() + item.getToElsAccount())));
            item.setFirstQuotePrice(item.getNetPrice() != null ? item.getNetPrice().stripTrailingZeros() : item.getNetPrice());
            if (purchaseEnquiryItemHis != null) {
                item.setFirstQuotePrice(purchaseEnquiryItemHis.getNetPrice() != null ? purchaseEnquiryItemHis.getNetPrice().stripTrailingZeros() : purchaseEnquiryItemHis.getNetPrice());
            }
        });
    }
}

