/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.ebidding.utils.CompareIPUtils;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.logisticspurchase.enquiry.entity.EnquirySupplierListLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryItemHisLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.enumerate.EnquiryLpStatusEnum;
import com.els.modules.logisticspurchase.enquiry.mapper.PurchaseEnquiryItemHisLpMapper;
import com.els.modules.logisticspurchase.enquiry.mapper.PurchaseEnquiryItemLpMapper;
import com.els.modules.logisticspurchase.enquiry.service.EnquirySubstituteItemLpService;
import com.els.modules.logisticspurchase.enquiry.service.EnquirySupplierListLpService;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryItemLpService;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryItemLpService;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PurchaseEnquiryItemLpServiceImpl
extends ServiceImpl<PurchaseEnquiryItemLpMapper, PurchaseEnquiryItemLp>
implements PurchaseEnquiryItemLpService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEnquiryItemLpServiceImpl.class);
    @Autowired
    private SaleEnquiryItemLpService saleEnquiryItemService;
    @Autowired
    private EnquirySupplierListLpService enquirySupplierListService;
    @Autowired
    @Lazy
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private EnquirySubstituteItemLpService enquirySubstituteItemService;
    @Autowired
    private PurchaseEnquiryItemHisLpMapper purchaseEnquiryItemHisMapper;

    @Override
    public List<PurchaseEnquiryItemLp> selectByMainId(String mainId) {
        return ((PurchaseEnquiryItemLpMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseEnquiryItemLpMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public void hideQuotePrice(PurchaseEnquiryHeadLp dbHead, List<PurchaseEnquiryItemLp> itemList) {
        LoginUserDTO loginUser;
        boolean showPrice;
        boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
        if (!showPrice) {
            for (PurchaseEnquiryItemLp item : itemList) {
                Object object2;
                item.setPrice(null);
                item.setNetPrice(null);
                item.setTaxAmount(null);
                item.setNetAmount(null);
                if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())) {
                    JSONArray ladderPriceJson = StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson()) ? JSONArray.parseArray((String)item.getLadderPriceJson()) : new JSONArray();
                    for (Object object2 : ladderPriceJson) {
                        JSONObject ladderItem = (JSONObject)object2;
                        ladderItem.put("price", null);
                        ladderItem.put("netPrice", null);
                        ladderItem.put("taxAmount", null);
                        ladderItem.put("netAmount", null);
                    }
                    item.setLadderPriceJson(ladderPriceJson.toJSONString());
                }
                if (!EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay())) continue;
                JSONObject costFormJson = StrUtil.isNotBlank((CharSequence)item.getCostFormJson()) ? JSONObject.parseObject((String)item.getCostFormJson()) : new JSONObject();
                JSONArray groups = costFormJson.getJSONArray("groups") == null ? new JSONArray() : costFormJson.getJSONArray("groups");
                object2 = groups.iterator();
                while (object2.hasNext()) {
                    Object object3 = object2.next();
                    JSONObject group = (JSONObject)object3;
                    group.put("totalValue", null);
                }
                JSONObject data = costFormJson.getJSONObject("data") == null ? new JSONObject() : costFormJson.getJSONObject("data");
                for (String key : data.keySet()) {
                    data.put(key, (Object)new JSONArray());
                }
                item.setCostFormJson(costFormJson.toJSONString());
            }
        }
        if (!ObjectUtil.isEmpty((Object)(loginUser = SysUtil.getLoginUser())) && !"1001".equals(loginUser.getSubAccount())) {
            for (PurchaseEnquiryItemLp item : itemList) {
                item.setIntervalRatioPrice1(null);
                item.setIntervalRatioPrice2(null);
                item.setIntervalRatioPrice3(null);
                item.setIntervalRatioPrice4(null);
                item.setIntervalRatioNetPrice1(null);
                item.setIntervalRatioNetPrice2(null);
                item.setIntervalRatioNetPrice3(null);
                item.setIntervalRatioNetPrice4(null);
                item.setToDoorPrice(null);
                item.setToDoorNetPrice(null);
                item.setToDoorDate(null);
                item.setToStationPrice(null);
                item.setToStationNetPrice(null);
                item.setToSta(null);
                item.setToDoorTonsPrice(null);
                item.setToDoorTonsNetPrice(null);
                item.setToDoorTonsDate(null);
            }
        }
    }

    @Override
    public void replenishMaterialNumber(PurchaseEnquiryItemLp webItem) {
        List<PurchaseEnquiryItemLp> itemList = this.selectByMainId(webItem.getHeadId());
        this.checkMaterialNumber(webItem, itemList);
        List<PurchaseEnquiryItemLp> items = this.handlePurchaseEnquiyItemList(webItem, itemList);
        this.updateBatchById(items);
        this.saleEnquiryItemService.replenishMaterialNumber(items);
        this.enquirySubstituteItemService.replenishMaterialNumber(items);
        PurchaseEnquiryItemLp item = items.get(0);
        if (SourceTypeEnum.REQUEST.getValue().equals(item.getSourceType()) && StrUtil.isNotBlank((CharSequence)item.getSourceItemId())) {
            this.purchaseRequestItemService.replenishMaterial(item.getSourceItemId(), item.getMaterialNumber(), item.getMaterialDesc(), item.getMaterialGroup(), item.getMaterialSpec());
        }
    }

    private List<PurchaseEnquiryItemLp> handlePurchaseEnquiyItemList(PurchaseEnquiryItemLp webItem, List<PurchaseEnquiryItemLp> itemList) {
        List<PurchaseEnquiryItemLp> items = itemList.stream().filter(item -> item.getItemNumber().equals(webItem.getItemNumber())).collect(Collectors.toList());
        items.forEach(item -> {
            item.setMaterialNumber(webItem.getMaterialNumber());
            item.setMaterialDesc(webItem.getMaterialDesc());
            item.setMaterialGroup(webItem.getMaterialGroup());
            item.setMaterialSpec(webItem.getMaterialSpec());
            item.setMaterialGroupName(webItem.getMaterialGroupName());
        });
        return items;
    }

    private void checkMaterialNumber(PurchaseEnquiryItemLp webItem, List<PurchaseEnquiryItemLp> itemList) {
        List materialNumbers = itemList.stream().map(PurchaseEnquiryItemLp::getMaterialNumber).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(materialNumbers)) {
            return;
        }
        boolean b = materialNumbers.stream().anyMatch(item -> item.equals(webItem.getMaterialNumber()));
        if (b) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n__SLAoxOVB_f1d5e3eb", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u91cd\u590d"));
        }
    }

    @Override
    public void exportCompare(PurchaseEnquiryHeadLp dbHead, HttpServletResponse response) {
        List<PurchaseEnquiryItemLp> itemList = ((PurchaseEnquiryItemLpMapper)this.baseMapper).selectByMainId(dbHead.getId());
        List itemHisList = this.purchaseEnquiryItemHisMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(PurchaseEnquiryItemHisLp::getHeadId, (Object)dbHead.getId()));
        this.hidePriceHis(dbHead, itemHisList);
        this.hideQuotePrice(dbHead, itemList);
        List distinctList = itemList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEnquiryItemLp>(Comparator.comparing(PurchaseEnquiryItemLp::getItemNumber))), ArrayList::new));
        List<EnquirySupplierListLp> supplierList = this.enquirySupplierListService.selectByMainId(dbHead.getId());
        ExcelWriter writer = new ExcelWriter(true, "\u5e38\u89c4\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u540d\u79f0", "\u7269\u6599\u63cf\u8ff0", "\u7269\u6599\u89c4\u683c", "\u9700\u6c42\u6570\u91cf", "\u91c7\u8d2d\u5355\u4f4d", "\u76ee\u6807\u5355\u4ef7", "\u5de5\u5382", "\u5e93\u5b58\u5730\u70b9", "\u5bf9\u6bd4\u9879"));
        int firstRow = 1;
        List<JSONObject> data = this.getDictJsonObjects(distinctList);
        List normalItemList = distinctList.stream().filter(item -> EnquiryQuoteWayEnum.NORMAL.getValue().equals(item.getQuotePriceWay())).collect(Collectors.toList());
        int i = 0;
        for (Object item2 : normalItemList) {
            JSONObject jsonObject = data.get(i);
            log.info("dbResult-JSON:{}, \u91c7\u8d2d\u5355\u4f4d:{}", (Object)jsonObject.toJSONString(), (Object)jsonObject.getString("purchaseUnit_dictText"));
            writer.merge(firstRow, firstRow + 9, 0, 0, (Object)((PurchaseEnquiryItemLp)((Object)item2)).getEnquiryNumber(), false);
            writer.merge(firstRow, firstRow + 9, 1, 1, (Object)((PurchaseEnquiryItemLp)((Object)item2)).getItemNumber(), false);
            writer.merge(firstRow, firstRow + 9, 2, 2, (Object)((PurchaseEnquiryItemLp)((Object)item2)).getMaterialNumber(), false);
            writer.merge(firstRow, firstRow + 9, 3, 3, (Object)((PurchaseEnquiryItemLp)((Object)item2)).getMaterialName(), false);
            writer.merge(firstRow, firstRow + 9, 4, 4, (Object)((PurchaseEnquiryItemLp)((Object)item2)).getMaterialDesc(), false);
            writer.merge(firstRow, firstRow + 9, 5, 5, (Object)((PurchaseEnquiryItemLp)((Object)item2)).getMaterialSpec(), false);
            writer.merge(firstRow, firstRow + 9, 6, 6, (Object)((PurchaseEnquiryItemLp)((Object)item2)).getRequireQuantity(), false);
            writer.merge(firstRow, firstRow + 9, 7, 7, (Object)jsonObject.getString("purchaseUnit_dictText"), false);
            writer.merge(firstRow, firstRow + 9, 8, 8, (Object)((PurchaseEnquiryItemLp)((Object)item2)).getFuturePrice(), false);
            writer.merge(firstRow, firstRow + 9, 9, 9, (Object)jsonObject.getString("factory_dictText"), false);
            writer.merge(firstRow, firstRow + 9, 10, 10, (Object)jsonObject.getString("storageLocation_dictText"), false);
            ++i;
            writer.writeCellValue(11, firstRow, (Object)"\u542b\u7a0e\u4ef7");
            writer.writeCellValue(11, firstRow + 1, (Object)"\u672a\u7a0e\u5355\u4ef7");
            writer.writeCellValue(11, firstRow + 2, (Object)"\u7a0e\u7387");
            writer.writeCellValue(11, firstRow + 3, (Object)"\u4ea4\u8d27\u65e5\u671f");
            writer.writeCellValue(11, firstRow + 4, (Object)"\u62a5\u4ef7\u65f6\u95f4");
            writer.writeCellValue(11, firstRow + 5, (Object)"\u6700\u5c0f\u5305\u88c5\u91cf");
            writer.writeCellValue(11, firstRow + 6, (Object)"\u6700\u5c0f\u8ba2\u5355\u91cf");
            writer.writeCellValue(11, firstRow + 7, (Object)"\u4ef7\u683c\u751f\u6548\u65f6\u95f4");
            writer.writeCellValue(11, firstRow + 8, (Object)"\u4ef7\u683c\u5931\u6548\u65f6\u95f4");
            writer.writeCellValue(11, firstRow + 9, (Object)"\u62a5\u4ef7\u8f6e\u6b21");
            firstRow += 10;
        }
        AtomicInteger x = new AtomicInteger(12);
        if (!CollectionUtils.isEmpty(normalItemList)) {
            for (EnquirySupplierListLp supplier : supplierList) {
                List dataList = itemHisList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).filter(item -> EnquiryQuoteWayEnum.NORMAL.getValue().equals(item.getQuotePriceWay())).collect(Collectors.toList());
                Map<String, List<PurchaseEnquiryItemHisLp>> itemByNumberMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHisLp::getItemNumber));
                AtomicInteger y = new AtomicInteger(1);
                int[] row = new int[]{0};
                AtomicInteger finalX1 = x;
                itemByNumberMap.forEach((itemNumber, v) -> {
                    if (v.size() > row[0]) {
                        row[0] = v.size();
                    }
                    AtomicInteger finalX = new AtomicInteger(finalX1.get());
                    v.forEach(item -> {
                        writer.writeCellValue(finalX.get(), y.get(), (Object)item.getPrice());
                        writer.writeCellValue(finalX.get(), y.get() + 1, (Object)item.getNetPrice());
                        writer.writeCellValue(finalX.get(), y.get() + 2, (Object)item.getTaxRate());
                        writer.writeCellValue(finalX.get(), y.get() + 3, item.getDeliveryDate() == null ? null : DateUtil.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), y.get() + 4, item.getQuoteTime() == null ? null : DateUtil.format((Date)item.getQuoteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                        writer.writeCellValue(finalX.get(), y.get() + 5, (Object)item.getMinPackQuantity());
                        writer.writeCellValue(finalX.get(), y.get() + 6, (Object)item.getMinOrderQuantity());
                        writer.writeCellValue(finalX.get(), y.get() + 7, item.getEffectiveDate() == null ? null : DateUtil.format((Date)item.getEffectiveDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), y.get() + 8, item.getExpiryDate() == null ? null : DateUtil.format((Date)item.getExpiryDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), y.get() + 9, (Object)item.getQuoteCount());
                        writer.setColumnWidth(finalX.get(), 16);
                        finalX.getAndIncrement();
                    });
                    y.addAndGet(10);
                });
                if (row[0] > 1) {
                    writer.merge(0, 0, x.get(), x.addAndGet(row[0]) - 1, (Object)supplier.getSupplierName(), true);
                    continue;
                }
                x.addAndGet(row[0]);
            }
        }
        this.ladderCompare(writer, itemHisList, distinctList, supplierList);
        this.costCompare(writer, itemHisList, distinctList, supplierList);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u6bd4\u4ef7\u62a5\u8868.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        try (ServletOutputStream out = response.getOutputStream();){
            writer.flush((OutputStream)out);
            writer.close();
        }
        catch (IOException e) {
            log.error("IO\u5f02\u5e38:", (Throwable)e);
        }
    }

    private void hidePriceHis(PurchaseEnquiryHeadLp dbHead, List<PurchaseEnquiryItemHisLp> itemHisList) {
        boolean showPrice;
        boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
        if (!showPrice) {
            for (PurchaseEnquiryItemHisLp itemHis : itemHisList) {
                Object object2;
                itemHis.setPrice(null);
                itemHis.setNetPrice(null);
                itemHis.setTaxAmount(null);
                itemHis.setNetAmount(null);
                if (EnquiryQuoteWayEnum.LADDER.getValue().equals(itemHis.getQuotePriceWay())) {
                    JSONArray ladderPriceJson = StrUtil.isNotBlank((CharSequence)itemHis.getLadderPriceJson()) ? JSONArray.parseArray((String)itemHis.getLadderPriceJson()) : new JSONArray();
                    for (Object object2 : ladderPriceJson) {
                        JSONObject ladderItem = (JSONObject)object2;
                        ladderItem.put("price", null);
                        ladderItem.put("netPrice", null);
                        ladderItem.put("taxAmount", null);
                        ladderItem.put("netAmount", null);
                    }
                    itemHis.setLadderPriceJson(ladderPriceJson.toJSONString());
                }
                if (!EnquiryQuoteWayEnum.COST.getValue().equals(itemHis.getQuotePriceWay())) continue;
                JSONObject costFormJson = StrUtil.isNotBlank((CharSequence)itemHis.getCostFormJson()) ? JSONObject.parseObject((String)itemHis.getCostFormJson()) : new JSONObject();
                JSONArray groups = costFormJson.getJSONArray("groups") == null ? new JSONArray() : costFormJson.getJSONArray("groups");
                object2 = groups.iterator();
                while (object2.hasNext()) {
                    Object object3 = object2.next();
                    JSONObject group = (JSONObject)object3;
                    group.put("totalValue", null);
                }
                JSONObject data = costFormJson.getJSONObject("data") == null ? new JSONObject() : costFormJson.getJSONObject("data");
                for (String key : data.keySet()) {
                    data.put(key, (Object)new JSONArray());
                }
                itemHis.setCostFormJson(costFormJson.toJSONString());
            }
        }
    }

    @Override
    public Map<String, Long> getSupplierPortraitCount(String toElsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEnquiryItemLp::getToElsAccount, (Object)toElsAccount);
        queryWrapper.eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        List allList = this.list((Wrapper)queryWrapper);
        long participationCount = allList.stream().map(PurchaseEnquiryItemLp::getHeadId).distinct().count();
        long biddingWinCount = allList.stream().filter(item -> EnquiryLpStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).map(PurchaseEnquiryItemLp::getHeadId).distinct().count();
        HashMap<String, Long> returnMap = new HashMap<String, Long>();
        returnMap.put("participationCount", participationCount);
        returnMap.put("biddingWinCount", biddingWinCount);
        return returnMap;
    }

    @Override
    public List<PurchaseEnquiryItemLp> queryEnquiryByDesc(List<String> materialDescs) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(PurchaseEnquiryItemLp::getItemStatus, new Object[]{EnquiryLpStatusEnum.ACCEPT.getValue(), EnquiryLpStatusEnum.PRICED.getValue()});
        lambdaQueryWrapper.in(PurchaseEnquiryItemLp::getMaterialDesc, materialDescs);
        lambdaQueryWrapper.and(qw -> ((LambdaQueryWrapper)qw.isNull(PurchaseEnquiryItemLp::getMaterialNumber)).or(qw1 -> qw1.eq(PurchaseEnquiryItemLp::getMaterialNumber, (Object)"")));
        return ((PurchaseEnquiryItemLpMapper)this.baseMapper).selectList((Wrapper)lambdaQueryWrapper);
    }

    private void ladderCompare(ExcelWriter writer, List<PurchaseEnquiryItemHisLp> itemHisList, List<PurchaseEnquiryItemLp> distinctList, List<EnquirySupplierListLp> supplierList) {
        writer.setSheet("\u9636\u68af\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u540d\u79f0", "\u7269\u6599\u63cf\u8ff0", "\u7269\u6599\u89c4\u683c", "\u9700\u6c42\u6570\u91cf", "\u91c7\u8d2d\u5355\u4f4d", "\u76ee\u6807\u5355\u4ef7", "\u5de5\u5382", "\u5e93\u5b58\u5730\u70b9", "\u9636\u68af\u7ea7", ""));
        writer.merge(0, 0, 11, 12, (Object)"\u9636\u68af\u6bd4\u4ef7", true);
        int firstRow = 1;
        List<JSONObject> data = this.getDictJsonObjects(distinctList);
        int i = 0;
        for (PurchaseEnquiryItemLp item2 : distinctList) {
            JSONObject jsonObject = data.get(i);
            if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item2.getQuotePriceWay()) && StrUtil.isNotBlank((CharSequence)item2.getLadderPriceJson())) {
                JSONArray array = JSONArray.parseArray((String)item2.getLadderPriceJson());
                this.mergeCell(writer, firstRow, array, item2, jsonObject);
                for (int index = 0; index < array.size(); ++index) {
                    JSONObject ladder = array.getJSONObject(index);
                    writer.writeCellValue(12, firstRow + index, (Object)ladder.getString("ladder"));
                }
                int index2 = 0;
                for (int index = array.size(); index < array.size() * 2; ++index) {
                    JSONObject ladder = array.getJSONObject(index2);
                    writer.writeCellValue(12, firstRow + index, (Object)ladder.getString("ladder"));
                    ++index2;
                }
                int rows = array.size() * 2 + 8;
                firstRow += rows;
            }
            ++i;
        }
        AtomicInteger x = new AtomicInteger(13);
        for (EnquirySupplierListLp supplier : supplierList) {
            List dataList = itemHisList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson())).filter(item -> EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
            Map<String, List<PurchaseEnquiryItemHisLp>> itemByNumberMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHisLp::getItemNumber));
            AtomicInteger y = new AtomicInteger(1);
            int[] row = new int[]{0};
            AtomicInteger finalX1 = x;
            itemByNumberMap.forEach((itemNumber, v) -> {
                if (v.size() > row[0]) {
                    row[0] = v.size();
                }
                JSONArray array1 = JSONArray.parseArray((String)((PurchaseEnquiryItemHisLp)((Object)((Object)v.get(0)))).getLadderPriceJson());
                int size = array1.size();
                AtomicInteger finalX = new AtomicInteger(finalX1.get());
                v.forEach(item -> {
                    JSONArray array = JSONArray.parseArray((String)item.getLadderPriceJson());
                    for (int index = 0; index < array.size(); ++index) {
                        JSONObject ladder = array.getJSONObject(index);
                        writer.writeCellValue(finalX.get(), y.get() + index, (Object)ladder.getBigDecimal("price"));
                    }
                    int index2 = 0;
                    for (int index = array.size(); index < array.size() * 2; ++index) {
                        JSONObject ladder = array.getJSONObject(index2);
                        writer.writeCellValue(finalX.get(), y.get() + index, (Object)ladder.getBigDecimal("netPrice"));
                        ++index2;
                    }
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2, (Object)item.getTaxRate());
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 1, item.getDeliveryDate() == null ? null : DateUtil.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd"));
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 2, item.getQuoteTime() == null ? null : DateUtil.format((Date)item.getQuoteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 3, (Object)item.getMinPackQuantity());
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 4, (Object)item.getMinOrderQuantity());
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 5, item.getEffectiveDate() == null ? null : DateUtil.format((Date)item.getEffectiveDate(), (String)"yyyy-MM-dd"));
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 6, item.getExpiryDate() == null ? null : DateUtil.format((Date)item.getExpiryDate(), (String)"yyyy-MM-dd"));
                    writer.writeCellValue(finalX.get(), y.get() + array.size() * 2 + 7, (Object)item.getQuoteCount());
                    writer.setColumnWidth(finalX.get(), 16);
                    finalX.getAndIncrement();
                });
                int rows = size * 2 + 8;
                y.addAndGet(rows);
            });
            if (row[0] > 1) {
                writer.merge(0, 0, x.get(), x.addAndGet(row[0]) - 1, (Object)supplier.getSupplierName(), true);
                continue;
            }
            x.addAndGet(row[0]);
        }
    }

    private List<JSONObject> getDictJsonObjects(List<PurchaseEnquiryItemLp> distinctList) {
        ArrayList itemList1 = new ArrayList();
        distinctList.forEach(e -> {
            PurchaseEnquiryItemLp item = new PurchaseEnquiryItemLp();
            BeanUtils.copyProperties((Object)e, (Object)((Object)item));
            itemList1.add(item);
        });
        Result dbResult = Result.ok(itemList1);
        ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)dbResult, new DictTranslateAspectParam());
        return (List)dbResult.getResult();
    }

    private void costCompare(ExcelWriter writer, List<PurchaseEnquiryItemHisLp> itemHisList, List<PurchaseEnquiryItemLp> distinctList, List<EnquirySupplierListLp> supplierList) {
        writer.setSheet("\u6210\u672c\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u540d\u79f0", "\u7269\u6599\u63cf\u8ff0", "\u7269\u6599\u89c4\u683c", "\u9700\u6c42\u6570\u91cf", "\u91c7\u8d2d\u5355\u4f4d", "\u76ee\u6807\u5355\u4ef7", "\u5de5\u5382", "\u5e93\u5b58\u5730\u70b9", "\u6210\u672c\u9879", ""));
        writer.merge(0, 0, 11, 12, (Object)"\u6210\u672c\u9879", true);
        int firstRow = 1;
        int i = 0;
        List distinctList1 = distinctList.stream().filter(item -> EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay()) && CharSequenceUtil.isNotBlank((CharSequence)item.getCostFormJson()) && !ObjectUtils.isEmpty((Object)JSON.parseObject((String)item.getCostFormJson()).getJSONArray("groups"))).sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEnquiryItemLp>(Comparator.comparing(PurchaseEnquiryItemLp::getItemNumber))), ArrayList::new));
        List<JSONObject> data = this.getDictJsonObjects(distinctList1);
        for (PurchaseEnquiryItemLp item2 : distinctList1) {
            JSONObject dictJsonObject = data.get(i);
            if (EnquiryQuoteWayEnum.COST.getValue().equals(item2.getQuotePriceWay()) && CharSequenceUtil.isNotBlank((CharSequence)item2.getCostFormJson())) {
                JSONObject jsonObject = JSON.parseObject((String)item2.getCostFormJson());
                log.info("costCompare-jsonObject:{}", (Object)jsonObject.toJSONString());
                JSONArray groups = jsonObject.getJSONArray("groups");
                if (groups != null) {
                    this.mergeCell(writer, firstRow, groups, item2, dictJsonObject);
                    for (int index = 0; index < groups.size(); ++index) {
                        JSONObject group = groups.getJSONObject(index);
                        writer.writeCellValue(12, firstRow + index, (Object)group.getString("groupName"));
                    }
                    int index2 = 0;
                    for (int index = groups.size(); index < groups.size() * 2; ++index) {
                        JSONObject group = groups.getJSONObject(index2);
                        writer.writeCellValue(12, firstRow + index, (Object)group.getString("groupName"));
                        ++index2;
                    }
                    int rows = groups.size() * 2 + 8;
                    firstRow += rows;
                }
            }
            ++i;
        }
        AtomicInteger x = new AtomicInteger(13);
        for (EnquirySupplierListLp supplier : supplierList) {
            List dataList = itemHisList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> StrUtil.isNotBlank((CharSequence)item.getCostFormJson())).filter(item -> EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay())).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
            Map<String, List<PurchaseEnquiryItemHisLp>> itemByNumberMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHisLp::getItemNumber));
            AtomicInteger y = new AtomicInteger(1);
            int[] row = new int[]{0};
            AtomicInteger finalX1 = x;
            itemByNumberMap.forEach((itemNumber, v) -> {
                JSONObject jsonObject1;
                if (v.size() > row[0]) {
                    row[0] = v.size();
                }
                JSONArray groups1 = (jsonObject1 = JSONObject.parseObject((String)((PurchaseEnquiryItemHisLp)((Object)((Object)v.get(0)))).getCostFormJson())).getJSONArray("groups") == null ? new JSONArray() : jsonObject1.getJSONArray("groups");
                int size = groups1.size();
                AtomicInteger finalX = new AtomicInteger(finalX1.get());
                v.forEach(item -> {
                    JSONObject jsonObject = JSONObject.parseObject((String)item.getCostFormJson());
                    JSONArray groups = jsonObject.getJSONArray("groups") == null ? new JSONArray() : jsonObject.getJSONArray("groups");
                    for (int index = 0; index < groups.size(); ++index) {
                        JSONObject group = groups.getJSONObject(index);
                        writer.writeCellValue(finalX.get(), y.get() + index, (Object)group.getBigDecimal("totalValue"));
                    }
                    int index2 = 0;
                    for (int index = groups.size(); index < groups.size() * 2; ++index) {
                        JSONObject group = groups.getJSONObject(index2);
                        writer.writeCellValue(finalX.get(), y.get() + index, (Object)group.getBigDecimal("netPrice"));
                        ++index2;
                    }
                    if (!groups.isEmpty()) {
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2, (Object)item.getTaxRate());
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 1, item.getDeliveryDate() == null ? null : DateUtil.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 2, item.getQuoteTime() == null ? null : DateUtil.format((Date)item.getQuoteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 3, (Object)item.getMinPackQuantity());
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 4, (Object)item.getMinOrderQuantity());
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 5, item.getEffectiveDate() == null ? null : DateUtil.format((Date)item.getEffectiveDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 6, item.getExpiryDate() == null ? null : DateUtil.format((Date)item.getExpiryDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), y.get() + groups.size() * 2 + 7, (Object)item.getQuoteCount());
                        writer.setColumnWidth(finalX.get(), 16);
                        finalX.getAndIncrement();
                    }
                });
                int rows = size * 2 + 8;
                y.addAndGet(rows);
            });
            if (row[0] > 1) {
                writer.merge(0, 0, x.get(), x.addAndGet(row[0]) - 1, (Object)supplier.getSupplierName(), true);
                continue;
            }
            x.addAndGet(row[0]);
        }
    }

    private void mergeCell(ExcelWriter writer, int firstRow, JSONArray ladderOrGroups, PurchaseEnquiryItemLp item, JSONObject jsonObject) {
        if (ladderOrGroups.size() > 1) {
            writer.merge(firstRow, 8 + firstRow + ladderOrGroups.size() * 2 - 1, 0, 0, (Object)item.getEnquiryNumber(), false);
            writer.merge(firstRow, 8 + firstRow + ladderOrGroups.size() * 2 - 1, 1, 1, (Object)item.getItemNumber(), false);
            writer.merge(firstRow, 8 + firstRow + ladderOrGroups.size() * 2 - 1, 2, 2, (Object)item.getMaterialNumber(), false);
            writer.merge(firstRow, 8 + firstRow + ladderOrGroups.size() * 2 - 1, 3, 3, (Object)item.getMaterialName(), false);
            writer.merge(firstRow, 8 + firstRow + ladderOrGroups.size() * 2 - 1, 4, 4, (Object)item.getMaterialDesc(), false);
            writer.merge(firstRow, 8 + firstRow + ladderOrGroups.size() * 2 - 1, 5, 5, (Object)item.getMaterialSpec(), false);
            writer.merge(firstRow, 8 + firstRow + ladderOrGroups.size() * 2 - 1, 6, 6, (Object)item.getRequireQuantity(), false);
            writer.merge(firstRow, 8 + firstRow + ladderOrGroups.size() * 2 - 1, 7, 7, (Object)jsonObject.getString("purchaseUnit_dictText"), false);
            writer.merge(firstRow, 8 + firstRow + ladderOrGroups.size() * 2 - 1, 8, 8, (Object)item.getFuturePrice(), false);
            writer.merge(firstRow, 8 + firstRow + ladderOrGroups.size() * 2 - 1, 9, 9, (Object)jsonObject.getString("factory_dictText"), false);
            writer.merge(firstRow, 8 + firstRow + ladderOrGroups.size() * 2 - 1, 10, 10, (Object)jsonObject.getString("storageLocation_dictText"), false);
            this.getWriteRows(writer, firstRow, ladderOrGroups);
        } else {
            writer.writeCellValue(0, 7 + firstRow, (Object)item.getEnquiryNumber());
            writer.writeCellValue(1, 7 + firstRow, (Object)item.getItemNumber());
            writer.writeCellValue(2, 7 + firstRow, (Object)item.getMaterialNumber());
            writer.writeCellValue(3, 7 + firstRow, (Object)item.getMaterialName());
            writer.writeCellValue(4, 7 + firstRow, (Object)item.getMaterialDesc());
            writer.writeCellValue(5, 7 + firstRow, (Object)item.getMaterialSpec());
            writer.writeCellValue(6, 7 + firstRow, (Object)item.getRequireQuantity());
            writer.writeCellValue(7, 7 + firstRow, (Object)jsonObject.getString("purchaseUnit_dictText"));
            writer.writeCellValue(8, 7 + firstRow, (Object)item.getFuturePrice());
            writer.writeCellValue(9, 7 + firstRow, (Object)jsonObject.getString("factory_dictText"));
            writer.writeCellValue(10, 7 + firstRow, (Object)jsonObject.getString("storageLocation_dictText"));
            this.getWriteRows(writer, firstRow, ladderOrGroups);
        }
    }

    private void getWriteRows(ExcelWriter writer, int firstRow, JSONArray ladderOrGroups) {
        int row = ladderOrGroups.size() * 2;
        writer.merge(firstRow, firstRow + ladderOrGroups.size() - 1, 11, 11, (Object)"\u542b\u7a0e\u4ef7", false);
        writer.merge(firstRow + ladderOrGroups.size(), firstRow + ladderOrGroups.size() * 2 - 1, 11, 11, (Object)"\u672a\u7a0e\u4ef7", false);
        writer.merge(firstRow + row, firstRow + row, 11, 12, (Object)"\u7a0e\u7387", false);
        writer.merge(firstRow + row + 1, firstRow + row + 1, 11, 12, (Object)"\u4ea4\u8d27\u65e5\u671f", false);
        writer.merge(firstRow + row + 2, firstRow + row + 2, 11, 12, (Object)"\u62a5\u4ef7\u65f6\u95f4", false);
        writer.merge(firstRow + row + 3, firstRow + row + 3, 11, 12, (Object)"\u6700\u5c0f\u5305\u88c5\u91cf", false);
        writer.merge(firstRow + row + 4, firstRow + row + 4, 11, 12, (Object)"\u6700\u5c0f\u8ba2\u5355\u91cf", false);
        writer.merge(firstRow + row + 5, firstRow + row + 5, 11, 12, (Object)"\u4ef7\u683c\u751f\u6548\u65f6\u95f4", false);
        writer.merge(firstRow + row + 6, firstRow + row + 6, 11, 12, (Object)"\u4ef7\u683c\u5931\u6548\u65f6\u95f4", false);
        writer.merge(firstRow + row + 7, firstRow + row + 7, 11, 12, (Object)"\u62a5\u4ef7\u8f6e\u6b21", false);
    }

    private List<String> getHeaderList(List<EnquirySupplierListLp> supplierList, String ... headText) {
        ArrayList<String> excelHeader = new ArrayList<String>(Arrays.asList(headText));
        for (EnquirySupplierListLp supplier : supplierList) {
            excelHeader.add(supplier.getSupplierName());
        }
        return excelHeader;
    }

    @Override
    public List<SupplierRelationFindResultVO> probeIP(List<PurchaseEnquiryItemLp> purchaseBiddingItemList) {
        ArrayList<SupplierRelationFindResultVO> result = new ArrayList<SupplierRelationFindResultVO>();
        List accountIpList = purchaseBiddingItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getQuoteIp())).map(item -> item.getToElsAccount() + "_" + item.getQuoteIp()).distinct().collect(Collectors.toList());
        Map<String, PurchaseEnquiryItemLp> supplierMap = purchaseBiddingItemList.stream().collect(Collectors.toMap(PurchaseEnquiryItemLp::getToElsAccount, Function.identity(), (supplier1, supplier2) -> supplier2));
        for (String sourceAccountIp : accountIpList) {
            for (String targetAccountIp : accountIpList) {
                if (sourceAccountIp.equals(targetAccountIp)) continue;
                CompareIPUtils.compareEnquiryLpIp(sourceAccountIp, targetAccountIp, supplierMap, result);
            }
        }
        return result;
    }

    @Override
    public List<PurchaseEnquiryItemLp> findBySourceItemId(List<String> headIdList, List<String> sourceIdList) {
        return ((PurchaseEnquiryItemLpMapper)this.baseMapper).findBySourceItemId(headIdList, sourceIdList);
    }

    @Override
    public void deleteByMainIdAndAccount(String id, String toElsAccount) {
        ((PurchaseEnquiryItemLpMapper)this.baseMapper).deleteByMainIdAndAccount(id, toElsAccount);
    }
}

