/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.priceEvaluationManagement.excel;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.demand.rpc.ElsTaxLocalRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.demand.rpc.TemplateLocalRpcService;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationItem;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationStandardHead;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationItemService;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationStandardHeadService;
import com.els.modules.system.dto.ExcelByConfigDTO;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
@RpcService(value="purchaseBaseMaterialImportRpcServiceImpl")
public class PurchaseBaseMaterialItemExcelHandler
extends ErrorExcelHandlerService
implements ExcelItemByConfigRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseBaseMaterialItemExcelHandler.class);
    @Autowired
    private PurchasePriceEvaluationStandardHeadService purchasePriceEvaluationStandardHeadService;
    @Autowired
    private PurchasePriceEvaluationItemService purchasePriceEvaluationItemService;
    @Resource
    private TemplateLocalRpcService templateHeadService;
    @Resource
    private ElsTaxLocalRpcService elsTaxService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadService;
    private List<TemplateConfigItemDTO> templateConfigItemDTOList;

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        String templateAccount = excelByConfigDTO.getTemplateAccount();
        String templateVersion = excelByConfigDTO.getTemplateVersion();
        String templateNumber = excelByConfigDTO.getTemplateNumber();
        String groupCode = excelByConfigDTO.getGroupCode();
        if (StrUtil.isNotBlank((CharSequence)excelByConfigDTO.getHeadId()) && !"undefined".equals(excelByConfigDTO.getHeadId())) {
            PurchasePriceEvaluationStandardHead dbHead = (PurchasePriceEvaluationStandardHead)((Object)this.purchasePriceEvaluationStandardHeadService.getById((Serializable)((Object)excelByConfigDTO.getHeadId())));
            templateAccount = StrUtil.isNotBlank((CharSequence)dbHead.getTemplateAccount()) ? dbHead.getTemplateAccount() : dbHead.getElsAccount();
            templateVersion = String.valueOf(dbHead.getTemplateVersion());
            templateNumber = String.valueOf(dbHead.getTemplateNumber());
        }
        TemplateHeadDTO config = this.templateHeadService.getConfig(templateAccount, templateNumber, templateVersion);
        List templateConfigItemList = config.getTemplateConfigItemList().stream().filter(item -> item.getGroupCode().equals(groupCode)).collect(Collectors.toList());
        this.templateConfigItemDTOList = JSON.parseArray((String)JSON.toJSONString(templateConfigItemList), TemplateConfigItemDTO.class);
        return config;
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        List<PurchasePriceEvaluationItem> itemList = this.purchasePriceEvaluationItemService.selectByMainId(excelByConfigDTO.getHeadId());
        return new ArrayList<PurchasePriceEvaluationItem>(itemList);
    }

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List editColumn = this.templateConfigItemDTOList.stream().map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        ArrayList<Map<String, Object>> returnDataList = new ArrayList<Map<String, Object>>();
        for (Map data : dataList) {
            for (String field : data.keySet()) {
                if (editColumn.contains(field)) continue;
                data.put(field, null);
            }
            returnDataList.add(data);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return returnDataList;
    }
}

