/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quotaProcotol.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.quotaProcotol.entity.PurchaseQuotaProtocolHead;
import com.els.modules.quotaProcotol.service.PurchaseQuotaProtocolHeadService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseQuotaProcotolAuditAdapter")
public class PurchaseQuotaProcotolAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseQuotaProcotolAuditOptCallBackServiceImpl.class);
    @Autowired
    private PurchaseQuotaProtocolHeadService purchaseQuotaProtocolHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseQuotaProtocolHead head = (PurchaseQuotaProtocolHead)((Object)this.purchaseQuotaProtocolHeadService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseQuotaProtocolHead purchaseQuotaProtocolHead = (PurchaseQuotaProtocolHead)((Object)this.purchaseQuotaProtocolHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        if (purchaseQuotaProtocolHead == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_HemhxurtFW_1f2b4ae7", (String)"\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e!"));
        }
        PurchaseQuotaProtocolHead head = new PurchaseQuotaProtocolHead();
        head.setId(flowCallbackDTO.getBusinessId());
        head.setAuditStatus(auditStatus);
        head.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.purchaseQuotaProtocolHeadService.updateById((Object)head);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            this.purchaseQuotaProtocolHeadService.submit(purchaseQuotaProtocolHead, null);
        }
    }
}

