/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quotaProcotol.api.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.util.ClassTypeBuilder;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.quotaProcotol.entity.PurchaseQuotaProtocolHead;
import com.els.modules.quotaProcotol.entity.PurchaseQuotaProtocolItem;
import com.els.modules.quotaProcotol.service.PurchaseQuotaProtocolHeadService;
import com.els.modules.quotaProcotol.service.PurchaseQuotaProtocolItemService;
import com.els.modules.quotaProcotol.vo.PurchaseQuotaProtocolHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="quotaProtocol_create")
public class QuotaProtocolCreateServiceImpl
implements OpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(QuotaProtocolCreateServiceImpl.class);
    @Autowired
    private PurchaseQuotaProtocolHeadService quotaProtocolHeadService;
    @Autowired
    private PurchaseQuotaProtocolItemService quotaProtocolItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        ArrayList<PurchaseQuotaProtocolHead> headList = new ArrayList<PurchaseQuotaProtocolHead>();
        ArrayList allItem = new ArrayList();
        JSONArray headArray = new JSONArray();
        for (Object obj : array) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, obj);
            if (object.size() == 0) continue;
            PurchaseQuotaProtocolHead head = (PurchaseQuotaProtocolHead)((Object)JSON.parseObject((String)object.toString(), PurchaseQuotaProtocolHead.class));
            head.setElsAccount(account);
            head.setCreateTime(currentTime);
            head.setUpdateBy(head.getCreateBy());
            head.setDeleted(CommonConstant.DEL_FLAG_0);
            head.setTemplateName(templateHead.getTemplateName());
            head.setTemplateNumber(templateHead.getTemplateNumber());
            head.setTemplateVersion(templateHead.getTemplateVersion());
            head.setTemplateAccount(templateHead.getElsAccount());
            BeanUtil.copyProperties(defaultHeadMap, (Object)((Object)head), (String[])new String[0]);
            head.setId(SysUtil.getAssignId((Object)((Object)head)));
            if ("1".equals(head.getPublishStatus())) {
                head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            } else {
                head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            }
            headList.add(head);
            JSONObject headObj = SysUtil.objectToJSON((Object)((Object)head));
            headArray.add((Object)headObj);
            List itemList = null;
            JSONArray itemListJsonArray = null;
            if (object.containsKey((Object)"purchaseQuotaProtocolItemList")) {
                itemListJsonArray = object.getJSONArray("purchaseQuotaProtocolItemList");
            } else if (object.containsKey((Object)"itemList")) {
                itemListJsonArray = object.getJSONArray("itemList");
            }
            try {
                if (null == itemListJsonArray || itemListJsonArray.isEmpty() || null == (itemList = JSON.parseArray((String)itemListJsonArray.toJSONString(), PurchaseQuotaProtocolItem.class))) continue;
                for (PurchaseQuotaProtocolItem item : itemList) {
                    item.setHeadId(head.getId());
                    item.setElsAccount(account);
                    item.setCreateTime(currentTime);
                    item.setHeadId(head.getId());
                    item.setDeleted(CommonConstant.DEL_FLAG_0);
                    BeanUtil.copyProperties(defaultItemMap, (Object)((Object)item), (String[])new String[0]);
                }
                allItem.addAll(itemList);
            }
            catch (Exception e) {
                log.error("{}==>ItemList\u6570\u636e\u683c\u5f0f\u5f02\u5e38:{}", (Object)this.getBusinessType(), (Object)e.getMessage());
            }
        }
        if (!headList.isEmpty()) {
            PurchaseQuotaProtocolHead entity = (PurchaseQuotaProtocolHead)((Object)headList.get(0));
            long size = headList.stream().filter(x -> CharSequenceUtil.isEmpty((CharSequence)x.getDocumentNumber())).count();
            if (size > 0L) {
                List nextCodes = this.invokeBaseRpcService.getNextCodes("quotaProcotol", (Object)entity, (int)size);
                int codeIndex = 0;
                for (PurchaseQuotaProtocolHead e : headList) {
                    if (!CharSequenceUtil.isEmpty((CharSequence)e.getDocumentNumber())) continue;
                    e.setDocumentNumber((String)nextCodes.get(codeIndex++));
                }
            }
            this.quotaProtocolHeadService.saveBatch(headList, 2000);
        }
        if (!allItem.isEmpty()) {
            this.quotaProtocolItemService.saveBatch(allItem, 2000);
        }
        List collect = headList.stream().map(x -> (PurchaseQuotaProtocolHeadVO)((Object)((Object)Convert.convert(PurchaseQuotaProtocolHeadVO.class, (Object)x)))).collect(Collectors.toList());
        Map<String, List<PurchaseQuotaProtocolItem>> itemMap = allItem.stream().collect(Collectors.groupingBy(PurchaseQuotaProtocolItem::getHeadId));
        for (PurchaseQuotaProtocolHeadVO vo : collect) {
            vo.setPurchaseQuotaProtocolItemList(itemMap.get(vo.getId()));
        }
        JSONObject resultObj = new JSONObject();
        resultObj.put("headList", collect);
        return resultObj;
    }

    public void doParamCheck(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHeadDTO> configHeadList, List<TemplateConfigItemDTO> configItemList) {
    }

    public String getBusinessType() {
        return "quotaProcotol";
    }

    public List<ExcelExportClassColumnDTO> getBusinessClass() {
        return ClassTypeBuilder.buildClassTypeList(PurchaseQuotaProtocolHeadVO.class, null, null);
    }

    public List<String> supportItemList() {
        return Lists.newArrayList((Object[])new String[]{"purchaseQuotaProtocolItemList"});
    }
}

