/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.searchSourceConfig.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.searchSourceConfig.enums.AmountThresholdValidEnum;
import com.els.modules.searchSourceConfig.mapper.PurchaseSearchSourceConfigHeadMapper;
import com.els.modules.searchSourceConfig.service.SearSourMaterValidService;
import com.els.modules.searchSourceConfig.utils.SearSourConfigUtil;
import com.els.modules.searchSourceConfig.vo.MaterialAmountDataVo;
import com.els.modules.searchSourceConfig.vo.MaterialAmountValidVo;
import com.els.modules.searchSourceConfig.vo.MaterialDataValidParamVo;
import com.els.modules.searchSourceConfig.vo.MaterialDataVo;
import com.els.modules.searchSourceConfig.vo.PurAmountThresItemVo;
import com.els.modules.searchSourceConfig.vo.PurSourceTypeItemVo;
import com.els.modules.searchSourceConfig.vo.base.IMaterialAmountDataValidParam;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SearSourMaterValidServiceImpl
implements SearSourMaterValidService {
    @Resource
    private PurchaseSearchSourceConfigHeadMapper headMapper;

    private List<PurSourceTypeItemVo> getSourTypeItems(String purOrgCode) {
        return this.headMapper.getMaterSourType(purOrgCode);
    }

    private List<PurAmountThresItemVo> getMaterAmountThres(String purOrgCode) {
        return this.headMapper.getMaterAmountThres(purOrgCode);
    }

    private <T extends PurSourceTypeItemVo, R extends MaterialDataVo> void validSearSourType(List<T> itemVos, List<R> materialDataVos, String searchSourceType) {
        List cateCodes = materialDataVos.stream().filter(dataVo -> StrUtil.isNotBlank((CharSequence)dataVo.getCateCode())).map(MaterialDataVo::getCateCode).distinct().collect(Collectors.toList());
        itemVos.forEach(itemVo -> {
            if (StrUtil.isNotBlank((CharSequence)itemVo.getCateCode()) && !cateCodes.contains(itemVo.getCateCode())) {
                return;
            }
            SearSourConfigUtil.validSearSourType(itemVo.getCateCode(), searchSourceType, itemVo.getSearchSourceType());
        });
    }

    private void validMaterialAmount(List<PurAmountThresItemVo> itemVos, List<MaterialAmountDataVo> materialDataVos, BigDecimal totalAmount) {
        itemVos.forEach(itemVo -> {
            MaterialAmountValidVo validVo = new MaterialAmountValidVo();
            validVo.setCateCode(itemVo.getCateCode());
            validVo.setAmountThreshold(itemVo.getAmountThreshold());
            validVo.setTotalAmount(totalAmount);
            validVo.setMaterialDataVos(materialDataVos);
            AmountThresholdValidEnum.of(itemVo.getStatisticalType()).amountThreshValid(validVo);
        });
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void validMaterial(MaterialDataValidParamVo validParamVo) {
        if (StrUtil.isBlank((CharSequence)validParamVo.getPurOrgCode()) || CollectionUtils.isEmpty(validParamVo.getMaterialDataVos())) {
            return;
        }
        List<PurSourceTypeItemVo> itemVos = this.getSourTypeItems(validParamVo.getPurOrgCode());
        if (CollectionUtils.isEmpty(itemVos)) {
            return;
        }
        this.validSearSourType(itemVos, validParamVo.getMaterialDataVos(), validParamVo.getSearchSourceType());
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void validMaterialAmount(IMaterialAmountDataValidParam validParam) {
        List<PurAmountThresItemVo> itemVos = this.getMaterAmountThres(validParam.getPurOrgCode());
        if (CollectionUtils.isEmpty(itemVos)) {
            return;
        }
        this.validSearSourType(itemVos, validParam.getMaterialDataVos(), validParam.getSearchSourceType());
        this.validMaterialAmount(itemVos, validParam.getMaterialDataVos(), validParam.getTotalAmount());
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public void publishEnquiry(String purchaseOrg, List<PurchaseEnquiryItem> itemList) {
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public void publishEbidding(String purchaseOrg, List<PurchaseEbiddingItem> itemList) {
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public void publishBidding(String purchaseOrg, List<PurchaseBiddingItem> itemList) {
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public void requestPoolValid(String searchSourceType, String purchaseOrg, List<PurchaseRequestItem> itemList) {
    }
}

