/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.socket.handler;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.corundumstudio.socketio.SocketIOClient;
import com.corundumstudio.socketio.SocketIOServer;
import com.corundumstudio.socketio.annotation.OnConnect;
import com.corundumstudio.socketio.annotation.OnDisconnect;
import com.els.common.util.SysUtil;
import com.els.modules.socket.entity.SocketUserBo;
import com.els.modules.socket.utils.SocketUtil;
import com.els.modules.socket.utils.SysUserOnlineUtils;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SocketIOHandler {
    private static final Logger log = LoggerFactory.getLogger(SocketIOHandler.class);
    @Autowired
    private SocketIOServer socketIoServer;
    @Resource
    private SocketUtil socketUtil;

    @PostConstruct
    private void start() {
        try {
            this.socketIoServer.start();
            log.info("socketServer is start");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PreDestroy
    private void destroy() {
        try {
            this.socketIoServer.stop();
            log.info("socketServer is stop");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @OnConnect
    public void connect(SocketIOClient client) {
        try {
            String userId = client.getHandshakeData().getSingleUrlParam("userId");
            String elsAccount = client.getHandshakeData().getSingleUrlParam("elsAccount");
            String subAccount = client.getHandshakeData().getSingleUrlParam("subAccount");
            String busAccount = client.getHandshakeData().getSingleUrlParam("busAccount");
            String clientId = client.getHandshakeData().getSingleUrlParam("clientId");
            String group = client.getHandshakeData().getSingleUrlParam("relationId");
            String type = client.getHandshakeData().getSingleUrlParam("type");
            log.info("[\u5efa\u7acbsokect\u8fde\u63a5]\u5ba2\u6237\u7aefTransport:" + client.getTransport() + "RemoteAddress:" + client.getRemoteAddress() + "clientId: " + clientId + "  userId: " + userId + " type: " + type + "\u5f00\u59cb\u8fde\u63a5");
            ConcurrentHashMap<String, SocketUserBo> map = (ConcurrentHashMap<String, SocketUserBo>)SocketUtil.connectMap.get(group);
            String role = "sale";
            String purchaseAccount = SysUtil.getPurchaseAccount();
            if ("cloud".equals(SysUtil.getDeployWay())) {
                if (StrUtil.isNotBlank((CharSequence)busAccount) && elsAccount.equals(busAccount)) {
                    role = "purchase";
                }
            } else if (purchaseAccount.equals(elsAccount)) {
                role = "purchase";
            }
            if (CollUtil.isEmpty((Map)map)) {
                map = new ConcurrentHashMap<String, SocketUserBo>();
            }
            map.put(clientId, SocketUserBo.builder().status(Integer.valueOf(1)).elsAccount(elsAccount).subAccount(subAccount).role(role).client(client).userId(userId).type(Integer.valueOf(Integer.parseInt(type))).build());
            SocketUtil.connectMap.put(group, map);
            this.socketUtil.addOnlineUser(elsAccount + "_" + subAccount);
            if ("sysUserOnline".equals(group)) {
                SysUserOnlineUtils.sendOnlineNumberMessage(this.socketUtil, clientId, group, "\u3010" + elsAccount + "_" + subAccount + "\u3011\u4e0a\u7ebf");
            } else {
                HashMap<String, Object> mapMsg = new HashMap<String, Object>();
                mapMsg.put("RemoteAddress", client.getRemoteAddress());
                mapMsg.put("clientId", clientId);
                mapMsg.put("userId", userId);
                mapMsg.put("elsAccount", elsAccount);
                mapMsg.put("subAccount", subAccount);
                mapMsg.put("type", type);
                mapMsg.put("time", new Date());
                mapMsg.put("code", 201);
                mapMsg.put("message", "clientId: " + clientId + "\u5728\u5355\u636eid: " + group + "\u4e0a\u7ebf");
                this.socketUtil.sendToAll(mapMsg, "CHANNEL_EBIDDING", group, clientId);
            }
        }
        catch (Exception e) {
            log.error("[\u5efa\u7acbsokect\u8fde\u63a5]\u5ba2\u6237\u7aefclientId: \u63a5\u53d7\u4fe1\u606f\u9519\u8bef", (Throwable)e);
            log.info("[\u5efa\u7acbsokect\u8fde\u63a5]\u5ba2\u6237\u7aefclientId: \u63a5\u53d7\u4fe1\u606f\u9519\u8bef");
        }
    }

    private void closeConnect(String closeClientId, String group) {
        try {
            ConcurrentMap map;
            SocketUserBo socketUserBo = (SocketUserBo)((ConcurrentMap)SocketUtil.connectMap.get(group)).get(closeClientId);
            if (!((ConcurrentMap)SocketUtil.connectMap.get(group)).isEmpty()) {
                ((ConcurrentMap)SocketUtil.connectMap.get(group)).remove(closeClientId);
            }
            if (CollUtil.isEmpty((Map)(map = (ConcurrentMap)SocketUtil.connectMap.get(group)))) {
                SocketUtil.connectMap.remove(group);
            }
            this.socketUtil.removeOnlineUser(socketUserBo.getElsAccount() + "_" + socketUserBo.getSubAccount());
            if (socketUserBo == null) {
                return;
            }
            if ("sysUserOnline".equals(group)) {
                SysUserOnlineUtils.sendOnlineNumberMessage(this.socketUtil, closeClientId, group, "\u3010" + socketUserBo.getElsAccount() + "_" + socketUserBo.getSubAccount() + "\u3011\u4e0b\u7ebf");
            } else {
                HashMap<String, Object> mapMsg = new HashMap<String, Object>();
                mapMsg.put("RemoteAddress", socketUserBo.getClient().getRemoteAddress());
                mapMsg.put("clientId", closeClientId);
                mapMsg.put("userId", socketUserBo.getUserId());
                mapMsg.put("type", socketUserBo.getType());
                mapMsg.put("elsAccount", socketUserBo.getElsAccount());
                mapMsg.put("subAccount", socketUserBo.getSubAccount());
                mapMsg.put("time", new Date());
                mapMsg.put("code", 202);
                mapMsg.put("message", "clientId: " + closeClientId + "\u5728\u5355\u636eid: " + group + "\u4e0b\u7ebf");
                this.socketUtil.sendToAll(mapMsg, "CHANNEL_EBIDDING", group, closeClientId);
            }
        }
        catch (Exception e) {
            log.error("[\u5173\u95edsokect\u8fde\u63a5]\u5ba2\u6237\u7aefclientId: \u79bb\u5f00\u9519\u8bef", (Throwable)e);
            log.info("[\u5173\u95edsokect\u8fde\u63a5]\u5ba2\u6237\u7aefclientId: \u79bb\u5f00\u9519\u8bef");
        }
    }

    @OnDisconnect
    public void onDisconnect(SocketIOClient client) {
        try {
            String clientId = client.getHandshakeData().getSingleUrlParam("clientId");
            String group = client.getHandshakeData().getSingleUrlParam("relationId");
            this.closeConnect(clientId, group);
        }
        catch (Exception e) {
            log.error("[\u5173\u95edsokect\u8fde\u63a5]\u5ba2\u6237\u7aefclientId: \u79bb\u5f00\u9519\u8bef", (Throwable)e);
            log.info("[\u5173\u95edsokect\u8fde\u63a5]\u5ba2\u6237\u7aefclientId: \u79bb\u5f00\u9519\u8bef");
        }
    }
}

