/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.approval.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.tender.approval.entity.TenderProjectApprovalHead;
import com.els.modules.tender.approval.enumerate.TenderProjectApprovalStateEnum;
import com.els.modules.tender.approval.service.TenderProjectApprovalHeadService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;

@RpcService(value="tenderProjectApprovalAuditCallBackServiceImpl")
public class TenderProjectApprovalAdapter
implements WorkflowAuditOptCallBackService {
    @Resource
    private TenderProjectApprovalHeadService approvalHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        TenderProjectApprovalHead head = (TenderProjectApprovalHead)((Object)this.approvalHeadService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    public void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        TenderProjectApprovalHead tenderProjectApprovalHead = new TenderProjectApprovalHead();
        tenderProjectApprovalHead.setId(flowCallbackDTO.getBusinessId());
        tenderProjectApprovalHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            tenderProjectApprovalHead.setSourceStatus(TenderProjectApprovalStateEnum.ISSUE.getValue());
        } else if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            tenderProjectApprovalHead.setSourceStatus(TenderProjectApprovalStateEnum.NEW.getValue());
        } else if (AuditStatusEnum.AUDIT_NEW.getValue().equals(auditStatus)) {
            tenderProjectApprovalHead.setSourceStatus(TenderProjectApprovalStateEnum.NEW.getValue());
        } else {
            tenderProjectApprovalHead.setSourceStatus(TenderProjectApprovalStateEnum.NOT_ISSUE.getValue());
        }
        tenderProjectApprovalHead.setAuditStatus(auditStatus);
        this.approvalHeadService.updateById((Object)tenderProjectApprovalHead);
    }
}

