/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.approval.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.bidding.enumerate.BiddingItemStatusEnum;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.utils.RequestItemUtils;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.enquiry.utils.DefaultValueInitUtil;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.searchSourceConfig.service.SearSourMaterValidService;
import com.els.modules.tender.approval.entity.TenderProjectApprovalHead;
import com.els.modules.tender.approval.entity.TenderProjectApprovalItem;
import com.els.modules.tender.approval.enumerate.TenderProjectApprovalStateEnum;
import com.els.modules.tender.approval.service.TenderProjectApprovalHeadService;
import com.els.modules.tender.approval.vo.TenderProjectApprovalHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/tenderProjectApprovalHead"})
@Tag(name="\u9879\u76ee\u7acb\u9879")
public class TenderProjectApprovalHeadController
extends BaseController<TenderProjectApprovalHead, TenderProjectApprovalHeadService> {
    private static final Logger log = LoggerFactory.getLogger(TenderProjectApprovalHeadController.class);
    @Autowired
    private TenderProjectApprovalHeadService tenderProjectApprovalHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private RequestItemUtils requestItemUtils;
    @Autowired
    private SearSourMaterValidService validService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProjectApprovalHead:list"})
    @PermissionDataView(businessType="projectApproval")
    public Result<?> queryPageList(TenderProjectApprovalHead tenderProjectApprovalHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)tenderProjectApprovalHead), (Map)req.getParameterMap());
        queryWrapper.orderByDesc((Object)"create_time");
        String tenant = TenantContext.getTenant();
        queryWrapper.and(wrapper -> ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"agency_library_account", (Object)tenant)).or()).eq((Object)"els_account", (Object)tenant));
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.tenderProjectApprovalHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u4ee3\u7406\u673a\u6784\u67e5\u8be2\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u4ee3\u7406\u673a\u6784\u67e5\u8be2\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryProjectApprovalByAgenct"})
    @RequiresPermissions(value={"tender#tenderProjectApprovalHead:queryById"})
    public Result<?> queryProjectApprovalByAgenct(TenderProjectApprovalHead tenderProjectApprovalHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)tenderProjectApprovalHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant())).or()).eq((Object)"agency_library_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.eq((Object)"source_status", (Object)TenderProjectApprovalStateEnum.ISSUE.getValue());
        IPage pageList = this.tenderProjectApprovalHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u9879\u76ee\u7acb\u9879", value="\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProjectApprovalHead:add"})
    @PermissionDataOpt(businessType="projectApproval", beanClass=TenderProjectApprovalHeadService.class)
    public Result<?> add(@RequestBody TenderProjectApprovalHeadVO tenderProjectApprovalHeadPage) {
        TenderProjectApprovalHead tenderProjectApprovalHead = new TenderProjectApprovalHead();
        BeanUtils.copyProperties((Object)((Object)tenderProjectApprovalHeadPage), (Object)((Object)tenderProjectApprovalHead));
        this.tenderProjectApprovalHeadService.saveMain(tenderProjectApprovalHead, tenderProjectApprovalHeadPage.getApprovalItemList(), tenderProjectApprovalHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)tenderProjectApprovalHead));
    }

    @AutoLog(busModule="\u9879\u76ee\u7acb\u9879", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"tender#tenderProjectApprovalHead:edit"})
    @SrmValidated
    @PermissionDataOpt(businessType="projectApproval", beanClass=TenderProjectApprovalHeadService.class)
    public Result<?> edit(@RequestBody TenderProjectApprovalHeadVO tenderProjectApprovalHeadPage) {
        TenderProjectApprovalHead tenderProjectApprovalHead = new TenderProjectApprovalHead();
        BeanUtils.copyProperties((Object)((Object)tenderProjectApprovalHeadPage), (Object)((Object)tenderProjectApprovalHead));
        this.tenderProjectApprovalHeadService.updateMain(tenderProjectApprovalHead, tenderProjectApprovalHeadPage.getApprovalItemList(), tenderProjectApprovalHeadPage.getPurchaseAttachmentList());
        String id = tenderProjectApprovalHead.getId();
        return this.queryById(id);
    }

    @AutoLog(busModule="\u9879\u76ee\u7acb\u9879", value="\u8865\u5145\u7269\u6599\u884c")
    @Operation(summary="\u8865\u5145\u7269\u6599\u884c", description="\u8865\u5145\u7269\u6599\u884c")
    @PostMapping(value={"/replenish"})
    @RequiresPermissions(value={"tender#tenderProjectApprovalHead:replenish"})
    @SrmValidated
    public Result<?> replenish(@RequestBody TenderProjectApprovalHeadVO tenderProjectApprovalHeadPage) {
        TenderProjectApprovalHead tenderProjectApprovalHead = new TenderProjectApprovalHead();
        BeanUtils.copyProperties((Object)((Object)tenderProjectApprovalHeadPage), (Object)((Object)tenderProjectApprovalHead));
        this.tenderProjectApprovalHeadService.replenish(tenderProjectApprovalHead, tenderProjectApprovalHeadPage.getApprovalItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9879\u76ee\u7acb\u9879", value="\u9700\u6c42\u6c60\u8f6c\u9879\u76ee\u7acb\u9879")
    @Operation(summary="\u9700\u6c42\u6c60\u8f6c\u9879\u76ee\u7acb\u9879", description="\u9700\u6c42\u6c60\u8f6c\u9879\u76ee\u7acb\u9879")
    @PostMapping(value={"/requestToTenderProjectApproval"})
    @RequiresPermissions(value={"tender#tenderProjectApprovalHead:tenderProjectApproval"})
    @SrmValidated
    public Result<?> requestToTenderProjectApproval(@RequestBody PurchaseRequestHeadVO requestHeadVO) {
        String flag;
        this.requestItemUtils.validRequestItemStatus(requestHeadVO.getPurchaseRequestItemList());
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        JSONObject companySet = loginUser.getCompanySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("1");
        arrayList.add("2");
        boolean allowMultipleSources = false;
        if (companySet != null && "1".equals(flag = companySet.getString("allowMultipleSources"))) {
            allowMultipleSources = true;
        }
        String templateNumber = requestHeadVO.getTemplateNumber();
        String templateVersion = requestHeadVO.getTemplateVersion();
        Assert.hasText((String)templateNumber, (String)I18nUtil.translate((String)"i18n_alert_empty_template_num_no_null_template", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)templateVersion, (String)I18nUtil.translate((String)"i18n_alert_empty_template_version_num_template", (String)"\u6a21\u677f\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        TenderProjectApprovalHead head = new TenderProjectApprovalHead();
        head.setTemplateNumber(templateNumber);
        head.setTemplateVersion(Integer.valueOf(templateVersion));
        head.setTemplateName(requestHeadVO.getTemplateName());
        head.setTemplateAccount(requestHeadVO.getTemplateAccount());
        head.setSourceStatus("0");
        ArrayList<TenderProjectApprovalItem> itemList = new ArrayList<TenderProjectApprovalItem>();
        List<PurchaseRequestItem> requestItemList = requestHeadVO.getPurchaseRequestItemList();
        List collect1 = requestItemList.stream().map(item -> item.getId()).distinct().collect(Collectors.toList());
        List requestItemListDb = ((LambdaQueryChainWrapper)this.purchaseRequestItemService.lambdaQuery().in(ParentEntity::getId, collect1)).list();
        ArrayList<PurchaseRequestItem> purchaseRequestItems = new ArrayList<PurchaseRequestItem>();
        block0: for (PurchaseRequestItem item2 : requestItemList) {
            for (Object item1 : requestItemListDb) {
                if (!Objects.equals(item2.getId(), item1.getId())) continue;
                purchaseRequestItems.add((PurchaseRequestItem)((Object)item1));
                continue block0;
            }
        }
        List orgList = requestItemList.stream().map(item -> item.getPurchaseOrg() == null ? "" : item.getPurchaseOrg()).distinct().collect(Collectors.toList());
        Assert.isTrue((orgList.size() == 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_oper_no_the_same_purchase_organization", (String)"\u76f8\u540c\u91c7\u8d2d\u7ec4\u7ec7\u624d\u53ef\u8f6c\u5355"));
        this.validService.requestPoolValid("2", ((PurchaseRequestItem)((Object)purchaseRequestItems.get(0))).getPurchaseOrg(), purchaseRequestItems);
        List<PurchaseRequestItem> mergeRequestList = this.purchaseRequestItemService.mergeRequest(purchaseRequestItems);
        Map<String, String> itemValueMap = DefaultValueInitUtil.getItemDefaultValue(requestHeadVO.getTemplateAccount(), templateNumber, templateVersion);
        for (PurchaseRequestItem requestItem : mergeRequestList) {
            if (!allowMultipleSources && !arrayList.contains(requestItem.getItemStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVtyWWWWWWEyWWWWWWxBnHeiTOmhjER_5462a613", (String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7:${0},\u884c\u53f7:${1},\u4e0d\u7b26\u5408\u7cfb\u7edf\u5141\u8bb8\u591a\u6b21\u5bfb\u6e90\u914d\u7f6e", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
            }
            TenderProjectApprovalItem item3 = new TenderProjectApprovalItem();
            BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)item3));
            item3.setId(null);
            item3.setSourceType(SourceTypeEnum.REQUEST.getValue());
            item3.setSourceNumber(requestItem.getRequestNumber());
            item3.setSourceItemNumber(requestItem.getItemNumber());
            item3.setSourceItemId(requestItem.getId());
            item3.setPriceUnit(requestItem.getUnitPrice());
            String purchaseUnit = DefaultValueInitUtil.getFieldValue(itemValueMap, "purchaseUnit", requestItem.getPurchaseUnit());
            String purchaseType = DefaultValueInitUtil.getFieldValue(itemValueMap, "purchaseType", requestItem.getPurchaseType());
            item3.setPurchaseUnit(purchaseUnit);
            item3.setPurchaseType(purchaseType);
            item3.setRequireQuantity(requestItem.getQuantity());
            item3.setRequireDate(requestItem.getDeliveryDate());
            item3.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            item3.setItemStatus(BiddingItemStatusEnum.NEW.getValue());
            item3.setCreateBy(null);
            item3.setCreateTime(null);
            item3.setCreateById(null);
            item3.setUpdateBy(null);
            item3.setUpdateById(null);
            item3.setUpdateTime(null);
            itemList.add(item3);
        }
        head.setPurchaseNumber(requestItemList.get(0).getRequestNumber());
        head.setDocumentId(requestItemList.get(0).getDocumentId());
        if (StrUtil.isNotBlank((CharSequence)requestItemList.get(0).getDocumentId())) {
            head.setDocumentParentId(requestItemList.get(0).getHeadId());
        }
        head.setCompany(requestItemList.get(0).getCompany());
        Map<String, String> headValueMap = DefaultValueInitUtil.getHeadDefaultValue(requestHeadVO.getTemplateAccount(), templateNumber, templateVersion);
        String purchaseGroup = DefaultValueInitUtil.getFieldValue(headValueMap, "purchaseGroup", mergeRequestList.get(0).getPurchaseGroup());
        head.setPurchaseGroup(purchaseGroup);
        head.setPurchaseOrg(requestItemList.get(0).getPurchaseOrg());
        head.setSourceType(SourceTypeEnum.REQUEST.getValue());
        if ("person".equals(requestItemList.get(0).getTacticsEntity())) {
            head.setPurchasePrincipal(requestItemList.get(0).getTacticsObject());
        } else {
            LoginUserDTO sysUser = this.getCurrentUser();
            head.setPurchasePrincipal(sysUser.getRealname());
            head.setPurchasePrincipalAccount(sysUser.getElsAccount() + "_" + sysUser.getSubAccount());
        }
        head.setAudited("0");
        head.setProjectNumber(this.invokeBaseRpcService.getNextCode("srmBiddingProjectNumber", (Object)head));
        this.tenderProjectApprovalHeadService.saveMain(head, itemList, new ArrayList<PurchaseAttachmentDTO>());
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_sdIvdLRWdIvdtyLWWWWWWW_ba8f0df1", (String)"\u8f6c\u9879\u76ee\u7acb\u9879\u6210\u529f,\u9879\u76ee\u7acb\u9879\u5355\u53f7\u4e3a:[${0}]", (String[])new String[]{head.getProjectNumber()}), Arrays.asList(head));
    }

    @AutoLog(busModule="\u9879\u76ee\u7acb\u9879", value="\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"tender#tenderProjectApprovalHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.tenderProjectApprovalHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u9879\u76ee\u7acb\u9879", value="\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"tender#tenderProjectApprovalHead:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.tenderProjectApprovalHeadService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProjectApprovalHead:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TenderProjectApprovalHeadVO tenderProjectApprovalHeadVo = this.tenderProjectApprovalHeadService.queryById(id);
        return Result.ok((Object)((Object)tenderProjectApprovalHeadVo));
    }

    @AutoLog(busModule="\u9879\u76ee\u7acb\u9879", value="\u72b6\u6001\u5e9f\u5f03")
    @Operation(summary="\u9879\u76ee\u7acb\u9879", description="\u72b6\u6001\u5e9f\u5f03")
    @PostMapping(value={"/abandonStatus"})
    @RequiresPermissions(value={"tender#tenderProjectApprovalHead:abandonStatus"})
    @SrmValidated
    public Result<?> abandonStatus(@RequestBody TenderProjectApprovalHead tenderProjectApprovalHead) {
        this.tenderProjectApprovalHeadService.abandonStatus(tenderProjectApprovalHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9879\u76ee\u7acb\u9879", value="\u56de\u5f52\u9700\u6c42\u6c60")
    @Operation(summary="\u9879\u76ee\u7acb\u9879", description="\u56de\u5f52\u9700\u6c42\u6c60")
    @PostMapping(value={"/goBackDemandPool"})
    @RequiresPermissions(value={"tender#tenderProjectApprovalHead:goBackDemandPool"})
    @SrmValidated
    public Result<?> goBackDemandPool(@RequestBody TenderProjectApprovalHead tenderProjectApprovalHead) {
        this.tenderProjectApprovalHeadService.goBackDemandPool(tenderProjectApprovalHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u9879\u76ee\u7acb\u9879", value="\u53d1\u5e03")
    @Operation(summary="\u9879\u76ee\u7acb\u9879", description="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"tender#tenderProjectApprovalHead:publish"})
    @SrmValidated
    @PermissionDataOpt(businessType="projectApproval", beanClass=TenderProjectApprovalHeadService.class)
    public Result<?> publish(@RequestBody TenderProjectApprovalHead tenderProjectApprovalHead) {
        this.tenderProjectApprovalHeadService.publish(tenderProjectApprovalHead.getId());
        return this.commonSuccessResult(3);
    }

    @Operation(summary="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"tender#tenderProjectApprovalHead:list"})
    @PermissionDataView(businessType="projectApproval")
    public Result<?> queryTabsCount(TenderProjectApprovalHead tenderProjectApprovalHead, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)tenderProjectApprovalHead), (Map)req.getParameterMap());
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        List<CountVO> countVOList = this.tenderProjectApprovalHeadService.queryTabsCount(TenantContext.getTenant(), (QueryWrapper<TenderProjectApprovalHead>)queryWrapper);
        Map<String, Long> countMap = countVOList.stream().collect(Collectors.toMap(o -> o.getValue(), o -> o.getTotal()));
        long totalCount = countVOList.stream().mapToLong(CountVO::getTotal).sum();
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "sourceStatus", null, totalCount));
        List dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("approvalSourceStatus", TenantContext.getTenant());
        if (CollectionUtil.isNotEmpty((Collection)dictDTOList)) {
            for (DictDTO status : dictDTOList) {
                long count = countMap.get(status.getValue()) == null ? 0L : countMap.get(status.getValue());
                result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "sourceStatus", status.getValue(), count));
            }
        }
        return Result.ok(result);
    }
}

