/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.tender.clarification.entity.PurchaseTenderEvaClarificationHead;
import com.els.modules.tender.clarification.entity.PurchaseTenderEvaClarificationItem;
import com.els.modules.tender.clarification.entity.PurchaseTenderEvaClarificationRecord;
import com.els.modules.tender.clarification.entity.PurchaseTenderEvaClarificationSupplier;
import com.els.modules.tender.clarification.service.PurchaseTenderEvaClarificationHeadService;
import com.els.modules.tender.clarification.service.PurchaseTenderEvaClarificationItemService;
import com.els.modules.tender.clarification.service.PurchaseTenderEvaClarificationRecordService;
import com.els.modules.tender.clarification.service.PurchaseTenderEvaClarificationSupplierService;
import com.els.modules.tender.clarification.vo.PurchaseTenderEvaClarificationHeadVO;
import com.els.modules.tender.clarification.vo.PurchaseTenderEvaClarificationItemVO;
import com.els.modules.tender.common.aspect.ValidatedTenderStatus;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/clarification/purchaseTenderEvaClarificationHead"})
@Tag(name="\u91c7\u8d2d\u8bc4\u6807\u6f84\u6e05\u5934")
public class PurchaseTenderEvaClarificationHeadController
extends BaseController<PurchaseTenderEvaClarificationHead, PurchaseTenderEvaClarificationHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderEvaClarificationHeadController.class);
    @Autowired
    private PurchaseTenderEvaClarificationHeadService purchaseTenderEvaClarificationHeadService;
    @Autowired
    private PurchaseTenderEvaClarificationItemService purchaseTenderEvaClarificationItemService;
    @Autowired
    private PurchaseTenderEvaClarificationRecordService purchaseTenderEvaClarificationRecordService;
    @Autowired
    private PurchaseTenderEvaClarificationSupplierService purchaseTenderEvaClarificationSupplierService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Operation(summary="\u5217\u8868\u67e5\u8be2", description="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    public Result<?> queryList(PurchaseTenderEvaClarificationHead purchaseTenderEvaClarificationHead, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseTenderEvaClarificationHead), (Map)req.getParameterMap());
        queryWrapper.orderByDesc((Object)"update_time");
        List list = this.purchaseTenderEvaClarificationHeadService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return Result.ok();
        }
        ArrayList evaClarificationHeadVOS = SysUtil.copyProperties((List)list, PurchaseTenderEvaClarificationHeadVO.class);
        List<String> ids = evaClarificationHeadVOS.stream().map(ParentEntity::getId).collect(Collectors.toList());
        List<PurchaseTenderEvaClarificationSupplier> evaClarificationSuppliers = this.purchaseTenderEvaClarificationSupplierService.selectByMainIds(ids);
        Map<String, List<PurchaseTenderEvaClarificationSupplier>> evaClarificationSupplierMap = evaClarificationSuppliers.stream().collect(Collectors.groupingBy(PurchaseTenderEvaClarificationSupplier::getHeadId));
        for (PurchaseTenderEvaClarificationHeadVO evaClarificationHeadVO : evaClarificationHeadVOS) {
            List<PurchaseTenderEvaClarificationSupplier> purchaseTenderEvaClarificationSuppliers = evaClarificationSupplierMap.get(evaClarificationHeadVO.getId());
            evaClarificationHeadVO.setPurchaseTenderEvaClarificationSupplierList(purchaseTenderEvaClarificationSuppliers);
        }
        Page page = new Page();
        page.setTotal((long)evaClarificationHeadVOS.size());
        page.setRecords((List)evaClarificationHeadVOS);
        return Result.ok((Object)page);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u8bc4\u6807\u6f84\u6e05\u5934", value="\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> add(@RequestBody PurchaseTenderEvaClarificationHeadVO purchaseTenderEvaClarificationHeadPage) {
        PurchaseTenderEvaClarificationHead purchaseTenderEvaClarificationHead = new PurchaseTenderEvaClarificationHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderEvaClarificationHeadPage), (Object)((Object)purchaseTenderEvaClarificationHead));
        this.purchaseTenderEvaClarificationHeadService.saveMain(purchaseTenderEvaClarificationHead, purchaseTenderEvaClarificationHeadPage.getPurchaseTenderEvaClarificationSupplierList(), purchaseTenderEvaClarificationHeadPage.getAttachmentList());
        return Result.ok((Object)((Object)purchaseTenderEvaClarificationHead));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u8bc4\u6807\u6f84\u6e05\u5934", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> edit(@RequestBody PurchaseTenderEvaClarificationHeadVO purchaseTenderEvaClarificationHeadPage) {
        PurchaseTenderEvaClarificationHead purchaseTenderEvaClarificationHead = new PurchaseTenderEvaClarificationHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderEvaClarificationHeadPage), (Object)((Object)purchaseTenderEvaClarificationHead));
        this.purchaseTenderEvaClarificationHeadService.updateMain(purchaseTenderEvaClarificationHead, purchaseTenderEvaClarificationHeadPage.getPurchaseTenderEvaClarificationSupplierList(), purchaseTenderEvaClarificationHeadPage.getAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u8bc4\u6807\u6f84\u6e05\u5934", value="\u53d1\u5e03")
    @Operation(summary="\u53d1\u5e03", description="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> publish(@RequestBody PurchaseTenderEvaClarificationHeadVO purchaseTenderEvaClarificationHeadPage) {
        PurchaseTenderEvaClarificationHead purchaseTenderEvaClarificationHead = new PurchaseTenderEvaClarificationHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderEvaClarificationHeadPage), (Object)((Object)purchaseTenderEvaClarificationHead));
        this.purchaseTenderEvaClarificationHeadService.saveOrUpdate(purchaseTenderEvaClarificationHead, purchaseTenderEvaClarificationHeadPage.getPurchaseTenderEvaClarificationSupplierList(), purchaseTenderEvaClarificationHeadPage.getAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u8bc4\u6807\u6f84\u6e05\u5934", value="\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseTenderEvaClarificationHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseTenderEvaClarificationHead purchaseTenderEvaClarificationHead = (PurchaseTenderEvaClarificationHead)((Object)this.purchaseTenderEvaClarificationHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseTenderEvaClarificationHeadVO purchaseTenderEvaClarificationHeadVO = new PurchaseTenderEvaClarificationHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderEvaClarificationHead), (Object)((Object)purchaseTenderEvaClarificationHeadVO));
        List<PurchaseTenderEvaClarificationItem> evaClarificationItemList = this.purchaseTenderEvaClarificationItemService.selectByMainId(id);
        ArrayList evaClarificationItemVOS = SysUtil.copyProperties(evaClarificationItemList, PurchaseTenderEvaClarificationItemVO.class);
        List<PurchaseTenderEvaClarificationSupplier> purchaseTenderEvaClarificationSuppliers = this.purchaseTenderEvaClarificationSupplierService.selectByMainId(id);
        List ids = evaClarificationItemVOS.stream().map(ParentEntity::getId).distinct().collect(Collectors.toList());
        ids.add(purchaseTenderEvaClarificationHead.getId());
        List purchaseAttachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainIds(ids);
        Map<String, List<PurchaseAttachmentDTO>> purchaseAttachmentMap = purchaseAttachmentDTOList.stream().collect(Collectors.groupingBy(PurchaseAttachmentDTO::getHeadId));
        purchaseTenderEvaClarificationHeadVO.setAttachmentList(purchaseAttachmentMap.get(purchaseTenderEvaClarificationHeadVO.getId()));
        evaClarificationItemVOS.forEach(evaClarificationItemVO -> evaClarificationItemVO.setAttachmentList((List)purchaseAttachmentMap.get(evaClarificationItemVO.getId())));
        purchaseTenderEvaClarificationHeadVO.setPurchaseTenderEvaClarificationItemList(evaClarificationItemVOS);
        purchaseTenderEvaClarificationHeadVO.setPurchaseTenderEvaClarificationSupplierList(purchaseTenderEvaClarificationSuppliers);
        return Result.ok((Object)((Object)purchaseTenderEvaClarificationHeadVO));
    }

    @AutoLog(busModule="\u91c7\u8d2d\u8bc4\u6807\u6f84\u6e05\u5934", value="\u53d8\u66f4")
    @Operation(summary="\u53d8\u66f4", description="\u53d8\u66f4")
    @PostMapping(value={"/changeRecord"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> changeRecord(@RequestBody PurchaseTenderEvaClarificationRecord purchaseTenderEvaClarificationRecord) {
        this.purchaseTenderEvaClarificationHeadService.changeRecord(purchaseTenderEvaClarificationRecord);
        return this.commonSuccessResult(3);
    }

    @Operation(summary="\u53d8\u66f4\u5217\u8868", description="\u53d8\u66f4\u5217\u8868")
    @GetMapping(value={"/queryRecordByMainId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryList(@RequestParam(name="mainId") String mainId) {
        List<PurchaseTenderEvaClarificationRecord> purchaseTenderEvaClarificationRecords = this.purchaseTenderEvaClarificationRecordService.selectByMainId(mainId);
        return Result.ok(purchaseTenderEvaClarificationRecords);
    }
}

