/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPriceRegulationInfo;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationRegulationInfo;
import com.els.modules.tender.clarification.entity.PurchaseClarificationEvaluationGroup;
import com.els.modules.tender.clarification.entity.PurchaseClarificationEvaluationPriceRegulationInfo;
import com.els.modules.tender.clarification.entity.PurchaseClarificationEvaluationRegulationInfo;
import com.els.modules.tender.clarification.mapper.PurchaseClarificationEvaluationGroupMapper;
import com.els.modules.tender.clarification.service.PurchaseClarificationEvaluationGroupService;
import com.els.modules.tender.clarification.service.PurchaseClarificationEvaluationPriceRegulationInfoService;
import com.els.modules.tender.clarification.service.PurchaseClarificationEvaluationRegulationInfoService;
import com.els.modules.tender.clarification.vo.PurchaseClarificationEvaluationGroupVO;
import com.els.modules.tender.common.utils.NumericUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseClarificationEvaluationGroupServiceImpl
extends BaseServiceImpl<PurchaseClarificationEvaluationGroupMapper, PurchaseClarificationEvaluationGroup>
implements PurchaseClarificationEvaluationGroupService {
    @Autowired
    private PurchaseClarificationEvaluationPriceRegulationInfoService clarificationPriceRegulationInfoService;
    @Autowired
    private PurchaseClarificationEvaluationRegulationInfoService clarificationRegulationInfoService;

    @Override
    public List<PurchaseClarificationEvaluationGroup> selectByMainId(String mainId) {
        return ((PurchaseClarificationEvaluationGroupMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseClarificationEvaluationGroupMapper)this.baseMapper).deleteByMainId(mainId);
        this.clarificationRegulationInfoService.deleteByMainId(mainId);
        this.clarificationPriceRegulationInfoService.deleteByMainId(mainId);
    }

    @Override
    public List<PurchaseClarificationEvaluationGroupVO> queryEvaluationInfoVo(String mainId) {
        List<PurchaseClarificationEvaluationGroup> evaluationInfoList = ((PurchaseClarificationEvaluationGroupMapper)this.baseMapper).selectByMainId(mainId);
        if (CollectionUtil.isEmpty(evaluationInfoList)) {
            return new ArrayList<PurchaseClarificationEvaluationGroupVO>();
        }
        List<PurchaseClarificationEvaluationRegulationInfo> regulationInfoList = this.clarificationRegulationInfoService.selectByMainId(mainId);
        Map<String, List<PurchaseClarificationEvaluationRegulationInfo>> regulationInfoListMap = regulationInfoList.parallelStream().collect(Collectors.groupingBy(PurchaseTenderEvaluationRegulationInfo::getGroupId));
        List<PurchaseClarificationEvaluationPriceRegulationInfo> priceRegulationInfoList = this.clarificationPriceRegulationInfoService.selectByMainId(mainId);
        Map<String, List<PurchaseClarificationEvaluationPriceRegulationInfo>> priceRegulationInfoListMap = priceRegulationInfoList.parallelStream().collect(Collectors.groupingBy(PurchaseTenderEvaluationPriceRegulationInfo::getGroupId));
        ArrayList voList = SysUtil.copyProperties(evaluationInfoList, PurchaseClarificationEvaluationGroupVO.class);
        voList.stream().forEach(evaluationInfo -> {
            List regulationInfos = (List)regulationInfoListMap.get(evaluationInfo.getId());
            evaluationInfo.setTenderEvaluationTemplateRegulationInfoList(regulationInfos);
            List priceRegulationInfos = (List)priceRegulationInfoListMap.get(evaluationInfo.getId());
            if (priceRegulationInfos != null && priceRegulationInfos.size() > 0) {
                evaluationInfo.setTenderEvaluationTemplatePriceRegulationInfo((PurchaseClarificationEvaluationPriceRegulationInfo)((Object)((Object)priceRegulationInfos.get(0))));
            }
        });
        return voList;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addTenderEvaluationInfo(List<PurchaseClarificationEvaluationGroupVO> evaluationInfoVoList) {
        ArrayList regulationInfos = new ArrayList(10);
        ArrayList purchaseTenderEvaluationPriceRegulationInfoList = new ArrayList(10);
        List purchaseTenderEvaluationGroupList = evaluationInfoVoList.stream().map(tenderEvaluationInfoVo -> {
            PurchaseClarificationEvaluationPriceRegulationInfo priceRegulationInfo;
            tenderEvaluationInfoVo.setId(IdWorker.getIdStr());
            tenderEvaluationInfoVo.setDeleted(CommonConstant.DEL_FLAG_0);
            List<PurchaseClarificationEvaluationRegulationInfo> regulationInfoList = tenderEvaluationInfoVo.getTenderEvaluationTemplateRegulationInfoList();
            if (CollectionUtil.isNotEmpty(regulationInfoList)) {
                for (PurchaseClarificationEvaluationRegulationInfo tenderEvaluationRegulationInfo : tenderEvaluationInfoVo.getTenderEvaluationTemplateRegulationInfoList()) {
                    tenderEvaluationRegulationInfo.setId(IdWorker.getIdStr());
                    tenderEvaluationRegulationInfo.setSubpackageId(tenderEvaluationInfoVo.getSubpackageId());
                    tenderEvaluationRegulationInfo.setTenderProjectId(tenderEvaluationInfoVo.getTenderProjectId());
                    tenderEvaluationRegulationInfo.setHeadId(tenderEvaluationInfoVo.getHeadId());
                    tenderEvaluationRegulationInfo.setClarificationId(tenderEvaluationInfoVo.getClarificationId());
                    tenderEvaluationRegulationInfo.setGroupId(tenderEvaluationInfoVo.getId());
                    tenderEvaluationRegulationInfo.setDeleted(CommonConstant.DEL_FLAG_0);
                    regulationInfos.add(tenderEvaluationRegulationInfo);
                }
            }
            if (null != (priceRegulationInfo = tenderEvaluationInfoVo.getTenderEvaluationTemplatePriceRegulationInfo())) {
                Assert.isTrue((boolean)NumericUtils.isNumeric(priceRegulationInfo.getAboveScore()), (String)I18nUtil.translate((String)"i18n_alert_suBxUtruWWVWWWzsnWTLWRmK_16af42a6", (String)"\u62a5\u4ef7\u6bcf\u9ad8\u4e8e\u57fa\u51c6\u4ef71%\u6263\u3010x\u3011\u5206\u4e2d\u7684x\u9700\u4e3a\u6570\u503c\u683c\u5f0f"));
                Assert.isTrue((boolean)NumericUtils.isNumeric(priceRegulationInfo.getBelowScore()), (String)I18nUtil.translate((String)"i18n_alert_suBnUtruWWVWWWzsnWTLWRmK_7c4e201c", (String)"\u62a5\u4ef7\u6bcf\u4f4e\u4e8e\u57fa\u51c6\u4ef71%\u6263\u3010x\u3011\u5206\u4e2d\u7684x\u9700\u4e3a\u6570\u503c\u683c\u5f0f"));
                Assert.isTrue((boolean)NumericUtils.isNumeric(priceRegulationInfo.getMostScore()), (String)I18nUtil.translate((String)"i18n_alert_eOVRWWWzsnWTLWRmK_314933d3", (String)"\u6700\u591a\u6263\u81f3\u3010x\u3011\u5206\u4e2d\u7684x\u9700\u4e3a\u6570\u503c\u683c\u5f0f"));
                Assert.isTrue((boolean)NumericUtils.isNumeric(priceRegulationInfo.getLowestScore()), (String)I18nUtil.translate((String)"i18n_alert_enVRWWWzsnWTLWRmK_503f8f1f", (String)"\u6700\u4f4e\u6263\u81f3\u3010x\u3011\u5206\u4e2d\u7684x\u9700\u4e3a\u6570\u503c\u683c\u5f0f"));
                priceRegulationInfo.setId(IdWorker.getIdStr());
                priceRegulationInfo.setSubpackageId(tenderEvaluationInfoVo.getSubpackageId());
                priceRegulationInfo.setTenderProjectId(tenderEvaluationInfoVo.getTenderProjectId());
                priceRegulationInfo.setHeadId(tenderEvaluationInfoVo.getHeadId());
                priceRegulationInfo.setClarificationId(tenderEvaluationInfoVo.getClarificationId());
                priceRegulationInfo.setGroupId(tenderEvaluationInfoVo.getId());
                priceRegulationInfo.setDeleted(CommonConstant.DEL_FLAG_0);
                purchaseTenderEvaluationPriceRegulationInfoList.add(priceRegulationInfo);
            }
            PurchaseClarificationEvaluationGroup purchaseClarificationEvaluationGroup = new PurchaseClarificationEvaluationGroup();
            BeanUtils.copyProperties((Object)tenderEvaluationInfoVo, (Object)((Object)purchaseClarificationEvaluationGroup));
            return purchaseClarificationEvaluationGroup;
        }).collect(Collectors.toList());
        this.saveBatch(purchaseTenderEvaluationGroupList, 2000);
        this.clarificationRegulationInfoService.saveBatch(regulationInfos, 2000);
        this.clarificationPriceRegulationInfoService.saveBatch(purchaseTenderEvaluationPriceRegulationInfoList, 2000);
    }
}

