/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.tender.common.aspect.TenderPermissions;
import com.els.modules.tender.common.aspect.ValidatedTenderStatus;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaHead;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaBidAttachmentInfo;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaInfo;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaHeadService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaInfoService;
import com.els.modules.tender.evaluation.vo.EvaGroupRegulationResultVO;
import com.els.modules.tender.evaluation.vo.EvaLeaderOpinionVO;
import com.els.modules.tender.evaluation.vo.EvaResultVO;
import com.els.modules.tender.evaluation.vo.OfflineBidEvaluationVO;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectBidEvaHeadVO;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectBidEvaRegulationResultVO;
import com.els.modules.tender.evaluation.vo.SummaryEvaGroupResultVO;
import com.els.modules.tender.evaluation.vo.SupplierEvaGroupResultVO;
import com.els.modules.tender.evaluation.vo.SupplierVO;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.enumerate.TenderRoleEnum;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/evaluation/purchaseTenderProjectBidEvaHead"})
@Tag(name="\u8bc4\u6807\u7ba1\u7406")
public class PurchaseTenderProjectBidEvaHeadController
extends BaseController<PurchaseTenderProjectBidEvaHead, PurchaseTenderProjectBidEvaHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderProjectBidEvaHeadController.class);
    @Autowired
    private PurchaseTenderProjectBidEvaHeadService purchaseTenderProjectBidEvaHeadService;
    @Autowired
    private PurchaseTenderProjectEvaInfoService purchaseTenderProjectEvaInfoService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    public Result<?> queryPageList(PurchaseTenderProjectBidEvaHead purchaseTenderProjectBidEvaHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseTenderProjectBidEvaHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_sub_account", (Object)SysUtil.getLoginUser().getSubAccount());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseTenderProjectBidEvaHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseTenderProjectBidEvaHeadVO bidEvaHeadVO = this.purchaseTenderProjectBidEvaHeadService.queryById(id);
        return Result.ok((Object)((Object)bidEvaHeadVO));
    }

    @Operation(summary="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2(\u62db\u6807\u5927\u5385\u4f7f\u7528)", description="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2")
    @GetMapping(value={"/queryBySubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER, TenderRoleEnum.JURY_MEMBER})
    public Result<?> queryBySubpackageId(@RequestParam(name="subpackageId") String subpackageId) {
        PurchaseTenderProjectBidEvaHeadVO bidEvaHeadVO = this.purchaseTenderProjectBidEvaHeadService.queryBySubpackageId(subpackageId);
        if (bidEvaHeadVO != null) {
            PurchaseTenderProjectEvaInfo evaInfo = (PurchaseTenderProjectEvaInfo)((Object)this.purchaseTenderProjectEvaInfoService.getById((Serializable)((Object)bidEvaHeadVO.getEvaInfoId())));
            bidEvaHeadVO.setStageQuoteOperator(evaInfo.getStageQuoteOperator());
            bidEvaHeadVO.setStageQuote(evaInfo.getStageQuote());
        }
        return Result.ok((Object)((Object)bidEvaHeadVO));
    }

    @Operation(summary="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2", description="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2")
    @GetMapping(value={"/querySupplierByEvaGroupId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> querySupplierByEvaGroupId(@RequestParam(name="evaGroupId") String evaGroupId, @RequestParam(name="evaInfoId") String evaInfoId, @RequestParam(name="supplierAccount") String supplierAccount) {
        EvaGroupRegulationResultVO evaGroupRegulationResultVO = this.purchaseTenderProjectBidEvaHeadService.querySupplierByEvaGroupId(evaGroupId, evaInfoId, supplierAccount);
        return Result.ok((Object)((Object)evaGroupRegulationResultVO));
    }

    @Operation(summary="\u901a\u8fc7\u6761\u4f8b\u7ec4Id\u67e5\u8be2\u4f9b\u5e94\u5546\u8bc4\u6807\u7ed3\u679c", description="\u901a\u8fc7\u6761\u4f8b\u7ec4Id\u67e5\u8be2\u4f9b\u5e94\u5546\u8bc4\u6807\u7ed3\u679c")
    @GetMapping(value={"/querySupplierEvaGroupResultByGroupId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> querySupplierEvaGroupResultByGroupId(@RequestParam(name="evaGroupId") String evaGroupId, @RequestParam(name="judgesTaskItemId") String judgesTaskItemId) {
        SupplierEvaGroupResultVO supplierEvaGroupResultVO = this.purchaseTenderProjectBidEvaHeadService.querySupplierResultByGroupId(evaGroupId, judgesTaskItemId);
        return Result.ok((Object)((Object)supplierEvaGroupResultVO));
    }

    @Operation(summary="\u901a\u8fc7\u6761\u4f8b\u7ec4Id\u67e5\u8be2\u6c47\u603b\u8bc4\u6807\u7ed3\u679c", description="\u901a\u8fc7\u6761\u4f8b\u7ec4Id\u67e5\u8be2\u6c47\u603b\u8bc4\u6807\u7ed3\u679c")
    @GetMapping(value={"/querySummaryEvaGroupResultByGroupId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> querySummaryEvaGroupResultByGroupId(@RequestParam(name="evaGroupId") String evaGroupId, @RequestParam(name="evaInfoId") String evaInfoId) {
        SummaryEvaGroupResultVO supplierEvaGroupResultVO = this.purchaseTenderProjectBidEvaHeadService.querySummaryEvaGroupResultByGroupId(evaGroupId, evaInfoId);
        return Result.ok((Object)((Object)supplierEvaGroupResultVO));
    }

    @AutoLog(value="\u8bc4\u6807\u7ba1\u7406-\u4fdd\u5b58\u4f9b\u5e94\u5546\u8bc4\u6807\u7ed3\u679c")
    @Operation(summary="\u4fdd\u5b58\u4f9b\u5e94\u5546\u8bc4\u6807\u7ed3\u679c", description="\u4fdd\u5b58\u4f9b\u5e94\u5546\u8bc4\u6807\u7ed3\u679c")
    @PostMapping(value={"/saveSupplierEvaGroupResult"})
    @SrmValidated
    @RequiresPermissions(value={"tender#purchaseTenderProjectBidEvaHead:save"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> saveSupplierEvaGroupResult(@RequestBody SupplierEvaGroupResultVO supplierEvaGroupResultVO) {
        List<SupplierVO> supplierList = supplierEvaGroupResultVO.getSupplierList();
        Iterator<SupplierVO> iterator = supplierList.iterator();
        while (iterator.hasNext()) {
            SupplierVO supplierVO = iterator.next();
            if ("1".equals(supplierVO.getInvalid())) {
                iterator.remove();
                continue;
            }
            if (supplierEvaGroupResultVO.getEvaResultListMap() == null) continue;
            List<PurchaseTenderProjectBidEvaRegulationResultVO> resultVOList = supplierEvaGroupResultVO.getEvaResultListMap().get(supplierVO.getSupplierAccount());
            supplierVO.setBidEvaRegulationResultList(resultVOList);
        }
        Assert.isTrue((!supplierList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_RdXIbxQKWxiTtkWqUBsRSVVUBSHcdIQBW_5e61ee5a", (String)"\u4f9b\u5e94\u5546\u5df2\u5168\u90e8\u5426\u51b3\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff0c\u53ef\u8bc4\u6807\u7ec8\u6b62\u540e\u91cd\u65b0\u8bc4\u6807\u6216\u8fdb\u884c\u9879\u76ee\u6d41\u6807!"));
        this.purchaseTenderProjectBidEvaHeadService.saveSupplierEvaGroupResult(supplierEvaGroupResultVO.getEvaluationGroupType(), supplierList);
        return Result.ok();
    }

    @AutoLog(value="\u8bc4\u6807\u7ba1\u7406-\u63d0\u4ea4\u4f9b\u5e94\u5546\u8bc4\u6807\u7ed3\u679c")
    @Operation(summary="\u63d0\u4ea4\u4f9b\u5e94\u5546\u8bc4\u6807\u7ed3\u679c", description="\u63d0\u4ea4\u4f9b\u5e94\u5546\u8bc4\u6807\u7ed3\u679c")
    @PostMapping(value={"/publishSupplierEvaGroupResult"})
    @SrmValidated
    @RequiresPermissions(value={"tender#purchaseTenderProjectBidEvaHead:publish"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> publishSupplierEvaGroupResult(@RequestBody SupplierEvaGroupResultVO supplierEvaGroupResultVO) {
        List<SupplierVO> supplierList = supplierEvaGroupResultVO.getSupplierList();
        Iterator<SupplierVO> iterator = supplierList.iterator();
        while (iterator.hasNext()) {
            SupplierVO supplierVO = iterator.next();
            if ("1".equals(supplierVO.getInvalid())) {
                iterator.remove();
                continue;
            }
            if (supplierEvaGroupResultVO.getEvaResultListMap() == null) continue;
            List<PurchaseTenderProjectBidEvaRegulationResultVO> resultVOList = supplierEvaGroupResultVO.getEvaResultListMap().get(supplierVO.getSupplierAccount());
            supplierVO.setBidEvaRegulationResultList(resultVOList);
        }
        Assert.isTrue((!supplierList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_RdXIbxQKWxiTtkWqUBsRSVVUBSHcdIQBW_5e61ee5a", (String)"\u4f9b\u5e94\u5546\u5df2\u5168\u90e8\u5426\u51b3\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff0c\u53ef\u8bc4\u6807\u7ec8\u6b62\u540e\u91cd\u65b0\u8bc4\u6807\u6216\u8fdb\u884c\u9879\u76ee\u6d41\u6807!"));
        this.purchaseTenderProjectBidEvaHeadService.publishSupplierEvaGroupResult(supplierEvaGroupResultVO.getEvaluationGroupType(), supplierList);
        return Result.ok();
    }

    @Operation(summary="\u67e5\u8be2\u4f9b\u5e94\u5546\u6392\u540d\u4e2d\u6807\u4fe1\u606f", description="\u67e5\u8be2\u4f9b\u5e94\u5546\u6392\u540d\u4e2d\u6807\u4fe1\u606f")
    @GetMapping(value={"/getSupplierEvaRanking"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> getSupplierEvaRanking(@RequestParam(name="evaInfoId") String evaInfoId) {
        EvaResultVO evaResultVO = this.purchaseTenderProjectBidEvaHeadService.getSupplierEvaRanking(evaInfoId);
        return Result.ok((Object)evaResultVO);
    }

    @Operation(summary="\u67e5\u8be2\u8bc4\u6807\u662f\u5426\u5b8c\u6210", description="\u67e5\u8be2\u8bc4\u6807\u662f\u5426\u5b8c\u6210")
    @GetMapping(value={"/isEvaFinish"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> isEvaFinish(@RequestParam(name="evaInfoId") String evaInfoId) {
        return Result.ok((Object)this.purchaseTenderProjectBidEvaHeadService.isEvaFinish(evaInfoId));
    }

    @Operation(summary="\u67e5\u8be2\u8bc4\u6807\u662f\u5426\u53ef\u4ee5\u8bc4\u6807", description="\u67e5\u8be2\u8bc4\u6807\u662f\u5426\u53ef\u4ee5\u8bc4\u6807")
    @GetMapping(value={"/isArrowEva"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> isAllowEva(@RequestParam(name="evaGroupId") String evaGroupId, @RequestParam(name="judgesTaskItemId") String judgesTaskItemId) {
        return Result.ok((Object)this.purchaseTenderProjectBidEvaHeadService.isAllowEva(evaGroupId, judgesTaskItemId));
    }

    @AutoLog(value="\u8bc4\u6807\u7ba1\u7406-\u7ed3\u675f\u8bc4\u6807")
    @Operation(summary="\u7ed3\u675f\u8bc4\u6807", description="\u7ed3\u675f\u8bc4\u6807")
    @PostMapping(value={"/saveEvaResult"})
    @SrmValidated
    @RequiresPermissions(value={"tender#purchaseTenderProjectBidEvaHead:save"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> saveEvaResult(@RequestBody EvaResultVO evaResultVO) {
        this.purchaseTenderProjectBidEvaHeadService.saveEvaResult(evaResultVO);
        return Result.ok();
    }

    @AutoLog(value="\u8bc4\u6807\u7ba1\u7406-\u4ef7\u683c\u8bc4\u5206\u8ba1\u7b97")
    @Operation(summary="\u4ef7\u683c\u8bc4\u5206\u8ba1\u7b97", description="\u4ef7\u683c\u8bc4\u5206\u8ba1\u7b97")
    @PostMapping(value={"/priceScoreCalculation"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> priceScoreCalculation(@RequestBody List<PurchaseTenderProjectBidEvaRegulationResultVO> regulationCalList) {
        Assert.isTrue((!regulationCalList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_RdXIbxQKWxiTtkWqUBsRSVVUBSHcdIQBW_5e61ee5a", (String)"\u4f9b\u5e94\u5546\u5df2\u5168\u90e8\u5426\u51b3\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff0c\u53ef\u8bc4\u6807\u7ec8\u6b62\u540e\u91cd\u65b0\u8bc4\u6807\u6216\u8fdb\u884c\u9879\u76ee\u6d41\u6807!"));
        int index = 0;
        for (PurchaseTenderProjectBidEvaRegulationResultVO resultVO : regulationCalList) {
            resultVO.setKeepOrder(index++);
        }
        List<PurchaseTenderProjectBidEvaRegulationResultVO> result = this.purchaseTenderProjectBidEvaHeadService.priceScoreCalculation(regulationCalList);
        result = result.stream().sorted(Comparator.comparing(PurchaseTenderProjectBidEvaRegulationResultVO::getKeepOrder)).collect(Collectors.toList());
        return Result.ok(result);
    }

    @AutoLog(value="\u8bc4\u6807\u7ba1\u7406-\u8bc4\u6807\u7ec8\u6b62")
    @Operation(summary="\u8bc4\u6807\u7ba1\u7406-\u8bc4\u6807\u7ec8\u6b62", description="\u8bc4\u6807\u7ba1\u7406-\u8bc4\u6807\u7ec8\u6b62")
    @PostMapping(value={"/termination"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> termination(@RequestBody PurchaseTenderProjectBidEvaHead bidEvaHead) {
        this.purchaseTenderProjectBidEvaHeadService.termination(bidEvaHead);
        return Result.ok();
    }

    @AutoLog(value="\u8bc4\u6807\u7ba1\u7406-\u91cd\u65b0\u8bc4\u6807")
    @Operation(summary="\u8bc4\u6807\u7ba1\u7406-\u91cd\u65b0\u8bc4\u6807", description="\u8bc4\u6807\u7ba1\u7406-\u91cd\u65b0\u8bc4\u6807")
    @PostMapping(value={"/reEvaluate"})
    @SrmValidated
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> reEvaluate(@RequestBody PurchaseTenderProjectBidEvaHead bidEvaHead) {
        this.purchaseTenderProjectBidEvaHeadService.reEvaluate(bidEvaHead);
        return Result.ok();
    }

    @Operation(summary="\u901a\u8fc7\u5206\u5305Id\u67e5\u8be2\u7ebf\u4e0b\u8bc4\u6807\u7ed3\u679c", description="\u901a\u8fc7\u5206\u5305Id\u67e5\u8be2\u7ebf\u4e0b\u8bc4\u6807\u7ed3\u679c")
    @GetMapping(value={"/queryOfflineBidEvaluationBySubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER, TenderRoleEnum.JURY_MEMBER})
    public Result<?> queryOfflineBidEvaluationBySubpackageId(@RequestParam(name="subpackageId") String subpackageId) {
        OfflineBidEvaluationVO offlineBidEvaluationVO = this.purchaseTenderProjectBidEvaHeadService.queryOfflineBidEvaluationBySubpackageId(subpackageId);
        return Result.ok((Object)((Object)offlineBidEvaluationVO));
    }

    @AutoLog(value="\u8bc4\u6807\u7ba1\u7406-\u4fdd\u5b58\u7ebf\u4e0b\u8bc4\u6807\u7ed3\u679c")
    @Operation(summary="\u4fdd\u5b58\u7ebf\u4e0b\u8bc4\u6807\u7ed3\u679c", description="\u4fdd\u5b58\u7ebf\u4e0b\u8bc4\u6807\u7ed3\u679c")
    @PostMapping(value={"/saveOfflineBidEvaluationResult"})
    @SrmValidated
    @RequiresPermissions(value={"tender#purchaseTenderProjectBidEvaHead:save"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> saveOfflineBidEvaluationResult(@RequestBody OfflineBidEvaluationVO offlineBidEvaluationVO) {
        PurchaseTenderProjectEvaInfo evaInfo = (PurchaseTenderProjectEvaInfo)((Object)SysUtil.copyProperties((Object)((Object)offlineBidEvaluationVO), PurchaseTenderProjectEvaInfo.class));
        this.purchaseTenderProjectBidEvaHeadService.saveOfflineBidEvaluationResult(evaInfo, offlineBidEvaluationVO.getBidEvaSupplierRecordList(), offlineBidEvaluationVO.getEvaBidAttachmentInfoList());
        return Result.ok((Object)((Object)this.purchaseTenderProjectBidEvaHeadService.queryOfflineBidEvaluationBySubpackageId(evaInfo.getSubpackageId())));
    }

    @AutoLog(value="\u8bc4\u6807\u7ba1\u7406-\u7f16\u8f91\u7ebf\u4e0b\u8bc4\u6807\u7ed3\u679c")
    @Operation(summary="\u7f16\u8f91\u7ebf\u4e0b\u8bc4\u6807\u7ed3\u679c", description="\u7f16\u8f91\u7ebf\u4e0b\u8bc4\u6807\u7ed3\u679c")
    @PostMapping(value={"/editOfflineBidEvaluationResult"})
    @SrmValidated
    @RequiresPermissions(value={"tender#purchaseTenderProjectBidEvaHead:save"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> editOfflineBidEvaluationResult(@RequestBody OfflineBidEvaluationVO offlineBidEvaluationVO) {
        PurchaseTenderProjectEvaInfo evaInfo = (PurchaseTenderProjectEvaInfo)((Object)SysUtil.copyProperties((Object)((Object)offlineBidEvaluationVO), PurchaseTenderProjectEvaInfo.class));
        this.purchaseTenderProjectBidEvaHeadService.editOfflineBidEvaluationResult(evaInfo, offlineBidEvaluationVO.getBidEvaSupplierRecordList(), offlineBidEvaluationVO.getEvaBidAttachmentInfoList());
        return Result.ok((Object)((Object)this.purchaseTenderProjectBidEvaHeadService.queryOfflineBidEvaluationBySubpackageId(evaInfo.getSubpackageId())));
    }

    @AutoLog(value="\u8bc4\u6807\u7ba1\u7406-\u63d0\u4ea4\u7ebf\u4e0b\u8bc4\u6807\u7ed3\u679c")
    @Operation(summary="\u63d0\u4ea4\u7ebf\u4e0b\u8bc4\u6807\u7ed3\u679c", description="\u63d0\u4ea4\u7ebf\u4e0b\u8bc4\u6807\u7ed3\u679c")
    @PostMapping(value={"/publishOfflineBidEvaluationResult"})
    @SrmValidated
    @RequiresPermissions(value={"tender#purchaseTenderProjectBidEvaHead:publish"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> publishOfflineBidEvaluationResult(@RequestBody OfflineBidEvaluationVO offlineBidEvaluationVO) {
        PurchaseTenderProjectEvaInfo evaInfo = (PurchaseTenderProjectEvaInfo)((Object)SysUtil.copyProperties((Object)((Object)offlineBidEvaluationVO), PurchaseTenderProjectEvaInfo.class));
        this.purchaseTenderProjectBidEvaHeadService.publishOfflineBidEvaluationResult(evaInfo, offlineBidEvaluationVO.getBidEvaSupplierRecordList(), offlineBidEvaluationVO.getEvaBidAttachmentInfoList());
        return Result.ok((Object)((Object)this.purchaseTenderProjectBidEvaHeadService.queryOfflineBidEvaluationBySubpackageId(evaInfo.getSubpackageId())));
    }

    @GetMapping(value={"/downloadWord"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> downloadPDF(@RequestParam(name="id", required=true) String id, HttpServletRequest request, HttpServletResponse response) {
        this.purchaseTenderProjectBidEvaHeadService.downloadWord(id, request, response);
        return Result.ok();
    }

    @AutoLog(value="\u8bc4\u6807\u7ba1\u7406-\u4fdd\u5b58\u9644\u4ef6\u4fe1\u606f")
    @Operation(summary="\u4fdd\u5b58\u9644\u4ef6\u4fe1\u606f", description="\u4fdd\u5b58\u9644\u4ef6\u4fe1\u606f")
    @PostMapping(value={"/saveEvaAttachmentInfo"})
    @SrmValidated
    @RequiresPermissions(value={"tender#purchaseTenderProjectBidEvaHead:save"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> saveEvaAttachmentInfo(@RequestBody PurchaseTenderProjectEvaBidAttachmentInfo attachmentInfo) {
        this.purchaseTenderProjectBidEvaHeadService.saveEvaAttachmentInfo(attachmentInfo);
        return Result.ok();
    }

    @AutoLog(value="\u8bc4\u6807\u7ba1\u7406-\u5220\u9664\u9644\u4ef6")
    @Operation(summary="\u5220\u9664\u9644\u4ef6", description="\u5220\u9664\u9644\u4ef6")
    @GetMapping(value={"/deleteEvaAttachmentInfo"})
    @RequiresPermissions(value={"tender#purchaseTenderProjectBidEvaHead:operational"})
    public Result<?> deleteEvaAttachmentInfo(@RequestParam(value="id") String id) {
        this.purchaseTenderProjectBidEvaHeadService.deleteEvaAttachmentInfo(id);
        return Result.ok();
    }

    @GetMapping(value={"/queryAttachmentInfo"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryAttachmentInfo(@RequestParam(name="evaInfoId") String evaInfoId, @RequestParam(name="fileType") String fileType, HttpServletRequest request, HttpServletResponse response) {
        PurchaseTenderProjectEvaBidAttachmentInfo info = this.purchaseTenderProjectBidEvaHeadService.queryAttachmentInfo(evaInfoId, fileType);
        return Result.ok((Object)((Object)info));
    }

    @Operation(summary="\u901a\u8fc7\u5934Id\u67e5\u8be2\u5c0f\u7ec4\u957f\u8bc4\u6807\u610f\u89c1", description="\u901a\u8fc7\u5934Id\u67e5\u8be2\u5c0f\u7ec4\u957f\u8bc4\u6807\u610f\u89c1")
    @GetMapping(value={"/queryLeaderOpinion"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryLeaderOpinion(@RequestParam(name="evaInfoId") String evaInfoId, @RequestParam(name="evaGroupId") String evaGroupId) {
        EvaLeaderOpinionVO evaLeaderOpinionVO = this.purchaseTenderProjectBidEvaHeadService.queryLeaderOpinion(evaInfoId, evaGroupId);
        return Result.ok((Object)evaLeaderOpinionVO);
    }

    @Operation(summary="\u4fdd\u5b58\u5c0f\u7ec4\u957f\u8bc4\u6807\u610f\u89c1", description="\u4fdd\u5b58\u5c0f\u7ec4\u957f\u8bc4\u6807\u610f\u89c1")
    @PostMapping(value={"/saveLeaderOpinion"})
    @RequiresPermissions(value={"tender#purchaseTenderProjectBidEvaHead:save"})
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> saveLeaderOpinion(@RequestBody EvaLeaderOpinionVO evaLeaderOpinionVO) {
        this.purchaseTenderProjectBidEvaHeadService.saveLeaderOpinion(evaLeaderOpinionVO);
        return Result.ok((Object)evaLeaderOpinionVO);
    }
}

