/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.tender.calibration.enumerate.BidWinningCandidatePublicityStatusEnum;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidWinningCandidate;
import com.els.modules.tender.evaluation.enumerate.PurchaseTenderProjectBidWinningCandidateStatusEnum;
import com.els.modules.tender.evaluation.mapper.PurchaseTenderProjectBidWinningCandidateMapper;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidWinningCandidateService;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCurrentStepEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderProjectBidWinningCandidateServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectBidWinningCandidateMapper, PurchaseTenderProjectBidWinningCandidate>
implements PurchaseTenderProjectBidWinningCandidateService {
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;

    @Override
    public void deleteByMainId(String evaInfoId) {
        ((PurchaseTenderProjectBidWinningCandidateMapper)this.baseMapper).deleteByMainId(evaInfoId);
    }

    @Override
    public List<PurchaseTenderProjectBidWinningCandidate> queryCandidateAcquisition(PurchaseTenderProjectBidWinningCandidate candidate) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseTenderProjectBidWinningCandidate::getTenderProjectId, (Object)candidate.getTenderProjectId());
        queryWrapper.eq(PurchaseTenderProjectBidWinningCandidate::getSubpackageId, (Object)candidate.getSubpackageId());
        return ((PurchaseTenderProjectBidWinningCandidateMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<PurchaseTenderProjectBidWinningCandidate> selectBySubpackageId(String subpackageId, String candidateStatus) {
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderCurrentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        return ((PurchaseTenderProjectBidWinningCandidateMapper)this.baseMapper).selectBySubpackageId(subpackageId, candidateStatus, tenderCheckType, tenderProcessType, tenderCurrentStep);
    }

    @Override
    public List<PurchaseTenderProjectBidWinningCandidate> selectBidWinningResultBySubpackageId(String subpackageId, String candidateStatus) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)subpackageId)));
        String tenderProcessType = subpackageInfo.getProcessType();
        String tenderCurrentStep = null;
        if (SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(tenderProcessType)) {
            tenderCurrentStep = SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue();
        }
        return ((PurchaseTenderProjectBidWinningCandidateMapper)this.baseMapper).selectBySubpackageId(subpackageId, candidateStatus, SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue(), tenderProcessType, tenderCurrentStep);
    }

    @Override
    public List<PurchaseTenderProjectBidWinningCandidate> selectByEvaInfoId(String evaInfoId) {
        return ((PurchaseTenderProjectBidWinningCandidateMapper)this.baseMapper).selectByEvaInfoId(evaInfoId);
    }

    @Override
    public void updateBidWinningCandidateStatus(List<String> bidWinningCandidateIds, String subpackageId, String candidatePublicityStatus) {
        if (BidWinningCandidatePublicityStatusEnum.FINISH.getValue().equals(candidatePublicityStatus)) {
            List<PurchaseTenderProjectBidWinningCandidate> bidWinningCandidates = this.selectBySubpackageId(subpackageId, PurchaseTenderProjectBidWinningCandidateStatusEnum.CHECK.getValue());
            bidWinningCandidates.forEach(bidWinningCandidate -> bidWinningCandidate.setCandidateStatus(PurchaseTenderProjectBidWinningCandidateStatusEnum.AFFIRM.getValue()));
            this.updateBatchById(bidWinningCandidates);
        } else {
            List<PurchaseTenderProjectBidWinningCandidate> bidWinningCandidates = this.selectBidWinningResultBySubpackageId(subpackageId, null);
            Assert.isTrue((boolean)CollectionUtil.isNotEmpty(bidWinningCandidates), (String)I18nUtil.translate((String)"i18n_field_sBSiLVHxMKW_e41143c2", (String)"\u4e2d\u6807\u5019\u9009\u4eba\u4fe1\u606f\u4e0d\u5b58\u5728!"));
            bidWinningCandidates.forEach(bidWinningCandidate -> {
                if (bidWinningCandidateIds.contains(bidWinningCandidate.getId())) {
                    bidWinningCandidate.setCandidateStatus(PurchaseTenderProjectBidWinningCandidateStatusEnum.CHECK.getValue());
                } else {
                    bidWinningCandidate.setCandidateStatus(PurchaseTenderProjectBidWinningCandidateStatusEnum.NEW.getValue());
                }
            });
            this.updateBatchById(bidWinningCandidates);
        }
    }
}

