/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.openbid.job;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.service.JobRpcService;
import com.els.common.util.BusMessageUtil;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.openbid.job.TenderJobUtil;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoCurrentStepEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public abstract class AbstractTenderOpenBidForewarningJobService
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(AbstractTenderOpenBidForewarningJobService.class);

    public void doExecute(String parameter) {
        log.info(" \u62db\u6807\u89e3\u5bc6\u5012\u8ba1\u65f6\u5b9a\u65f6\u4efb\u52a1 AbstractTenderOpenBidForewarningJobService \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        if (StrUtil.isEmpty((CharSequence)parameter)) {
            log.error("parameter must not be null.");
            return;
        }
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String id = paramObj.getString("id");
        String checkType = paramObj.getString("checkType");
        String processType = paramObj.getString("processType");
        String currentStep = paramObj.getString("currentStep");
        String tenantId = paramObj.getString("tenantId");
        if (StrUtil.isEmpty((CharSequence)id) || StrUtil.isEmpty((CharSequence)checkType)) {
            log.error("parameter must contain {}.{}.{}.{}", new Object[]{id, checkType, processType, currentStep});
            return;
        }
        TenderFlagInjectionContext.setTenderCheckType(checkType);
        TenderFlagInjectionContext.setTenderProcessType(processType);
        TenderFlagInjectionContext.setTenderCurrentStep(currentStep);
        TenantContext.setTenant((String)tenantId);
        TenderProjectSupplierService supplierService = (TenderProjectSupplierService)SpringContextUtils.getBean(TenderProjectSupplierService.class);
        PurchaseTenderProjectSubpackageInfoService subpackageInfoService = (PurchaseTenderProjectSubpackageInfoService)SpringContextUtils.getBean(PurchaseTenderProjectSubpackageInfoService.class);
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)subpackageInfoService.getById((Serializable)((Object)id)));
        TenderProjectSupplier querySupplier = new TenderProjectSupplier();
        querySupplier.setEffective("1");
        querySupplier.setSubpackageId(id);
        List<TenderProjectSupplier> projectSupplierList = supplierService.selectBySubpackageId(querySupplier);
        if (CollectionUtil.isNotEmpty(projectSupplierList)) {
            List<String> supplierAccountList = null;
            String operation = null;
            if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(checkType)) {
                operation = "preTenderAlert";
                supplierAccountList = projectSupplierList.stream().filter(supplier -> "1".equals(supplier.getPreResponseStatus())).map(TenderProjectSupplier::getSupplierAccount).collect(Collectors.toList());
            } else if (SubpackageInfoCurrentStepEnum.SECOND_STEP.getValue().equals(currentStep)) {
                supplierAccountList = projectSupplierList.stream().filter(supplier -> "1".equals(supplier.getShortlisted())).map(TenderProjectSupplier::getSupplierAccount).collect(Collectors.toList());
                operation = "secondTenderAlert";
            } else {
                supplierAccountList = projectSupplierList.stream().filter(supplier -> "1".equals(supplier.getResponseStatus())).map(TenderProjectSupplier::getSupplierAccount).collect(Collectors.toList());
                operation = "firstTenderAlert";
                if (SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(subpackageInfo.getProcessType())) {
                    operation = "tenderAlert";
                }
            }
            TenderProjectSupplier supplier2 = projectSupplierList.get(0);
            StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(supplier2.getTenderProjectId()).append("&subpackageId=").append(supplier2.getSubpackageId());
            this.sendMsg(supplier2.getPurchaseEnterpriseAccount(), supplierAccountList, (Object)supplier2, urlParams.toString(), "tender", operation);
        }
        String jobKey = paramObj.getString("jobKey");
        TenderJobUtil.deleteJob(jobKey);
        log.info(" \u62db\u6807\u5f00\u6807\u9884\u8b66\u5b9a\u65f6\u4efb\u52a1 AbstractTenderOpenBidForewarningJobService \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
    }

    public void sendMsg(String purchaseElsAccount, List<String> toElsAccountList, Object object, String url, String businessType, String operateType) {
        try {
            TenantContext.setTenant((String)purchaseElsAccount);
            AccountRpcService accountRpcService = (AccountRpcService)SpringContextUtils.getBean(AccountRpcService.class);
            ElsSubAccountDTO account = accountRpcService.getAccount(purchaseElsAccount, "1001");
            LoginUserDTO loginUser = new LoginUserDTO();
            BeanUtils.copyProperties((Object)account, (Object)loginUser);
            CoreInvokeSupplierRpcService coreInvokeSupplierRpcService = (CoreInvokeSupplierRpcService)SpringContextUtils.getBean(CoreInvokeSupplierRpcService.class);
            Map receiverMap = coreInvokeSupplierRpcService.getSupplierContacts(purchaseElsAccount, toElsAccountList, businessType, operateType);
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgKey", (Object)IdWorker.getIdStr());
            msgObj.put("busAccount", (Object)purchaseElsAccount);
            msgObj.put("businessType", (Object)businessType);
            msgObj.put("operateType", (Object)operateType);
            msgObj.put("businessObj", (Object)SysUtil.objectToJSON((Object)object));
            msgObj.put("sendObj", (Object)loginUser);
            JSONArray array = new JSONArray();
            for (String toElsAccount : receiverMap.keySet()) {
                JSONArray toSubAccountArray = JSONArray.parseArray((String)JSON.toJSONString(receiverMap.get(toElsAccount)));
                JSONObject receiveObj = new JSONObject();
                receiveObj.put("toElsAccount", (Object)toElsAccount);
                receiveObj.put("urlParam", (Object)url);
                receiveObj.put("toSubAccountList", (Object)toSubAccountArray);
                array.add((Object)receiveObj);
            }
            msgObj.put("receiveList", (Object)array);
            BusMessageUtil.sendBusMsg((String)msgObj.toJSONString(), (String)IdWorker.getIdStr());
        }
        catch (Exception e) {
            log.error("sendMsg failed:", (Throwable)e);
        }
    }
}

