/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.process.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.tender.evaluation.entity.TenderEvaluationTemplateHead;
import com.els.modules.tender.process.entity.TenderProcessModelHead;
import com.els.modules.tender.process.entity.TenderProcessModelNode;
import com.els.modules.tender.process.service.TenderProcessModelHeadService;
import com.els.modules.tender.process.service.TenderProcessModelNodeService;
import com.els.modules.tender.process.vo.TenderProcessModelHeadVO;
import com.els.modules.tender.process.vo.TenderProcessNodeGroupVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/tenderProcessModelHead"})
@Tag(name="\u62db\u6807\u6d41\u7a0b")
public class TenderProcessModelHeadController
extends BaseController<TenderProcessModelHead, TenderProcessModelHeadService> {
    private static final Logger log = LoggerFactory.getLogger(TenderProcessModelHeadController.class);
    @Autowired
    private TenderProcessModelHeadService tenderProcessModelHeadService;
    @Autowired
    private TenderProcessModelNodeService tenderProcessModelNodeService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    @PermissionDataView(businessType="tenderProcessModel")
    public Result<?> queryPageList(TenderProcessModelHead tenderProcessModelHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)tenderProcessModelHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.tenderProcessModelHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u67e5\u8be2\u5217\u8868\u660e\u7ec6", description="\u67e5\u8be2\u5217\u8868\u660e\u7ec6")
    @GetMapping(value={"/listDetial"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    public Result<?> querryListDetail() {
        List<TenderProcessModelHeadVO> list = this.tenderProcessModelHeadService.querryListDetail();
        return Result.ok(list);
    }

    @AutoLog(busModule="\u62db\u6807\u6d41\u7a0b", value="\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"tender#tenderProcessModelHead:add"})
    @SrmValidated
    @PermissionDataOpt(businessType="tenderProcessModel", beanClass=TenderProcessModelHeadService.class)
    public Result<?> add(@RequestBody TenderProcessModelHeadVO tenderProcessModelHeadPage) {
        TenderProcessModelHead tenderProcessModelHead = new TenderProcessModelHead();
        BeanUtils.copyProperties((Object)((Object)tenderProcessModelHeadPage), (Object)((Object)tenderProcessModelHead));
        this.tenderProcessModelHeadService.saveMain(tenderProcessModelHead, tenderProcessModelHeadPage.getNodeIds());
        return Result.ok((Object)((Object)tenderProcessModelHead));
    }

    @AutoLog(busModule="\u62db\u6807\u6d41\u7a0b", value="\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"tender#tenderProcessModelHead:edit"})
    @SrmValidated
    @PermissionDataOpt(businessType="tenderProcessModel", beanClass=TenderProcessModelHeadService.class)
    public Result<?> edit(@RequestBody TenderProcessModelHeadVO tenderProcessModelHeadPage) {
        TenderProcessModelHead tenderProcessModelHead = new TenderProcessModelHead();
        BeanUtils.copyProperties((Object)((Object)tenderProcessModelHeadPage), (Object)((Object)tenderProcessModelHead));
        this.tenderProcessModelHeadService.updateMain(tenderProcessModelHead, tenderProcessModelHeadPage.getNodeIds());
        String id = tenderProcessModelHead.getId();
        return this.queryById(id);
    }

    @AutoLog(busModule="\u62db\u6807\u6d41\u7a0b", value="\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"tender#tenderProcessModelHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.tenderProcessModelHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u62db\u6807\u6d41\u7a0b", value="\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"tender#tenderProcessModelHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.tenderProcessModelHeadService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TenderProcessModelHead tenderProcessModelHead = (TenderProcessModelHead)((Object)this.tenderProcessModelHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        TenderProcessModelHeadVO tenderProcessModelHeadVO = new TenderProcessModelHeadVO();
        BeanUtils.copyProperties((Object)((Object)tenderProcessModelHead), (Object)((Object)tenderProcessModelHeadVO));
        List<TenderProcessModelNode> tenderProcessModelNodeList = this.tenderProcessModelNodeService.selectByMainId(id);
        tenderProcessModelHeadVO.setTenderProcessModelNodeList(tenderProcessModelNodeList);
        return Result.ok((Object)((Object)tenderProcessModelHeadVO));
    }

    @Operation(summary="\u53d1\u5e03", description="\u53d1\u5e03")
    @GetMapping(value={"/publish"})
    @RequiresPermissions(value={"tender#tenderProcessModelHead:publish"})
    @PermissionDataOpt(businessType="tenderProcessModel", beanClass=TenderProcessModelHeadService.class)
    public Result<?> publish(@RequestParam(name="id") String id) {
        this.tenderProcessModelHeadService.publish(id);
        return Result.ok();
    }

    @Operation(summary="\u901a\u8fc7\u62db\u6807\u6d41\u7a0bid\u67e5\u8be2\u62db\u6807\u6d41\u7a0b\u660e\u7ec6", description="\u901a\u8fc7\u62db\u6807\u6d41\u7a0bid\u67e5\u8be2\u62db\u6807\u6d41\u7a0b\u660e\u7ec6")
    @GetMapping(value={"/queryTenderProcessModelItemByMainId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryTenderProcessModelItemListByMainId(@RequestParam(name="id") String id) {
        List<TenderProcessModelNode> tenderProcessModelNodeList = this.tenderProcessModelNodeService.selectByMainId(id);
        return Result.ok(tenderProcessModelNodeList);
    }

    @Operation(summary="\u6839\u636e\u5fc5\u9009/\u975e\u5fc5\u9009\u5206\u7ec4\u67e5\u8be2\u8282\u70b9\u5217\u8868", description="\u6839\u636e\u5fc5\u9009/\u975e\u5fc5\u9009\u5206\u7ec4\u67e5\u8be2\u8282\u70b9\u5217\u8868")
    @PostMapping(value={"/queryNodeByGruop"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    @SrmValidated
    public Result<?> queryNodeByGruop(@RequestBody TenderProcessModelHead tenderProcessModelHead) {
        TenderProcessNodeGroupVO tenderProcessNodeGroupVO = this.tenderProcessModelHeadService.queryByGruop(tenderProcessModelHead);
        return Result.ok((Object)tenderProcessNodeGroupVO);
    }

    @Operation(summary="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    @PermissionDataView(businessType="tenderProcessModel")
    public Result<?> queryTabsCount(TenderEvaluationTemplateHead tenderEvaluationTemplateHead, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)tenderEvaluationTemplateHead), (Map)req.getParameterMap());
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        List<CountVO> countVOList = this.tenderProcessModelHeadService.queryTabsCount(TenantContext.getTenant(), (QueryWrapper<TenderEvaluationTemplateHead>)queryWrapper);
        Map<String, Long> countMap = countVOList.stream().collect(Collectors.toMap(o -> o.getValue(), o -> o.getTotal()));
        long totalCount = countVOList.stream().mapToLong(CountVO::getTotal).sum();
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "status", null, totalCount));
        List dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("tenderProcessModelHeadStatus", TenantContext.getTenant());
        if (CollectionUtil.isNotEmpty((Collection)dictDTOList)) {
            for (DictDTO status : dictDTOList) {
                long count = countMap.get(status.getValue()) == null ? 0L : countMap.get(status.getValue());
                result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "status", status.getValue(), count));
            }
        }
        return Result.ok(result);
    }
}

