/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.project.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.entity.PurchaseTenderSubpackagePriceChange;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.service.PurchaseTenderSubpackagePriceChangeService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u91c7\u8d2d\u9879\u76ee\u6210\u5458\u7ec4\u8868")
@RestController
@RequestMapping(value={"/tender/project/subpackagePriceChange"})
public class PurchaseSubpackagePriceChangeController
extends BaseController<PurchaseTenderSubpackagePriceChange, PurchaseTenderSubpackagePriceChangeService> {
    @Autowired
    private PurchaseTenderSubpackagePriceChangeService subpackagePriceChangeService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;

    @Operation(summary="\u8ddf\u636e\u9879\u76eeID\u67e5\u8be2\u9879\u76ee\u91d1\u989d\u53d8\u66f4\u4fe1\u606f", description="\u8ddf\u636e\u9879\u76eeID\u67e5\u8be2\u9879\u76ee\u91d1\u989d\u53d8\u66f4\u4fe1\u606f")
    @GetMapping(value={"/querySubpackageChangePriceById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> saveSubpackagePriceChange(@RequestParam(name="id") String id) {
        List<PurchaseTenderSubpackagePriceChange> subpackagePriceChanges = this.subpackagePriceChangeService.selectByMainId(id);
        List<PurchaseTenderProjectSubpackageInfo> subpackageInfoList = this.subpackageInfoService.selectByMainId(id);
        List<PurchaseTenderSubpackagePriceChange> subpackageBuildList = this.buildSubpackageInfoList(subpackageInfoList);
        if (CollectionUtil.isEmpty(subpackagePriceChanges)) {
            return Result.ok(subpackageBuildList);
        }
        if (subpackagePriceChanges.size() != subpackageInfoList.size()) {
            Map<String, List<PurchaseTenderSubpackagePriceChange>> subpackageChangeMaps = subpackagePriceChanges.stream().collect(Collectors.groupingBy(PurchaseTenderSubpackagePriceChange::getSubpackageId));
            for (PurchaseTenderSubpackagePriceChange buildSubpackage : subpackageBuildList) {
                if (subpackageChangeMaps.containsKey(buildSubpackage.getSubpackageId())) continue;
                subpackagePriceChanges.add(buildSubpackage);
            }
        }
        subpackagePriceChanges.forEach(x -> {
            if (!AuditStatusEnum.AUDIT_DOING.getValue().equals(x.getAuditStatus())) {
                x.setPreSubpackageChangeBudget(null);
            }
        });
        return Result.ok(subpackagePriceChanges);
    }

    private List<PurchaseTenderSubpackagePriceChange> buildSubpackageInfoList(List<PurchaseTenderProjectSubpackageInfo> subpackageInfoList) {
        if (CollectionUtil.isEmpty(subpackageInfoList)) {
            return new ArrayList<PurchaseTenderSubpackagePriceChange>();
        }
        List<PurchaseTenderSubpackagePriceChange> priceChangeList = subpackageInfoList.stream().map(info -> {
            PurchaseTenderSubpackagePriceChange priceChange = new PurchaseTenderSubpackagePriceChange();
            priceChange.setSubpackageId(info.getId());
            priceChange.setProjectId(info.getHeadId());
            priceChange.setSubpackageChangeBudget(info.getBudget());
            priceChange.setSubpackageName(info.getSubpackageName());
            priceChange.setSubpackageNumber(info.getSubpackageNumber());
            priceChange.setTenderProjectName(info.getTenderProjectName());
            return priceChange;
        }).collect(Collectors.toList());
        return priceChangeList;
    }

    @Operation(summary="\u6821\u9a8c\u5ba1\u6279\u662f\u5426\u5b58\u5728", description="\u6821\u9a8c\u5ba1\u6279\u662f\u5426\u5b58\u5728")
    @GetMapping(value={"/checkAuditConfig"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> checkAuditConfig() {
        boolean auditFlag = this.subpackagePriceChangeService.checkAuditConfig();
        return Result.ok((Object)auditFlag);
    }

    @Operation(summary="\u5206\u5305\u4ef7\u683c\u53d8\u66f4", description="\u5206\u5305\u4ef7\u683c\u53d8\u66f4")
    @PostMapping(value={"/saveSubpackagePriceChange"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @SrmValidated
    public Result<?> saveSubpackagePriceChange(@RequestBody PurchaseTenderSubpackagePriceChange priceChange) {
        this.subpackagePriceChangeService.saveSubpackagePriceChange(priceChange);
        return Result.ok();
    }

    @Operation(summary="\u5206\u5305\u6279\u91cf\u4ef7\u683c\u53d8\u66f4", description="\u5206\u5305\u6279\u91cf\u4ef7\u683c\u53d8\u66f4")
    @PostMapping(value={"/batchSubpackagePriceChange"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @SrmValidated
    public Result<?> batchSubpackagePriceChange(@RequestBody List<PurchaseTenderSubpackagePriceChange> priceChanges) {
        this.subpackagePriceChangeService.batchSubpackagePriceChange(priceChanges);
        return Result.ok();
    }
}

