/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.sale.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.util.WorkFlowUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.calibration.entity.BidWinningAffirmItem;
import com.els.modules.tender.common.utils.TenderAuditSubjectUtils;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectInfoVO;
import com.els.modules.tender.sale.entity.PurchaseTenderBidWinningServiceFeeHead;
import com.els.modules.tender.sale.entity.PurchaseTenderBidWinningServiceFeeItem;
import com.els.modules.tender.sale.enumerate.BidWinningServiceFeeItemPaymentTypeEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginHeadStatusEnum;
import com.els.modules.tender.sale.mapper.PurchaseTenderBidWinningServiceFeeHeadMapper;
import com.els.modules.tender.sale.service.PurchaseTenderBidWinningServiceFeeHeadService;
import com.els.modules.tender.sale.service.PurchaseTenderBidWinningServiceFeeItemService;
import com.els.modules.tender.sale.vo.PurchaseTenderBidWinningServiceFeeHeadVO;
import com.els.modules.tender.sale.vo.PurchaseTenderBidWinningServiceFeeItemVO;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.PurchaseTenderProjectMarginHeadService;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.els.srm.workflow.modules.dto.SubmitAuditDTO;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseTenderBidWinningServiceFeeHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderBidWinningServiceFeeHeadMapper, PurchaseTenderBidWinningServiceFeeHead>
implements PurchaseTenderBidWinningServiceFeeHeadService {
    @Autowired
    private PurchaseTenderBidWinningServiceFeeItemService purchaseTenderBidWinningServiceFeeItemService;
    @Resource
    @Lazy
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;
    @Resource
    @Lazy
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Lazy
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseTenderProjectMarginHeadService purchaseTenderProjectMarginHeadService;
    @Resource
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;

    @Override
    public IPage<PurchaseTenderBidWinningServiceFeeHead> queryTenderPage(Page<PurchaseTenderBidWinningServiceFeeHead> page, QueryWrapper<PurchaseTenderBidWinningServiceFeeHead> queryWrapper) {
        return ((PurchaseTenderBidWinningServiceFeeHeadMapper)this.baseMapper).queryTenderPage(page, queryWrapper);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(List<BidWinningAffirmItem> bidWinningAffirmItems) {
        BidWinningAffirmItem bidWinningAffirmItem = bidWinningAffirmItems.get(0);
        PurchaseTenderProjectInfoVO purchaseTenderProjectInfoVO = this.purchaseTenderProjectHeadService.queryProjectInfoBySubpackageId(bidWinningAffirmItem.getSubpackageId());
        TenderProjectSupplier querySupplier = new TenderProjectSupplier();
        querySupplier.setSubpackageId(bidWinningAffirmItem.getSubpackageId());
        List<TenderProjectSupplier> tenderProjectSuppliers = this.tenderProjectSupplierService.selectBySubpackageId(querySupplier);
        Map supplierMap = tenderProjectSuppliers.stream().collect(Collectors.toMap(TenderProjectSupplier::getSupplierAccount, Function.identity()));
        ArrayList<PurchaseTenderBidWinningServiceFeeHead> bidWinningServiceFeeHeads = new ArrayList<PurchaseTenderBidWinningServiceFeeHead>();
        for (BidWinningAffirmItem winningAffirmItem : bidWinningAffirmItems) {
            PurchaseTenderBidWinningServiceFeeHead bidWinningServiceFeeHead = new PurchaseTenderBidWinningServiceFeeHead();
            bidWinningServiceFeeHead.setElsAccount(TenantContext.getTenant());
            bidWinningServiceFeeHead.setTenderProjectId(purchaseTenderProjectInfoVO.getTenderProjectId());
            bidWinningServiceFeeHead.setTenderProjectName(purchaseTenderProjectInfoVO.getTenderProjectName());
            bidWinningServiceFeeHead.setTenderProjectNumber(purchaseTenderProjectInfoVO.getTenderProjectNumber());
            bidWinningServiceFeeHead.setSubpackageId(purchaseTenderProjectInfoVO.getSubpackageId());
            bidWinningServiceFeeHead.setSubpackageName(purchaseTenderProjectInfoVO.getSubpackageName());
            bidWinningServiceFeeHead.setSupplierAccount(winningAffirmItem.getSupplierAccount());
            bidWinningServiceFeeHead.setSupplierName(winningAffirmItem.getSupplierName());
            bidWinningServiceFeeHead.setStatus(TenderProjectMarginHeadStatusEnum.UNPAID.getValue());
            bidWinningServiceFeeHead.setAudited("0");
            bidWinningServiceFeeHead.setPaidAmount(BigDecimal.ZERO);
            bidWinningServiceFeeHead.setCurrentRank(winningAffirmItem.getScopeSort());
            bidWinningServiceFeeHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            TenderProjectSupplier tenderProjectSupplier = (TenderProjectSupplier)((Object)supplierMap.get(winningAffirmItem.getSupplierAccount()));
            bidWinningServiceFeeHead.setCombination(tenderProjectSupplier.getCombination());
            bidWinningServiceFeeHead.setCombinationName(tenderProjectSupplier.getCombinationName());
            bidWinningServiceFeeHead.setBidWinningAmount(tenderProjectSupplier.getWinnerAmount() == null ? BigDecimal.ZERO : tenderProjectSupplier.getWinnerAmount());
            bidWinningServiceFeeHeads.add(bidWinningServiceFeeHead);
        }
        this.saveBatch(bidWinningServiceFeeHeads, 2000);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public PurchaseTenderBidWinningServiceFeeHead updateMain(PurchaseTenderBidWinningServiceFeeHeadVO purchaseTenderBidWinningServiceFeeHeadVO) {
        PurchaseTenderBidWinningServiceFeeHead dbBidWinningServiceFeeHead = (PurchaseTenderBidWinningServiceFeeHead)((Object)((PurchaseTenderBidWinningServiceFeeHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchaseTenderBidWinningServiceFeeHeadVO.getId())));
        if (dbBidWinningServiceFeeHead != null) {
            Assert.isTrue((boolean)TenderProjectMarginHeadStatusEnum.UNPAID.getValue().equals(dbBidWinningServiceFeeHead.getStatus()), (String)I18nUtil.translate((String)"i18n_alert_APzExqcrW_3ebe12cf", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u4fee\u6539\uff01"));
        }
        PurchaseTenderBidWinningServiceFeeHead purchaseTenderBidWinningServiceFeeHead = new PurchaseTenderBidWinningServiceFeeHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderBidWinningServiceFeeHeadVO), (Object)((Object)purchaseTenderBidWinningServiceFeeHead));
        int count = ((PurchaseTenderBidWinningServiceFeeHeadMapper)this.baseMapper).updateById((Object)purchaseTenderBidWinningServiceFeeHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        List<PurchaseTenderBidWinningServiceFeeItem> purchaseTenderBidWinningServiceFeeItems = this.purchaseTenderBidWinningServiceFeeItemService.selectByMainId(purchaseTenderBidWinningServiceFeeHead.getId());
        List<String> itemIds = purchaseTenderBidWinningServiceFeeItems.stream().map(ParentEntity::getId).collect(Collectors.toList());
        this.purchaseTenderBidWinningServiceFeeItemService.deleteByMainId(purchaseTenderBidWinningServiceFeeHead.getId());
        this.insertData(purchaseTenderBidWinningServiceFeeHead, purchaseTenderBidWinningServiceFeeHeadVO.getPurchaseTenderBidWinningServiceFeeItemList(), itemIds);
        return purchaseTenderBidWinningServiceFeeHead;
    }

    private void insertData(PurchaseTenderBidWinningServiceFeeHead purchaseTenderBidWinningServiceFeeHead, List<PurchaseTenderBidWinningServiceFeeItemVO> purchaseTenderBidWinningServiceFeeItemListVO, List<String> itemIds) {
        if (CollectionUtil.isNotEmpty(itemIds)) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainIds(itemIds);
        }
        if (!CollectionUtils.isEmpty(purchaseTenderBidWinningServiceFeeItemListVO)) {
            ArrayList<PurchaseAttachmentDTO> attachmentDTOList = new ArrayList<PurchaseAttachmentDTO>();
            for (PurchaseTenderBidWinningServiceFeeItemVO entity : purchaseTenderBidWinningServiceFeeItemListVO) {
                entity.setHeadId(purchaseTenderBidWinningServiceFeeHead.getId());
                entity.setId(IdWorker.getIdStr());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseTenderBidWinningServiceFeeHead);
                List<PurchaseAttachmentDTO> attachmentDTOS = entity.getAttachmentDTOList();
                if (!CollectionUtil.isNotEmpty(attachmentDTOS)) continue;
                for (PurchaseAttachmentDTO attachmentDTO : attachmentDTOS) {
                    attachmentDTO.setHeadId(entity.getId());
                }
                attachmentDTOList.addAll(attachmentDTOS);
            }
            if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentDTOList);
            }
            ArrayList purchaseTenderBidWinningServiceFeeItems = SysUtil.copyProperties(purchaseTenderBidWinningServiceFeeItemListVO, PurchaseTenderBidWinningServiceFeeItem.class);
            this.purchaseTenderBidWinningServiceFeeItemService.saveBatch(purchaseTenderBidWinningServiceFeeItems, 2000);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchaseTenderBidWinningServiceFeeItemService.deleteByMainId(id);
        ((PurchaseTenderBidWinningServiceFeeHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseTenderBidWinningServiceFeeItemService.deleteByMainId(serializable.toString());
            ((PurchaseTenderBidWinningServiceFeeHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(PurchaseTenderBidWinningServiceFeeHeadVO purchaseTenderBidWinningServiceFeeHeadPage) {
        PurchaseTenderBidWinningServiceFeeHead purchaseTenderBidWinningServiceFeeHead = this.updateMain(purchaseTenderBidWinningServiceFeeHeadPage);
        this.checkParamAndSetMargin(purchaseTenderBidWinningServiceFeeHead, purchaseTenderBidWinningServiceFeeHeadPage.getPurchaseTenderBidWinningServiceFeeItemList());
        if ("1".equals(purchaseTenderBidWinningServiceFeeHeadPage.getAudited())) {
            PurchaseTenderProjectInfoVO purchaseTenderProjectInfoVO = this.purchaseTenderProjectHeadService.queryProjectInfoBySubpackageId(purchaseTenderBidWinningServiceFeeHead.getSubpackageId());
            String subject = TenderAuditSubjectUtils.getTenderAuditSubject("bidWinningServiceFee", "\u4e2d\u6807\u670d\u52a1\u8d39", purchaseTenderProjectInfoVO.getTenderProjectNumber(), null, purchaseTenderProjectInfoVO.getSubpackageName());
            SubmitAuditDTO dto = SubmitAuditDTO.builder().businessId(purchaseTenderBidWinningServiceFeeHeadPage.getId()).businessType("bidWinningServiceFee").processTitle(subject).businessObj((Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)purchaseTenderBidWinningServiceFeeHead)))).build();
            WorkFlowUtil.submit((SubmitAuditDTO)dto);
        } else {
            purchaseTenderBidWinningServiceFeeHead.setStatus(TenderProjectMarginHeadStatusEnum.PAID.getValue());
            ((PurchaseTenderBidWinningServiceFeeHeadMapper)this.baseMapper).updateById((Object)purchaseTenderBidWinningServiceFeeHead);
            this.publish(purchaseTenderBidWinningServiceFeeHead);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseTenderBidWinningServiceFeeHead purchaseTenderBidWinningServiceFeeHead) {
        List<PurchaseTenderBidWinningServiceFeeItem> purchaseTenderBidWinningServiceFeeItems = this.purchaseTenderBidWinningServiceFeeItemService.selectByMainId(purchaseTenderBidWinningServiceFeeHead.getId());
        if (TenderProjectMarginHeadStatusEnum.PAID.getValue().equals(purchaseTenderBidWinningServiceFeeHead.getStatus())) {
            BigDecimal paidAmount = purchaseTenderBidWinningServiceFeeItems.stream().map(PurchaseTenderBidWinningServiceFeeItem::getPaymentAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            purchaseTenderBidWinningServiceFeeHead.setPaidAmount(paidAmount);
            this.updateById((Object)purchaseTenderBidWinningServiceFeeHead);
            if (CollectionUtil.isNotEmpty(purchaseTenderBidWinningServiceFeeItems)) {
                List itemIds = purchaseTenderBidWinningServiceFeeItems.stream().map(ParentEntity::getId).collect(Collectors.toList());
                List purchaseAttachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainIds(itemIds);
                ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentDTOS, null, purchaseTenderBidWinningServiceFeeHead.getSubpackageId(), purchaseTenderBidWinningServiceFeeHead.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.SERVICE_CHARGE.getValue());
            }
        }
        if (CollectionUtil.isNotEmpty(purchaseTenderBidWinningServiceFeeItems = purchaseTenderBidWinningServiceFeeItems.stream().filter(item -> BidWinningServiceFeeItemPaymentTypeEnum.MARGIN.getValue().equals(item.getPaymentType())).collect(Collectors.toList()))) {
            this.purchaseTenderProjectMarginHeadService.addMarginDeductRecord(purchaseTenderBidWinningServiceFeeHead, purchaseTenderBidWinningServiceFeeItems);
        }
    }

    public void checkParamAndSetMargin(PurchaseTenderBidWinningServiceFeeHead purchaseTenderBidWinningServiceFeeHead, List<PurchaseTenderBidWinningServiceFeeItemVO> purchaseTenderBidWinningServiceFeeItemListVO) {
        Assert.hasText((String)purchaseTenderBidWinningServiceFeeHead.getPaymentType(), (String)I18nUtil.translate((String)"i18n_alert_JpCKxOLVW_54f4d47c", (String)"\u7f34\u7eb3\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)purchaseTenderBidWinningServiceFeeHead.getDueAmount()), (String)I18nUtil.translate((String)"i18n_alert_dJHfxOLVW_33173985", (String)"\u5e94\u7f34\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.notEmpty(purchaseTenderBidWinningServiceFeeItemListVO, (String)I18nUtil.translate((String)"i18n_alert_BSJptHxOLVW_d9106df9", (String)"\u670d\u52a1\u7f34\u7eb3\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a!"));
        BigDecimal totalPaymentAmount = BigDecimal.ZERO;
        for (PurchaseTenderBidWinningServiceFeeItemVO purchaseTenderBidWinningServiceFeeItemVO : purchaseTenderBidWinningServiceFeeItemListVO) {
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)purchaseTenderBidWinningServiceFeeItemVO.getPaymentAmount()), (String)I18nUtil.translate((String)"i18n_alert_JpHfxOLVW_13451dc6", (String)"\u7f34\u7eb3\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.notNull((Object)purchaseTenderBidWinningServiceFeeItemVO.getPaymentTime(), (String)I18nUtil.translate((String)"i18n_alert_JpKIxOLVW_9c484334", (String)"\u7f34\u7eb3\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!"));
            if (BidWinningServiceFeeItemPaymentTypeEnum.CASH.getValue().equals(purchaseTenderBidWinningServiceFeeItemVO.getPaymentType())) {
                Assert.notEmpty(purchaseTenderBidWinningServiceFeeItemVO.getAttachmentDTOList(), (String)I18nUtil.translate((String)"i18n_alert_JpCKLWHWBIxOLVW_2c93f299", (String)"\u7f34\u7eb3\u65b9\u5f0f\u4e3a\u73b0\u91d1\uff0c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!"));
            }
            totalPaymentAmount = totalPaymentAmount.add(purchaseTenderBidWinningServiceFeeItemVO.getPaymentAmount());
        }
        Assert.isTrue((purchaseTenderBidWinningServiceFeeHead.getDueAmount().compareTo(totalPaymentAmount) == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_dJHflTEUJpknW_4b1dbe4a", (String)"\u5e94\u7f34\u91d1\u989d\u5fc5\u987b\u7b49\u4e8e\u7f34\u7eb3\u603b\u548c!"));
        List marginList = purchaseTenderBidWinningServiceFeeItemListVO.stream().filter(item -> BidWinningServiceFeeItemPaymentTypeEnum.MARGIN.getValue().equals(item.getPaymentType())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(marginList)) {
            BigDecimal totalPaymentMarginAmount = marginList.stream().map(PurchaseTenderBidWinningServiceFeeItem::getPaymentAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            this.purchaseTenderProjectMarginHeadService.addFrozenAmount(purchaseTenderBidWinningServiceFeeHead.getSubpackageId(), purchaseTenderBidWinningServiceFeeHead.getSupplierAccount(), totalPaymentMarginAmount);
        }
    }
}

