/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.PurchaseConfirmBiddingHisService;
import com.els.modules.bidding.vo.PurchaseBiddingHeadVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="resultBiddingAuditCallBackServiceImpl")
public class ResultBiddingAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Autowired
    private BiddingSupplierService biddingSupplierService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private PurchaseConfirmBiddingHisService purchaseConfirmBiddingHisService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        String id = flowCallbackDTO.getBusinessId();
        this.biddingSupplierService.publish(id);
        this.purchaseConfirmBiddingHisService.saveConfirmBidData(id);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            PurchaseBiddingHeadVO headVO = new PurchaseBiddingHeadVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
            List<PurchaseBiddingItem> itemList = this.purchaseBiddingItemService.selectByMainId(id);
            headVO.setPurchaseBiddingItemList(itemList);
            return SrmUtil.toJSONObject((Object)((Object)headVO));
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseBiddingHead updateHead = new PurchaseBiddingHead();
        updateHead.setId(flowCallbackDTO.getBusinessId());
        updateHead.setResultFlowId(flowCallbackDTO.getProcessInstanceId());
        updateHead.setResultAuditStatus(auditStatus);
        this.purchaseBiddingHeadService.updateById((Object)updateHead);
    }
}

