/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.adapter;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.enquiry.vo.PurchaseEnquiryHeadVO;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="resultEnquiryRpcAdapter")
public class ResultEnquiryAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseEnquiryHead head = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            PurchaseEnquiryHeadVO headVO = new PurchaseEnquiryHeadVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
            List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(id);
            headVO.setPurchaseEnquiryItemList(itemList);
            return SrmUtil.toJSONObject((Object)((Object)head));
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        List<PurchaseEnquiryItem> itemList;
        List<String> itemNumbers;
        String headId;
        String businessId = flowCallbackDTO.getBusinessId();
        String flowId = flowCallbackDTO.getProcessInstanceId();
        PurchaseEnquiryHeadVO headVO = new PurchaseEnquiryHeadVO();
        PurchaseEnquiryHead head = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        boolean isByRowAudit = businessId.contains("_");
        String string = headId = isByRowAudit ? businessId.split("_")[0] : businessId;
        if (isByRowAudit) {
            itemNumbers = Arrays.asList(businessId.split("_")[1].split(","));
            this.updateAudit(true, headId, itemNumbers, auditStatus, null, flowId);
            itemList = this.purchaseEnquiryItemService.selectByMainId(headId);
        } else {
            this.updateAudit(false, headId, null, auditStatus, null, flowId);
            itemList = this.purchaseEnquiryItemService.selectByMainId(headId);
            itemNumbers = itemList.stream().map(PurchaseEnquiryItem::getItemNumber).distinct().collect(Collectors.toList());
        }
        PurchaseEnquiryHead enquiryHead = new PurchaseEnquiryHead();
        enquiryHead.setId(headId);
        enquiryHead.setResultAuditStatus(auditStatus);
        enquiryHead.setResultFlowId(flowId);
        this.purchaseEnquiryHeadService.updateById((Object)enquiryHead);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)));
            List<PurchaseEnquiryItem> accept = headVO.getPurchaseEnquiryItemList().stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
            List<PurchaseEnquiryItem> reject = headVO.getPurchaseEnquiryItemList().stream().filter(item -> EnquiryStatusEnum.REJECT.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
            this.saleEnquiryItemService.accept(accept);
            if (!reject.isEmpty()) {
                this.saleEnquiryItemService.reject(reject);
            }
            if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                List<PurchaseEnquiryItem> acceptList = itemList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).filter(item -> itemNumbers.contains(item.getItemNumber())).collect(Collectors.toList());
                this.purchaseEnquiryHeadService.generatePriceRecord(dbHead, acceptList);
            }
            List<PurchaseEnquiryItem> pricedList = itemList.stream().filter(item -> itemNumbers.contains(item.getItemNumber())).collect(Collectors.toList());
            this.purchaseEnquiryHeadService.priced(dbHead, pricedList);
            List<PurchaseEnquiryItem> acceptList = pricedList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).toList();
            this.purchaseEnquiryHeadService.goBackDemand(acceptList, PurchaseRequestStatusItemEnum.INQUIRY_COMPLETED.getValue());
        }
    }

    private void updateAudit(boolean isByRowAudit, String headId, List<String> itemNumbers, String auditStatus, String bpmnType, String flowId) {
        this.purchaseEnquiryItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEnquiryItem::getHeadId, (Object)headId)).in(isByRowAudit, PurchaseEnquiryItem::getItemNumber, itemNumbers)).set(PurchaseEnquiryItem::getAuditStatus, (Object)auditStatus)).set(PurchaseEnquiryItem::getWorkFlowType, (Object)bpmnType)).set(PurchaseEnquiryItem::getFlowId, (Object)flowId));
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }
}

