/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.ebidding.adapter;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.ebidding.enumerate.EbiddingMethodEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemHisLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingSupplierLp;
import com.els.modules.logisticspurchase.ebidding.enumerate.EbiddingItemLpStatusEnum;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingHeadLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemHisLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingSupplierLpService;
import com.els.modules.logisticspurchase.ebidding.vo.PurchaseEbiddingHeadLpVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResultEbiddingLpAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseEbiddingHeadLpService purchaseEbiddingHeadService;
    @Autowired
    private PurchaseEbiddingItemLpService purchaseEbiddingItemService;
    @Autowired
    private PurchaseEbiddingItemHisLpService purchaseEbiddingItemHisService;
    @Autowired
    private PurchaseEbiddingSupplierLpService purchaseEbiddingSupplierService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
            if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod()) && "1".equals(dbHead.getAllowModifyQuantity()) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                List<PurchaseEbiddingItemHisLp> itemList = this.purchaseEbiddingItemHisService.selectByMainId(dbHead.getId());
                List<PurchaseEbiddingItemHisLp> acceptList = itemList.stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                this.purchaseEbiddingHeadService.generatePriceRecordByHis(dbHead, acceptList);
                List<PurchaseEbiddingSupplierLp> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
                this.purchaseEbiddingHeadService.pricedByHis(dbHead, itemList, supplierList);
                List ids = itemList.stream().map(PurchaseEbiddingItemHisLp::getItemId).distinct().collect(Collectors.toList());
                List byIds = this.purchaseEbiddingItemService.listByIds(ids);
                this.purchaseEbiddingHeadService.goBackDemand(byIds, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
            } else {
                List<PurchaseEbiddingItemLp> itemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId());
                List<PurchaseEbiddingItemLp> acceptList = itemList.stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                this.purchaseEbiddingHeadService.generatePriceRecord(dbHead, acceptList);
                List<PurchaseEbiddingSupplierLp> supplierList = this.purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
                this.purchaseEbiddingHeadService.priced(dbHead, itemList, supplierList);
                this.purchaseEbiddingHeadService.goBackDemand(itemList, PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue());
            }
        }
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseEbiddingHeadLp head = (PurchaseEbiddingHeadLp)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            PurchaseEbiddingHeadLpVO headVO = new PurchaseEbiddingHeadLpVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
            List<PurchaseEbiddingItemLp> itemList = this.purchaseEbiddingItemService.selectByMainId(id);
            headVO.setPurchaseEbiddingItemList(itemList);
            return SrmUtil.toJSONObject((Object)((Object)headVO));
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        String headId = flowCallbackDTO.getBusinessId();
        String flowId = flowCallbackDTO.getProcessInstanceId();
        PurchaseEbiddingHeadLp updateHead = new PurchaseEbiddingHeadLp();
        updateHead.setId(headId);
        updateHead.setResultFlowId(flowId);
        updateHead.setResultAuditStatus(auditStatus);
        this.purchaseEbiddingHeadService.updateById((Object)updateHead);
        this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItemLp::getHeadId, (Object)headId)).set(PurchaseEbiddingItemLp::getFlowId, (Object)flowId)).set(PurchaseEbiddingItemLp::getAuditStatus, (Object)auditStatus));
    }
}

