/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.priceEvaluationManagement.adapter;

import com.alibaba.fastjson.JSONObject;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationManageHead;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationManagePriceItem;
import com.els.modules.priceEvaluationManagement.enumerate.PurchasePriceEvaluationManagementStatusEnum;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationManageHeadService;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationManagePriceItemService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="priceEvaluationManagementAuditAdapter")
public class PriceEvaluationManagementAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchasePriceEvaluationManageHeadService purchasePriceEvaluationManageHeadService;
    @Autowired
    private PurchasePriceEvaluationManagePriceItemService purchasePriceEvaluationManagePriceItemService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchasePriceEvaluationManageHead purchasePriceEvaluationManageHead = (PurchasePriceEvaluationManageHead)((Object)this.purchasePriceEvaluationManageHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        List<PurchasePriceEvaluationManagePriceItem> purchasePriceEvaluationManagePriceItemList = this.purchasePriceEvaluationManagePriceItemService.selectByMainId(flowCallbackDTO.getBusinessId());
        this.purchasePriceEvaluationManageHeadService.accept(purchasePriceEvaluationManageHead, purchasePriceEvaluationManagePriceItemList);
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchasePriceEvaluationManageHead head = (PurchasePriceEvaluationManageHead)((Object)this.purchasePriceEvaluationManageHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)head, new DictTranslateAspectParam());
            return jsonObject;
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchasePriceEvaluationManageHead purchasePriceEvaluationManageHead = (PurchasePriceEvaluationManageHead)((Object)this.purchasePriceEvaluationManageHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        if (purchasePriceEvaluationManageHead == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_HemhxurtFW_1f2b4ae7", (String)"\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e!"));
        }
        PurchasePriceEvaluationManageHead head = new PurchasePriceEvaluationManageHead();
        head.setId(flowCallbackDTO.getBusinessId());
        head.setAuditStatus(auditStatus);
        head.setFlowId(flowCallbackDTO.getProcessInstanceId());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            List<PurchasePriceEvaluationManagePriceItem> purchasePriceEvaluationManagePriceItemList = this.purchasePriceEvaluationManagePriceItemService.selectByMainId(flowCallbackDTO.getBusinessId());
            head.setDocumentStatus(PurchasePriceEvaluationManagementStatusEnum.HAD_EVALUATION_PRING.getValue());
            this.purchasePriceEvaluationManageHeadService.updataEnquiryItem(purchasePriceEvaluationManagePriceItemList);
        }
        this.purchasePriceEvaluationManageHeadService.updateById((Object)head);
    }
}

