/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.openbid.job;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.api.service.JobRpcService;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.OpenBidRecordLogUtils;
import com.els.modules.tender.common.utils.TenderOperationFieldUtils;
import com.els.modules.tender.openbid.enumerate.PurchaseOpenBidStatusEnum;
import com.els.modules.tender.openbid.job.TenderJobUtil;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectOpenInfoHeadVO;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTenderOpenBidAlertJobBeanService
implements JobRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTenderOpenBidAlertJobBeanService.class);

    public void doExecute(String parameter) {
        log.info(" \u62db\u6807\u81ea\u52a8\u5f00\u6807\u5b9a\u65f6\u4efb\u52a1 tenderOpenBidAlertJobServiceImpl \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        if (StrUtil.isEmpty((CharSequence)parameter)) {
            log.error("parameter must not be null.");
            return;
        }
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String id = paramObj.getString("id");
        String checkType = paramObj.getString("checkType");
        String processType = paramObj.getString("processType");
        String currentStep = paramObj.getString("currentStep");
        String tenantId = paramObj.getString("tenantId");
        if (StrUtil.isEmpty((CharSequence)id) || StrUtil.isEmpty((CharSequence)checkType)) {
            log.error("parameter must contain {}.{}.{}.{}", new Object[]{id, checkType, processType, currentStep});
            return;
        }
        TenderFlagInjectionContext.setTenderCheckType(checkType);
        TenderFlagInjectionContext.setTenderProcessType(processType);
        TenderFlagInjectionContext.setTenderCurrentStep(currentStep);
        TenantContext.setTenant((String)tenantId);
        PurchaseTenderProjectSubpackageInfoService subpackageInfoService = (PurchaseTenderProjectSubpackageInfoService)SpringContextUtils.getBean(PurchaseTenderProjectSubpackageInfoService.class);
        PurchaseTenderProjectHeadService projectSupplierService = (PurchaseTenderProjectHeadService)SpringContextUtils.getBean(PurchaseTenderProjectHeadService.class);
        TenderProjectSupplierService supplierService = (TenderProjectSupplierService)SpringContextUtils.getBean(TenderProjectSupplierService.class);
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)subpackageInfoService.getById((Serializable)((Object)id)));
        PurchaseTenderProjectHead tenderProjectHead = (PurchaseTenderProjectHead)((Object)projectSupplierService.getById((Serializable)((Object)subpackageInfo.getHeadId())));
        TenderOperationFieldUtils.setOpenBidSubpackageStatus((Object)subpackageInfo);
        String openBidStatus = TenderOperationFieldUtils.getOpenBidStatus((Object)subpackageInfo);
        if (PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue().equals(openBidStatus) && TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED.getValue() != subpackageInfo.getStatus().intValue()) {
            boolean openBid = true;
            if (tenderProjectHead.getBidOpeningLimit() != null) {
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.eq(TenderProjectSupplier::getSubpackageId, (Object)subpackageInfo.getId());
                lambdaQueryWrapper.eq(TenderProjectSupplier::getEffective, (Object)"1");
                lambdaQueryWrapper.eq(TenderProjectSupplier::getInvalid, (Object)"0");
                List tenderProjectSupplierList = supplierService.list((Wrapper)lambdaQueryWrapper);
                long responseNumber = 0L;
                responseNumber = SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(TenderFlagInjectionContext.getTenderCheckType()) ? tenderProjectSupplierList.stream().filter(supplier -> "1".equals(supplier.getPreResponseStatus())).count() : tenderProjectSupplierList.stream().filter(supplier -> "1".equals(supplier.getResultResponseStatus())).count();
                boolean bl = openBid = responseNumber >= (long)tenderProjectHead.getBidOpeningLimit().intValue();
            }
            if (openBid) {
                TenderOperationFieldUtils.setOpenBidStatus((Object)subpackageInfo, PurchaseOpenBidStatusEnum.DECRYPTING.getValue());
                subpackageInfoService.updateOpenBidStatus(subpackageInfo);
                PurchaseTenderProjectOpenInfoHeadVO openInfoHeadVO = (PurchaseTenderProjectOpenInfoHeadVO)((Object)SysUtil.copyProperties((Object)((Object)subpackageInfo), PurchaseTenderProjectOpenInfoHeadVO.class));
                OpenBidRecordLogUtils.saveRecordMsg(openInfoHeadVO, "\u5f00\u6807\u65f6\u95f4\u5df2\u7ecf\u5df2\u5230\uff0c\u7cfb\u7edf\u81ea\u52a8\u5ba3\u5e03\u5f00\u6807");
                if (!"1".equals(subpackageInfo.getOpenBidEncrypt())) {
                    PurchaseTenderProjectOpenInfoHeadVO purchaseTenderProjectOpenInfoHeadVO = (PurchaseTenderProjectOpenInfoHeadVO)((Object)SysUtil.copyProperties((Object)((Object)subpackageInfo), PurchaseTenderProjectOpenInfoHeadVO.class));
                    OpenBidRecordLogUtils.saveRecordMsg(purchaseTenderProjectOpenInfoHeadVO, "\u5f00\u6807\u7ed3\u675f");
                }
            }
        }
        String jobKey = paramObj.getString("jobKey");
        TenderJobUtil.deleteJob(jobKey);
        log.info(" \u62db\u6807\u81ea\u52a8\u5f00\u6807\u5b9a\u65f6\u4efb\u52a1 tenderOpenBidAlertJobServiceImpl \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
    }
}

