/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.openbid.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.utils.PushEventUtils;
import com.els.modules.tender.openbid.entity.TenderOpenBidRecordAttachment;
import com.els.modules.tender.openbid.entity.TenderOpenBidRecordHead;
import com.els.modules.tender.openbid.entity.TenderOpenBidRecordSupplier;
import com.els.modules.tender.openbid.enumerate.TenderOpenBidRecordStatusEnum;
import com.els.modules.tender.openbid.mapper.TenderOpenBidRecordHeadMapper;
import com.els.modules.tender.openbid.service.TenderOpenBidRecordAttachmentService;
import com.els.modules.tender.openbid.service.TenderOpenBidRecordHeadService;
import com.els.modules.tender.openbid.service.TenderOpenBidRecordSupplierService;
import com.els.modules.tender.openbid.vo.TenderOpenBidRecordHeadVO;
import com.els.modules.tender.openbid.vo.TenderOpenBidRecordSupplierVO;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class TenderOpenBidRecordHeadServiceImpl
extends BaseServiceImpl<TenderOpenBidRecordHeadMapper, TenderOpenBidRecordHead>
implements TenderOpenBidRecordHeadService {
    @Autowired
    private TenderOpenBidRecordSupplierService tenderOpenBidRecordSupplierService;
    @Autowired
    private TenderOpenBidRecordAttachmentService tenderOpenBidRecordAttachmentService;
    @Autowired
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(TenderOpenBidRecordHead tenderOpenBidRecordHead, List<TenderOpenBidRecordSupplierVO> tenderOpenBidRecordSupplierList, List<TenderOpenBidRecordAttachment> tenderOpenBidRecordAttachmentList) {
        tenderOpenBidRecordHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        tenderOpenBidRecordHead.setStatus(TenderOpenBidRecordStatusEnum.NEW.getValue());
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.eq(TenderOpenBidRecordHead::getSubpackageId, (Object)tenderOpenBidRecordHead.getSubpackageId())).eq(TenderOpenBidRecordHead::getCheckType, (Object)tenderOpenBidRecordHead.getCheckType());
        List tenderOpenBidRecordHeads = ((TenderOpenBidRecordHeadMapper)this.baseMapper).selectList((Wrapper)qw);
        Assert.isTrue((boolean)CollectionUtil.isEmpty((Collection)tenderOpenBidRecordHeads), (String)I18nUtil.translate((String)"i18n_alert_UJCKMKOTWFWxqVBsMW_eac918a7", (String)"\u5ba1\u67e5\u65b9\u5f0f\u5b58\u5728\u591a\u6761\u6570\u636e\uff0c\u4e0d\u53ef\u91cd\u590d\u4fdd\u5b58!"));
        ((TenderOpenBidRecordHeadMapper)this.baseMapper).insert((Object)tenderOpenBidRecordHead);
        super.setHeadDefaultValue((ParentEntity)tenderOpenBidRecordHead);
        this.insertData(tenderOpenBidRecordHead, tenderOpenBidRecordSupplierList, tenderOpenBidRecordAttachmentList);
        String subpackageStatus = SubpackageInfoCheckTypeEnum.hasPreTrial(tenderOpenBidRecordHead.getCheckType()) ? "" + TenderProjectSubpackageStatusEnum.PRE_OPEN_BIDING.getValue() : "" + TenderProjectSubpackageStatusEnum.OPEN_BIDING.getValue();
        this.updateTenderProjectSubpackageInfo(tenderOpenBidRecordHead, subpackageStatus);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(TenderOpenBidRecordHead tenderOpenBidRecordHead, List<TenderOpenBidRecordSupplierVO> tenderOpenBidRecordSupplierList, List<TenderOpenBidRecordAttachment> tenderOpenBidRecordAttachmentList) {
        int count = ((TenderOpenBidRecordHeadMapper)this.baseMapper).updateById((Object)tenderOpenBidRecordHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.tenderOpenBidRecordSupplierService.deleteByMainId(tenderOpenBidRecordHead.getId());
        this.tenderOpenBidRecordAttachmentService.deleteByMainId(tenderOpenBidRecordHead.getId());
        this.insertData(tenderOpenBidRecordHead, tenderOpenBidRecordSupplierList, tenderOpenBidRecordAttachmentList);
    }

    private void insertData(TenderOpenBidRecordHead tenderOpenBidRecordHead, List<TenderOpenBidRecordSupplierVO> tenderOpenBidRecordSupplierList, List<TenderOpenBidRecordAttachment> tenderOpenBidRecordAttachmentList) {
        ArrayList<String> attachmentMainIds = new ArrayList<String>();
        ArrayList<PurchaseAttachmentDTO> attachmentDTOList = new ArrayList<PurchaseAttachmentDTO>();
        if (!CollectionUtils.isEmpty(tenderOpenBidRecordSupplierList)) {
            List elsAccountList = tenderOpenBidRecordSupplierList.stream().map(TenderOpenBidRecordSupplier::getSupplierAccount).collect(Collectors.toList());
            List tenantList = this.invokeAccountRpcService.getTenantList(elsAccountList);
            Map<String, String> accountNameMap = tenantList.stream().collect(Collectors.toMap(BaseDTO::getElsAccount, ElsTenantDTO::getCompanyName));
            for (TenderOpenBidRecordSupplierVO entity : tenderOpenBidRecordSupplierList) {
                entity.setHeadId(tenderOpenBidRecordHead.getId());
                entity.setSubpackageId(tenderOpenBidRecordHead.getSubpackageId());
                entity.setCheckType(tenderOpenBidRecordHead.getCheckType());
                entity.setTenderProjectId(tenderOpenBidRecordHead.getTenderProjectId());
                entity.setSupplierName(accountNameMap.get(entity.getSupplierAccount()));
                if (StrUtil.isBlank((CharSequence)entity.getId())) {
                    entity.setId(IdWorker.getIdStr());
                } else {
                    attachmentMainIds.add(entity.getId());
                }
                List<PurchaseAttachmentDTO> supplierAttachmentDTO = entity.getAttachmentDTOList();
                if (CollectionUtil.isNotEmpty(supplierAttachmentDTO)) {
                    for (PurchaseAttachmentDTO purchaseAttachmentDTO : supplierAttachmentDTO) {
                        purchaseAttachmentDTO.setHeadId(entity.getId());
                    }
                    attachmentDTOList.addAll(supplierAttachmentDTO);
                }
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)tenderOpenBidRecordHead);
            }
            ArrayList tenderOpenBidRecordSuppliers = SysUtil.copyProperties(tenderOpenBidRecordSupplierList, TenderOpenBidRecordSupplier.class);
            this.tenderOpenBidRecordSupplierService.saveBatch(tenderOpenBidRecordSuppliers, 2000);
        }
        if (!CollectionUtils.isEmpty(tenderOpenBidRecordAttachmentList)) {
            attachmentMainIds.add(tenderOpenBidRecordHead.getId());
            List openBidRecordAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(tenderOpenBidRecordHead.getId());
            Map attachmentDTOMap = openBidRecordAttachmentList.parallelStream().collect(Collectors.toMap(BaseDTO::getId, Function.identity()));
            for (TenderOpenBidRecordAttachment entity : tenderOpenBidRecordAttachmentList) {
                entity.setHeadId(tenderOpenBidRecordHead.getId());
                entity.setSubpackageId(tenderOpenBidRecordHead.getSubpackageId());
                entity.setTenderProjectId(tenderOpenBidRecordHead.getTenderProjectId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)tenderOpenBidRecordHead);
                PurchaseAttachmentDTO purchaseAttachmentDTO = (PurchaseAttachmentDTO)attachmentDTOMap.get(entity.getAttachmentId());
                if (purchaseAttachmentDTO == null) {
                    purchaseAttachmentDTO = new PurchaseAttachmentDTO();
                    BeanUtils.copyProperties((Object)((Object)entity), (Object)purchaseAttachmentDTO);
                    purchaseAttachmentDTO.setId(entity.getAttachmentId());
                    purchaseAttachmentDTO.setHeadId(tenderOpenBidRecordHead.getId());
                    purchaseAttachmentDTO.setBusinessType("biddingPlatform");
                    purchaseAttachmentDTO.setFileName(entity.getFileName());
                    purchaseAttachmentDTO.setFilePath(entity.getFilePath());
                    purchaseAttachmentDTO.setFileType(entity.getFileType());
                }
                entity.setAttachmentId(purchaseAttachmentDTO.getId());
                purchaseAttachmentDTO.setHeadId(tenderOpenBidRecordHead.getId());
                attachmentDTOList.add(purchaseAttachmentDTO);
            }
            this.tenderOpenBidRecordAttachmentService.saveBatch(tenderOpenBidRecordAttachmentList, 2000);
        }
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainIds(attachmentMainIds);
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentDTOList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.tenderOpenBidRecordSupplierService.deleteByMainId(id);
        this.tenderOpenBidRecordAttachmentService.deleteByMainId(id);
        ((TenderOpenBidRecordHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.tenderOpenBidRecordSupplierService.deleteByMainId(serializable.toString());
            this.tenderOpenBidRecordAttachmentService.deleteByMainId(serializable.toString());
            ((TenderOpenBidRecordHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(TenderOpenBidRecordHeadVO tenderOpenBidRecordHeadPage) {
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(TenderOpenBidRecordHeadVO tenderOpenBidRecordHeadPage) {
        TenderOpenBidRecordHead tenderOpenBidRecordHead = new TenderOpenBidRecordHead();
        BeanUtils.copyProperties((Object)((Object)tenderOpenBidRecordHeadPage), (Object)((Object)tenderOpenBidRecordHead));
        if (StrUtil.isBlank((CharSequence)tenderOpenBidRecordHeadPage.getId())) {
            this.saveMain(tenderOpenBidRecordHead, tenderOpenBidRecordHeadPage.getTenderOpenBidRecordSupplierList(), tenderOpenBidRecordHeadPage.getTenderOpenBidRecordAttachmentList());
        } else {
            this.updateMain(tenderOpenBidRecordHead, tenderOpenBidRecordHeadPage.getTenderOpenBidRecordSupplierList(), tenderOpenBidRecordHeadPage.getTenderOpenBidRecordAttachmentList());
        }
        ArrayList tenderOpenBidRecordSuppliers = SysUtil.copyProperties(tenderOpenBidRecordHeadPage.getTenderOpenBidRecordSupplierList(), TenderOpenBidRecordSupplier.class);
        this.checkParam(tenderOpenBidRecordHead, tenderOpenBidRecordSuppliers);
        tenderOpenBidRecordHead.setStatus(TenderOpenBidRecordStatusEnum.PUBLISH.getValue());
        ((TenderOpenBidRecordHeadMapper)this.baseMapper).updateById((Object)tenderOpenBidRecordHead);
        this.tenderProjectSupplierService.saveOrUpdateByOfflineOpenBid(tenderOpenBidRecordHead, tenderOpenBidRecordSuppliers);
        String subpackageStatus = SubpackageInfoCheckTypeEnum.hasPreTrial(tenderOpenBidRecordHead.getCheckType()) ? "" + TenderProjectSubpackageStatusEnum.PRE_END_OPEN_BID.getValue() : "" + TenderProjectSubpackageStatusEnum.END_OPEN_BID.getValue();
        this.updateTenderProjectSubpackageInfo(tenderOpenBidRecordHead, subpackageStatus);
        this.buildArchiveAttachment(tenderOpenBidRecordHeadPage);
    }

    private void buildArchiveAttachment(TenderOpenBidRecordHeadVO tenderOpenBidRecordHeadPage) {
        if (CollectionUtil.isNotEmpty(tenderOpenBidRecordHeadPage.getTenderOpenBidRecordSupplierList())) {
            ArrayList<PurchaseAttachmentDTO> supplierAttachmentDTO = new ArrayList<PurchaseAttachmentDTO>();
            List<TenderOpenBidRecordSupplierVO> recordSupplierList = tenderOpenBidRecordHeadPage.getTenderOpenBidRecordSupplierList();
            for (TenderOpenBidRecordSupplierVO recordSupplierVO : recordSupplierList) {
                if (!CollectionUtil.isNotEmpty(recordSupplierVO.getAttachmentDTOList())) continue;
                supplierAttachmentDTO.addAll(recordSupplierVO.getAttachmentDTOList());
            }
            ArrayList saleAttachmentDTOS = SysUtil.copyProperties(supplierAttachmentDTO, SaleAttachmentDTO.class);
            ArchiveUtil.saveArchiveBySaleAttachmentDTO(saleAttachmentDTOS, tenderOpenBidRecordHeadPage.getId(), tenderOpenBidRecordHeadPage.getSubpackageId(), tenderOpenBidRecordHeadPage.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.OPEN_RECORD_SUPPLIER_PREFIX.getValue());
        }
        if (CollectionUtil.isNotEmpty(tenderOpenBidRecordHeadPage.getTenderOpenBidRecordAttachmentList())) {
            List<TenderOpenBidRecordAttachment> openBidRecordAttachmentList = tenderOpenBidRecordHeadPage.getTenderOpenBidRecordAttachmentList();
            List<PurchaseAttachmentDTO> purchaseAttachmentDTOS = openBidRecordAttachmentList.stream().map(item -> {
                PurchaseAttachmentDTO purchaseAttachmentDTO = (PurchaseAttachmentDTO)SysUtil.copyProperties((Object)item, PurchaseAttachmentDTO.class);
                purchaseAttachmentDTO.setId(item.getAttachmentId());
                return purchaseAttachmentDTO;
            }).collect(Collectors.toList());
            ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentDTOS, tenderOpenBidRecordHeadPage.getId(), tenderOpenBidRecordHeadPage.getSubpackageId(), tenderOpenBidRecordHeadPage.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.OPEN_RECORD_PREFIX.getValue());
        }
    }

    private void checkParam(TenderOpenBidRecordHead tenderOpenBidRecordHead, List<TenderOpenBidRecordSupplier> tenderOpenBidRecordSupplierList) {
        Assert.hasText((String)tenderOpenBidRecordHead.getSubpackageId(), (String)I18nUtil.translate((String)"i18n_alert_zsWWxOLVW_7f830737", (String)"\u5206\u5305ID\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)tenderOpenBidRecordHead.getSubpackageName(), (String)I18nUtil.translate((String)"i18n_alert_zsRLxOLVW_44e329cf", (String)"\u5206\u5305\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)tenderOpenBidRecordHead.getTenderProjectId(), (String)I18nUtil.translate((String)"i18n_alert_dIWWxOLVW_25af7ea1", (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)tenderOpenBidRecordHead.getCheckType(), (String)I18nUtil.translate((String)"i18n_alert_UJCKxOLVW_e56eae77", (String)"\u5ba1\u67e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.notEmpty(tenderOpenBidRecordSupplierList, (String)I18nUtil.translate((String)"i18n_alert_ViFRdXW_6cf46e6b", (String)"\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546!"));
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(tenderOpenBidRecordHead.getCheckType());
        for (TenderOpenBidRecordSupplier tenderOpenBidRecordSupplier : tenderOpenBidRecordSupplierList) {
            Assert.hasText((String)tenderOpenBidRecordSupplier.getSupplierAccount(), (String)I18nUtil.translate((String)"i18n_alert_RdXeyxOLVW_e6a8e73", (String)"\u4f9b\u5e94\u5546\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
            if (hasPreTrial) continue;
            Assert.notNull((Object)tenderOpenBidRecordSupplier.getQuote(), (String)I18nUtil.translate((String)"i18n_alert_eBsuxOLVW_51fdd40d", (String)"\u6295\u6807\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a!"));
        }
    }

    private void updateTenderProjectSubpackageInfo(TenderOpenBidRecordHead tenderOpenBidRecordHead, String subPackageStatus) {
        TenderWriteBackSubpackageInfoEventDTO eventDTO = TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)tenderOpenBidRecordHead).subpackageId(tenderOpenBidRecordHead.getSubpackageId()).subpackageStatus(subPackageStatus).build();
        PushEventUtils.updateSubpackageInfo(eventDTO);
    }
}

