/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.supplier.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.BusMessageVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentInfo;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentInfoService;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.utils.TenderProjectMemberUtils;
import com.els.modules.tender.project.vo.PurchaseTenderProjectInfoVO;
import com.els.modules.tender.sale.enumerate.TenderProjectPurchaseBidStatusEnum;
import com.els.modules.tender.sale.vo.TenderProjectPurchaseBidOrderVO;
import com.els.modules.tender.sale.vo.TenderProjectPurchaseBidVO;
import com.els.modules.tender.supplier.entity.TenderInvoiceInfo;
import com.els.modules.tender.supplier.entity.TenderProjectPurchaseBid;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.mapper.TenderProjectPurchaseBidMapper;
import com.els.modules.tender.supplier.service.TenderInvitationSupplierReceiptService;
import com.els.modules.tender.supplier.service.TenderInvoiceInfoService;
import com.els.modules.tender.supplier.service.TenderProjectPurchaseBidService;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class TenderProjectPurchaseBidServiceImpl
extends BaseServiceImpl<TenderProjectPurchaseBidMapper, TenderProjectPurchaseBid>
implements TenderProjectPurchaseBidService {
    @Autowired
    private TenderInvoiceInfoService saleTenderInvoiceInfoService;
    @Autowired
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;
    @Autowired
    private PurchaseTenderProjectAttachmentInfoService attachmentInfoService;
    @Autowired
    private TenderInvitationSupplierReceiptService tenderInvitationSupplierReceiptService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saleSubmit(TenderProjectPurchaseBid tenderProjectPurchaseBid, List<TenderInvoiceInfo> saleTenderInvoiceInfoList, List<SaleAttachmentDTO> attachmentList) {
        this.checkParam(tenderProjectPurchaseBid, saleTenderInvoiceInfoList);
        boolean hasReject = this.tenderInvitationSupplierReceiptService.hasReject(tenderProjectPurchaseBid.getSupplierAccount(), tenderProjectPurchaseBid.getSubpackageId());
        Assert.isTrue((!hasReject ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_PVIFKWxqRBW_c16890ff", (String)"\u9080\u8bf7\u5df2\u62d2\u7edd\uff0c\u4e0d\u53ef\u8d2d\u6807!"));
        this.buildParam(tenderProjectPurchaseBid);
        TenderProjectPurchaseBid purchaseBid = (TenderProjectPurchaseBid)((Object)((TenderProjectPurchaseBidMapper)this.baseMapper).selectById((Serializable)((Object)tenderProjectPurchaseBid.getId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseBid)), (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01"));
        tenderProjectPurchaseBid.setDataVersion(purchaseBid.getDataVersion());
        int count = ((TenderProjectPurchaseBidMapper)this.baseMapper).updateById((Object)tenderProjectPurchaseBid);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        super.setHeadDefaultValue((ParentEntity)tenderProjectPurchaseBid);
        this.saleTenderInvoiceInfoService.deleteByMainId(tenderProjectPurchaseBid.getId());
        this.insertData(tenderProjectPurchaseBid, saleTenderInvoiceInfoList);
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(attachmentList), (String)I18nUtil.translate((String)"i18n_field_RBBIxOLVW_4bedce65", (String)"\u8d2d\u6807\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!"));
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(tenderProjectPurchaseBid.getId());
        attachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(tenderProjectPurchaseBid.getId()));
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentList);
        ArchiveUtil.saveArchiveBySaleAttachmentDTO(attachmentList, tenderProjectPurchaseBid.getId(), tenderProjectPurchaseBid.getSubpackageId(), tenderProjectPurchaseBid.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.PURCHASE_BID_PREFIX.getValue());
        this.tenderProjectSupplierService.saveOrUpdateByPurchaseBid(tenderProjectPurchaseBid);
        if ("1".equals(tenderProjectPurchaseBid.getSourceType())) {
            this.tenderProjectSupplierService.updateByPurchaseBidApproved(tenderProjectPurchaseBid.getSubpackageId(), tenderProjectPurchaseBid.getSupplierAccount());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void purchaseSubmit(TenderProjectPurchaseBid tenderProjectPurchaseBid, List<TenderInvoiceInfo> saleTenderInvoiceInfoList, List<SaleAttachmentDTO> attachmentList) {
        this.saleSubmit(tenderProjectPurchaseBid, saleTenderInvoiceInfoList, attachmentList);
        this.approved(tenderProjectPurchaseBid.getId());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveOrUpdatePublish(TenderProjectPurchaseBid tenderProjectPurchaseBid, List<TenderInvoiceInfo> saleTenderInvoiceInfoList, List<SaleAttachmentDTO> attachmentList) {
        if (StrUtil.isBlank((CharSequence)tenderProjectPurchaseBid.getId())) {
            this.saveMain(tenderProjectPurchaseBid, saleTenderInvoiceInfoList, attachmentList);
        } else {
            this.updateMain(tenderProjectPurchaseBid, saleTenderInvoiceInfoList, attachmentList);
        }
        tenderProjectPurchaseBid.setStatus(TenderProjectPurchaseBidStatusEnum.NOT_CONFIRM.getValue());
        this.saleSubmit(tenderProjectPurchaseBid, saleTenderInvoiceInfoList, attachmentList);
        List<ElsSubAccountDTO> accountDTOList = TenderProjectMemberUtils.getTenderProjectMember(tenderProjectPurchaseBid.getTenderProjectId());
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(tenderProjectPurchaseBid.getTenderProjectId()).append("&subpackageId=").append(tenderProjectPurchaseBid.getSubpackageId());
        String operation = "prePurchaseBid";
        if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderProjectPurchaseBid.getCheckType())) {
            operation = "purchaseBid";
        }
        List collect = accountDTOList.stream().map(BaseDTO::getId).distinct().collect(Collectors.toList());
        BusMessageVO messageVO = BusMessageVO.builder().businessId(tenderProjectPurchaseBid.getTenderProjectId()).msgConfigCode("tender_" + operation).businessBean("tenderBusDataServiceImpl").receiveSubAccountIdList(collect).build();
        super.sendMessage(messageVO);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(TenderProjectPurchaseBid tenderProjectPurchaseBid, List<TenderInvoiceInfo> saleTenderInvoiceInfoList, List<SaleAttachmentDTO> attachmentList) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectPurchaseBid.getSupplierAccount()), (String)I18nUtil.translate((String)"i18n_field_RdXeyxOLVW_e6a8e73", (String)"\u4f9b\u5e94\u5546\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectPurchaseBid.getCheckType()), (String)I18nUtil.translate((String)"i18n_field_UJCKxOLVW_e56eae77", (String)"\u5ba1\u67e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        List<TenderProjectPurchaseBid> tenderProjectPurchaseBids = ((TenderProjectPurchaseBidMapper)this.baseMapper).selectBySubpackageId(tenderProjectPurchaseBid.getSubpackageId(), tenderProjectPurchaseBid.getSupplierAccount(), tenderProjectPurchaseBid.getCheckType());
        Assert.isTrue((boolean)CollectionUtil.isEmpty(tenderProjectPurchaseBids), (String)I18nUtil.translate((String)"i18n_field_IMKRBVHWxqVBRBW_d7cf2323", (String)"\u5df2\u5b58\u5728\u8d2d\u6807\u4fe1\u606f\uff0c\u4e0d\u53ef\u91cd\u590d\u8d2d\u6807!"));
        boolean hasReject = this.tenderInvitationSupplierReceiptService.hasReject(tenderProjectPurchaseBid.getSupplierAccount(), tenderProjectPurchaseBid.getSubpackageId());
        Assert.isTrue((!hasReject ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_PVIFKWxqRBW_c16890ff", (String)"\u9080\u8bf7\u5df2\u62d2\u7edd\uff0c\u4e0d\u53ef\u8d2d\u6807!"));
        this.buildParam(tenderProjectPurchaseBid);
        tenderProjectPurchaseBid.setStatus(TenderProjectPurchaseBidStatusEnum.NEW.getValue());
        ((TenderProjectPurchaseBidMapper)this.baseMapper).insert((Object)tenderProjectPurchaseBid);
        super.setHeadDefaultValue((ParentEntity)tenderProjectPurchaseBid);
        this.insertData(tenderProjectPurchaseBid, saleTenderInvoiceInfoList);
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            attachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(tenderProjectPurchaseBid.getId()));
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(TenderProjectPurchaseBid tenderProjectPurchaseBid, List<TenderInvoiceInfo> saleTenderInvoiceInfoList, List<SaleAttachmentDTO> attachmentList) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectPurchaseBid.getSupplierAccount()), (String)I18nUtil.translate((String)"i18n_field_RdXeyxOLVW_e6a8e73", (String)"\u4f9b\u5e94\u5546\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        TenderProjectPurchaseBid purchaseBid = (TenderProjectPurchaseBid)((Object)((TenderProjectPurchaseBidMapper)this.baseMapper).selectById((Serializable)((Object)tenderProjectPurchaseBid.getId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseBid)), (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01"));
        Assert.isTrue((boolean)TenderProjectPurchaseBidStatusEnum.NEW.getValue().equals(purchaseBid.getStatus()), (String)I18nUtil.translate((String)"i18n_field_APzExqcrW_3ebe12cf", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u4fee\u6539\uff01"));
        boolean hasReject = this.tenderInvitationSupplierReceiptService.hasReject(tenderProjectPurchaseBid.getSupplierAccount(), tenderProjectPurchaseBid.getSubpackageId());
        Assert.isTrue((!hasReject ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_PVIFKWxqRBW_c16890ff", (String)"\u9080\u8bf7\u5df2\u62d2\u7edd\uff0c\u4e0d\u53ef\u8d2d\u6807!"));
        tenderProjectPurchaseBid.setDataVersion(purchaseBid.getDataVersion());
        this.buildParam(tenderProjectPurchaseBid);
        tenderProjectPurchaseBid.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
        tenderProjectPurchaseBid.setStatus(TenderProjectPurchaseBidStatusEnum.NEW.getValue());
        int count = ((TenderProjectPurchaseBidMapper)this.baseMapper).updateById((Object)tenderProjectPurchaseBid);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        super.setHeadDefaultValue((ParentEntity)tenderProjectPurchaseBid);
        this.saleTenderInvoiceInfoService.deleteByMainId(tenderProjectPurchaseBid.getId());
        this.insertData(tenderProjectPurchaseBid, saleTenderInvoiceInfoList);
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            this.invokeBaseRpcService.deleteSaleAttachmentByMainId(tenderProjectPurchaseBid.getId());
            attachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(tenderProjectPurchaseBid.getId()));
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentList);
        }
    }

    private void insertData(TenderProjectPurchaseBid tenderProjectPurchaseBid, List<TenderInvoiceInfo> saleTenderInvoiceInfoList) {
        if (!CollectionUtils.isEmpty(saleTenderInvoiceInfoList)) {
            for (TenderInvoiceInfo entity : saleTenderInvoiceInfoList) {
                entity.setDeleted(CommonConstant.DEL_FLAG_0);
                entity.setHeadId(tenderProjectPurchaseBid.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)tenderProjectPurchaseBid);
                entity.setElsAccount(tenderProjectPurchaseBid.getElsAccount());
            }
            this.saleTenderInvoiceInfoService.saveBatch(saleTenderInvoiceInfoList, 2000);
        }
    }

    @Override
    public TenderProjectPurchaseBidVO queryPurchaseBidInfo(String subpackageId) {
        String elsAccount = TenantContext.getTenant();
        TenderProjectPurchaseBidVO tenderProjectPurchaseBidVO = new TenderProjectPurchaseBidVO();
        TenderProjectPurchaseBid tenderProjectPurchaseBid = null;
        List<TenderProjectPurchaseBid> tenderProjectPurchaseBids = ((TenderProjectPurchaseBidMapper)this.baseMapper).selectBySubpackageId(subpackageId, elsAccount, TenderFlagInjectionContext.getTenderCheckType());
        if (CollectionUtil.isNotEmpty(tenderProjectPurchaseBids)) {
            tenderProjectPurchaseBid = tenderProjectPurchaseBids.get(0);
            BeanUtils.copyProperties((Object)((Object)tenderProjectPurchaseBid), (Object)((Object)tenderProjectPurchaseBidVO));
        }
        if (tenderProjectPurchaseBid != null) {
            List<TenderInvoiceInfo> tenderInvoiceInfos = this.saleTenderInvoiceInfoService.selectByMainId(tenderProjectPurchaseBidVO.getId());
            if (CollectionUtil.isEmpty(tenderInvoiceInfos)) {
                tenderInvoiceInfos = new ArrayList<TenderInvoiceInfo>();
            }
            tenderProjectPurchaseBidVO.setSaleTenderInvoiceInfoList(tenderInvoiceInfos);
            List saleAttachmentDemandDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(tenderProjectPurchaseBid.getId());
            tenderProjectPurchaseBidVO.setAttachmentList(saleAttachmentDemandDTOS);
            tenderProjectPurchaseBidVO.setBusAccount(tenderProjectPurchaseBid.getPurchaseEnterpriseAccount());
        } else {
            PurchaseTenderProjectInfoVO purchaseTenderProjectInfoVO = this.purchaseTenderProjectHeadService.queryProjectInfoBySubpackageId(subpackageId);
            if (ObjectUtil.isNull((Object)purchaseTenderProjectInfoVO)) {
                return tenderProjectPurchaseBidVO;
            }
            BeanUtils.copyProperties((Object)purchaseTenderProjectInfoVO, (Object)((Object)tenderProjectPurchaseBidVO), (String[])new String[]{"id"});
            TenderProjectSupplier querySupplier = new TenderProjectSupplier();
            querySupplier.setSubpackageId(subpackageId);
            querySupplier.setSupplierAccount(elsAccount);
            List<TenderProjectSupplier> tenderProjectSupplierList = this.tenderProjectSupplierService.selectBySubpackageId(querySupplier);
            if (CollectionUtil.isNotEmpty(tenderProjectSupplierList)) {
                TenderProjectSupplier saleTenderProjectSupplier = tenderProjectSupplierList.get(0);
                tenderProjectPurchaseBidVO.setContacts(saleTenderProjectSupplier.getContacts());
                tenderProjectPurchaseBidVO.setContactsPhone(saleTenderProjectSupplier.getContactsPhone());
                tenderProjectPurchaseBidVO.setCombination(saleTenderProjectSupplier.getCombination());
                tenderProjectPurchaseBidVO.setCombinationName(saleTenderProjectSupplier.getCombinationName());
                tenderProjectPurchaseBidVO.setConsortiumBidding(saleTenderProjectSupplier.getConsortiumBidding());
                tenderProjectPurchaseBidVO.setBusAccount(saleTenderProjectSupplier.getPurchaseEnterpriseAccount());
            }
        }
        this.selectOrderInfo(tenderProjectPurchaseBidVO);
        return tenderProjectPurchaseBidVO;
    }

    @Override
    public void selectOrderInfo(TenderProjectPurchaseBidVO tenderProjectPurchaseBidVO) {
        List<PurchaseTenderProjectAttachmentInfo> attachmentInfos = this.attachmentInfoService.selectBySubpackageId(tenderProjectPurchaseBidVO.getSubpackageId());
        if (CollectionUtil.isNotEmpty(attachmentInfos)) {
            ArrayList tenderProjectPurchaseBidOrderVOList = SysUtil.copyProperties(attachmentInfos, TenderProjectPurchaseBidOrderVO.class);
            tenderProjectPurchaseBidVO.setTenderProjectPurchaseBidOrderVOList(tenderProjectPurchaseBidOrderVOList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void approved(String id) {
        TenderProjectPurchaseBid tenderProjectPurchaseBid = (TenderProjectPurchaseBid)((Object)((TenderProjectPurchaseBidMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)tenderProjectPurchaseBid)), (String)I18nUtil.translate((String)"i18n_field_WFxMKW_b697ca02", (String)"\u6570\u636e\u4e0d\u5b58\u5728!"));
        tenderProjectPurchaseBid.setStatus(TenderProjectPurchaseBidStatusEnum.CONFIRM.getValue());
        ((TenderProjectPurchaseBidMapper)this.baseMapper).updateById((Object)tenderProjectPurchaseBid);
        this.tenderProjectSupplierService.updateByPurchaseBidApproved(tenderProjectPurchaseBid.getSubpackageId(), tenderProjectPurchaseBid.getSupplierAccount());
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        toElsAccountList.add(tenderProjectPurchaseBid.getSupplierAccount());
        StringBuilder urlParams = new StringBuilder("id=").append(tenderProjectPurchaseBid.getId());
        String operation = "prePurchaseBidConfirm";
        if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderProjectPurchaseBid.getCheckType())) {
            operation = "purchaseBidConfirm";
        }
        BusMessageVO messageVO = BusMessageVO.builder().businessId(tenderProjectPurchaseBid.getTenderProjectId()).msgConfigCode("tender_" + operation).businessBean("tenderBusDataServiceImpl").receiveAccountList(toElsAccountList).build();
        super.sendMessage(messageVO);
    }

    @Override
    public List<TenderProjectPurchaseBid> selectBySubpackageId(String subpackageId) {
        return ((TenderProjectPurchaseBidMapper)this.baseMapper).selectBySubpackageId(subpackageId, null, null);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        TenderProjectPurchaseBid tenderProjectPurchaseBid = (TenderProjectPurchaseBid)((Object)((TenderProjectPurchaseBidMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)tenderProjectPurchaseBid)), (String)I18nUtil.translate((String)"i18n_field_WFxMKW_b697ca02", (String)"\u6570\u636e\u4e0d\u5b58\u5728!"));
        Assert.isTrue((boolean)TenderProjectPurchaseBidStatusEnum.NOT_CONFIRM.getValue().equals(tenderProjectPurchaseBid.getStatus()), (String)I18nUtil.translate((String)"i18n_field_RBIRLWxqQGW_6ca5bf3d", (String)"\u8d2d\u6807\u5df2\u786e\u8ba4\uff0c\u4e0d\u53ef\u5220\u9664!"));
        ((TenderProjectPurchaseBidMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.saleTenderInvoiceInfoService.deleteByMainId(id);
    }

    @Override
    public List<TenderProjectPurchaseBidVO> selectByMainIds(List<String> oldIds) {
        List<TenderProjectPurchaseBid> purchaseBidList = ((TenderProjectPurchaseBidMapper)this.baseMapper).selectByMainIds(oldIds);
        if (CollectionUtil.isEmpty(purchaseBidList)) {
            return null;
        }
        List<String> purchaseBidIds = purchaseBidList.stream().map(ParentEntity::getId).collect(Collectors.toList());
        ArrayList purchaseBidVOList = SysUtil.copyProperties(purchaseBidList, TenderProjectPurchaseBidVO.class);
        List<TenderInvoiceInfo> tenderInvoiceInfos = this.saleTenderInvoiceInfoService.selectByMainIds(purchaseBidIds);
        Map<String, List<TenderInvoiceInfo>> tenderInvoiceInfoMaps = tenderInvoiceInfos.stream().collect(Collectors.groupingBy(TenderInvoiceInfo::getHeadId));
        for (TenderProjectPurchaseBidVO tenderProjectPurchaseBidVO : purchaseBidVOList) {
            List<TenderInvoiceInfo> saleInvoiceInfo = tenderInvoiceInfoMaps.get(tenderProjectPurchaseBidVO.getId());
            tenderProjectPurchaseBidVO.setSaleTenderInvoiceInfoList(saleInvoiceInfo);
            List saleAttachmentDemandDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(tenderProjectPurchaseBidVO.getId());
            tenderProjectPurchaseBidVO.setAttachmentList(saleAttachmentDemandDTOS);
            this.selectOrderInfo(tenderProjectPurchaseBidVO);
        }
        return purchaseBidVOList;
    }

    @Override
    public TenderProjectPurchaseBid queryById(String id) {
        return (TenderProjectPurchaseBid)((Object)((TenderProjectPurchaseBidMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    @Override
    public List<CountVO> queryTabsCount(String elsAccount) {
        return ((TenderProjectPurchaseBidMapper)this.baseMapper).queryTabsCount(elsAccount);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void dataVoSaveBatch(List<TenderProjectPurchaseBidVO> newTenderProjectPurchaseBidVOS) {
        if (CollectionUtil.isEmpty(newTenderProjectPurchaseBidVOS)) {
            return;
        }
        ArrayList purchaseBidList = SysUtil.copyProperties(newTenderProjectPurchaseBidVOS, TenderProjectPurchaseBid.class);
        ArrayList tenderInvoiceInfoList = new ArrayList();
        ArrayList attachmentList = new ArrayList();
        newTenderProjectPurchaseBidVOS.stream().forEach(purchaseBidVo -> {
            List<SaleAttachmentDTO> saleAttachmentList;
            List<TenderInvoiceInfo> saleTenderInvoiceInfoList = purchaseBidVo.getSaleTenderInvoiceInfoList();
            if (CollectionUtil.isNotEmpty(saleTenderInvoiceInfoList)) {
                tenderInvoiceInfoList.addAll(saleTenderInvoiceInfoList);
            }
            if (CollectionUtil.isNotEmpty(saleAttachmentList = purchaseBidVo.getAttachmentList())) {
                attachmentList.addAll(saleAttachmentList);
            }
        });
        this.saveBatch(purchaseBidList);
        this.saleTenderInvoiceInfoService.saveBatch(tenderInvoiceInfoList, 2000);
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentList);
    }

    private void checkParam(TenderProjectPurchaseBid tenderProjectPurchaseBid, List<TenderInvoiceInfo> saleTenderInvoiceInfoList) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectPurchaseBid.getSupplierName()), (String)I18nUtil.translate((String)"i18n_field_eBtLRLxOLVW_b6922b04", (String)"\u6295\u6807\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        if ("1".equals(tenderProjectPurchaseBid.getCombination())) {
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectPurchaseBid.getCombinationName()), (String)I18nUtil.translate((String)"i18n_field_KnDRLxOLVW_f8dad7ef", (String)"\u8054\u5408\u4f53\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        }
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectPurchaseBid.getPurchaseEnterpriseAccount()), (String)I18nUtil.translate((String)"i18n_field_YBtLeyxOLVW_e92a07c", (String)"\u62db\u6807\u5355\u4f4d\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectPurchaseBid.getContacts()), (String)I18nUtil.translate((String)"i18n_field_KHLxOLVW_eddf217e", (String)"\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectPurchaseBid.getContactsPhone()), (String)I18nUtil.translate((String)"i18n_field_KHLCExOLVW_da0049f6", (String)"\u8054\u7cfb\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectPurchaseBid.getTenderProjectNumber()), (String)I18nUtil.translate((String)"i18n_field_dIAyxOLVW_a6e5f3db", (String)"\u9879\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectPurchaseBid.getTenderProjectName()), (String)I18nUtil.translate((String)"i18n_field_dIRLxOLVW_eb0fa139", (String)"\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectPurchaseBid.getSubpackageId()), (String)I18nUtil.translate((String)"i18n_alert_zsxOLVW_2edb7bb2", (String)"\u5206\u5305\u4e0d\u80fd\u4e3a\u7a7a!"));
        saleTenderInvoiceInfoList.forEach(supplierTenderInvoiceInfo -> {
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getPayType()), (String)I18nUtil.translate((String)"i18n_field_RBCKxOLVW_477a3bb2", (String)"\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)supplierTenderInvoiceInfo.getPayMoney()), (String)I18nUtil.translate((String)"i18n_field_RBHfxOLVW_5ca84fc", (String)"\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getInvoice()), (String)I18nUtil.translate((String)"i18n_field_ViFKQvhPW_fb790198", (String)"\u8bf7\u9009\u62e9\u662f\u5426\u5f00\u53d1\u7968!"));
            if ("1".equals(supplierTenderInvoiceInfo.getInvoice())) {
                Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getInvoiceType()), (String)I18nUtil.translate((String)"i18n_field_hPAcxOLVW_b764ae0a", (String)"\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getEnterpriseName()), (String)I18nUtil.translate((String)"i18n_field_AERLxOLVW_b1d84f15", (String)"\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getDutyParagraph()), (String)I18nUtil.translate((String)"i18n_field_fyxOLVW_6c444408", (String)"\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getEnterpriseAddress()), (String)I18nUtil.translate((String)"i18n_field_AEnRxOLVW_6eea20a8", (String)"\u4f01\u4e1a\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getEnterprisePhone()), (String)I18nUtil.translate((String)"i18n_field_AECEyxOLVW_6e7549fb", (String)"\u4f01\u4e1a\u7535\u8bdd\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getDepositBank()), (String)I18nUtil.translate((String)"i18n_field_vDWExOLVW_f5ba2aa4", (String)"\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a!"));
                Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)supplierTenderInvoiceInfo.getBankNumber()), (String)I18nUtil.translate((String)"i18n_field_WEeDxOLVW_49ed880a", (String)"\u94f6\u884c\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a!"));
            }
        });
        PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = this.subpackageInfoService.selectById(tenderProjectPurchaseBid.getSubpackageId());
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseTenderProjectSubpackageInfo)), (String)I18nUtil.translate((String)"i18n_field_dIVHxMKW_dc01fda7", (String)"\u9879\u76ee\u4fe1\u606f\u4e0d\u5b58\u5728!"));
        if ("1".equals(purchaseTenderProjectSubpackageInfo.getSignUp())) {
            TenderProjectSupplier querySupplier = new TenderProjectSupplier();
            querySupplier.setSubpackageId(tenderProjectPurchaseBid.getSubpackageId());
            querySupplier.setSupplierAccount(tenderProjectPurchaseBid.getSupplierAccount());
            List<TenderProjectSupplier> tenderProjectSuppliers = this.tenderProjectSupplierService.selectBySubpackageId(querySupplier);
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty(tenderProjectSuppliers), (String)I18nUtil.translate((String)"i18n_field_VWsRW_dacafd48", (String)"\u8bf7\u5148\u62a5\u540d!"));
            TenderProjectSupplier tenderProjectSupplier = tenderProjectSuppliers.get(0);
            Assert.isTrue((boolean)"2".equals(tenderProjectSupplier.getSignUpStatus()), (String)I18nUtil.translate((String)"i18n_alert_sRLRLW_25a45089", (String)"\u62a5\u540d\u672a\u786e\u8ba4!"));
        }
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        Date currentDate = new Date();
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(tenderCheckType)) {
            Assert.isTrue((boolean)currentDate.after(purchaseTenderProjectSubpackageInfo.getPreBiddingBeginTime()), (String)I18nUtil.translate((String)"i18n_field_lBLvKW_44af9365", (String)"\u552e\u6807\u672a\u5f00\u59cb!"));
            Assert.isTrue((boolean)currentDate.before(purchaseTenderProjectSubpackageInfo.getPreBiddingEndTime()), (String)I18nUtil.translate((String)"i18n_field_lBIyRW_408cc990", (String)"\u552e\u6807\u5df2\u622a\u6b62!"));
        } else {
            Assert.isTrue((boolean)currentDate.after(purchaseTenderProjectSubpackageInfo.getBiddingBeginTime()), (String)I18nUtil.translate((String)"i18n_field_lBLvKW_44af9365", (String)"\u552e\u6807\u672a\u5f00\u59cb!"));
            Assert.isTrue((boolean)currentDate.before(purchaseTenderProjectSubpackageInfo.getBiddingEndTime()), (String)I18nUtil.translate((String)"i18n_field_lBIyRW_408cc990", (String)"\u552e\u6807\u5df2\u622a\u6b62!"));
        }
    }

    private void buildParam(TenderProjectPurchaseBid tenderProjectPurchaseBid) {
        PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = this.subpackageInfoService.selectById(tenderProjectPurchaseBid.getSubpackageId());
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseTenderProjectSubpackageInfo)), (String)I18nUtil.translate((String)"i18n_field_dIVHxMKW_dc01fda7", (String)"\u9879\u76ee\u4fe1\u606f\u4e0d\u5b58\u5728!"));
        tenderProjectPurchaseBid.setElsAccount(tenderProjectPurchaseBid.getSupplierAccount());
        tenderProjectPurchaseBid.setTenderProjectId(purchaseTenderProjectSubpackageInfo.getHeadId());
        tenderProjectPurchaseBid.setSubpackageName(purchaseTenderProjectSubpackageInfo.getSubpackageName());
        tenderProjectPurchaseBid.setDeleted(CommonConstant.DEL_FLAG_0);
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(purchaseTenderProjectSubpackageInfo.getCheckType()) && SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderProjectPurchaseBid.getCheckType())) {
            TenderProjectSupplier supplier = new TenderProjectSupplier();
            supplier.setSubpackageId(tenderProjectPurchaseBid.getSubpackageId());
            supplier.setPreShortlisted("1");
            List<TenderProjectSupplier> supplierList = this.tenderProjectSupplierService.selectBySubpackageId(supplier);
            List list = supplierList.stream().filter(temp -> temp.getSupplierAccount().equals(tenderProjectPurchaseBid.getSupplierAccount())).collect(Collectors.toList());
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty(list), (String)I18nUtil.translate((String)"i18n_alert_LLeRJmUUWShsUSTYBSyW_57cc96fa", (String)"\u60a8\u672a\u901a\u8fc7\u8d44\u683c\u9884\u5ba1\uff0c\u65e0\u6cd5\u53c2\u4e0e\u540e\u7eed\u62db\u6807\u73af\u8282\uff01"));
        }
    }
}

