/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.service.PurchaseEbiddingConfirmService;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.vo.PurchaseEbiddingHeadVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="publishEbiddingRpcAdapter")
public class PublishEbiddingAdapter
implements WorkflowAuditOptCallBackService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PublishEbiddingAdapter.class);
    @Autowired
    private PurchaseEbiddingHeadService purchaseEbiddingHeadService;
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private PurchaseEbiddingSupplierService purchaseEbiddingSupplierService;
    @Autowired
    private PurchaseEbiddingConfirmService purchaseEbiddingConfirmService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
        String id = flowCallbackDTO.getBusinessId();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        headVO.setPurchaseEbiddingItemList(this.purchaseEbiddingItemService.selectByMainId(id));
        headVO.setPurchaseEbiddingSupplierList(this.purchaseEbiddingSupplierService.selectByMainId(id));
        headVO.setPurchaseEbiddingConfirmList(this.purchaseEbiddingConfirmService.selectByMainId(id));
        headVO.setPurchaseAttachmentDemandList(this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id));
        this.purchaseEbiddingHeadService.publish(headVO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseEbiddingHead head = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
            List<PurchaseEbiddingItem> itemList = this.purchaseEbiddingItemService.selectByMainId(id);
            headVO.setPurchaseEbiddingItemList(itemList);
            return SrmUtil.toJSONObject((Object)((Object)headVO));
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseEbiddingHead updateHead = new PurchaseEbiddingHead();
        updateHead.setId(flowCallbackDTO.getBusinessId());
        updateHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        updateHead.setAuditStatus(auditStatus);
        this.purchaseEbiddingHeadService.updateById((Object)updateHead);
    }
}

