/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.priceEvaluationManagement.adapter;

import cn.hutool.core.bean.BeanUtil;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.priceEvaluationManagement.entity.PurchaseManagementClassifyItem;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationItem;
import com.els.modules.priceEvaluationManagement.entity.PurchasePriceEvaluationStandardHead;
import com.els.modules.priceEvaluationManagement.entity.PurchaseProcessingProcedurePriceItem;
import com.els.modules.priceEvaluationManagement.enumerate.PurchasePriceEvaluationStandardStatusEnum;
import com.els.modules.priceEvaluationManagement.service.PurchaseManagementClassifyItemService;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationItemService;
import com.els.modules.priceEvaluationManagement.service.PurchasePriceEvaluationStandardHeadService;
import com.els.modules.priceEvaluationManagement.service.PurchaseProcessingProcedurePriceItemService;
import com.els.modules.priceEvaluationManagement.vo.PurchasePriceEvaluationStandardHeadVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="priceEvaluationStandardAuditAdapter")
public class PriceEvaluationStanderAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PriceEvaluationStanderAuditOptCallBackServiceImpl.class);
    @Autowired
    private PurchasePriceEvaluationStandardHeadService purchasePriceEvaluationStandardHeadService;
    @Autowired
    private PurchasePriceEvaluationItemService purchasePriceEvaluationItemService;
    @Autowired
    private PurchaseProcessingProcedurePriceItemService purchaseProcessingProcedurePriceItemService;
    @Autowired
    private PurchaseManagementClassifyItemService purchaseManagementClassifyItemService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchasePriceEvaluationStandardHead head = (PurchasePriceEvaluationStandardHead)((Object)this.purchasePriceEvaluationStandardHeadService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchasePriceEvaluationStandardHead purchasePriceEvaluationStandardHead = (PurchasePriceEvaluationStandardHead)((Object)this.purchasePriceEvaluationStandardHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        if (purchasePriceEvaluationStandardHead == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_HemhxurtFW_1f2b4ae7", (String)"\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e!"));
        }
        PurchasePriceEvaluationStandardHead head = new PurchasePriceEvaluationStandardHead();
        head.setId(flowCallbackDTO.getBusinessId());
        head.setAuditStatus(auditStatus);
        head.setFlowId(flowCallbackDTO.getProcessInstanceId());
        log.info("xxxxxxxxxxxx");
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            head.setDocumentStatus(PurchasePriceEvaluationStandardStatusEnum.START.getValue());
            if ("1".equals(purchasePriceEvaluationStandardHead.getPublish())) {
                if (purchasePriceEvaluationStandardHead.getDeadline() != null && new Date().compareTo(purchasePriceEvaluationStandardHead.getDeadline()) > 0) {
                    throw new ELSBootException("\u5f53\u524d\u65f6\u95f4\u5df2\u7ecf\u5927\u4e8e\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\uff0c\u8be5\u5355\u636e\u4e0d\u80fd\u901a\u8fc7!");
                }
                PurchasePriceEvaluationStandardHeadVO purchasePriceEvaluationStandardHeadVO = new PurchasePriceEvaluationStandardHeadVO();
                BeanUtil.copyProperties((Object)((Object)purchasePriceEvaluationStandardHead), (Object)((Object)purchasePriceEvaluationStandardHeadVO), (String[])new String[0]);
                List<PurchasePriceEvaluationItem> purchasePriceEvaluationItemList = this.purchasePriceEvaluationItemService.selectByMainId(flowCallbackDTO.getBusinessId());
                List<PurchaseProcessingProcedurePriceItem> purchaseProcessingProcedurePriceItemList = this.purchaseProcessingProcedurePriceItemService.selectByMainId(flowCallbackDTO.getBusinessId());
                List<PurchaseManagementClassifyItem> purchaseManagementClassifyItemList = this.purchaseManagementClassifyItemService.selectByMainId(flowCallbackDTO.getBusinessId());
                purchasePriceEvaluationStandardHeadVO.setPurchasePriceEvaluationItemList(purchasePriceEvaluationItemList);
                purchasePriceEvaluationStandardHeadVO.setPurchaseProcessingProcedurePriceItemList(purchaseProcessingProcedurePriceItemList);
                purchasePriceEvaluationStandardHeadVO.setPurchaseManagementClassifyItemList(purchaseManagementClassifyItemList);
                this.purchasePriceEvaluationStandardHeadService.publish(purchasePriceEvaluationStandardHeadVO);
            }
        }
        this.purchasePriceEvaluationStandardHeadService.updateById((Object)head);
        log.info("\u6838\u4ef7\u6807\u51c6\u5ba1\u6279\u5b8c\u6210");
    }
}

