/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.abnormal.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.tender.abnormal.entity.PurchaseTenderSubpackageTerminateHead;
import com.els.modules.tender.abnormal.enumerate.SubpackageTerminateHeadStatusEnum;
import com.els.modules.tender.abnormal.service.PurchaseTenderSubpackageTerminateHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;

@RpcService(value="terminateAdapterCallBackServiceImpl")
public class TenderSubpackageTerminateAdapter
implements WorkflowAuditOptCallBackService {
    @Resource
    private PurchaseTenderSubpackageTerminateHeadService terminateHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseTenderSubpackageTerminateHead head = (PurchaseTenderSubpackageTerminateHead)((Object)this.terminateHeadService.getBaseMapper().selectById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    public void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseTenderSubpackageTerminateHead terminateHead = (PurchaseTenderSubpackageTerminateHead)((Object)this.terminateHeadService.getBaseMapper().selectById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        terminateHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            this.terminateHeadService.publish(terminateHead);
            return;
        }
        if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            terminateHead.setStatus(SubpackageTerminateHeadStatusEnum.NEW.getValue());
        } else if (AuditStatusEnum.AUDIT_NEW.getValue().equals(auditStatus)) {
            terminateHead.setStatus(SubpackageTerminateHeadStatusEnum.NEW.getValue());
        } else {
            terminateHead.setStatus(SubpackageTerminateHeadStatusEnum.AUDIT.getValue());
        }
        terminateHead.setAuditStatus(auditStatus);
        this.terminateHeadService.updateById((Object)terminateHead);
    }
}

