/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.approval.excel;

import cn.hutool.core.util.StrUtil;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.modules.tender.approval.entity.TenderProjectApprovalHead;
import com.els.modules.tender.approval.entity.TenderProjectApprovalItem;
import com.els.modules.tender.approval.service.TenderProjectApprovalHeadService;
import com.els.modules.tender.approval.service.TenderProjectApprovalItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseApprovalItemExcelRpcDubboServiceImpl")
public class PurchaseApprovalItemExcelServiceImpl
extends ErrorExcelHandlerService
implements ExcelItemByConfigRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseApprovalItemExcelServiceImpl.class);
    @Autowired
    private TenderProjectApprovalHeadService approvalHeadService;
    @Autowired
    private TenderProjectApprovalItemService approvalItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;
    private String headId;
    private String groupCode;
    private static final List<String> MATER_STRING = Lists.newArrayList((Object[])new String[]{"materialNumber", "materialName", "materialDesc", "materialSpec", "materialGroup", "materialGroupName", "cateCode", "cateName"});

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        String templateAccount = excelByConfigDTO.getTemplateAccount();
        String templateVersion = excelByConfigDTO.getTemplateVersion();
        String templateNumber = excelByConfigDTO.getTemplateNumber();
        this.groupCode = excelByConfigDTO.getGroupCode();
        if (StrUtil.isNotBlank((CharSequence)excelByConfigDTO.getHeadId()) && !"undefined".equals(excelByConfigDTO.getHeadId())) {
            this.headId = excelByConfigDTO.getHeadId();
            TenderProjectApprovalHead approvalHead = (TenderProjectApprovalHead)((Object)this.approvalHeadService.getById((Serializable)((Object)this.headId)));
            if (approvalHead != null) {
                templateAccount = StrUtil.isNotBlank((CharSequence)approvalHead.getTemplateAccount()) ? approvalHead.getTemplateAccount() : approvalHead.getElsAccount();
                templateVersion = String.valueOf(approvalHead.getTemplateVersion());
                templateNumber = String.valueOf(approvalHead.getTemplateNumber());
            }
        }
        return this.invokeBaseRpcService.getTemplateConfig(templateAccount, templateNumber, templateVersion);
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        List<TenderProjectApprovalItem> itemList = this.approvalItemService.selectByMainId(excelByConfigDTO.getHeadId());
        return new ArrayList<TenderProjectApprovalItem>(itemList);
    }

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ExcelByConfigDTO excelByConfigDTO = excelImportDTO.getExcelByConfigDTO();
        List configItemList = this.getTemplate(excelByConfigDTO).getTemplateConfigItemList();
        String[] excludeColumn = new String[]{"materialNumber", "taxCode"};
        List editColumn = configItemList.stream().filter(item -> "1".equals(item.getPurchaseEdit())).map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        if (StrUtil.isNotBlank((CharSequence)this.groupCode)) {
            editColumn = configItemList.stream().filter(item -> "1".equals(item.getPurchaseEdit()) && this.groupCode.equals(item.getGroupCode())).map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        }
        editColumn.addAll(Arrays.asList(excludeColumn));
        Map taxMap = this.invokeBaseRpcService.getAllTax(TenantContext.getTenant());
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            Field[] fields;
            String materialNumber;
            Map data = (Map)iterator.next();
            HashMap errorData = new HashMap(data);
            List finalEditColumn = editColumn;
            data.forEach((key, value) -> {
                if (!finalEditColumn.contains(key)) {
                    data.put(key, null);
                }
            });
            String taxCode = (String)data.get("taxCode");
            if (StrUtil.isNotBlank((CharSequence)taxCode)) {
                if (!taxMap.containsKey(taxCode)) {
                    String msg = I18nUtil.translate((String)"i18n_alert_foWWWWWWWxMK_e919daf8", (String)"\u7a0e\u7801\uff1a[${0}]\u4e0d\u5b58\u5728", (String[])new String[]{taxCode});
                    this.errorAdd(excelImportDTO, msg, errorData);
                    iterator.remove();
                    continue;
                }
                data.put("taxRate", taxMap.get(taxCode));
            }
            if (!StrUtil.isNotBlank((CharSequence)(materialNumber = (String)data.get("materialNumber")))) continue;
            PurchaseMaterialHeadDTO materialHead = this.purchaseMaterialHeadLocalRpcService.getMaterialHeadByNumber(materialNumber);
            if (null == materialHead) {
                String msg = I18nUtil.translate((String)"i18n_alert_SLAoWWWWWWWxMK_44822940", (String)"\u7269\u6599\u7f16\u7801\uff1a[${0}]\u4e0d\u5b58\u5728", (String[])new String[]{materialNumber});
                this.errorAdd(excelImportDTO, msg, errorData);
                iterator.remove();
                continue;
            }
            data.put("materialId", materialHead.getId());
            for (Field field : fields = ConvertUtils.getAllFields((Object)materialHead)) {
                if (!data.containsKey(field.getName()) || !MATER_STRING.contains(field.getName())) continue;
                try {
                    field.setAccessible(true);
                    data.put(field.getName(), field.get(materialHead));
                }
                catch (IllegalAccessException e) {
                    log.error("\u53cd\u5c04\u83b7\u53d6\u503c\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

