/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.tender.evaluation.entity.TenderEvaluationTemplateHead;
import com.els.modules.tender.evaluation.service.TenderEvaluationTemplateHeadService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.srm.workflow.modules.dto.FlowCallBackDTO;
import com.els.srm.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;

@RpcService(value="tenderEvaluationTemplateAuditCallBackServiceImpl")
public class TenderEvaluationTemplateAdapter
implements WorkflowAuditOptCallBackService {
    @Resource
    private TenderEvaluationTemplateHeadService headService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        this.headService.publishTemplate(flowCallbackDTO.getBusinessId());
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        TenderEvaluationTemplateHead head = (TenderEvaluationTemplateHead)((Object)this.headService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    public void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        TenderEvaluationTemplateHead tenderEvaluationTemplateHead = new TenderEvaluationTemplateHead();
        tenderEvaluationTemplateHead.setId(flowCallbackDTO.getBusinessId());
        tenderEvaluationTemplateHead.setAuditStatus(auditStatus);
        tenderEvaluationTemplateHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.headService.updateById((Object)tenderEvaluationTemplateHead);
    }
}

