/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.util.WorkFlowUtil;
import com.els.common.vo.CountVO;
import com.els.modules.tender.common.utils.NumericUtils;
import com.els.modules.tender.evaluation.entity.TenderEvaluationTemplateHead;
import com.els.modules.tender.evaluation.entity.TenderEvaluationTemplatePriceRegulationInfo;
import com.els.modules.tender.evaluation.entity.TenderEvaluationTemplateRegulationGroup;
import com.els.modules.tender.evaluation.entity.TenderEvaluationTemplateRegulationInfo;
import com.els.modules.tender.evaluation.enumerate.TenderEvaGroupTypeEnum;
import com.els.modules.tender.evaluation.enumerate.TenderEvaluationMainStatusEnum;
import com.els.modules.tender.evaluation.enumerate.TenderEvaluationTemplateStatusEnum;
import com.els.modules.tender.evaluation.mapper.TenderEvaluationTemplateHeadMapper;
import com.els.modules.tender.evaluation.service.TenderEvaluationTemplateHeadService;
import com.els.modules.tender.evaluation.service.TenderEvaluationTemplatePriceRegulationInfoService;
import com.els.modules.tender.evaluation.service.TenderEvaluationTemplateRegulationGroupService;
import com.els.modules.tender.evaluation.service.TenderEvaluationTemplateRegulationInfoService;
import com.els.modules.tender.evaluation.vo.TenderEvaluationTemplateHeadVO;
import com.els.modules.tender.evaluation.vo.TenderEvaluationTemplateRegulationGroupVo;
import com.els.rpc.service.InvokeBaseRpcService;
import com.els.srm.workflow.modules.dto.SubmitAuditDTO;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class TenderEvaluationTemplateHeadServiceImpl
extends BaseServiceImpl<TenderEvaluationTemplateHeadMapper, TenderEvaluationTemplateHead>
implements TenderEvaluationTemplateHeadService {
    @Autowired
    private TenderEvaluationTemplateRegulationGroupService tenderEvaluationTemplateRegulationGroupService;
    @Autowired
    private TenderEvaluationTemplateRegulationInfoService tenderEvaluationTemplateRegulationInfoService;
    @Autowired
    private TenderEvaluationTemplatePriceRegulationInfoService tenderEvaluationTemplatePriceRegulationInfoService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(TenderEvaluationTemplateHead tenderEvaluationTemplateHead, List<TenderEvaluationTemplateRegulationGroupVo> tenderEvaluationTemplateItemVoList) {
        tenderEvaluationTemplateHead.setMain(TenderEvaluationMainStatusEnum.YES.getValue());
        tenderEvaluationTemplateHead.setStatus("0");
        tenderEvaluationTemplateHead.setEvaluationNumber(this.invokeBaseRpcService.getNextCode("tenderEvaluationTemplateNumber", (Object)tenderEvaluationTemplateHead));
        ((TenderEvaluationTemplateHeadMapper)this.baseMapper).insert((Object)tenderEvaluationTemplateHead);
        super.setHeadDefaultValue((ParentEntity)tenderEvaluationTemplateHead);
        this.insertData(tenderEvaluationTemplateHead, tenderEvaluationTemplateItemVoList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(TenderEvaluationTemplateHead tenderEvaluationTemplateHead, List<TenderEvaluationTemplateRegulationGroupVo> tenderEvaluationTemplateItemList) {
        this.tenderEvaluationTemplateRegulationGroupService.deleteByMainId(tenderEvaluationTemplateHead.getId());
        this.tenderEvaluationTemplateRegulationInfoService.deleteByMainId(tenderEvaluationTemplateHead.getId());
        this.tenderEvaluationTemplatePriceRegulationInfoService.deleteByMainId(tenderEvaluationTemplateHead.getId());
        tenderEvaluationTemplateHead.setMain(TenderEvaluationMainStatusEnum.YES.getValue());
        ((TenderEvaluationTemplateHeadMapper)this.baseMapper).updateById((Object)tenderEvaluationTemplateHead);
        this.insertData(tenderEvaluationTemplateHead, tenderEvaluationTemplateItemList);
    }

    private void insertData(TenderEvaluationTemplateHead tenderEvaluationTemplateHead, List<TenderEvaluationTemplateRegulationGroupVo> tenderEvaluationTemplateItemVoList) {
        if (!CollectionUtils.isEmpty(tenderEvaluationTemplateItemVoList)) {
            ArrayList<TenderEvaluationTemplateRegulationGroup> addTemplateItems = new ArrayList<TenderEvaluationTemplateRegulationGroup>(16);
            ArrayList<TenderEvaluationTemplateRegulationInfo> addRegulationInfos = new ArrayList<TenderEvaluationTemplateRegulationInfo>(16);
            ArrayList<TenderEvaluationTemplatePriceRegulationInfo> addPriceRegulationInfos = new ArrayList<TenderEvaluationTemplatePriceRegulationInfo>(16);
            for (TenderEvaluationTemplateRegulationGroupVo entity : tenderEvaluationTemplateItemVoList) {
                TenderEvaluationTemplatePriceRegulationInfo priceInfo;
                entity.setId(IdWorker.getIdStr());
                entity.setHeadId(tenderEvaluationTemplateHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)tenderEvaluationTemplateHead);
                TenderEvaluationTemplateRegulationGroup tenderEvaluationTemplateRegulationGroup = new TenderEvaluationTemplateRegulationGroup();
                BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)tenderEvaluationTemplateRegulationGroup));
                addTemplateItems.add(tenderEvaluationTemplateRegulationGroup);
                List<TenderEvaluationTemplateRegulationInfo> infoList = entity.getTenderEvaluationTemplateRegulationInfoList();
                if (!CollectionUtils.isEmpty(infoList)) {
                    for (TenderEvaluationTemplateRegulationInfo regulationInfo : infoList) {
                        regulationInfo.setHeadId(tenderEvaluationTemplateHead.getId());
                        regulationInfo.setGroupId(entity.getId());
                        SysUtil.setSysParam((BaseEntity)regulationInfo, (BaseEntity)tenderEvaluationTemplateHead);
                        addRegulationInfos.add(regulationInfo);
                    }
                }
                if ((priceInfo = entity.getTenderEvaluationTemplatePriceRegulationInfo()) == null) continue;
                Assert.isTrue((boolean)NumericUtils.isNumeric(priceInfo.getAboveScore()), (String)I18nUtil.translate((String)"i18n_alert_suBxUtruWWVWWWzsnWTLWRmK_16af42a6", (String)"\u62a5\u4ef7\u6bcf\u9ad8\u4e8e\u57fa\u51c6\u4ef71%\u6263\u3010x\u3011\u5206\u4e2d\u7684x\u9700\u4e3a\u6570\u503c\u683c\u5f0f"));
                Assert.isTrue((boolean)NumericUtils.isNumeric(priceInfo.getBelowScore()), (String)I18nUtil.translate((String)"i18n_alert_suBnUtruWWVWWWzsnWTLWRmK_7c4e201c", (String)"\u62a5\u4ef7\u6bcf\u4f4e\u4e8e\u57fa\u51c6\u4ef71%\u6263\u3010x\u3011\u5206\u4e2d\u7684x\u9700\u4e3a\u6570\u503c\u683c\u5f0f"));
                Assert.isTrue((boolean)NumericUtils.isNumeric(priceInfo.getMostScore()), (String)I18nUtil.translate((String)"i18n_alert_eOVRWWWzsnWTLWRmK_314933d3", (String)"\u6700\u591a\u6263\u81f3\u3010x\u3011\u5206\u4e2d\u7684x\u9700\u4e3a\u6570\u503c\u683c\u5f0f"));
                Assert.isTrue((boolean)NumericUtils.isNumeric(priceInfo.getLowestScore()), (String)I18nUtil.translate((String)"i18n_alert_enVRWWWzsnWTLWRmK_503f8f1f", (String)"\u6700\u4f4e\u6263\u81f3\u3010x\u3011\u5206\u4e2d\u7684x\u9700\u4e3a\u6570\u503c\u683c\u5f0f"));
                priceInfo.setHeadId(tenderEvaluationTemplateHead.getId());
                priceInfo.setGroupId(entity.getId());
                SysUtil.setSysParam((BaseEntity)priceInfo, (BaseEntity)tenderEvaluationTemplateHead);
                addPriceRegulationInfos.add(priceInfo);
            }
            this.tenderEvaluationTemplateRegulationGroupService.saveBatch(addTemplateItems, 2000);
            this.tenderEvaluationTemplateRegulationInfoService.saveBatch(addRegulationInfos, 2000);
            this.tenderEvaluationTemplatePriceRegulationInfoService.saveBatch(addPriceRegulationInfos, 2000);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.tenderEvaluationTemplateRegulationGroupService.deleteByMainId(id);
        this.tenderEvaluationTemplateRegulationInfoService.deleteByMainId(id);
        this.tenderEvaluationTemplatePriceRegulationInfoService.deleteByMainId(id);
        ((TenderEvaluationTemplateHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.tenderEvaluationTemplateRegulationGroupService.deleteByMainId(serializable.toString());
            this.tenderEvaluationTemplateRegulationInfoService.deleteByMainId(serializable.toString());
            this.tenderEvaluationTemplatePriceRegulationInfoService.deleteByMainId(serializable.toString());
            ((TenderEvaluationTemplateHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishTemplate(String id) {
        TenderEvaluationTemplateHead evaluationTemplateHead = (TenderEvaluationTemplateHead)((Object)this.getById((Serializable)((Object)id)));
        evaluationTemplateHead.setStatus(TenderEvaluationTemplateStatusEnum.EFFECTIVE.getValue());
        this.updateById((Object)evaluationTemplateHead);
    }

    @Override
    public void submit(TenderEvaluationTemplateHead tenderEvaluationTemplateHead) {
        SubmitAuditDTO dto = SubmitAuditDTO.builder().businessId(tenderEvaluationTemplateHead.getId()).businessType("tenderEvaluationTemplate").processTitle("\u8bc4\u6807\u6a21\u677f\u53f7:" + tenderEvaluationTemplateHead.getEvaluationNumber() + " " + tenderEvaluationTemplateHead.getEvaluationName()).businessObj((Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)tenderEvaluationTemplateHead)))).build();
        WorkFlowUtil.submit((SubmitAuditDTO)dto);
    }

    @Override
    public List<CountVO> queryTabsCount(String elsAccount, QueryWrapper<TenderEvaluationTemplateHead> queryWrapper) {
        return ((TenderEvaluationTemplateHeadMapper)this.baseMapper).queryTabsCount(elsAccount, queryWrapper);
    }

    @Override
    public TenderEvaluationTemplateHeadVO queryById(String id) {
        TenderEvaluationTemplateHead tenderEvaluationTemplateHead = (TenderEvaluationTemplateHead)((Object)this.getById((Serializable)((Object)id)));
        TenderEvaluationTemplateHeadVO tenderEvaluationTemplateHeadVO = new TenderEvaluationTemplateHeadVO();
        BeanUtils.copyProperties((Object)((Object)tenderEvaluationTemplateHead), (Object)((Object)tenderEvaluationTemplateHeadVO));
        List<TenderEvaluationTemplateRegulationGroup> regulationGroupList = this.tenderEvaluationTemplateRegulationGroupService.selectByMainId(id);
        List<TenderEvaluationTemplateRegulationInfo> regulationInfoList = this.tenderEvaluationTemplateRegulationInfoService.selectByMainId(id);
        Map<String, List<TenderEvaluationTemplateRegulationInfo>> templateRegulationInfoListMap = regulationInfoList.parallelStream().collect(Collectors.groupingBy(TenderEvaluationTemplateRegulationInfo::getGroupId));
        List<TenderEvaluationTemplatePriceRegulationInfo> priceRegulationInfoList = this.tenderEvaluationTemplatePriceRegulationInfoService.selectByMainId(id);
        Map<String, List<TenderEvaluationTemplatePriceRegulationInfo>> priceRegulationInfoListMap = priceRegulationInfoList.parallelStream().collect(Collectors.groupingBy(TenderEvaluationTemplatePriceRegulationInfo::getGroupId));
        ArrayList groupVoList = SysUtil.copyProperties(regulationGroupList, TenderEvaluationTemplateRegulationGroupVo.class);
        groupVoList.parallelStream().sorted(Comparator.comparing(TenderEvaluationTemplateRegulationGroup::getOrderBy)).forEach(item -> {
            List regulationInfos = (List)templateRegulationInfoListMap.get(item.getId());
            item.setTenderEvaluationTemplateRegulationInfoList(regulationInfos);
            List priceRegulationInfos = (List)priceRegulationInfoListMap.get(item.getId());
            if (priceRegulationInfos != null && priceRegulationInfos.size() > 0) {
                item.setTenderEvaluationTemplatePriceRegulationInfo((TenderEvaluationTemplatePriceRegulationInfo)((Object)((Object)priceRegulationInfos.get(0))));
            }
        });
        tenderEvaluationTemplateHeadVO.setTenderEvaluationTemplateItemVoList(groupVoList);
        return tenderEvaluationTemplateHeadVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void copyData(String id) {
        TenderEvaluationTemplateHeadVO tenderEvaluationTemplateHeadVO = this.queryById(id);
        TenderEvaluationTemplateHead tenderEvaluationTemplateHead = new TenderEvaluationTemplateHead();
        BeanUtils.copyProperties((Object)((Object)tenderEvaluationTemplateHeadVO), (Object)((Object)tenderEvaluationTemplateHead));
        tenderEvaluationTemplateHead.setId(null);
        tenderEvaluationTemplateHead.setCreateBy(null);
        tenderEvaluationTemplateHead.setCreateById(null);
        tenderEvaluationTemplateHead.setCreateTime(null);
        tenderEvaluationTemplateHead.setUpdateBy(null);
        tenderEvaluationTemplateHead.setUpdateById(null);
        tenderEvaluationTemplateHead.setUpdateTime(null);
        tenderEvaluationTemplateHead.setFlowId(null);
        tenderEvaluationTemplateHead.setAuditStatus("1".equals(tenderEvaluationTemplateHead.getAudited()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        for (TenderEvaluationTemplateRegulationGroupVo groupVo : tenderEvaluationTemplateHeadVO.getTenderEvaluationTemplateItemVoList()) {
            groupVo.setId(null);
            if (groupVo.getTenderEvaluationTemplatePriceRegulationInfo() != null) {
                groupVo.getTenderEvaluationTemplatePriceRegulationInfo().setId(null);
            }
            if (!CollectionUtil.isNotEmpty(groupVo.getTenderEvaluationTemplateRegulationInfoList())) continue;
            groupVo.getTenderEvaluationTemplateRegulationInfoList().parallelStream().forEach(item -> item.setId(null));
        }
        this.saveMain(tenderEvaluationTemplateHead, tenderEvaluationTemplateHeadVO.getTenderEvaluationTemplateItemVoList());
    }

    public void checkParam(TenderEvaluationTemplateHeadVO tenderEvaluationTemplateHeadVO) {
        Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)tenderEvaluationTemplateHeadVO.getEvaluationName()), (String)I18nUtil.translate((String)"i18n_alert_UBIrRLxOLVW_1b731aad", (String)"\u8bc4\u6807\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)tenderEvaluationTemplateHeadVO.getEvaluationDescribe()), (String)I18nUtil.translate((String)"i18n_alert_UBIrMWW_e85abff", (String)"\u8bc4\u6807\u6a21\u677f\u63cf\u8ff0\uff01"));
        List<TenderEvaluationTemplateRegulationGroupVo> tenderEvaluationTemplateItemVoList = tenderEvaluationTemplateHeadVO.getTenderEvaluationTemplateItemVoList();
        Assert.isTrue((boolean)CollectionUtils.isEmpty(tenderEvaluationTemplateItemVoList), (String)I18nUtil.translate((String)"i18n_alert_TvVxOLVW_93778d77", (String)"\u6761\u4f8b\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        tenderEvaluationTemplateItemVoList.stream().forEach(item -> {
            this.checkTenderEvaluationTemplateItem((TenderEvaluationTemplateRegulationGroupVo)((Object)item));
            TenderEvaluationTemplatePriceRegulationInfo tenderEvaluationTemplatePriceRegulationInfo = item.getTenderEvaluationTemplatePriceRegulationInfo();
            List<TenderEvaluationTemplateRegulationInfo> tenderEvaluationTemplateRegulationInfoList = item.getTenderEvaluationTemplateRegulationInfoList();
        });
    }

    public void checkTenderEvaluationTemplateItem(TenderEvaluationTemplateRegulationGroupVo item) {
        Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)item.getGroupName()), (String)I18nUtil.translate((String)"i18n_alert_TvVRLxOLVW_ef061654", (String)"\u6761\u4f8b\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)item.getGroupType()), (String)I18nUtil.translate((String)"i18n_alert_TvVSyAqxOLVW_dcac7b54", (String)"\u6761\u4f8b\u7ec4\u73af\u8282\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Integer score = item.getScore();
        BigDecimal weights = item.getWeights();
        Integer orderBy = item.getOrderBy();
        String closedBid = item.getClosedBid();
        String veto = item.getVeto();
        Integer vetoCondition = item.getVetoCondition();
        Integer reviewGradingType = item.getReviewGradingType();
        Integer reviewGradingRules = item.getVetoCondition();
        if (TenderEvaGroupTypeEnum.REVIEW.getValue().equals(item.getGroupType())) {
            Assert.isTrue((null == orderBy ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_ATxOLVW_177fcdd4", (String)"\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((null == vetoCondition ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_QKTIxOLVW_4ace6f6f", (String)"\u5426\u51b3\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        } else if (TenderEvaGroupTypeEnum.SCORE.getValue().equals(item.getGroupType())) {
            Assert.isTrue((null == weights ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_bsxOLVW_ce54ac47", (String)"\u6743\u91cd\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((null == orderBy ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_ATxOLVW_177fcdd4", (String)"\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((null == closedBid ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_KQpBxOLVW_c60476ea", (String)"\u662f\u5426\u6697\u6807\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((null == veto ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_KQQKdxOLVW_6dd5097c", (String)"\u662f\u5426\u5426\u51b3\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        } else if (TenderEvaGroupTypeEnum.REVIEW_SCORE.getValue().equals(item.getGroupType())) {
            Assert.isTrue((null == score ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_zRxOLVW_6e2d27bb", (String)"\u5206\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((null == weights ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_bsxOLVW_ce54ac47", (String)"\u6743\u91cd\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((null == orderBy ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_ATxOLVW_177fcdd4", (String)"\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((null == closedBid ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_KQpBxOLVW_c60476ea", (String)"\u662f\u5426\u6697\u6807\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((null == reviewGradingType ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_UUUzdLFxOLVW_b7cdeb82", (String)"\u8bc4\u5ba1\u8bc4\u5206\u9879\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((null == reviewGradingRules ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_LFmWxOLVW_dd4ad9b6", (String)"\u89c4\u5219\u4e2a\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        } else if (TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue().equals(item.getGroupType())) {
            Assert.isTrue((null == score ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_zRxOLVW_6e2d27bb", (String)"\u5206\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((null == weights ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_bsxOLVW_ce54ac47", (String)"\u6743\u91cd\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((null == orderBy ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_ATxOLVW_177fcdd4", (String)"\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishSubmit(String id) {
        TenderEvaluationTemplateHead tenderEvaluationTemplateHead = (TenderEvaluationTemplateHead)((Object)((TenderEvaluationTemplateHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(TenderEvaluationTemplateHead::getEvaluationNumber, (Object)tenderEvaluationTemplateHead.getEvaluationNumber())).eq(TenderEvaluationTemplateHead::getStatus, (Object)TenderEvaluationTemplateStatusEnum.EFFECTIVE.getValue())).set(TenderEvaluationTemplateHead::getStatus, (Object)TenderEvaluationTemplateStatusEnum.LOST_EFFECTIVE.getValue());
        ((TenderEvaluationTemplateHeadMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
        updateWrapper.clear();
        ((LambdaUpdateWrapper)updateWrapper.eq(ParentEntity::getId, (Object)tenderEvaluationTemplateHead.getId())).set(TenderEvaluationTemplateHead::getStatus, (Object)TenderEvaluationTemplateStatusEnum.EFFECTIVE.getValue());
    }

    public void updateMainStatus(TenderEvaluationTemplateHead tenderEvaluationTemplateHead) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.eq(TenderEvaluationTemplateHead::getEvaluationNumber, (Object)tenderEvaluationTemplateHead.getEvaluationNumber())).set(TenderEvaluationTemplateHead::getMain, (Object)TenderEvaluationMainStatusEnum.NO.getValue());
        ((TenderEvaluationTemplateHeadMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }
}

