/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.sale.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.BusMessageVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeHead;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeItem;
import com.els.modules.tender.notice.entity.PurchaseTenderSupplierInvitation;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.utils.TenderProjectMemberUtils;
import com.els.modules.tender.sale.entity.SaleTenderProjectMarginHead;
import com.els.modules.tender.sale.entity.SaleTenderProjectMarginItem;
import com.els.modules.tender.sale.entity.SaleTenderProjectRefund;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginHeadStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginItemMarginCollectionTypeEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginItemStatusEnum;
import com.els.modules.tender.sale.mapper.SaleTenderProjectMarginHeadMapper;
import com.els.modules.tender.sale.service.SaleTenderProjectMarginHeadService;
import com.els.modules.tender.sale.service.SaleTenderProjectMarginItemService;
import com.els.modules.tender.sale.service.SaleTenderProjectRefundService;
import com.els.modules.tender.sale.vo.SaleTenderProjectMarginItemVO;
import com.els.modules.tender.supplier.entity.PurchaseTenderProjectMarginHead;
import com.els.modules.tender.supplier.entity.PurchaseTenderProjectMarginItem;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.PurchaseTenderProjectMarginHeadService;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.modules.tender.supplier.vo.PurchaseTenderProjectMarginItemVO;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleTenderProjectMarginHeadServiceImpl
extends BaseServiceImpl<SaleTenderProjectMarginHeadMapper, SaleTenderProjectMarginHead>
implements SaleTenderProjectMarginHeadService {
    @Autowired
    private SaleTenderProjectMarginItemService tenderProjectMarginItemService;
    @Autowired
    private SaleTenderProjectRefundService tenderProjectRefundService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectMarginHeadService purchaseMarginHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    @Lazy
    private TenderProjectSupplierService supplierService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public SaleTenderProjectMarginHead add(TenderProjectSupplier tenderProjectSupplier) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.subpackageInfoService.selectById(tenderProjectSupplier.getSubpackageId());
        if (subpackageInfo.getStatus() < TenderProjectSubpackageStatusEnum.PRE_BID_EVA_END.getValue()) {
            return null;
        }
        List<SaleTenderProjectMarginHead> tenderProjectMarginHeadList = ((SaleTenderProjectMarginHeadMapper)this.baseMapper).selectBySubpackageId(tenderProjectSupplier.getSubpackageId(), tenderProjectSupplier.getSupplierAccount());
        if (CollectionUtil.isNotEmpty(tenderProjectMarginHeadList)) {
            return tenderProjectMarginHeadList.get(0);
        }
        SaleTenderProjectMarginHead tenderProjectMarginHead = new SaleTenderProjectMarginHead();
        this.build(tenderProjectMarginHead, subpackageInfo, tenderProjectSupplier);
        ((SaleTenderProjectMarginHeadMapper)this.baseMapper).insert((Object)tenderProjectMarginHead);
        PurchaseTenderProjectMarginHead purchaseTenderProjectMarginHead = new PurchaseTenderProjectMarginHead();
        BeanUtil.copyProperties((Object)((Object)tenderProjectMarginHead), (Object)((Object)purchaseTenderProjectMarginHead), (String[])new String[0]);
        purchaseTenderProjectMarginHead.setId(tenderProjectMarginHead.getRelationId());
        purchaseTenderProjectMarginHead.setRelationId(tenderProjectMarginHead.getId());
        purchaseTenderProjectMarginHead.setElsAccount(tenderProjectSupplier.getPurchaseEnterpriseAccount());
        this.purchaseMarginHeadService.add(purchaseTenderProjectMarginHead);
        return tenderProjectMarginHead;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateDueAmount(List<PurchaseTenderNoticeItem> noticeItemList) {
        if (CollectionUtil.isEmpty(noticeItemList)) {
            return;
        }
        Map noticeItemMap = noticeItemList.stream().collect(Collectors.toMap(PurchaseTenderNoticeItem::getSubpackageId, Function.identity()));
        List<String> supackageIdList = noticeItemList.stream().map(PurchaseTenderNoticeItem::getSubpackageId).collect(Collectors.toList());
        List<SaleTenderProjectMarginHead> saleMarginHeadList = ((SaleTenderProjectMarginHeadMapper)this.baseMapper).selectBySubpackageIds(supackageIdList);
        for (SaleTenderProjectMarginHead saleTenderProjectMarginHead : saleMarginHeadList) {
            PurchaseTenderNoticeItem noticeItem = (PurchaseTenderNoticeItem)((Object)noticeItemMap.get(saleTenderProjectMarginHead.getSubpackageId()));
            if (noticeItem == null) continue;
            saleTenderProjectMarginHead.setDueAmount(noticeItem.getMargin());
        }
        this.updateBatchById(saleMarginHeadList);
        List<PurchaseTenderProjectMarginHead> projectMarginHeadList = this.purchaseMarginHeadService.selectBySubpackageIds(supackageIdList);
        for (PurchaseTenderProjectMarginHead projectMarginHead : projectMarginHeadList) {
            PurchaseTenderNoticeItem noticeItem = (PurchaseTenderNoticeItem)((Object)noticeItemMap.get(projectMarginHead.getSubpackageId()));
            if (noticeItem == null) continue;
            projectMarginHead.setDueAmount(noticeItem.getMargin());
        }
        this.purchaseMarginHeadService.updateBatchById(projectMarginHeadList);
    }

    @Override
    public void addBatch(List<TenderProjectSupplier> tenderProjectSuppliers) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        List<String> subpackageIds = tenderProjectSuppliers.stream().map(TenderProjectSupplier::getSubpackageId).distinct().collect(Collectors.toList());
        query.in(PurchaseTenderProjectMarginHead::getSubpackageId, subpackageIds);
        List list = this.purchaseMarginHeadService.list((Wrapper)query);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            List supplierAccounts = list.stream().map(margin -> margin.getSubpackageId() + margin.getSupplierAccount()).distinct().collect(Collectors.toList());
            tenderProjectSuppliers = tenderProjectSuppliers.stream().filter(supplierAccount -> !supplierAccounts.contains(supplierAccount.getSubpackageId() + supplierAccount.getSupplierAccount())).collect(Collectors.toList());
        }
        List<PurchaseTenderProjectSubpackageInfo> purchaseTenderProjectSubpackageInfos = this.subpackageInfoService.selectBatchIds(subpackageIds);
        Map subpackageInfoMap = purchaseTenderProjectSubpackageInfos.stream().collect(Collectors.toMap(ParentEntity::getId, Function.identity()));
        ArrayList<SaleTenderProjectMarginHead> saleTenderProjectMarginHeads = new ArrayList<SaleTenderProjectMarginHead>();
        for (TenderProjectSupplier tenderProjectSupplier : tenderProjectSuppliers) {
            PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)subpackageInfoMap.get(tenderProjectSupplier.getSubpackageId()));
            SaleTenderProjectMarginHead tenderProjectMarginHead = new SaleTenderProjectMarginHead();
            this.build(tenderProjectMarginHead, subpackageInfo, tenderProjectSupplier);
            saleTenderProjectMarginHeads.add(tenderProjectMarginHead);
        }
        this.saveBatch(saleTenderProjectMarginHeads);
        for (SaleTenderProjectMarginHead tenderProjectMarginHead : saleTenderProjectMarginHeads) {
            String id = tenderProjectMarginHead.getId();
            tenderProjectMarginHead.setId(tenderProjectMarginHead.getRelationId());
            tenderProjectMarginHead.setRelationId(id);
            tenderProjectMarginHead.setElsAccount(TenantContext.getTenant());
        }
        ArrayList purchaseTenderProjectMarginHeads = SysUtil.copyProperties(saleTenderProjectMarginHeads, PurchaseTenderProjectMarginHead.class);
        this.purchaseMarginHeadService.addBatch(purchaseTenderProjectMarginHeads);
    }

    @Override
    public void addBatchByNotice(PurchaseTenderNoticeHead purchaseTenderNoticeHead, List<PurchaseTenderNoticeItem> purchaseTenderNoticeItemList, List<PurchaseTenderSupplierInvitation> purchaseTenderSupplierInvitationList) {
        ArrayList<TenderProjectSupplier> tenderProjectSupplierList = new ArrayList<TenderProjectSupplier>();
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        for (PurchaseTenderNoticeItem purchaseTenderNoticeItem : purchaseTenderNoticeItemList) {
            for (PurchaseTenderSupplierInvitation invitation : purchaseTenderSupplierInvitationList) {
                TenderProjectSupplier tenderProjectSupplier = new TenderProjectSupplier();
                tenderProjectSupplier.setElsAccount(invitation.getSupplierAccount());
                tenderProjectSupplier.setPurchaseEnterpriseAccount(loginUser.getElsAccount());
                tenderProjectSupplier.setPurchaseEnterpriseName(loginUser.getCompanyName());
                tenderProjectSupplier.setSupplierSubAccount("1001");
                tenderProjectSupplier.setSupplierAccount(invitation.getSupplierAccount());
                tenderProjectSupplier.setSupplierName(invitation.getSupplierName());
                tenderProjectSupplier.setElsAccount(invitation.getSupplierAccount());
                tenderProjectSupplier.setSubpackageId(purchaseTenderNoticeItem.getSubpackageId());
                tenderProjectSupplier.setSubpackageName(purchaseTenderNoticeItem.getSubpackageName());
                tenderProjectSupplier.setTenderProjectId(purchaseTenderNoticeItem.getTenderProjectId());
                tenderProjectSupplierList.add(tenderProjectSupplier);
            }
        }
        this.addBatch(tenderProjectSupplierList);
    }

    private void build(SaleTenderProjectMarginHead tenderProjectMarginHead, PurchaseTenderProjectSubpackageInfo subpackageInfo, TenderProjectSupplier tenderProjectSupplier) {
        tenderProjectMarginHead.setTenderProjectId(tenderProjectSupplier.getTenderProjectId());
        tenderProjectMarginHead.setSubpackageId(tenderProjectSupplier.getSubpackageId());
        tenderProjectMarginHead.setSupplierAccount(tenderProjectSupplier.getSupplierAccount());
        tenderProjectMarginHead.setSupplierName(tenderProjectSupplier.getSupplierName());
        tenderProjectMarginHead.setMarginNumber(this.invokeBaseRpcService.getNextCode("tenderProjectMarginNumber", (Object)tenderProjectMarginHead));
        BigDecimal dueAmount = subpackageInfo.getMargin() == null ? BigDecimal.ZERO : subpackageInfo.getMargin();
        tenderProjectMarginHead.setDueAmount(dueAmount);
        tenderProjectMarginHead.setPaidTotalAmount(BigDecimal.ZERO);
        tenderProjectMarginHead.setPaidAmount(BigDecimal.ZERO);
        tenderProjectMarginHead.setGuaranteePaidAmount(BigDecimal.ZERO);
        tenderProjectMarginHead.setStatus(TenderProjectMarginHeadStatusEnum.UNPAID.getValue());
        tenderProjectMarginHead.setDeleted(CommonConstant.DEL_FLAG_0);
        tenderProjectMarginHead.setElsAccount(tenderProjectSupplier.getSupplierAccount());
        tenderProjectMarginHead.setId(IdWorker.getIdStr());
        tenderProjectMarginHead.setRelationId(IdWorker.getIdStr());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public SaleTenderProjectMarginItem addMargin(SaleTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectMarginItemVO.getSupplierAccount()), (String)I18nUtil.translate((String)"i18n_field_eBtLxOLVW_df534627", (String)"\u6295\u6807\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!"));
        List<SaleTenderProjectMarginHead> tenderProjectMarginHeadList = ((SaleTenderProjectMarginHeadMapper)this.baseMapper).selectBySubpackageId(tenderProjectMarginItemVO.getSubpackageId(), tenderProjectMarginItemVO.getSupplierAccount());
        SaleTenderProjectMarginHead saleTenderProjectMarginHead = null;
        if (CollectionUtil.isEmpty(tenderProjectMarginHeadList)) {
            TenderProjectSupplier supplier = new TenderProjectSupplier();
            supplier.setSubpackageId(tenderProjectMarginItemVO.getSubpackageId());
            supplier.setSupplierAccount(TenantContext.getTenant());
            supplier.setInvalid("0");
            List<TenderProjectSupplier> supplierList = this.supplierService.selectBySubpackageId(supplier);
            Assert.isTrue((boolean)CollectionUtil.isNotEmpty(supplierList), (String)I18nUtil.translate((String)"i18n_field_LsRxqSusiHtH_a9f5ac19", (String)"\u672a\u62a5\u540d\u4e0d\u53ef\u6dfb\u52a0\u4fdd\u8bc1\u91d1\u8bb0\u5f55"));
            saleTenderProjectMarginHead = this.add(supplierList.get(0));
            Assert.notNull((Object)((Object)saleTenderProjectMarginHead), (String)I18nUtil.translate((String)"i18n_alert_JmUUyOxqSusiHtH_4168a0f7", (String)"\u8d44\u683c\u9884\u5ba1\u9636\u6bb5\u4e0d\u53ef\u6dfb\u52a0\u4fdd\u8bc1\u91d1\u8bb0\u5f55"));
        } else {
            saleTenderProjectMarginHead = tenderProjectMarginHeadList.get(0);
        }
        tenderProjectMarginItemVO.setHeadId(saleTenderProjectMarginHead.getId());
        tenderProjectMarginItemVO.setId(IdWorker.getIdStr());
        tenderProjectMarginItemVO.setElsAccount(saleTenderProjectMarginHead.getElsAccount());
        SaleTenderProjectMarginItemVO tenderProjectMarginItem = new SaleTenderProjectMarginItemVO();
        BeanUtils.copyProperties((Object)((Object)tenderProjectMarginItemVO), (Object)((Object)tenderProjectMarginItem));
        this.tenderProjectMarginItemService.save((Object)tenderProjectMarginItem);
        this.saveAttachment(tenderProjectMarginItem.getId(), tenderProjectMarginItemVO.getAttachmentDTOList());
        return tenderProjectMarginItem;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public SaleTenderProjectMarginItem editMargin(SaleTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectMarginItemVO.getSupplierAccount()), (String)I18nUtil.translate((String)"i18n_field_eBtLxOLVW_df534627", (String)"\u6295\u6807\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!"));
        SaleTenderProjectMarginItem tenderProjectMarginItem = (SaleTenderProjectMarginItem)((Object)this.tenderProjectMarginItemService.getById((Serializable)((Object)tenderProjectMarginItemVO.getId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)tenderProjectMarginItem)), (String)I18nUtil.translate((String)"i18n_field_WFxMKW_b697ca02", (String)"\u6570\u636e\u4e0d\u5b58\u5728"));
        BeanUtils.copyProperties((Object)((Object)tenderProjectMarginItemVO), (Object)((Object)tenderProjectMarginItem), (String[])new String[]{"headId", "status", "supplierAccount", "supplierName", "elsAccount"});
        this.tenderProjectMarginItemService.updateById((Object)tenderProjectMarginItem);
        this.saveAttachment(tenderProjectMarginItemVO.getId(), tenderProjectMarginItemVO.getAttachmentDTOList());
        return tenderProjectMarginItem;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public SaleTenderProjectMarginItem submitMargin(SaleTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        SaleTenderProjectMarginItem tenderProjectMarginItem = (SaleTenderProjectMarginItem)((Object)this.tenderProjectMarginItemService.getById((Serializable)((Object)tenderProjectMarginItemVO.getId())));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectMarginItem.getTenderProjectId()), (String)I18nUtil.translate((String)"i18n_field_dIxOLVW_2db2c59c", (String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((TenderProjectMarginItemStatusEnum.UNCONFIRMED.getValue().equals(tenderProjectMarginItem.getStatus()) || TenderProjectMarginItemStatusEnum.REFUSED.getValue().equals(tenderProjectMarginItem.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_APzExqDJW_3f04fb46", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u63d0\u4ea4!"));
        this.checkMarginItemParam(tenderProjectMarginItem);
        tenderProjectMarginItem.setStatus(TenderProjectMarginItemStatusEnum.SUBMIT.getValue());
        this.saveAttachment(tenderProjectMarginItemVO.getId(), tenderProjectMarginItemVO.getAttachmentDTOList());
        PurchaseTenderProjectMarginItemVO purchaseTenderProjectMarginItemVO = (PurchaseTenderProjectMarginItemVO)((Object)SysUtil.copyProperties((Object)((Object)tenderProjectMarginItem), PurchaseTenderProjectMarginItemVO.class));
        ArrayList attachmentDTOList = SysUtil.copyProperties(tenderProjectMarginItemVO.getAttachmentDTOList(), PurchaseAttachmentDTO.class);
        purchaseTenderProjectMarginItemVO.setAttachmentDTOList(attachmentDTOList);
        purchaseTenderProjectMarginItemVO.setRelationId(tenderProjectMarginItemVO.getId());
        PurchaseTenderProjectMarginItem purchaseTenderProjectMarginItem = this.purchaseMarginHeadService.addMargin(purchaseTenderProjectMarginItemVO);
        tenderProjectMarginItem.setRelationId(purchaseTenderProjectMarginItem.getId());
        boolean marginItemCount = this.tenderProjectMarginItemService.updateById((Object)tenderProjectMarginItem);
        Assert.isTrue((boolean)marginItemCount, (String)I18nUtil.translate((String)"i18n_field_DJKmWAPcWFIKXWVVVXVSDJHrW_5e42679e", (String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5f53\u524d\u884c\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(tenderProjectMarginItem.getTenderProjectId()).append("&subpackageId=").append(tenderProjectMarginItem.getSubpackageId()).append("&businessId=").append(tenderProjectMarginItem.getHeadId());
        List<ElsSubAccountDTO> tenderProjectMemberList = TenderProjectMemberUtils.getTenderProjectMember(tenderProjectMarginItem.getTenderProjectId());
        List collect = tenderProjectMemberList.stream().map(BaseDTO::getId).distinct().collect(Collectors.toList());
        BusMessageVO messageVO = BusMessageVO.builder().businessId(tenderProjectMarginItem.getTenderProjectId()).msgConfigCode("tender_tenderDepositPayment").businessBean("tenderBusDataServiceImpl").receiveSubAccountIdList(collect).build();
        super.sendMessage(messageVO);
        return tenderProjectMarginItem;
    }

    @Override
    public void confirmMargin(List<PurchaseTenderProjectMarginHead> purchaseTenderProjectMarginHeads, List<PurchaseTenderProjectMarginItem> purchaseTenderProjectMarginItems) {
        List<String> itemIds = purchaseTenderProjectMarginItems.stream().map(PurchaseTenderProjectMarginItem::getRelationId).collect(Collectors.toList());
        Map<String, PurchaseTenderProjectMarginHead> purchaseMarginHeadMap = purchaseTenderProjectMarginHeads.stream().collect(Collectors.toMap(PurchaseTenderProjectMarginHead::getRelationId, purchaseMarginHead -> purchaseMarginHead, (o1, o2) -> o1));
        LambdaQueryWrapper marginItemQw = new LambdaQueryWrapper();
        marginItemQw.in(ParentEntity::getId, itemIds);
        List<SaleTenderProjectMarginItem> tenderProjectMarginItems = this.tenderProjectMarginItemService.selectByIds(itemIds);
        Assert.isTrue((tenderProjectMarginItems.size() == itemIds.size() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_WFIHWVXVsKW_1040d961", (String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01"));
        for (SaleTenderProjectMarginItem tenderProjectMarginItem : tenderProjectMarginItems) {
            tenderProjectMarginItem.setStatus(TenderProjectMarginItemStatusEnum.CONFIRMED.getValue());
        }
        Set headIds = tenderProjectMarginItems.stream().map(SaleTenderProjectMarginItem::getHeadId).collect(Collectors.toSet());
        List tenderProjectMarginHeads = ((SaleTenderProjectMarginHeadMapper)this.baseMapper).selectBatchIds(headIds);
        Assert.isTrue((headIds.size() == tenderProjectMarginHeads.size() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_MKSXWFWVXVsK_54dec862", (String)"\u5b58\u5728\u65e0\u6548\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5"));
        boolean marginItemCount = this.tenderProjectMarginItemService.updateBatchById(tenderProjectMarginItems);
        Assert.isTrue((boolean)marginItemCount, (String)I18nUtil.translate((String)"i18n_field_RLKmWAPcWFIKXWVVVXVSDJHrW_1921253c", (String)"\u786e\u8ba4\u5931\u8d25\uff0c\u5f53\u524d\u884c\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        for (SaleTenderProjectMarginHead tenderProjectMarginHead : tenderProjectMarginHeads) {
            PurchaseTenderProjectMarginHead purchaseTenderProjectMarginHead = purchaseMarginHeadMap.get(tenderProjectMarginHead.getId());
            tenderProjectMarginHead.setPaidTotalAmount(purchaseTenderProjectMarginHead.getPaidTotalAmount());
            tenderProjectMarginHead.setPaidAmount(purchaseTenderProjectMarginHead.getPaidAmount());
            tenderProjectMarginHead.setGuaranteePaidAmount(purchaseTenderProjectMarginHead.getGuaranteePaidAmount());
            tenderProjectMarginHead.setStatus(purchaseTenderProjectMarginHead.getStatus());
        }
        boolean marginHeadCount = this.updateBatchById(tenderProjectMarginHeads);
        Assert.isTrue((boolean)marginHeadCount, (String)I18nUtil.translate((String)"i18n_field_RLKmWAPcWFIKXWVVVXVSDJHrW_1921253c", (String)"\u786e\u8ba4\u5931\u8d25\uff0c\u5f53\u524d\u884c\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void refund(List<PurchaseTenderProjectMarginHead> purchaseTenderProjectMarginHeads, List<SaleTenderProjectRefund> saleTenderProjectRefunds) {
        Set headIds = purchaseTenderProjectMarginHeads.stream().map(PurchaseTenderProjectMarginHead::getRelationId).collect(Collectors.toSet());
        List marginHeads = ((SaleTenderProjectMarginHeadMapper)this.baseMapper).selectBatchIds(headIds);
        List updMarginHeads = ((SaleTenderProjectMarginHeadMapper)this.baseMapper).selectBatchIds(headIds);
        Map<String, SaleTenderProjectMarginHead> saleSupplierMap = marginHeads.stream().collect(Collectors.toMap(SaleTenderProjectMarginHead::getSupplierAccount, marginHead -> marginHead, (o1, o2) -> o1));
        Map<String, PurchaseTenderProjectMarginHead> purchaseSupplierMap = purchaseTenderProjectMarginHeads.stream().collect(Collectors.toMap(PurchaseTenderProjectMarginHead::getSupplierAccount, marginHead -> marginHead, (o1, o2) -> o1));
        for (SaleTenderProjectRefund saleTenderProjectRefund : saleTenderProjectRefunds) {
            SaleTenderProjectMarginHead saleTenderProjectMarginHead = saleSupplierMap.get(saleTenderProjectRefund.getSupplierAccount());
            saleTenderProjectRefund.setHeadId(saleTenderProjectMarginHead.getId());
            saleTenderProjectRefund.setId(IdWorker.getIdStr());
            saleTenderProjectRefund.setElsAccount(saleTenderProjectMarginHead.getElsAccount());
            PurchaseTenderProjectMarginHead purchaseTenderProjectMarginHead = purchaseSupplierMap.get(saleTenderProjectRefund.getSupplierAccount());
            saleTenderProjectMarginHead.setPaidTotalAmount(purchaseTenderProjectMarginHead.getPaidTotalAmount());
            saleTenderProjectMarginHead.setPaidAmount(purchaseTenderProjectMarginHead.getPaidAmount());
            saleTenderProjectMarginHead.setStatus(purchaseTenderProjectMarginHead.getStatus());
            updMarginHeads.add(saleTenderProjectMarginHead);
        }
        boolean marginHeadCount = this.updateBatchById(updMarginHeads);
        Assert.isTrue((boolean)marginHeadCount, (String)I18nUtil.translate((String)"i18n_field_YVKmWVVVXVSDJHrW_84245fd3", (String)"\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.tenderProjectRefundService.saveBatch(saleTenderProjectRefunds);
    }

    @Override
    public void reject(String id) {
        SaleTenderProjectMarginItem tenderProjectMarginItem = (SaleTenderProjectMarginItem)((Object)this.tenderProjectMarginItemService.getById((Serializable)((Object)id)));
        Assert.isTrue((boolean)TenderProjectMarginItemStatusEnum.SUBMIT.getValue().equals(tenderProjectMarginItem.getStatus()), (String)I18nUtil.translate((String)"i18n_field_APWFzExiTYM_2195ec3f", (String)"\u5f53\u524d\u6570\u636e\u72b6\u6001\u4e0d\u5141\u8bb8\u9000\u56de"));
        tenderProjectMarginItem.setStatus(TenderProjectMarginItemStatusEnum.REFUSED.getValue());
        boolean marginItemCount = this.tenderProjectMarginItemService.updateById((Object)tenderProjectMarginItem);
        Assert.isTrue((boolean)marginItemCount, (String)I18nUtil.translate((String)"i18n_field_FKKmWAPcWFIKXWVVVXVSDJHrW_9d78a047", (String)"\u62d2\u7edd\u5931\u8d25\uff0c\u5f53\u524d\u884c\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    private void checkMarginItemParam(SaleTenderProjectMarginItem tenderProjectMarginItem) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectMarginItem.getTenderProjectId()), (String)I18nUtil.translate((String)"i18n_field_dIxOLVW_2db2c59c", (String)"\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectMarginItem.getSubpackageId()), (String)I18nUtil.translate((String)"i18n_alert_zsxOLVW_2edb7bb2", (String)"\u5206\u5305\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectMarginItem.getSupplierAccount()), (String)I18nUtil.translate((String)"i18n_field_eBtLxOLVW_df534627", (String)"\u6295\u6807\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectMarginItem.getSupplierName()), (String)I18nUtil.translate((String)"i18n_field_eBtLRLxOLVW_b6922b04", (String)"\u6295\u6807\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectMarginItem.getMarginCollectionType()), (String)I18nUtil.translate((String)"i18n_field_siHlMCKxOLVW_d85cd1ce", (String)"\u4fdd\u8bc1\u91d1\u6536\u53d6\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)tenderProjectMarginItem.getAmount()), (String)I18nUtil.translate((String)"i18n_field_siHHfxOLVW_62315538", (String)"\u4fdd\u8bc1\u91d1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!"));
        if (TenderProjectMarginItemMarginCollectionTypeEnum.LETTER_GUARANTEE.getValue().equals(tenderProjectMarginItem.getMarginCollectionType())) {
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectMarginItem.getGuarantor()), (String)I18nUtil.translate((String)"i18n_field_tsLxOLVW_b99c6f4f", (String)"\u62c5\u4fdd\u4eba\u4e0d\u80fd\u4e3a\u7a7a!"));
        } else if (TenderProjectMarginItemMarginCollectionTypeEnum.OTHER.getValue().equals(tenderProjectMarginItem.getMarginCollectionType())) {
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectMarginItem.getPayAccount()), (String)I18nUtil.translate((String)"i18n_field_MVeyxOLVW_bc58ed69", (String)"\u6c47\u6b3e\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectMarginItem.getPayName()), (String)I18nUtil.translate((String)"i18n_field_MVeDRxOLVW_2553840c", (String)"\u6c47\u6b3e\u8d26\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectMarginItem.getBankName()), (String)I18nUtil.translate((String)"i18n_field_vDcxOLVW_2c48a33c", (String)"\u5f00\u6237\u884c\u4e0d\u80fd\u4e3a\u7a7a!"));
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)tenderProjectMarginItem.getPayType()), (String)I18nUtil.translate((String)"i18n_field_JpCKCKxOLVW_40b60f06", (String)"\u7f34\u7eb3\u65b9\u5f0f\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        } else {
            Assert.isTrue((boolean)false, (String)I18nUtil.translate((String)"i18n_field_PxRuWTxJeyeRWCKRBW_2dc93e83", (String)"\u6682\u4e0d\u652f\u6301\u3010\u865a\u62df\u5b50\u8d26\u53f7\u6258\u7ba1\u3011\u65b9\u5f0f\u652f\u4ed8!"));
        }
    }

    private void saveAttachment(String mainId, List<SaleAttachmentDTO> attachmentDTOList) {
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(mainId);
        if (CollectionUtil.isNotEmpty(attachmentDTOList)) {
            attachmentDTOList.parallelStream().forEach(attachment -> {
                attachment.setId(IdWorker.getIdStr());
                attachment.setHeadId(mainId);
            });
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentDTOList);
        }
    }
}

