/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.bidding.entity.PurchaseBiddingEvaResult;
import com.els.modules.bidding.service.PurchaseBiddingEvaResultService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.vo.BiddingEvaResultVO;
import com.els.modules.bidding.vo.BiddingRegulationVO;
import com.els.modules.bidding.vo.PurchaseBiddingEvaResultVO;
import com.els.modules.bidding.vo.PurchaseBiddingHeadVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u8bc4\u6807\u7ed3\u679c")
@RestController
@RequestMapping(value={"/bidding/purchaseBiddingEvaResult"})
public class PurchaseBiddingEvaResultController
extends BaseController<PurchaseBiddingEvaResult, PurchaseBiddingEvaResultService> {
    @Autowired
    private PurchaseBiddingEvaResultService purchaseBiddingEvaResultService;

    @Operation(summary="\u901a\u8fc7\u62db\u6807\u5355id\u67e5\u8be2\u8bc4\u6807\u660e\u7ec6", description="\u901a\u8fc7\u62db\u6807\u5355id\u67e5\u8be2\u8bc4\u6807\u660e\u7ec6")
    @GetMapping(value={"/queryByBiddingId"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> queryByBiddingId(@RequestParam(name="id") String id) {
        List<BiddingRegulationVO> resultList = this.purchaseBiddingEvaResultService.findEvaResult(id);
        PurchaseBiddingEvaResultVO evaResultVO = new PurchaseBiddingEvaResultVO();
        evaResultVO.setId(id);
        evaResultVO.setBiddingRegulationList(resultList);
        return Result.ok((Object)((Object)evaResultVO));
    }

    @AutoLog(value="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406-\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c")
    @Operation(summary="\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c", description="\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c")
    @PostMapping(value={"/saveEvaResult"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:add"})
    public Result<?> saveEvaResult(@RequestBody PurchaseBiddingEvaResultVO result) {
        this.purchaseBiddingEvaResultService.saveEvaResult(result.getId(), result.getBiddingRegulationList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406-\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c")
    @Operation(summary="\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c", description="\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c")
    @PostMapping(value={"/submitEvaResult"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:add"})
    public Result<?> submitEvaResult(@RequestBody PurchaseBiddingHeadVO result) {
        this.purchaseBiddingEvaResultService.submitEvaResult(result.getId(), result.getBiddingSupplierVOList());
        return this.commonSuccessResult(3);
    }

    @Operation(summary="\u901a\u8fc7\u62db\u6807\u5355id\u67e5\u8be2\u8bc4\u6807\u7ed3\u679c\u4e00\u89c8\u8868", description="\u901a\u8fc7\u62db\u6807\u5355id\u67e5\u8be2\u8bc4\u6807\u7ed3\u679c\u4e00\u89c8\u8868")
    @GetMapping(value={"/queryEvaResultByBiddingId"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public Result<?> queryEvaResultByBiddingId(@RequestParam(name="id") String id) {
        List<BiddingEvaResultVO> resultList = this.purchaseBiddingEvaResultService.findEvaBidList(id);
        return Result.ok(resultList);
    }

    @Operation(summary="\u5bfc\u51fa\u8bc4\u6807\u7ed3\u679c\u4e00\u89c8\u8868", description="\u5bfc\u51fa\u8bc4\u6807\u7ed3\u679c\u4e00\u89c8\u8868")
    @GetMapping(value={"/exportProjectEvaResult"})
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:queryById"})
    public void exportProjectEvaResult(@RequestParam(name="id") String id, @RequestParam(name="type") String type, HttpServletResponse response) {
        this.purchaseBiddingEvaResultService.exportProjectEvaResult(id, type, response);
    }

    @AutoLog(value="\u91c7\u8d2d\u62db\u6807\u7ba1\u7406-\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c")
    @Operation(summary="\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c", description="\u4fdd\u5b58\u8bc4\u6807\u7ed3\u679c")
    @PostMapping(value={"/saveBidEvaOfOffLine"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#purchaseBiddingHead:add"})
    @PermissionDataOpt(businessType="bidding", beanClass=PurchaseBiddingHeadService.class)
    public Result<?> saveBidEvaOfOffLine(@RequestBody PurchaseBiddingHeadVO result) {
        this.purchaseBiddingEvaResultService.saveBidEvaOfOffLine(result);
        return this.commonSuccessResult(3);
    }
}

