/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.bidding.entity.SaleClarificationInfo;
import com.els.modules.bidding.service.SaleClarificationInfoService;
import com.els.modules.bidding.vo.SaleClarificationInfoVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u9500\u552e\u65b9\u6f84\u6e05\u4fe1\u606f")
@RestController
@RequestMapping(value={"/bidding/saleClarificationInfo"})
public class SaleClarificationInfoController
extends BaseController<SaleClarificationInfo, SaleClarificationInfoService> {
    @Autowired
    private SaleClarificationInfoService saleClarificationInfoService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"bidding#saleClarificationInfo:list"})
    public Result<?> queryPageList(SaleClarificationInfo saleClarificationInfo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleClarificationInfo), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleClarificationInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u9500\u552e\u65b9\u6f84\u6e05\u4fe1\u606f-\u6dfb\u52a0", operateType=2)
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#saleClarificationInfo:add"})
    public Result<?> add(@RequestBody SaleClarificationInfo saleClarificationInfo) {
        this.saleClarificationInfoService.saveSaleClarificationInfo(saleClarificationInfo);
        return Result.ok((Object)((Object)saleClarificationInfo));
    }

    @AutoLog(value="\u9500\u552e\u65b9\u6f84\u6e05\u4fe1\u606f-\u7f16\u8f91", operateType=3)
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#saleClarificationInfo:edit"})
    public Result<?> edit(@RequestBody SaleClarificationInfo saleClarificationInfo) {
        this.saleClarificationInfoService.updateSaleClarificationInfo(saleClarificationInfo);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u65b9\u6f84\u6e05\u4fe1\u606f-\u901a\u8fc7id\u5220\u9664", operateType=4)
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"bidding#saleClarificationInfo:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.saleClarificationInfoService.delSaleClarificationInfo(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9500\u552e\u65b9\u6f84\u6e05\u4fe1\u606f-\u6279\u91cf\u5220\u9664", operateType=4)
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"bidding#saleClarificationInfo:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.saleClarificationInfoService.delBatchSaleClarificationInfo(idList);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"bidding#saleClarificationInfo:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleClarificationInfo saleClarificationInfo = (SaleClarificationInfo)((Object)this.saleClarificationInfoService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SaleClarificationInfoVO infoVO = new SaleClarificationInfoVO();
        BeanUtils.copyProperties((Object)((Object)saleClarificationInfo), (Object)((Object)infoVO));
        List attachments = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        infoVO.setAttachments(attachments);
        return Result.ok((Object)((Object)infoVO));
    }

    @Operation(summary="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(SaleClarificationInfo saleClarificationInfo, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{"view_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"view_status");
        List list = ((SaleClarificationInfoService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SaleClarificationInfo::getViewStatus, SaleClarificationInfo::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "viewStatus", null, (long)all.intValue()));
        List srmRequestStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmHandleFlag", TenantContext.getTenant());
        for (DictDTO status : srmRequestStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "viewStatus", status.getValue(), (long)total.intValue()));
        }
        return Result.ok(result);
    }
}

