/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.ParentEntityDTO;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.BusMessageVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDemandDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDemandDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingProjectSubpackage;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.entity.PurchaseBiddingTalkPriceContinue;
import com.els.modules.bidding.entity.SaleBiddingHead;
import com.els.modules.bidding.entity.SaleBiddingItem;
import com.els.modules.bidding.enumerate.BiddingItemStatusEnum;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.enumerate.BiddingTypeEnum;
import com.els.modules.bidding.enumerate.BusinessBillTypeEnum;
import com.els.modules.bidding.enumerate.MemberRoleEnum;
import com.els.modules.bidding.enumerate.MemberTypeEnum;
import com.els.modules.bidding.enumerate.ReplyStatusEnum;
import com.els.modules.bidding.enumerate.SupplierSourceTypeEnum;
import com.els.modules.bidding.job.BiddingJobUtil;
import com.els.modules.bidding.mapper.BiddingSupplierMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingHeadMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingItemMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingSpecialistMapper;
import com.els.modules.bidding.mapper.SaleBiddingHeadMapper;
import com.els.modules.bidding.mapper.SaleBiddingItemMapper;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.bidding.service.PurchaseBiddingTalkPriceContinueService;
import com.els.modules.bidding.service.PurchaseClarificationInfoService;
import com.els.modules.bidding.service.PurchaseConfirmBiddingHisService;
import com.els.modules.bidding.service.SaleBiddingHeadService;
import com.els.modules.bidding.service.SaleBiddingItemService;
import com.els.modules.bidding.service.impl.PurchaseClarificationInfoServiceImpl;
import com.els.modules.bidding.vo.PurchaseBiddingHeadVO;
import com.els.modules.bidding.vo.SaleBiddingAttachmentVO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.contract.dto.PurchaseContractItemDTO;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.inquiry.enumerate.QualificationReviewEnum;
import com.els.modules.inquiry.qualification.entity.PurchaseQualificationReview;
import com.els.modules.inquiry.qualification.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.qualification.service.PurchaseExecuteReviewService;
import com.els.modules.inquiry.qualification.service.PurchaseQualificationReviewService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMessageRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.api.dto.PurchaseMaterialRelationDTO;
import com.els.modules.message.api.dto.PurchaseNoticeSupplierDTO;
import com.els.modules.notice.api.dto.PurchaseNoticeDTO;
import com.els.modules.notice.api.enumerate.NoticeScopeEnum;
import com.els.modules.rpc.service.InquiryInvokeContractService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.dto.SupplierOrgInfoDTO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Lazy
@Service
public class PurchaseBiddingHeadServiceImpl
extends BaseServiceImpl<PurchaseBiddingHeadMapper, PurchaseBiddingHead>
implements PurchaseBiddingHeadService,
PurchaseExecuteReviewService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseBiddingHeadServiceImpl.class);
    @Resource
    private PurchaseBiddingHeadMapper purchaseBiddingHeadMapper;
    @Resource
    private PurchaseBiddingItemMapper purchaseBiddingItemMapper;
    @Resource
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Resource
    private BiddingSupplierMapper biddingSupplierMapper;
    @Resource
    private BiddingSupplierService biddingSupplierService;
    @Resource
    private PurchaseBiddingSpecialistMapper purchaseBiddingSpecialistMapper;
    @Resource
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;
    @Resource
    private SaleBiddingHeadMapper saleBiddingHeadMapper;
    @Resource
    private SaleBiddingHeadService saleBiddingHeadService;
    @Resource
    private SaleBiddingItemMapper saleBiddingItemMapper;
    @Resource
    private SaleBiddingItemService saleBiddingItemService;
    @Resource
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InquiryInvokeMessageRpcService inquiryInvokeMessageRpcService;
    @Resource
    private InquiryInvokeMainDataRpcService inquiryInvokeMainDataRpcService;
    @Resource
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;
    @Resource
    private InquiryInvokeContractService inquiryInvokeContractService;
    @Autowired
    private PurchaseConfirmBiddingHisService purchaseConfirmBiddingHisService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadService;
    @Autowired
    private PurchaseBiddingTalkPriceContinueService talkPriceContinueService;

    @Override
    public IPage<PurchaseBiddingProjectSubpackage> queryProjectSubpackagePageList(Page<PurchaseBiddingProjectSubpackage> page, PurchaseBiddingProjectSubpackage purchaseBiddingHead, QueryWrapper<PurchaseBiddingProjectSubpackage> queryWrapper) {
        return ((PurchaseBiddingHeadMapper)this.baseMapper).queryProjectSubpackagePageList(page, queryWrapper, purchaseBiddingHead);
    }

    @Override
    public void abandoned(String id) {
        PurchaseBiddingHead biddingHead = (PurchaseBiddingHead)((Object)this.getById((Serializable)((Object)id)));
        if (BiddingStatusEnum.NEW.getValue().equals(biddingHead.getBiddingStatus()) || BiddingStatusEnum.CONFIRM_ED.getValue().equals(biddingHead.getBiddingStatus()) || BiddingStatusEnum.BID_FAILURE.getValue().equals(biddingHead.getBiddingStatus()) || BiddingStatusEnum.CANCEL.getValue().equals(biddingHead.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APzExiTuB_3e6549e7", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u5e9f\u6807"));
        }
        List<PurchaseBiddingItem> itemList = this.purchaseBiddingItemMapper.selectByMainId(id);
        this.goBackDemandUseForDel(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(PurchaseBiddingHead::getBiddingStatus, (Object)BiddingStatusEnum.CANCEL.getValue())).eq(ParentEntity::getId, (Object)id));
        this.saleBiddingHeadService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SaleBiddingHead::getBiddingStatus, (Object)BiddingStatusEnum.CANCEL.getValue())).eq(SaleBiddingHead::getRelationId, (Object)id));
    }

    @Override
    public List<CountVO> queryTabsCount() {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"create_type", (Object)"project");
        queryWrapper.select((Object[])new String[]{"bidding_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"bidding_status");
        List list = this.list((Wrapper)queryWrapper);
        Map<String, Long> countMap = list.stream().collect(Collectors.toMap(PurchaseBiddingHead::getBiddingStatus, PurchaseBiddingHead::getParticipateQuantity));
        Long all = 0L;
        for (Map.Entry<String, Long> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "biddingStatus", null, all.longValue()));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmBiddingStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            if (countMap.get(status.getValue()) == null) continue;
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "biddingStatus", status.getValue(), countMap.get(status.getValue()).longValue()));
        }
        return result;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseBiddingHead purchaseBiddingHead, List<PurchaseBiddingItem> purchaseBiddingItemList, List<BiddingSupplier> biddingSupplierList, List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList, List<PurchaseAttachmentDemandDTO> purchaseAttachmentDemandList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        super.setHeadDefaultValue((ParentEntity)purchaseBiddingHead);
        purchaseBiddingHead.setBusAccount(TenantContext.getTenant());
        purchaseBiddingHead.setBiddingStatus(BiddingStatusEnum.NEW.getValue());
        purchaseBiddingHead.setResultAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        purchaseBiddingHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        if (StrUtil.isBlank((CharSequence)purchaseBiddingHead.getAccessCategoryFilter())) {
            purchaseBiddingHead.setAccessCategoryFilter("0");
        }
        this.purchaseBiddingHeadMapper.insert((Object)purchaseBiddingHead);
        this.insertData(purchaseBiddingHead, purchaseBiddingItemList, biddingSupplierList, purchaseBiddingSpecialistList, purchaseAttachmentDemandList, purchaseAttachmentList);
        if (StrUtil.isNotBlank((CharSequence)purchaseBiddingHead.getDocumentId())) {
            this.invokeBaseRpcService.updateIntegratedDocumentMain("biddingHeadId", purchaseBiddingHead.getDocumentId(), purchaseBiddingHead.getDocumentParentId(), purchaseBiddingHead.getId());
        }
        this.sendLink(purchaseBiddingHead, purchaseBiddingItemList);
        this.goBackDemand(purchaseBiddingItemList, PurchaseRequestStatusItemEnum.TENDERS_BUILT.getValue());
    }

    private void goBackDemand(List<PurchaseBiddingItem> purchaseBiddingItemList, String status) {
        List<String> idList1 = purchaseBiddingItemList.stream().filter(o -> com.els.modules.inquiry.enumerate.SourceTypeEnum.REQUEST.getValue().equals(o.getSourceType())).filter(o -> StrUtil.isNotBlank((CharSequence)o.getId())).map(PurchaseBiddingItem::getSourceItemId).collect(Collectors.toList());
        if (!idList1.isEmpty()) {
            ArrayList<String> idList = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty(idList1)) {
                idList1.forEach(str -> idList.addAll(Arrays.stream(str.split(",")).collect(Collectors.toList())));
            }
            if (PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue().equals(status)) {
                List<String> headIdList = purchaseBiddingItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getHeadId())).map(PurchaseBiddingItem::getHeadId).distinct().collect(Collectors.toList());
                List<PurchaseBiddingItem> list = this.purchaseBiddingItemService.findBySourceItemId(headIdList, idList);
                if (!CollectionUtils.isEmpty(list)) {
                    Map<String, List> collect = list.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId())).collect(Collectors.toMap(PurchaseBiddingItem::getSourceItemId, p -> {
                        ArrayList<PurchaseBiddingItem> enquiryItems = new ArrayList<PurchaseBiddingItem>();
                        enquiryItems.add((PurchaseBiddingItem)((Object)p));
                        return enquiryItems;
                    }, (value1, value2) -> {
                        value1.addAll(value2);
                        return value1;
                    }));
                    Set<String> strings = collect.keySet();
                    ArrayList<String> ListDauctionsBuilt = new ArrayList<String>();
                    ArrayList ListCompletionOfTheAuction = new ArrayList();
                    ArrayList<PurchaseRequestItem> batchUpdatePurchaseRequestItemList = new ArrayList<PurchaseRequestItem>();
                    for (String string : strings) {
                        List purchaseBiddingItems = collect.get(string);
                        if (purchaseBiddingItems.isEmpty()) continue;
                        List collect1 = purchaseBiddingItems.stream().filter(item -> BiddingStatusEnum.CONFIRM_ED.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                        if (collect1.isEmpty()) {
                            ListDauctionsBuilt.addAll(Arrays.stream(string.split(",")).collect(Collectors.toList()));
                            continue;
                        }
                        ListCompletionOfTheAuction.addAll(Arrays.stream(string.split(",")).collect(Collectors.toList()));
                        for (PurchaseBiddingItem item2 : collect1) {
                            String[] split;
                            if (!StrUtil.isNotBlank((CharSequence)item2.getSourceItemId())) continue;
                            for (String id : split = item2.getSourceItemId().split(",")) {
                                PurchaseRequestItem requestItem = new PurchaseRequestItem();
                                requestItem.setMaterialNumber(item2.getMaterialNumber());
                                requestItem.setMaterialId(item2.getMaterialId());
                                requestItem.setMaterialName(item2.getMaterialName());
                                requestItem.setMaterialDesc(item2.getMaterialDesc());
                                requestItem.setMaterialSpec(item2.getMaterialSpec());
                                requestItem.setBrand(item2.getBrand());
                                requestItem.setMaterialGroup(item2.getMaterialGroup());
                                requestItem.setCateCode(item2.getCateCode());
                                requestItem.setCateName(item2.getCateName());
                                requestItem.setId(id);
                                requestItem.setItemStatus(PurchaseRequestStatusItemEnum.TENDER_COMPLETED.getValue());
                                batchUpdatePurchaseRequestItemList.add(requestItem);
                            }
                        }
                    }
                    idList.removeAll(ListDauctionsBuilt);
                    idList.removeAll(ListCompletionOfTheAuction);
                    if (!ListDauctionsBuilt.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(ListDauctionsBuilt, PurchaseRequestStatusItemEnum.TENDERS_BUILT.getValue());
                    }
                    if (!ListCompletionOfTheAuction.isEmpty()) {
                        this.purchaseRequestItemService.updateBatchById(batchUpdatePurchaseRequestItemList, 2000);
                    }
                    if (!idList.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(idList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                    }
                } else {
                    this.purchaseRequestItemService.updateStatusById(idList, status);
                }
            } else {
                this.purchaseRequestItemService.updateStatusById(idList, status);
            }
        }
    }

    private void goBackDemandUseForDel(List<PurchaseBiddingItem> purchaseBiddingItemList, String status) {
        List<String> idList1 = purchaseBiddingItemList.stream().filter(o -> com.els.modules.inquiry.enumerate.SourceTypeEnum.REQUEST.getValue().equals(o.getSourceType())).filter(o -> StrUtil.isNotBlank((CharSequence)o.getId())).map(PurchaseBiddingItem::getSourceItemId).collect(Collectors.toList());
        if (!idList1.isEmpty()) {
            ArrayList<String> idList = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty(idList1)) {
                idList1.forEach(str -> idList.addAll(Arrays.stream(str.split(",")).collect(Collectors.toList())));
            }
            if (PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue().equals(status)) {
                List<String> headIdList = purchaseBiddingItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getHeadId())).map(PurchaseBiddingItem::getHeadId).distinct().collect(Collectors.toList());
                List<PurchaseBiddingItem> list = this.purchaseBiddingItemService.findBySourceItemId(headIdList, idList);
                if (!CollectionUtils.isEmpty(list)) {
                    Map<String, List> collect = list.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getSourceItemId())).collect(Collectors.toMap(PurchaseBiddingItem::getSourceItemId, p -> {
                        ArrayList<PurchaseBiddingItem> enquiryItems = new ArrayList<PurchaseBiddingItem>();
                        enquiryItems.add((PurchaseBiddingItem)((Object)p));
                        return enquiryItems;
                    }, (value1, value2) -> {
                        value1.addAll(value2);
                        return value1;
                    }));
                    Set<String> strings = collect.keySet();
                    ArrayList<String> ListDauctionsBuilt = new ArrayList<String>();
                    ArrayList ListCompletionOfTheAuction = new ArrayList();
                    ArrayList<PurchaseRequestItem> batchUpdatePurchaseRequestItemList = new ArrayList<PurchaseRequestItem>();
                    for (String string : strings) {
                        List purchaseBiddingItems = collect.get(string);
                        if (purchaseBiddingItems.isEmpty()) continue;
                        List collect1 = purchaseBiddingItems.stream().filter(item -> BiddingStatusEnum.CONFIRM_ED.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                        if (collect1.isEmpty()) {
                            ListDauctionsBuilt.addAll(Arrays.stream(string.split(",")).collect(Collectors.toList()));
                            continue;
                        }
                        ListCompletionOfTheAuction.addAll(Arrays.stream(string.split(",")).collect(Collectors.toList()));
                        for (PurchaseBiddingItem item2 : collect1) {
                            String[] split;
                            if (!StrUtil.isNotBlank((CharSequence)item2.getSourceItemId())) continue;
                            for (String id : split = item2.getSourceItemId().split(",")) {
                                PurchaseRequestItem requestItem = new PurchaseRequestItem();
                                requestItem.setMaterialNumber(item2.getMaterialNumber());
                                requestItem.setMaterialId(item2.getMaterialId());
                                requestItem.setMaterialName(item2.getMaterialName());
                                requestItem.setMaterialDesc(item2.getMaterialDesc());
                                requestItem.setMaterialSpec(item2.getMaterialSpec());
                                requestItem.setBrand(item2.getBrand());
                                requestItem.setMaterialGroup(item2.getMaterialGroup());
                                requestItem.setCateCode(item2.getCateCode());
                                requestItem.setCateName(item2.getCateName());
                                requestItem.setId(id);
                                requestItem.setItemStatus(PurchaseRequestStatusItemEnum.TENDER_COMPLETED.getValue());
                                batchUpdatePurchaseRequestItemList.add(requestItem);
                            }
                        }
                    }
                    idList.removeAll(ListDauctionsBuilt);
                    idList.removeAll(ListCompletionOfTheAuction);
                    if (!ListDauctionsBuilt.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(ListDauctionsBuilt, PurchaseRequestStatusItemEnum.TENDERS_BUILT.getValue());
                    }
                    if (!ListCompletionOfTheAuction.isEmpty()) {
                        this.purchaseRequestItemService.updateBatchById(batchUpdatePurchaseRequestItemList, 2000);
                    }
                    if (!idList.isEmpty()) {
                        this.purchaseRequestItemService.updateStatusById(idList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                    }
                } else {
                    ArrayList<PurchaseRequestItem> purchaseRequestItemList = new ArrayList<PurchaseRequestItem>();
                    for (String id : idList) {
                        PurchaseRequestItem purchaseRequestItem = (PurchaseRequestItem)((Object)this.purchaseRequestItemService.getById((Serializable)((Object)id)));
                        purchaseRequestItemList.add(purchaseRequestItem);
                    }
                    if (CollectionUtil.isNotEmpty(purchaseRequestItemList)) {
                        List<PurchaseRequestItem> collect1 = purchaseRequestItemList.stream().filter(item -> !"12".equals(item.getItemStatus())).collect(Collectors.toList());
                        this.purchaseRequestHeadService.matchPrice(collect1);
                    }
                }
            } else {
                this.purchaseRequestItemService.updateStatusById(idList, status);
            }
        }
    }

    @Override
    @SrmTransaction
    public void updateMain(PurchaseBiddingHead purchaseBiddingHead, List<PurchaseBiddingItem> purchaseBiddingItemList, List<BiddingSupplier> biddingSupplierList, List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList, List<PurchaseAttachmentDemandDTO> purchaseAttachmentDemandList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        int count = this.purchaseBiddingHeadMapper.updateById((Object)purchaseBiddingHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        List<PurchaseBiddingItem> items = this.purchaseBiddingItemMapper.selectByMainId(purchaseBiddingHead.getId());
        if (!CollectionUtils.isEmpty(items)) {
            List stringList = items.stream().map(ParentEntity::getId).distinct().collect(Collectors.toList());
            MqUtil.sendIntegrateDataLinkMsg(null, stringList, null);
        }
        List<PurchaseBiddingItem> purchaseBiddingItems = this.purchaseBiddingItemMapper.selectByMainId(purchaseBiddingHead.getId());
        this.purchaseBiddingItemMapper.deleteByMainId(purchaseBiddingHead.getId());
        this.biddingSupplierMapper.deleteByMainId(purchaseBiddingHead.getId());
        this.purchaseBiddingSpecialistMapper.deleteByMainId(purchaseBiddingHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(purchaseBiddingHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseBiddingHead.getId());
        this.goBackDemand(purchaseBiddingItems, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        this.insertData(purchaseBiddingHead, purchaseBiddingItemList, biddingSupplierList, purchaseBiddingSpecialistList, purchaseAttachmentDemandList, purchaseAttachmentList);
        this.goBackDemand(purchaseBiddingItemList, PurchaseRequestStatusItemEnum.TENDERS_BUILT.getValue());
        this.sendLink(purchaseBiddingHead, purchaseBiddingItemList);
    }

    private void sendLink(PurchaseBiddingHead headVO, List<PurchaseBiddingItem> purchaseEnquiryItems) {
        JSONArray objects = new JSONArray();
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        JSONObject object = new JSONObject();
        if (headVO != null) {
            object.put("integratedId", (Object)headVO.getDocumentId());
            object.put("elsAccount", (Object)TenantContext.getTenant());
            object.put("createBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
            object.put("updateBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
            object.put("businessType", (Object)"bidding");
            object.put("businessParentType", null);
            object.put("businessId", (Object)headVO.getId());
            object.put("businessParentId", (Object)headVO.getDocumentParentId());
            object.put("businessDataType", (Object)"head");
            objects.add((Object)object);
        }
        if (!CollectionUtils.isEmpty(purchaseEnquiryItems)) {
            for (PurchaseBiddingItem item : purchaseEnquiryItems) {
                JSONObject objectItem = new JSONObject();
                objectItem.put("integratedId", (Object)item.getDocumentItemId());
                objectItem.put("elsAccount", (Object)TenantContext.getTenant());
                objectItem.put("createBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
                objectItem.put("updateBy", (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
                objectItem.put("businessType", (Object)"bidding");
                objectItem.put("businessParentType", null);
                objectItem.put("businessId", (Object)item.getId());
                objectItem.put("businessParentId", (Object)item.getDocumentParentId());
                objectItem.put("businessDataType", (Object)"item");
                objects.add((Object)objectItem);
            }
        }
        if (!objects.isEmpty()) {
            MqUtil.sendIntegrateDataLinkMsg((JSONArray)objects, null, null);
        }
    }

    private void insertData(PurchaseBiddingHead purchaseBiddingHead, List<PurchaseBiddingItem> purchaseBiddingItemList, List<BiddingSupplier> biddingSupplierList, List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList, List<PurchaseAttachmentDemandDTO> purchaseAttachmentDemandList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        int itemNumber = 1;
        for (PurchaseBiddingItem purchaseBiddingItem : purchaseBiddingItemList) {
            purchaseBiddingItem.setId(null);
            purchaseBiddingItem.setHeadId(purchaseBiddingHead.getId());
            purchaseBiddingItem.setDocumentId(purchaseBiddingHead.getDocumentId());
            purchaseBiddingItem.setBiddingNumber(purchaseBiddingHead.getBiddingNumber());
            purchaseBiddingItem.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            purchaseBiddingItem.setItemStatus(BiddingItemStatusEnum.NEW.getValue());
            purchaseBiddingItem.setItemNumber("" + itemNumber);
            purchaseBiddingItem.setCurrentRound(1);
            ++itemNumber;
            SysUtil.setSysParam((BaseEntity)purchaseBiddingItem, (BaseEntity)purchaseBiddingHead);
        }
        if (!purchaseBiddingItemList.isEmpty()) {
            this.purchaseBiddingItemService.saveBatch(purchaseBiddingItemList, 2000);
        }
        itemNumber = 1;
        for (BiddingSupplier biddingSupplier : biddingSupplierList) {
            biddingSupplier.setId(null);
            biddingSupplier.setHeadId(purchaseBiddingHead.getId());
            biddingSupplier.setBiddingNumber(purchaseBiddingHead.getBiddingNumber());
            biddingSupplier.setItemNumber("" + itemNumber);
            biddingSupplier.setCurrentRound(1);
            ++itemNumber;
            SysUtil.setSysParam((BaseEntity)biddingSupplier, (BaseEntity)purchaseBiddingHead);
        }
        if (!biddingSupplierList.isEmpty()) {
            this.biddingSupplierService.saveBatch(biddingSupplierList, 2000);
        }
        for (PurchaseBiddingSpecialist purchaseBiddingSpecialist : purchaseBiddingSpecialistList) {
            if ("1".equals(purchaseBiddingSpecialist.getProjectMemberType())) continue;
            purchaseBiddingSpecialist.setId(null);
            purchaseBiddingSpecialist.setHeadId(purchaseBiddingHead.getId());
            purchaseBiddingSpecialist.setElsAccount(TenantContext.getTenant());
            purchaseBiddingSpecialist.setProjectMemberType("0");
            SysUtil.setSysParam((BaseEntity)purchaseBiddingSpecialist, (BaseEntity)purchaseBiddingHead);
        }
        if (!purchaseBiddingSpecialistList.isEmpty()) {
            this.purchaseBiddingSpecialistService.saveBatch(purchaseBiddingSpecialistList);
        }
        for (PurchaseAttachmentDemandDTO purchaseAttachmentDemandDTO : purchaseAttachmentDemandList) {
            purchaseAttachmentDemandDTO.setId(null);
            purchaseAttachmentDemandDTO.setHeadId(purchaseBiddingHead.getId());
            purchaseAttachmentDemandDTO.setBusinessType("bidding");
            purchaseAttachmentDemandDTO.setElsAccount(purchaseBiddingHead.getElsAccount());
            purchaseAttachmentDemandDTO.setCreateBy(purchaseBiddingHead.getCreateBy());
            purchaseAttachmentDemandDTO.setUpdateBy(purchaseBiddingHead.getUpdateBy());
            purchaseAttachmentDemandDTO.setCreateTime(purchaseBiddingHead.getCreateTime());
            purchaseAttachmentDemandDTO.setUpdateTime(purchaseBiddingHead.getUpdateTime());
        }
        if (!purchaseAttachmentDemandList.isEmpty()) {
            this.invokeBaseRpcService.insertPurchaseAttachmentDemandBatchSomeColumn(purchaseAttachmentDemandList);
        }
        for (PurchaseAttachmentDTO purchaseAttachmentDTO : purchaseAttachmentList) {
            purchaseAttachmentDTO.setId(null);
            purchaseAttachmentDTO.setHeadId(purchaseBiddingHead.getId());
            purchaseAttachmentDTO.setBusinessType("bidding");
            purchaseAttachmentDTO.setElsAccount(purchaseBiddingHead.getElsAccount());
            purchaseAttachmentDTO.setCreateBy(purchaseBiddingHead.getCreateBy());
            purchaseAttachmentDTO.setUpdateBy(purchaseBiddingHead.getUpdateBy());
            purchaseAttachmentDTO.setCreateTime(purchaseBiddingHead.getCreateTime());
            purchaseAttachmentDTO.setUpdateTime(purchaseBiddingHead.getUpdateTime());
        }
        if (!purchaseAttachmentList.isEmpty()) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    @Override
    @SrmTransaction
    public void delMain(String id) {
        List<PurchaseBiddingItem> itemList = this.purchaseBiddingItemMapper.selectByMainId(id);
        this.goBackDemandUseForDel(itemList, PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
        this.purchaseBiddingItemMapper.deleteByMainId(id);
        this.biddingSupplierMapper.deleteByMainId(id);
        this.purchaseBiddingSpecialistMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        PurchaseBiddingHead purchaseBiddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)id)));
        if (StrUtil.isNotBlank((CharSequence)purchaseBiddingHead.getDocumentId())) {
            this.invokeBaseRpcService.delIntegratedDocumentMain("biddingHeadId", purchaseBiddingHead.getDocumentId(), purchaseBiddingHead.getDocumentParentId(), purchaseBiddingHead.getId());
        }
        this.purchaseBiddingHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    public void delete(Wrapper<PurchaseBiddingHead> queryWrapper) {
        this.purchaseBiddingHeadMapper.delete(queryWrapper);
    }

    @Override
    @SrmTransaction
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseBiddingItemMapper.deleteByMainId(serializable.toString());
            this.biddingSupplierMapper.deleteByMainId(serializable.toString());
            this.purchaseBiddingSpecialistMapper.deleteByMainId(serializable.toString());
            this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(serializable.toString());
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
            this.purchaseBiddingHeadMapper.deleteById(serializable);
        }
    }

    public static void checkAndSetParam(PurchaseBiddingHeadVO head) {
        int count;
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        head.setBiddingStatus(BiddingStatusEnum.BIDDING.getValue());
        head.setPublishTime(new Date());
        head.setPublishUser(loginUser.getSubAccount());
        head.setCurrentRound(1);
        String needEcho = head.getNeedEcho();
        Date echoEndTime = head.getEchoEndTime();
        Date applyEndTime = head.getApplyEndTime();
        String biddingType = head.getBiddingType();
        Assert.hasText((String)biddingType, (String)I18nUtil.translate((String)"i18n_alert_empty_bid_type_not_empty_bidding", (String)"\u62db\u6807\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        if (BiddingTypeEnum.PUBLIC.getValue().equals(biddingType)) {
            Assert.notNull((Object)applyEndTime, (String)I18nUtil.translate((String)"i18n_alert_empty_registration_time_not_empty", (String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (StrUtil.isBlank((CharSequence)head.getAccessCategoryFilter())) {
            head.setAccessCategoryFilter("0");
        }
        if ("1".equals(head.getAccessCategoryFilter())) {
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)head.getPurchaseOrg()), (String)I18nUtil.translate((String)"i18n_alert_pSLzARIvRvAKWnRVRlS_ec146c92", (String)"\u6309\u7269\u6599\u5206\u7c7b\u8fc7\u6ee4\u5f00\u5173\u5f00\u542f\u65f6\uff0c\u91c7\u8d2d\u7ec4\u7ec7\u5fc5\u586b"));
        }
        if (!"1".equals(head.getPublishAudit())) {
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        if (!"1".equals(head.getResultAudit())) {
            head.setResultAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        if ("1".equals(head.getBuyBidingDoc())) {
            Date buyBidDocBeginTime = head.getBuyBidDocBeginTime();
            Date buyBidDocEndTime = head.getBuyBidDocEndTime();
            Assert.notNull((Object)buyBidDocBeginTime, (String)I18nUtil.translate((String)"i18n_alert_empty_tender_buy_time_not_empty_bidding", (String)"\u6807\u4e66\u8d2d\u4e70\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.notNull((Object)buyBidDocEndTime, (String)I18nUtil.translate((String)"i18n_alert_empty_tender_buy_cut_off_time_not_empty_bidding", (String)"\u6807\u4e66\u8d2d\u4e70\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.isTrue((boolean)buyBidDocEndTime.after(buyBidDocBeginTime), (String)I18nUtil.translate((String)"i18n_alert_fail_tender_buy_time_gt_cut_off_time_bidding", (String)"\u6807\u4e66\u8d2d\u4e70\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6807\u4e66\u8d2d\u4e70\u622a\u6b62\u65f6\u95f4\uff01"));
        }
        if ("1".equals(needEcho)) {
            Assert.notNull((Object)echoEndTime, (String)I18nUtil.translate((String)"i18n_alert_empty_should_be_marked_not_empty_bidding", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        Date bidBeginTime = head.getBidBeginTime();
        Date bidEndTime = head.getBidEndTime();
        Assert.notNull((Object)bidBeginTime, (String)I18nUtil.translate((String)"i18n_alert_empty_tender_start_time_not_empty_bidding", (String)"\u6295\u6807\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.notNull((Object)bidEndTime, (String)I18nUtil.translate((String)"i18n_alert_empty_tender_cut_off_time_not_empty_bidding", (String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)bidEndTime.after(bidBeginTime), (String)I18nUtil.translate((String)"i18n_alert_fail_tender_start_time_gt_end_time_bidding", (String)"\u6295\u6807\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6295\u6807\u622a\u6b62\u65f6\u95f4\uff01"));
        Date planOpenBidTime = head.getPlanOpenBidTime();
        Assert.notNull((Object)planOpenBidTime, (String)I18nUtil.translate((String)"i18n_alert_empty_bid_open_time_not_empty_bidding", (String)"\u8ba1\u5212\u5f00\u6807\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)planOpenBidTime.after(bidEndTime), (String)I18nUtil.translate((String)"i18n_alert_fail_tender_cut_off_time_gt_open_time_bidding", (String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u8ba1\u5212\u5f00\u6807\u65f6\u95f4\uff01"));
        Date evaEndTime = head.getEvaEndTime();
        Assert.notNull((Object)evaEndTime, (String)I18nUtil.translate((String)"i18n_alert_empty_evaluation_of_bids_cut_off_time_bidding", (String)"\u8bc4\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)evaEndTime.after(planOpenBidTime), (String)I18nUtil.translate((String)"i18n_alert_fail_bid_open_time_gt_cut_off_time_bidding", (String)"\u8ba1\u5212\u5f00\u6807\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u8bc4\u6807\u622a\u6b62\u65f6\u95f4\uff01"));
        String purchasePrincipal = head.getPurchasePrincipal();
        Assert.hasText((String)purchasePrincipal, (String)I18nUtil.translate((String)"i18n_alert_empty_principal", (String)"\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.notEmpty(head.getPurchaseBiddingItemList(), (String)I18nUtil.translate((String)"i18n_alert_oper_must_create_one_row", (String)"\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u884c\u9879\u76ee\uff01"));
        Long participateQuantity = head.getParticipateQuantity();
        Assert.isTrue((participateQuantity != null && participateQuantity > 0L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_fail_parameter_num_must_gt_zero", (String)"\u53c2\u4e0e\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff01"));
        if (BiddingTypeEnum.INVITE.getValue().equals(biddingType)) {
            head.setInviteQuantity(head.getBiddingSupplierList().size());
            Assert.isTrue(((long)head.getInviteQuantity().intValue() >= participateQuantity ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_fail_supplier_num_must_gt_parameter_num_bidding", (String)"\u9080\u8bf7\u62db\u6807\u65f6\uff0c\u9009\u62e9\u4f9b\u5e94\u5546\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u53c2\u4e0e\u6570\u91cf\uff01"));
        }
        if ("1".equals(head.getAccessCategoryFilter()) && CollectionUtil.isNotEmpty(head.getBiddingSupplierList()) && (count = (int)head.getPurchaseBiddingItemList().stream().filter(item -> StrUtil.isBlank((CharSequence)item.getCateCode())).count()) == 0) {
            ArrayList<String> orgDataKeyList = new ArrayList<String>();
            List toElsAccountList = head.getBiddingSupplierList().stream().map(BiddingSupplier::getToElsAccount).distinct().collect(Collectors.toList());
            for (String toElsAccount : toElsAccountList) {
                orgDataKeyList.add(head.getElsAccount() + "&&" + toElsAccount + "&&" + head.getPurchaseOrg());
            }
            InquiryInvokeSupplierRpcService bean = (InquiryInvokeSupplierRpcService)SpringContextUtils.getBean(InquiryInvokeSupplierRpcService.class);
            List<SupplierOrgInfoDTO> selectSupplierOrgInfoList = bean.selectSupplierOrgInfoList(orgDataKeyList);
            Map<String, List<SupplierOrgInfoDTO>> supplierOrgInfoMap = selectSupplierOrgInfoList.stream().collect(Collectors.groupingBy(ParentEntityDTO::getElsAccount));
            StringBuilder temp = new StringBuilder();
            List cateCodes = head.getPurchaseBiddingItemList().stream().map(PurchaseBiddingItem::getCateCode).distinct().collect(Collectors.toList());
            int x = 0;
            for (BiddingSupplier biddingSupplier : head.getBiddingSupplierList()) {
                List<SupplierOrgInfoDTO> supplierOrgInfoDTOS = supplierOrgInfoMap.get(biddingSupplier.getToElsAccount());
                if (supplierOrgInfoDTOS == null || supplierOrgInfoDTOS.size() == 0) {
                    temp.append(x++ == 0 ? " " : "\u3001").append(biddingSupplier.getSupplierName());
                    continue;
                }
                List<String> collect = supplierOrgInfoDTOS.stream().map(SupplierOrgInfoDTO::getAccessCategory).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
                ArrayList accessCategorys = new ArrayList();
                collect.forEach(item -> accessCategorys.add(item.contains("_") ? item.split("_")[0] : item));
                int count1 = (int)accessCategorys.stream().filter(cateCodes::contains).count();
                if (count1 != 0) continue;
                temp.append(x++ == 0 ? " " : "\u3001").append(biddingSupplier.getSupplierName());
            }
            String supplierName = temp.toString();
            if (StrUtil.isNotBlank((CharSequence)supplierName)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_DJKmLIAjprNNARIMKRdXShzEuYBcVImYBcSLzAURdXjRHRdXNI0_7542c0a", (String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u60a8\u5df2\u542f\u7528\u201c\u6309\u51c6\u5165\u54c1\u7c7b\u8fc7\u6ee4\u201d\uff0c\u5b58\u5728\u4f9b\u5e94\u5546\u65e0\u6cd5\u5206\u914d\u5230\u62db\u6807\u884c\u3002\u8bf7\u68c0\u67e5\u62db\u6807\u884c\u7269\u6599\u5206\u7c7b\u4e0e\u4f9b\u5e94\u5546\u7684\u5173\u7cfb\u3002\u4f9b\u5e94\u5546\u5982\u4e0b\uff1a${0}\u3002", (String[])new String[]{supplierName}));
            }
        }
    }

    private void saveBiddingSpecialist(PurchaseBiddingHead head, List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList) {
        for (PurchaseBiddingSpecialist entity : purchaseBiddingSpecialistList) {
            if ("1".equals(entity.getProjectMemberType()) || "2".equals(entity.getMemberType())) continue;
            entity.setId(null);
            entity.setHeadId(head.getId());
            entity.setElsAccount(TenantContext.getTenant());
            entity.setMemberType(MemberTypeEnum.EVA_BID.getValue());
            entity.setProjectMemberType("0");
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)head);
        }
        String purchasePrincipal = head.getPurchasePrincipal();
        String[] array = purchasePrincipal.split("_");
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        long count = purchaseBiddingSpecialistList.parallelStream().filter(special -> MemberRoleEnum.BID_PRINCIPAL.getValue().equals(special.getMemberRole())).filter(special -> loginUser.getElsAccount().equals(special.getElsAccount()) && special.getSubAccount().equals(array[0])).count();
        if (count == 0L) {
            PurchaseBiddingSpecialist specialist = new PurchaseBiddingSpecialist();
            specialist.setHeadId(head.getId());
            specialist.setElsAccount(TenantContext.getTenant());
            specialist.setMemberType(MemberTypeEnum.PROJECT.getValue());
            SysUtil.setSysParam((BaseEntity)specialist, (BaseEntity)head);
            specialist.setMemberRole(MemberRoleEnum.BID_PRINCIPAL.getValue());
            specialist.setProjectMemberType("0");
            specialist.setSubAccount(array[0]);
            if (array.length > 1) {
                specialist.setName(array[1]);
            }
            specialist.setMobileTelephone(head.getContactNumber());
            specialist.setEmail(head.getEmail());
            purchaseBiddingSpecialistList.add(specialist);
        }
        this.purchaseBiddingSpecialistService.saveOrUpdateBatch(purchaseBiddingSpecialistList, 2000);
    }

    private void saveBiddingSupplier(PurchaseBiddingHead head, List<BiddingSupplier> biddingSupplierList) {
        BigDecimal bidingDocCost = head.getBidingDocCost();
        String bidCheck = "0";
        if (bidingDocCost == null || bidingDocCost.compareTo(BigDecimal.ZERO) == 0) {
            bidCheck = "1";
        }
        BigDecimal securityCost = head.getSecurityCost();
        String bidQuote = "0";
        if (securityCost == null || securityCost.compareTo(BigDecimal.ZERO) == 0) {
            bidQuote = "1";
        }
        String needEcho = head.getNeedEcho();
        String replyStatus = ReplyStatusEnum.NOT_NEED.getValue();
        if ("1".equals(needEcho)) {
            replyStatus = ReplyStatusEnum.WAIT_REPLY.getValue();
        }
        int itemNumber = 1;
        for (BiddingSupplier entity : biddingSupplierList) {
            entity.setId(null);
            entity.setHeadId(head.getId());
            entity.setBiddingNumber(head.getBiddingNumber());
            entity.setItemNumber("" + itemNumber);
            entity.setSourceType(StrUtil.isBlank((CharSequence)entity.getSourceType()) ? SupplierSourceTypeEnum.INVITE.getValue() : entity.getSourceType());
            entity.setReplyStatus(StrUtil.isBlank((CharSequence)entity.getReplyStatus()) ? replyStatus : entity.getReplyStatus());
            entity.setQuaCheckResult("1");
            entity.setBidCheck(bidCheck);
            entity.setBidQuote(bidQuote);
            entity.setCurrentRound(head.getCurrentRound());
            ++itemNumber;
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)head);
        }
        if (!biddingSupplierList.isEmpty()) {
            this.biddingSupplierService.saveBatch(biddingSupplierList, 2000);
        }
    }

    private void savePurchaseAttachmentDemand(PurchaseBiddingHead head, List<PurchaseAttachmentDemandDTO> purchaseAttachmentDemandList) {
        int itemNumber = 1;
        for (PurchaseAttachmentDemandDTO entity : purchaseAttachmentDemandList) {
            entity.setHeadId(head.getId());
            entity.setItemNumber("" + itemNumber);
            ++itemNumber;
            entity.setBusinessType("bidding");
            entity.setElsAccount(head.getElsAccount());
            entity.setCreateBy(head.getCreateBy());
            entity.setUpdateBy(head.getUpdateBy());
            entity.setCreateTime(head.getCreateTime());
            entity.setUpdateTime(head.getUpdateTime());
        }
        if (!purchaseAttachmentDemandList.isEmpty()) {
            this.invokeBaseRpcService.insertPurchaseAttachmentDemandBatchSomeColumn(purchaseAttachmentDemandList);
        }
    }

    private void savePurchaseBiddingItem(PurchaseBiddingHead head, List<PurchaseBiddingItem> purchaseBiddingItemList) {
        int itemNumber = 1;
        for (PurchaseBiddingItem entity : purchaseBiddingItemList) {
            entity.setId(null);
            entity.setHeadId(head.getId());
            entity.setBiddingNumber(head.getBiddingNumber());
            entity.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            entity.setItemNumber("" + itemNumber);
            entity.setCurrentRound(head.getCurrentRound());
            ++itemNumber;
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)head);
        }
        if (!purchaseBiddingItemList.isEmpty()) {
            this.purchaseBiddingItemService.saveBatch(purchaseBiddingItemList);
        }
    }

    private void insertInitTable(String headId, List<PurchaseBiddingItem> itemList) {
        ElsInitialTableDTO elsInitialTable = new ElsInitialTableDTO();
        elsInitialTable.setRelationId(headId);
        elsInitialTable.setBusinessInfoJson(JSON.toJSONString(itemList));
        this.invokeBaseRpcService.addElsInitialTable(elsInitialTable);
    }

    private AttachmentSendDTO publishBidding(PurchaseBiddingHead purchaseBiddingHead, List<PurchaseBiddingItem> purchaseBiddingItemList, List<BiddingSupplier> biddingSupplierList, List<PurchaseAttachmentDemandDTO> purchaseAttachmentDemandList, boolean isPublic) {
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        this.saveBiddingSupplier(purchaseBiddingHead, biddingSupplierList);
        ArrayList<SaleBiddingHead> insertSalebBiddingHeadList = new ArrayList<SaleBiddingHead>();
        ArrayList<PurchaseBiddingItem> insertPurchaseBiddingItemList = new ArrayList<PurchaseBiddingItem>();
        ArrayList<SaleBiddingItem> insertSaleBiddingItemList = new ArrayList<SaleBiddingItem>();
        ArrayList<SaleAttachmentDemandDTO> insertSaleAttachmentDemandList = new ArrayList<SaleAttachmentDemandDTO>();
        HashMap<String, String> toSend = new HashMap<String, String>();
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        List<String> toElsAccountList = biddingSupplierList.stream().map(BiddingSupplier::getToElsAccount).collect(Collectors.toList());
        List<String> materialNumberList = purchaseBiddingItemList.stream().filter(o -> StrUtil.isNotBlank((CharSequence)o.getMaterialNumber())).map(PurchaseBiddingItem::getMaterialNumber).collect(Collectors.toList());
        Map<String, PurchaseMaterialRelationDTO> relationMap = this.inquiryInvokeMainDataRpcService.findByMaterialAndAccount(materialNumberList, toElsAccountList);
        Map<Object, Object> supplierOrgInfoMap = new HashMap();
        boolean isAccessCategoryFilter = "1".equals(purchaseBiddingHead.getAccessCategoryFilter());
        if (isAccessCategoryFilter) {
            ArrayList orgDataKeyList = new ArrayList();
            for (String toElsAccount : toElsAccountList) {
                orgDataKeyList.add(purchaseBiddingHead.getElsAccount() + "&&" + toElsAccount + "&&" + purchaseBiddingHead.getPurchaseOrg());
            }
            List<SupplierOrgInfoDTO> selectSupplierOrgInfoList = this.inquiryInvokeSupplierRpcService.selectSupplierOrgInfoList(orgDataKeyList);
            supplierOrgInfoMap = selectSupplierOrgInfoList.stream().collect(Collectors.groupingBy(ParentEntityDTO::getElsAccount));
        }
        for (BiddingSupplier supplier : biddingSupplierList) {
            List<Object> assessCategorys = new ArrayList();
            if (CollectionUtil.isNotEmpty(supplierOrgInfoMap)) {
                List supplierOrgInfoDTOS = Optional.ofNullable((List)supplierOrgInfoMap.get(supplier.getToElsAccount())).orElse(new ArrayList());
                assessCategorys = supplierOrgInfoDTOS.stream().map(SupplierOrgInfoDTO::getAccessCategory).collect(Collectors.toList());
            }
            SaleBiddingHead saleBiddingHead = new SaleBiddingHead();
            BeanUtil.copyProperties((Object)((Object)purchaseBiddingHead), (Object)((Object)saleBiddingHead), (String[])new String[0]);
            saleBiddingHead.setElsAccount(supplier.getToElsAccount());
            saleBiddingHead.setToElsAccount(purchaseBiddingHead.getElsAccount());
            saleBiddingHead.setId(IdWorker.getIdStr());
            saleBiddingHead.setRelationId(purchaseBiddingHead.getId());
            saleBiddingHead.setSupplierListId(supplier.getId());
            saleBiddingHead.setPurchaseName(loginUser.getCompanyName());
            saleBiddingHead.setDeleted(CommonConstant.DEL_FLAG_0);
            saleBiddingHead.setElsAccount(supplier.getToElsAccount());
            saleBiddingHead.setToElsAccount(purchaseBiddingHead.getElsAccount());
            insertSalebBiddingHeadList.add(saleBiddingHead);
            toSend.put(saleBiddingHead.getId(), supplier.getToElsAccount());
            JSONObject urlParam = new JSONObject();
            urlParam.put("id", (Object)saleBiddingHead.getId());
            urlParam.put("templateNumber", (Object)saleBiddingHead.getTemplateNumber());
            urlParam.put("templateVersion", (Object)saleBiddingHead.getTemplateVersion());
            urlParam.put("busAccount", (Object)saleBiddingHead.getBusAccount());
            receiveParamMap.put(supplier.getToElsAccount(), urlParam);
            int itemNumber = 1;
            for (PurchaseBiddingItem item : purchaseBiddingItemList) {
                PurchaseMaterialRelationDTO relation;
                int number = itemNumber++;
                if (!isPublic && isAccessCategoryFilter && StrUtil.isNotBlank((CharSequence)item.getCateCode())) {
                    boolean flag = false;
                    for (String string : assessCategorys) {
                        if (!string.contains(item.getCateCode())) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                }
                PurchaseBiddingItem purchaseBiddingItem = new PurchaseBiddingItem();
                BeanUtil.copyProperties((Object)((Object)item), (Object)((Object)purchaseBiddingItem), (String[])new String[0]);
                SysUtil.setSysParam((BaseEntity)purchaseBiddingItem, (BaseEntity)purchaseBiddingHead);
                purchaseBiddingItem.setId(IdWorker.getIdStr());
                purchaseBiddingItem.setHeadId(purchaseBiddingHead.getId());
                purchaseBiddingItem.setRelationId(IdWorker.getIdStr());
                purchaseBiddingItem.setBiddingNumber(purchaseBiddingHead.getBiddingNumber());
                purchaseBiddingItem.setReplyStatus(ReplyStatusEnum.REPLYED.getValue());
                purchaseBiddingItem.setCurrentRound(purchaseBiddingHead.getCurrentRound());
                purchaseBiddingItem.setItemNumber(String.valueOf(number));
                purchaseBiddingItem.setElsAccount(purchaseBiddingHead.getElsAccount());
                purchaseBiddingItem.setToElsAccount(supplier.getToElsAccount());
                purchaseBiddingItem.setSupplierCode(supplier.getSupplierCode());
                purchaseBiddingItem.setSupplierName(supplier.getSupplierName());
                if (StrUtil.isNotBlank((CharSequence)item.getMaterialNumber()) && (relation = relationMap.get(item.getMaterialNumber() + supplier.getToElsAccount())) != null) {
                    purchaseBiddingItem.setSaleMaterialNumber(relation.getSaleMaterialNumber());
                }
                insertPurchaseBiddingItemList.add(purchaseBiddingItem);
                SaleBiddingItem saleBiddingItem = new SaleBiddingItem();
                BeanUtil.copyProperties((Object)((Object)purchaseBiddingItem), (Object)((Object)saleBiddingItem), (String[])new String[0]);
                saleBiddingItem.setId(purchaseBiddingItem.getRelationId());
                saleBiddingItem.setRelationId(purchaseBiddingItem.getId());
                saleBiddingItem.setHeadId(saleBiddingHead.getId());
                saleBiddingItem.setElsAccount(purchaseBiddingItem.getToElsAccount());
                saleBiddingItem.setToElsAccount(purchaseBiddingItem.getElsAccount());
                saleBiddingItem.setExpiryDate(purchaseBiddingItem.getExpiryDate());
                saleBiddingItem.setEffectiveDate(purchaseBiddingItem.getEffectiveDate());
                if ("0".equals(purchaseBiddingHead.getSendTargetPrice())) {
                    saleBiddingItem.setTargetPrice(null);
                }
                insertSaleBiddingItemList.add(saleBiddingItem);
            }
            for (PurchaseAttachmentDemandDTO demand : purchaseAttachmentDemandList) {
                SaleAttachmentDemandDTO saleAttachmentDemand = new SaleAttachmentDemandDTO();
                BeanUtil.copyProperties((Object)demand, (Object)saleAttachmentDemand, (String[])new String[0]);
                saleAttachmentDemand.setId(IdWorker.getIdStr());
                saleAttachmentDemand.setElsAccount(supplier.getToElsAccount());
                saleAttachmentDemand.setHeadId(saleBiddingHead.getId());
                insertSaleAttachmentDemandList.add(saleAttachmentDemand);
            }
        }
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setElsAccount(purchaseBiddingHead.getElsAccount());
        sendVO.setHeadId(purchaseBiddingHead.getId());
        sendVO.setToSend(toSend);
        if (biddingSupplierList.isEmpty()) {
            this.savePurchaseBiddingItem(purchaseBiddingHead, purchaseBiddingItemList);
        } else {
            this.saleBiddingHeadService.saveBatch(insertSalebBiddingHeadList, 2000);
            this.saleBiddingItemService.saveBatch(insertSaleBiddingItemList, 2000);
            if (!insertSaleAttachmentDemandList.isEmpty()) {
                this.invokeBaseRpcService.insertSaleAttachmentDemandBatchSomeColumn(insertSaleAttachmentDemandList);
            }
            this.purchaseBiddingItemService.saveBatch(insertPurchaseBiddingItemList, 2000);
            this.invokeBaseRpcService.sendPurchaseFile(sendVO, true);
            Map<String, String> supplierMap = biddingSupplierList.stream().collect(Collectors.toMap(BiddingSupplier::getToElsAccount, BiddingSupplier::getSupplierName, (newVal, oldVal) -> oldVal));
            super.sendMessage(TenantContext.getTenant(), "bidding", "publish", purchaseBiddingHead.getId(), "biddingBusDataServiceImpl", toElsAccountList);
        }
        return sendVO;
    }

    private void publishNotice(PurchaseBiddingHead head, List<BiddingSupplier> biddingSupplierList) {
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        String purchaseName = StrUtil.isBlank((CharSequence)loginUser.getCompanyName()) ? "" : loginUser.getCompanyName();
        String projectName = StrUtil.isBlank((CharSequence)head.getProjectName()) ? "" : head.getProjectName();
        String biddingType = head.getBiddingType();
        if (BiddingTypeEnum.INVITE.getValue().equals(biddingType)) {
            return;
        }
        PurchaseNoticeDTO notice = new PurchaseNoticeDTO();
        notice.setBusAccount(head.getBusAccount());
        notice.setNoticeTitle(purchaseName + "_" + projectName + I18nUtil.translate((String)"i18n_dict_YBRx_2e809dea", (String)"\u62db\u6807\u516c\u544a"));
        notice.setNoticeContent(I18nUtil.translate((String)"i18n_field_YBCcIdH_902088c1", (String)"\u62db\u6807\u5185\u5bb9\u89c1\u8be6\u7ec6"));
        notice.setNoticeType("2");
        notice.setTop("1");
        notice.setEffectiveTime(new Date());
        notice.setBusinessId(head.getId());
        notice.setBusinessType(SourceTypeEnum.BIDDING.getValue());
        notice.setTemplateNumber(head.getTemplateNumber());
        notice.setTemplateVersion(head.getTemplateVersion());
        notice.setTemplateAccount(head.getTemplateAccount());
        notice.setExpiryTime(head.getApplyEndTime());
        if (BiddingTypeEnum.INVITE.getValue().equals(biddingType)) {
            notice.setNoticeScope(NoticeScopeEnum.ASSIGN_SUPPLIER.getValue());
            ArrayList<PurchaseNoticeSupplierDTO> purchaseNoticeSupplierList = new ArrayList<PurchaseNoticeSupplierDTO>();
            for (BiddingSupplier supplier : biddingSupplierList) {
                PurchaseNoticeSupplierDTO noticeSupplier = new PurchaseNoticeSupplierDTO();
                BeanUtils.copyProperties((Object)((Object)supplier), (Object)noticeSupplier);
                noticeSupplier.setId(null);
                purchaseNoticeSupplierList.add(noticeSupplier);
            }
            this.inquiryInvokeMessageRpcService.publish(notice, purchaseNoticeSupplierList, new ArrayList<PurchaseAttachmentDTO>());
        } else {
            notice.setNoticeScope(NoticeScopeEnum.IN_STATION_OPEN.getValue());
            PurchaseNoticeDTO notice1 = new PurchaseNoticeDTO();
            BeanUtils.copyProperties((Object)notice, (Object)notice1);
            notice1.setNoticeContent(I18nUtil.translate((String)"i18n_field_diStqUHeCRxGsUsR_8490bd21", (String)"\u6ce8\u518c\u540e\u5373\u53ef\u4e8e\u7cfb\u7edf\u5185\u516c\u544a\u5904\u53c2\u4e0e\u62a5\u540d"));
            notice1.setNoticeScope(NoticeScopeEnum.OPEN.getValue());
            this.inquiryInvokeMessageRpcService.publish(notice, new ArrayList<PurchaseNoticeSupplierDTO>(), new ArrayList<PurchaseAttachmentDTO>());
            this.inquiryInvokeMessageRpcService.publish(notice1, new ArrayList<PurchaseNoticeSupplierDTO>(), new ArrayList<PurchaseAttachmentDTO>());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseBiddingHead purchaseBiddingHead, List<PurchaseBiddingItem> purchaseBiddingItemList, List<BiddingSupplier> biddingSupplierList, List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList, List<PurchaseAttachmentDemandDTO> purchaseAttachmentDemandList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.checkEnquirySameMaterial(purchaseBiddingItemList);
        this.checkMaterialNumber(purchaseBiddingItemList);
        this.validPublishParams(purchaseBiddingHead);
        PurchaseBiddingHeadVO headVO = new PurchaseBiddingHeadVO();
        BeanUtil.copyProperties((Object)((Object)purchaseBiddingHead), (Object)((Object)headVO), (String[])new String[0]);
        headVO.setPurchaseBiddingItemList(purchaseBiddingItemList);
        headVO.setBiddingSupplierList(biddingSupplierList);
        headVO.setBusAccount(TenantContext.getTenant());
        headVO.setResultAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        PurchaseBiddingHeadServiceImpl.checkAndSetParam(headVO);
        BeanUtil.copyProperties((Object)((Object)headVO), (Object)((Object)purchaseBiddingHead), (String[])new String[0]);
        if ("1".equals(purchaseBiddingHead.getPublishAudit())) {
            Assert.isTrue((boolean)AuditStatusEnum.AUDIT_FINISH.getValue().equals(purchaseBiddingHead.getAuditStatus()), (String)I18nUtil.translate((String)"i18n_alert_fail_publish_no_approved", (String)"\u5ba1\u6279\u901a\u8fc7\u540e\u624d\u53ef\u53d1\u5e03"));
        }
        if (StrUtil.isBlank((CharSequence)purchaseBiddingHead.getId())) {
            this.purchaseBiddingHeadMapper.insert((Object)purchaseBiddingHead);
        } else {
            int count = this.purchaseBiddingHeadMapper.updateById((Object)purchaseBiddingHead);
            if (count == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            }
            this.purchaseBiddingItemMapper.deleteByMainId(purchaseBiddingHead.getId());
            this.biddingSupplierMapper.deleteByMainId(purchaseBiddingHead.getId());
            this.purchaseBiddingSpecialistMapper.deleteByMainId(purchaseBiddingHead.getId());
            this.invokeBaseRpcService.deletePurchaseAttachmentDemandByMainId(purchaseBiddingHead.getId());
        }
        this.insertInitTable(purchaseBiddingHead.getId(), purchaseBiddingItemList);
        this.saveBiddingSpecialist(purchaseBiddingHead, purchaseBiddingSpecialistList);
        this.savePurchaseAttachmentDemand(purchaseBiddingHead, purchaseAttachmentDemandList);
        this.publishNotice(purchaseBiddingHead, biddingSupplierList);
        this.createOpenBidAlertJob(purchaseBiddingHead);
        if ("1".equals(purchaseBiddingHead.getNeedEcho())) {
            BiddingJobUtil.createFailureBidByReplyJob(purchaseBiddingHead, purchaseBiddingHead.getEchoEndTime());
        }
        BiddingJobUtil.createFailureBidByQuoteJob(purchaseBiddingHead, purchaseBiddingHead.getBidEndTime());
        this.saveTalkPriceContiune(purchaseBiddingHead, biddingSupplierList.size());
        this.publishBidding(purchaseBiddingHead, purchaseBiddingItemList, biddingSupplierList, purchaseAttachmentDemandList, false);
    }

    private void createOpenBidAlertJob(PurchaseBiddingHead head) {
        Date planOpenBidTime = head.getPlanOpenBidTime();
        int openBidAlertMinute = 5;
        if (head.getOpenBidAlertMinute() != null) {
            openBidAlertMinute = head.getOpenBidAlertMinute();
        }
        DateTime alertTime = DateUtil.offsetMinute((Date)planOpenBidTime, (int)(0 - openBidAlertMinute));
        BiddingJobUtil.createOpenBidAlertJob(head, (Date)alertTime);
    }

    @Override
    @SrmTransaction
    public void openPermission(PurchaseBiddingHead purchaseBiddingHead, List<BiddingSupplier> biddingSupplierList) {
        Assert.isTrue((!BiddingStatusEnum.CANCEL.getValue().equals(purchaseBiddingHead.getBiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_tFIkuxiTtk_19f6e2aa", (String)"\u5355\u636e\u5df2\u4f5c\u5e9f\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        this.checkPermission(purchaseBiddingHead.getId());
        ArrayList<BiddingSupplier> batchUpdateItemList = new ArrayList<BiddingSupplier>();
        for (BiddingSupplier supplier : biddingSupplierList) {
            BiddingSupplier updateItem = new BiddingSupplier();
            updateItem.setElsAccount(supplier.getElsAccount());
            updateItem.setId(supplier.getId());
            updateItem.setBidCheck(supplier.getBidCheck());
            updateItem.setBidQuote(supplier.getBidQuote());
            batchUpdateItemList.add(updateItem);
        }
        this.biddingSupplierService.updateBatchById(batchUpdateItemList, 2000);
    }

    @Override
    public void executeReview(PurchaseQualificationReview review) {
        String headId = review.getRelationId();
        PurchaseBiddingHead dbHead = (PurchaseBiddingHead)((Object)this.getById((Serializable)((Object)headId)));
        if (QualificationReviewEnum.BEFORE_QUOTE.getValue().equals(dbHead.getQualificationReview())) {
            return;
        }
        this.executeReview(dbHead, review);
    }

    @Override
    public List<PurchaseContractHeadDTO> generateContract(PurchaseBiddingHeadVO headVO) {
        String templateNumber = headVO.getTemplateNumber();
        String templateName = headVO.getTemplateName();
        String templateAccount = headVO.getTemplateAccount();
        Integer templateVersion = headVO.getTemplateVersion();
        String id = headVO.getId();
        PurchaseBiddingHead biddingHead = (PurchaseBiddingHead)((Object)((PurchaseBiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((!BiddingStatusEnum.CANCEL.getValue().equals(biddingHead.getBiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_tFIkuxiTtk_19f6e2aa", (String)"\u5355\u636e\u5df2\u4f5c\u5e9f\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        List<PurchaseBiddingItem> biddingItems = this.purchaseBiddingItemService.selectByMainId(id);
        Map<String, List> collect = biddingItems.stream().filter(item -> BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toMap(PurchaseBiddingItem::getToElsAccount, p -> {
            ArrayList<PurchaseBiddingItem> getNameList = new ArrayList<PurchaseBiddingItem>();
            getNameList.add((PurchaseBiddingItem)((Object)p));
            return getNameList;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        if (!CollectionUtils.isEmpty(collect)) {
            Iterator iterator = collect.keySet().stream().iterator();
            ArrayList<PurchaseContractHeadDTO> headDTOS = new ArrayList<PurchaseContractHeadDTO>();
            ArrayList<PurchaseContractItemDTO> itemDTOList = new ArrayList<PurchaseContractItemDTO>();
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                List purchaseBiddingItems = collect.get(next);
                PurchaseContractHeadDTO purchaseContractHeadDTO = this.generateContractheadDTO(biddingHead, (PurchaseBiddingItem)((Object)purchaseBiddingItems.get(0)));
                purchaseContractHeadDTO.setTemplateName(templateName);
                purchaseContractHeadDTO.setTemplateAccount(templateAccount);
                purchaseContractHeadDTO.setTemplateNumber(templateNumber);
                purchaseContractHeadDTO.setTemplateVersion("" + templateVersion);
                List<PurchaseContractItemDTO> itemDTOList1 = this.generateContractItemDTO(biddingHead, purchaseBiddingItems, purchaseContractHeadDTO.getId());
                headDTOS.add(purchaseContractHeadDTO);
                itemDTOList.addAll(itemDTOList1);
            }
            List<PurchaseContractHeadDTO> strings = this.inquiryInvokeContractService.generateContract(headDTOS, itemDTOList, null);
            List<PurchaseBiddingItem> collect1 = biddingItems.stream().filter(item -> BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
            this.goBackDemandUseForDel(collect1, PurchaseRequestStatusItemEnum.CONTRACT_BUILT.getValue());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseBiddingHead::getGenerateContract, (Object)"1")).eq(ParentEntity::getId, (Object)id)).update((Object)new PurchaseBiddingHead());
            return strings;
        }
        return null;
    }

    public PurchaseContractHeadDTO generateContractheadDTO(PurchaseBiddingHead head, PurchaseBiddingItem item) {
        PurchaseContractHeadDTO purchaseContractHeadDTO = new PurchaseContractHeadDTO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)purchaseContractHeadDTO);
        purchaseContractHeadDTO.setId(IdWorker.getIdStr());
        purchaseContractHeadDTO.setToElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setSupplierName(item.getSupplierName());
        purchaseContractHeadDTO.setSupplierCode(item.getSupplierCode());
        purchaseContractHeadDTO.setInvoicedElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setInvoicedErpCode(item.getSupplierCode());
        purchaseContractHeadDTO.setInvoicedName(item.getSupplierName());
        purchaseContractHeadDTO.setPerformingPartyElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setPerformingPartyName(item.getSupplierName());
        purchaseContractHeadDTO.setPerformingPartyCode(item.getSupplierCode());
        purchaseContractHeadDTO.setPayeeElsAccount(item.getToElsAccount());
        purchaseContractHeadDTO.setPayeeName(item.getSupplierName());
        purchaseContractHeadDTO.setPayeeErpCode(item.getSupplierCode());
        purchaseContractHeadDTO.setDocumentId(head.getDocumentId());
        purchaseContractHeadDTO.setDocumentParentId(head.getId());
        purchaseContractHeadDTO.setContractDesc(head.getBiddingDesc());
        purchaseContractHeadDTO.setContractName(head.getProjectName());
        purchaseContractHeadDTO.setContractName(head.getProjectName());
        purchaseContractHeadDTO.setAuditStatus(null);
        purchaseContractHeadDTO.setFlowId(null);
        purchaseContractHeadDTO.setCreateBy(null);
        purchaseContractHeadDTO.setCreateTime(null);
        purchaseContractHeadDTO.setCreateById(null);
        purchaseContractHeadDTO.setUpdateBy(null);
        purchaseContractHeadDTO.setUpdateTime(null);
        return purchaseContractHeadDTO;
    }

    public List<PurchaseContractItemDTO> generateContractItemDTO(PurchaseBiddingHead head, List<PurchaseBiddingItem> itemList, String id) {
        ArrayList<PurchaseContractItemDTO> itemDTOList = new ArrayList<PurchaseContractItemDTO>();
        for (PurchaseBiddingItem purchaseBiddingItem : itemList) {
            PurchaseContractItemDTO purchaseContractItemDTO = new PurchaseContractItemDTO();
            BeanUtils.copyProperties((Object)((Object)purchaseBiddingItem), (Object)purchaseContractItemDTO);
            purchaseContractItemDTO.setHeadId(id);
            purchaseContractItemDTO.setDocumentParentId(purchaseBiddingItem.getId());
            purchaseContractItemDTO.setQuantity(purchaseBiddingItem.getQuotaQuantity());
            purchaseContractItemDTO.setTaxAmount(purchaseBiddingItem.getQuotaTaxAmount());
            purchaseContractItemDTO.setNetAmount(purchaseBiddingItem.getQuotaNetAmount());
            purchaseContractItemDTO.setId(null);
            purchaseContractItemDTO.setCreateBy(null);
            purchaseContractItemDTO.setCreateTime(null);
            purchaseContractItemDTO.setCreateById(null);
            purchaseContractItemDTO.setUpdateBy(null);
            purchaseContractItemDTO.setUpdateTime(null);
            purchaseContractItemDTO.setSourceItemId(purchaseBiddingItem.getId());
            purchaseContractItemDTO.setSourceType("bidding");
            purchaseContractItemDTO.setSourceId(purchaseBiddingItem.getHeadId());
            purchaseContractItemDTO.setSourceItemNumber(purchaseBiddingItem.getItemNumber());
            purchaseContractItemDTO.setSourceNumber(purchaseBiddingItem.getBiddingNumber());
            itemDTOList.add(purchaseContractItemDTO);
        }
        return itemDTOList;
    }

    @Override
    public void executeReview(PurchaseBiddingHead dbHead, PurchaseQualificationReview review) {
        String headId = dbHead.getId();
        ElsInitialTableDTO initInfo = this.invokeBaseRpcService.selectElsInitialTableOne(headId);
        List initItemList = JSON.parseArray((String)initInfo.getBusinessInfoJson(), PurchaseBiddingItem.class);
        List initAttachmentItemList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(headId);
        if (StrUtil.isBlank((CharSequence)review.getSupplierId())) {
            SupplierMasterDataDTO masterData = this.inquiryInvokeSupplierRpcService.getByAccount(dbHead.getElsAccount(), review.getToElsAccount());
            review.setSupplierId(masterData.getId());
        }
        ArrayList supplierList = Lists.newArrayList();
        BiddingSupplier supplier = new BiddingSupplier();
        supplier.setToElsAccount(review.getToElsAccount());
        supplier.setSupplierCode(review.getSupplierCode());
        supplier.setSupplierName(review.getSupplierName());
        supplier.setId(review.getSupplierId());
        supplier.setSourceType(SupplierSourceTypeEnum.PUBLIC.getValue());
        supplier.setContacts(review.getContacts());
        supplier.setPhone(review.getPhone());
        supplier.setEmail(review.getEmail());
        supplier.setReplyStatus(ReplyStatusEnum.REPLYED.getValue());
        supplier.setReplyTime(review.getCreateTime());
        supplierList.add(supplier);
        List<PurchaseBiddingItem> dbItemList = this.purchaseBiddingItemMapper.selectByMainId(headId);
        if (StrUtil.isBlank((CharSequence)dbItemList.get(0).getToElsAccount())) {
            this.purchaseBiddingItemMapper.deleteByMainId(headId);
        }
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(review.getId());
        purchaseAttachmentList.forEach(attachment -> {
            attachment.setId(null);
            attachment.setHeadId(dbHead.getId());
            attachment.setBusinessType("bidding");
        });
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        AttachmentSendDTO sendVO = this.publishBidding(dbHead, initItemList, supplierList, initAttachmentItemList, true);
        this.saveSaleAttachment(purchaseAttachmentList, sendVO);
        PurchaseClarificationInfoService purchaseClarificationInfoService = (PurchaseClarificationInfoService)SpringContextUtils.getBean(PurchaseClarificationInfoServiceImpl.class);
        purchaseClarificationInfoService.addClarificationInfoForSupplier(BusinessBillTypeEnum.CALL_BIDS.getValue(), dbHead.getBiddingNumber(), supplier.getToElsAccount(), supplier.getSupplierName());
    }

    private void saveSaleAttachment(List<PurchaseAttachmentDTO> purchaseAttachmentList, AttachmentSendDTO sendVO) {
        ArrayList saleAttachmentDTOList = new ArrayList();
        String saleHeadId = sendVO.getToSend().keySet().stream().findFirst().map(Object::toString).orElse("");
        purchaseAttachmentList.forEach(e -> {
            SaleAttachmentDTO saleAttachmentDTO = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)e, (Object)saleAttachmentDTO);
            saleAttachmentDTO.setHeadId(saleHeadId);
            saleAttachmentDTO.setId(null);
            saleAttachmentDTO.setSendStatus("1");
            saleAttachmentDTOList.add(saleAttachmentDTO);
        });
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentDTOList);
    }

    private void checkPermission(String id) {
        LoginUserDTO user = SysUtil.getLoginUser();
        List specialistList = this.purchaseBiddingSpecialistMapper.selectByMainId(id).stream().filter(o -> MemberTypeEnum.PROJECT.getValue().equals(o.getMemberType())).filter(o -> MemberRoleEnum.BID_PRINCIPAL.getValue().equals(o.getMemberRole())).map(PurchaseBiddingSpecialist::getSubAccount).collect(Collectors.toList());
        if (!specialistList.contains(user.getSubAccount())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_bidding_principal_bidding", (String)"\u53ea\u6709\u62db\u6807\u8d1f\u8d23\u4eba\u53ef\u4ee5\u64cd\u4f5c\uff01"));
        }
    }

    @Override
    @Transactional
    public void openBidding(String id) {
        this.checkPermission(id);
        PurchaseBiddingHead dbHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)id)));
        Assert.isTrue((!BiddingStatusEnum.CANCEL.getValue().equals(dbHead.getBiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_tFIkuxiTtk_19f6e2aa", (String)"\u5355\u636e\u5df2\u4f5c\u5e9f\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        if (dbHead.getPlanOpenBidTime().after(new Date())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_bid_open_time_not_arrived_bidding", (String)"\u5f00\u6807\u65f6\u95f4\u672a\u5230\uff0c\u6682\u4e0d\u80fd\u5f00\u6807\uff01"));
        }
        this.failureBidAlert(id, "2");
        List<PurchaseBiddingSpecialist> specialist = this.purchaseBiddingSpecialistMapper.selectByMainId(id);
        List<String> specialistList = specialist.stream().filter(o -> MemberTypeEnum.EVA_BID.getValue().equals(o.getMemberType())).map(PurchaseBiddingSpecialist::getSubAccount).collect(Collectors.toList());
        if (specialistList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VRRSuILUBsuKHcvBW_c48b9309", (String)"\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u4f4d\u8bc4\u6807\u4e13\u5bb6\u518d\u8fdb\u884c\u5f00\u6807\uff01"));
        }
        PurchaseBiddingHead updateHead = new PurchaseBiddingHead();
        Date realityOpenBidTime = new Date();
        updateHead.setId(id);
        updateHead.setRealityOpenBidTime(realityOpenBidTime);
        updateHead.setBiddingStatus(BiddingStatusEnum.EVA_BIDDING.getValue());
        int count = this.purchaseBiddingHeadMapper.updateById((Object)updateHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        this.saleBiddingHeadService.updateByMainId(id, BiddingStatusEnum.EVA_BIDDING.getValue(), realityOpenBidTime);
        this.sendOpenBidMsg(dbHead, specialistList, "openBid");
    }

    @Override
    @SrmTransaction
    public void openBidAlert(String id) {
        PurchaseBiddingHead dbHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)id)));
        List<String> specialistList = this.purchaseBiddingSpecialistMapper.selectByMainId(id).stream().filter(o -> MemberTypeEnum.PROJECT.getValue().equals(o.getMemberType())).filter(o -> MemberRoleEnum.BID_PRINCIPAL.getValue().equals(o.getMemberRole())).map(PurchaseBiddingSpecialist::getSubAccount).collect(Collectors.toList());
        String elsAccount = dbHead.getElsAccount();
        TenantContext.setTenant((String)elsAccount);
        this.sendOpenBidMsg(dbHead, specialistList, "openBidAlert");
    }

    @Override
    @SrmTransaction
    public void failureBidAlert(String id, String type) {
        List quoteList;
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)id)));
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierMapper.selectByMainId(id);
        if ("1".equals(type)) {
            List replyList;
            if ("1".equals(head.getNeedEcho()) && (long)(replyList = biddingSupplierList.stream().filter(supplier -> ReplyStatusEnum.REPLYED.getValue().equals(supplier.getReplyStatus()) || ReplyStatusEnum.PART_REPLYED.getValue().equals(supplier.getReplyStatus()) || ReplyStatusEnum.QUOTE_BID.getValue().equals(supplier.getReplyStatus())).collect(Collectors.toList())).size() < head.getParticipateQuantity()) {
                head.setBiddingStatus(BiddingStatusEnum.BID_FAILURE.getValue());
                int count = this.purchaseBiddingHeadMapper.updateById((Object)head);
                if (count == 0) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
                }
                this.saleBiddingHeadService.updateByMainId(head.getId(), BiddingStatusEnum.BID_FAILURE.getValue(), null);
            }
        } else if ("2".equals(type) && (long)(quoteList = biddingSupplierList.stream().filter(supplier -> ReplyStatusEnum.QUOTE_BID.getValue().equals(supplier.getReplyStatus())).collect(Collectors.toList())).size() < head.getParticipateQuantity()) {
            head.setBiddingStatus(BiddingStatusEnum.BID_FAILURE.getValue());
            int count = this.purchaseBiddingHeadMapper.updateById((Object)head);
            if (count == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            }
            this.saleBiddingHeadService.updateByMainId(head.getId(), BiddingStatusEnum.BID_FAILURE.getValue(), null);
        }
    }

    private void sendOpenBidMsg(PurchaseBiddingHead dbHead, List<String> specialistList, String optType) {
        List accountList = this.invokeAccountRpcService.getAccountList(dbHead.getElsAccount(), specialistList);
        JSONObject msgObj = new JSONObject();
        msgObj.put("msgKey", (Object)IdWorker.getIdStr());
        msgObj.put("busAccount", (Object)TenantContext.getTenant());
        msgObj.put("businessType", (Object)"bidding");
        msgObj.put("operateType", (Object)optType);
        msgObj.put("businessObj", (Object)dbHead);
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        if (loginUser == null) {
            InvokeAccountRpcService invokeAccountRpcService = (InvokeAccountRpcService)SpringContextUtils.getBean(InvokeAccountRpcService.class);
            ElsSubAccountDTO account = invokeAccountRpcService.getAccount(dbHead.getElsAccount(), dbHead.getCreateBy());
            loginUser = (LoginUserDTO)JSONObject.parseObject((String)JSON.toJSONString((Object)account), LoginUserDTO.class);
        }
        msgObj.put("sendObj", (Object)loginUser);
        Map<String, List<ElsSubAccountDTO>> accountMap = accountList.stream().collect(Collectors.groupingBy(ParentEntityDTO::getElsAccount));
        JSONArray array = new JSONArray();
        for (String elsAccount : accountMap.keySet()) {
            List<ElsSubAccountDTO> list = accountMap.get(elsAccount);
            JSONObject receiveObj = new JSONObject();
            receiveObj.put("elsAccount", (Object)elsAccount);
            receiveObj.put("urlParam", (Object)"");
            receiveObj.put("toSubAccountList", (Object)JSONObject.parseArray((String)JSON.toJSONString(list)));
            array.add((Object)receiveObj);
        }
        msgObj.put("receiveList", (Object)array);
        List collect = accountList.stream().map(ParentEntityDTO::getId).collect(Collectors.toList());
        BusMessageVO build = BusMessageVO.builder().businessId(dbHead.getId()).msgConfigCode("bidding_" + optType).businessBean("biddingBusDataServiceImpl").receiveSubAccountIdList(collect).build();
        super.sendMessage(build);
    }

    private void validPublishParams(PurchaseBiddingHead purchaseBiddingHead) {
        if ("1".equals(purchaseBiddingHead.getNeedEcho()) && purchaseBiddingHead.getEchoEndTime() == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_dBKIxOLV_1aca3d81", (String)"\u5e94\u6807\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (purchaseBiddingHead.getBidEndTime() == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eByRKIxOLV_43ce1e58", (String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if ("1".equals(purchaseBiddingHead.getNeedEcho()) && DateUtil.between((Date)new Date(), (Date)purchaseBiddingHead.getEchoEndTime(), (DateUnit)DateUnit.MINUTE, (boolean)false) < 5L) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_dBKIGRRH_36d781cb", (String)"\u5e94\u6807\u65f6\u95f4\u8bbe\u7f6e\u8fc7\u8fd1"));
        }
        if (DateUtil.between((Date)new Date(), (Date)purchaseBiddingHead.getBidEndTime(), (DateUnit)DateUnit.MINUTE, (boolean)false) < 5L) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eByRKIGRRH_5fdb62a2", (String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4\u8bbe\u7f6e\u8fc7\u8fd1"));
        }
        if (purchaseBiddingHead.getPlanOpenBidTime() != null && DateUtil.between((Date)new Date(), (Date)purchaseBiddingHead.getPlanOpenBidTime(), (DateUnit)DateUnit.MINUTE, (boolean)false) < (long)(5 + (purchaseBiddingHead.getOpenBidAlertMinute() != null ? purchaseBiddingHead.getOpenBidAlertMinute() : 0))) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_vBKIGRRH_9d66fdf", (String)"\u5f00\u6807\u65f6\u95f4\u8bbe\u7f6e\u8fc7\u8fd1"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void copyData(PurchaseBiddingHeadVO purchaseBiddingHeadVO) {
        PurchaseBiddingHead purchaseBiddingHead = (PurchaseBiddingHead)((Object)SysUtil.copyProperties((Object)((Object)purchaseBiddingHeadVO), PurchaseBiddingHead.class));
        this.builderHead(purchaseBiddingHead);
        List<PurchaseBiddingItem> purchaseBiddingItemList = null;
        if ("0".equals(purchaseBiddingHeadVO.getBiddingStatus())) {
            Map biddingItemMap = purchaseBiddingHeadVO.getPurchaseBiddingItemList().stream().collect(Collectors.toMap(PurchaseBiddingItem::getItemNumber, Function.identity(), (o1, o2) -> o1));
            purchaseBiddingItemList = new ArrayList<PurchaseBiddingItem>();
            for (PurchaseBiddingItem value : biddingItemMap.values()) {
                value.setSupplierCode("");
                value.setSupplierName("");
                value.setSupplierRemark("");
                value.setToElsAccount("");
                purchaseBiddingItemList.add(value);
            }
        } else {
            purchaseBiddingItemList = purchaseBiddingHeadVO.getInitItemList();
        }
        this.builderItem(purchaseBiddingItemList);
        List<BiddingSupplier> biddingSupplierList = purchaseBiddingHeadVO.getBiddingSupplierList();
        this.builderSupplier(biddingSupplierList);
        List<PurchaseBiddingSpecialist> biddingSpecialists = purchaseBiddingHeadVO.getPurchaseBiddingSpecialistList();
        if (CollectionUtil.isNotEmpty(biddingSpecialists)) {
            biddingSpecialists = biddingSpecialists.stream().filter(item -> "2".equals(item.getMemberType())).collect(Collectors.toList());
        }
        if (CollectionUtil.isNotEmpty(biddingSpecialists)) {
            biddingSpecialists.stream().forEach(item -> item.setId(null));
        }
        List<PurchaseAttachmentDemandDTO> purchaseAttachmentDemandDTOList = purchaseBiddingHeadVO.getPurchaseAttachmentDemandList();
        this.saveMain(purchaseBiddingHead, purchaseBiddingItemList, biddingSupplierList, biddingSpecialists, purchaseAttachmentDemandDTOList, new ArrayList<PurchaseAttachmentDTO>());
    }

    private void builderItem(List<PurchaseBiddingItem> purchaseBiddingItemList) {
        purchaseBiddingItemList.parallelStream().forEach(item -> {
            item.setReplyStatus(null);
            item.setPrice(null);
            item.setNetPrice(null);
            item.setTaxAmount(null);
            item.setNetAmount(null);
            item.setQuotaTaxAmount(null);
            item.setQuotaNetAmount(null);
            item.setEffectiveDate(null);
            item.setExpiryDate(null);
            item.setQuota(null);
            item.setPurchaseRemark(null);
            item.setSupplierRemark(null);
            item.setConfirmBidTime(null);
            item.setCreateById(null);
            item.setCreateBy(null);
            item.setCreateTime(null);
            item.setId(null);
            item.setEffectiveDate(null);
            item.setExpiryDate(null);
        });
    }

    private void builderSupplier(List<BiddingSupplier> biddingSupplierList) {
        biddingSupplierList.parallelStream().forEach(item -> {
            item.setReplyStatus(null);
            item.setReplyTime(null);
            item.setQuaCheckResult(null);
            item.setBidEva(null);
            item.setRecommend(null);
            item.setBidCheck(null);
            item.setBidQuote(null);
            item.setBiddingStatus(null);
            item.setQuota(null);
            item.setPurchaseRemark(null);
            item.setSupplierRemark(null);
            item.setConfirmBidTime(null);
            item.setEmail(null);
            item.setPhone(null);
            item.setContacts(null);
        });
    }

    @Override
    public List<SaleBiddingAttachmentVO> queryAttachmentBySupplierAccount(String id, String supplierAccount) {
        List dbAttachmentDTOList;
        SaleBiddingAttachmentVO saleBiddingAttachmentVO;
        PurchaseQualificationReview purchaseQualificationReview;
        List<PurchaseAttachmentDTO> attachmentDTOList;
        ArrayList<SaleBiddingAttachmentVO> saleBiddingAttachmentVOList = new ArrayList<SaleBiddingAttachmentVO>(2);
        PurchaseBiddingHead biddingHead = (PurchaseBiddingHead)((Object)((PurchaseBiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        PurchaseQualificationReviewService reviewService = (PurchaseQualificationReviewService)SpringContextUtils.getBean(PurchaseQualificationReviewService.class);
        List<PurchaseQualificationReview> qualificationReviews = reviewService.selectByMainId(id);
        if (CollectionUtil.isNotEmpty(qualificationReviews) && CollectionUtil.isNotEmpty(qualificationReviews = qualificationReviews.stream().filter(review -> supplierAccount.equals(review.getToElsAccount())).collect(Collectors.toList())) && CollectionUtil.isNotEmpty((Collection)(attachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId((purchaseQualificationReview = qualificationReviews.get(0)).getId())))) {
            saleBiddingAttachmentVO = new SaleBiddingAttachmentVO();
            saleBiddingAttachmentVO.setPurchaseAttachmentDTOList(attachmentDTOList);
            saleBiddingAttachmentVO.setTitle("\u62a5\u540d\u9644\u4ef6");
            saleBiddingAttachmentVOList.add(saleBiddingAttachmentVO);
        }
        if (!BiddingStatusEnum.NEW.getValue().equals(biddingHead.getBiddingStatus()) && !BiddingStatusEnum.BIDDING.getValue().equals(biddingHead.getBiddingStatus()) && CollectionUtil.isNotEmpty(attachmentDTOList = (dbAttachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id)).stream().filter(item -> supplierAccount.equals(item.getUploadElsAccount())).collect(Collectors.toList()))) {
            saleBiddingAttachmentVO = new SaleBiddingAttachmentVO();
            saleBiddingAttachmentVO.setPurchaseAttachmentDTOList(attachmentDTOList);
            saleBiddingAttachmentVO.setTitle("\u6295\u6807\u9644\u4ef6");
            saleBiddingAttachmentVOList.add(saleBiddingAttachmentVO);
        }
        return saleBiddingAttachmentVOList;
    }

    @Override
    public JSONObject getBiddingDataById(String id) {
        PurchaseBiddingHeadVO purchaseBiddingHeadVO = this.getMessageById(id);
        if (purchaseBiddingHeadVO == null) {
            return null;
        }
        return ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)purchaseBiddingHeadVO, new DictTranslateAspectParam());
    }

    @Override
    public JSONArray getBiddingDataById(List<String> ids) {
        JSONArray array = new JSONArray();
        ids.forEach(id -> array.add((Object)this.getBiddingDataById((String)id)));
        return array;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateBidComfirmResult(String id) {
        PurchaseBiddingHead biddingHead = (PurchaseBiddingHead)((Object)this.getById((Serializable)((Object)id)));
        Assert.isTrue((!BiddingStatusEnum.CANCEL.getValue().equals(biddingHead.getBiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_tFIkuxiTtk_19f6e2aa", (String)"\u5355\u636e\u5df2\u4f5c\u5e9f\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        LoginUserDTO user = SysUtil.getLoginUser();
        List purchaseBiddingSpecialistList = this.purchaseBiddingSpecialistService.selectByMainId(id).stream().filter(o -> MemberTypeEnum.PROJECT.getValue().equals(o.getMemberType()) && MemberRoleEnum.BID_PRINCIPAL.getValue().equals(o.getMemberRole())).collect(Collectors.toList());
        List specialistList = purchaseBiddingSpecialistList.stream().filter(o -> o.getSubAccount().equals(user.getSubAccount())).collect(Collectors.toList());
        if (specialistList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RjAPYBtjUBsuAHIByRW_e5f72175", (String)"\u53ea\u6709\u5f53\u524d\u62db\u6807\u5355\u7684\u8bc4\u6807\u4e13\u5bb6\u53d8\u66f4\u5b9a\u6807\u7ed3\u679c\uff01"));
        }
        this.purchaseConfirmBiddingHisService.saveConfirmBidData(id);
        ((PurchaseBiddingHeadMapper)this.baseMapper).update((Object)new PurchaseBiddingHead(), (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ParentEntity::getId, (Object)id)).set(PurchaseBiddingHead::getBiddingStatus, (Object)BiddingStatusEnum.CONFIRM_ING.getValue()));
        this.purchaseBiddingItemMapper.update((Object)new PurchaseBiddingItem(), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseBiddingItem::getHeadId, (Object)id)).set(PurchaseBiddingItem::getQuota, null)).set(PurchaseBiddingItem::getItemStatus, (Object)BiddingItemStatusEnum.BID_QUOTE.getValue()));
        this.saleBiddingHeadService.updateByMainId(id, BiddingStatusEnum.CONFIRM_ING.getValue(), null);
    }

    @Override
    public void checkEnquirySameMaterial(List<PurchaseBiddingItem> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        for (int i = 0; i < itemList.size(); ++i) {
            if (!StrUtil.isBlank((CharSequence)itemList.get(i).getItemNumber())) continue;
            itemList.get(i).setItemNumber(String.valueOf(i + 1));
        }
        Map<String, List<PurchaseBiddingItem>> groupMap = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getMaterialNumber())).collect(Collectors.groupingBy(item -> {
            String materialNumber = StrUtil.isNotBlank((CharSequence)item.getMaterialNumber()) ? item.getMaterialNumber() : "";
            String factory = StrUtil.isNotBlank((CharSequence)item.getFactory()) ? item.getFactory() : "";
            String storageLocation = StrUtil.isNotBlank((CharSequence)item.getStorageLocation()) ? item.getStorageLocation() : "";
            return materialNumber + "_" + factory + "_" + storageLocation;
        }));
        groupMap.forEach((key, values) -> {
            if (values.size() > 1) {
                List itemNumber = values.stream().map(PurchaseBiddingItem::getItemNumber).collect(Collectors.toList());
                String msg = "\u884c\u53f7\uff1a${0}\uff0c\u540c\u4e00\u4e2a\u7269\u6599\u540c\u5de5\u5382\u540c\u5e93\u5b58\u5730\u70b9\uff0c\u65e0\u6cd5\u540c\u65f6\u62db\u6807\uff01";
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_Ey0eImSLeRHeGMnCSheKYB_d0067828", (String)msg, (String[])new String[]{"{" + StrUtil.join((CharSequence)"}\u3001{", itemNumber) + "}"}));
            }
        });
    }

    private void checkMaterialNumber(List<PurchaseBiddingItem> itemList) {
        List<String> materialNumbers = itemList.stream().map(PurchaseBiddingItem::getMaterialNumber).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(materialNumbers)) {
            Map<String, String> materialItemNumberMap = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getMaterialNumber())).collect(Collectors.toMap(PurchaseBiddingItem::getMaterialNumber, PurchaseBiddingItem::getItemNumber, (v1, v2) -> v1));
            List<PurchaseMaterialHeadDTO> purchaseMaterialHeadDTOS = this.purchaseMaterialHeadService.listByMaterialNumbers(materialNumbers);
            List blocDelMaterial = purchaseMaterialHeadDTOS.stream().filter(material -> "1".equals(material.getBlocDel())).collect(Collectors.toList());
            String str = blocDelMaterial.stream().map(p -> p.getMaterialNumber() + "\u3010" + (String)materialItemNumberMap.get(p.getMaterialNumber()) + "\u3011").collect(Collectors.joining(","));
            Assert.isTrue((boolean)CollectionUtils.isEmpty(blocDelMaterial), (String)I18nUtil.translate((String)"i18n_alert_SLAo0cSLIqQG_1fb7a3b6", (String)"\u7269\u6599\u7f16\u7801:${0}\u884c\u7269\u6599\u5df2\u88ab\u5220\u9664", (String[])new String[]{str}));
        }
    }

    private PurchaseBiddingHeadVO getMessageById(String id) {
        PurchaseBiddingHead purchaseRequestHead = (PurchaseBiddingHead)((Object)this.getById((Serializable)((Object)id)));
        if (purchaseRequestHead == null) {
            return null;
        }
        PurchaseBiddingHeadVO purchaseRequestHeadVO = new PurchaseBiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHead), (Object)((Object)purchaseRequestHeadVO));
        List<PurchaseBiddingItem> purchaseRequestItemList = this.purchaseBiddingItemMapper.selectByMainId(id);
        purchaseRequestHeadVO.setPurchaseBiddingItemList(purchaseRequestItemList);
        return purchaseRequestHeadVO;
    }

    public void builderHead(PurchaseBiddingHead purchaseBiddingHead) {
        purchaseBiddingHead.setId(null);
        purchaseBiddingHead.setBiddingNumber(this.invokeBaseRpcService.getNextCode("srmBiddingNumber", (Object)purchaseBiddingHead));
        purchaseBiddingHead.setCreateBy(null);
        purchaseBiddingHead.setCreateTime(null);
        purchaseBiddingHead.setUpdateBy(null);
        purchaseBiddingHead.setPublishTime(null);
        purchaseBiddingHead.setPublishUser(null);
        purchaseBiddingHead.setUpdateTime(null);
        purchaseBiddingHead.setRealityOpenBidTime(null);
        purchaseBiddingHead.setCurrentRound(null);
        purchaseBiddingHead.setConfirmBidBy(null);
        purchaseBiddingHead.setConfirmBidIp(null);
        purchaseBiddingHead.setEconomyAmount(null);
        purchaseBiddingHead.setEconomyRate(null);
        purchaseBiddingHead.setUpdateById(null);
        purchaseBiddingHead.setCreateById(null);
        purchaseBiddingHead.setFlowId(null);
        purchaseBiddingHead.setResultFlowId(null);
        purchaseBiddingHead.setGenerateContract("0");
    }

    @Async
    void sendIntegratedHeadData(String id) {
        PurchaseBiddingHeadVO headVO = new PurchaseBiddingHeadVO();
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)((PurchaseBiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
        List<PurchaseBiddingItem> purchaseRequestItemList = this.purchaseBiddingItemMapper.selectByMainId(id);
        headVO.setPurchaseBiddingItemList(purchaseRequestItemList);
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)headVO, new DictTranslateAspectParam());
        MqUtil.sendIntegrateDataMsg((String)head.getDocumentId(), (String)"bidding", (String)id, (String)"head", (JSONObject)jsonObject);
    }

    @Async
    void sendIntegratedItemData(String id) {
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)((PurchaseBiddingHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        PurchaseBiddingItem item = (PurchaseBiddingItem)((Object)this.purchaseBiddingItemMapper.selectById((Serializable)((Object)id)));
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)head, new DictTranslateAspectParam());
        jsonObject.put("bidding_head", (Object)jsonObject);
        MqUtil.sendIntegrateDataMsg((String)item.getDocumentItemId(), (String)"bidding", (String)id, (String)"item", (JSONObject)jsonObject);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addTalkPrice(PurchaseBiddingHeadVO purchaseBiddingHeadVO) {
        boolean flag;
        PurchaseBiddingHead head = (PurchaseBiddingHead)((Object)this.getById((Serializable)((Object)purchaseBiddingHeadVO.getId())));
        boolean bl = flag = head != null && !BiddingStatusEnum.CONFIRM_ING.getValue().equals(head.getBiddingStatus()) && !BiddingStatusEnum.TALK_PRICE.getValue().equals(head.getBiddingStatus());
        if (flag) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_APzExOssu_542f692a", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u91cd\u62a5\u4ef7"));
        }
        List<BiddingSupplier> biddingSupplierList = purchaseBiddingHeadVO.getBiddingSupplierList();
        Assert.notEmpty(biddingSupplierList, (String)I18nUtil.translate((String)"i18n_alert_RdXRtxOLV_8c4d365c", (String)"\u4f9b\u5e94\u5546\u540d\u5355\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        List supplierAccounts = biddingSupplierList.stream().map(BiddingSupplier::getToElsAccount).distinct().collect(Collectors.toList());
        List<SaleBiddingHead> saleBiddingHeads = this.saleBiddingHeadMapper.selectByMainId(purchaseBiddingHeadVO.getId());
        saleBiddingHeads = saleBiddingHeads.stream().filter(supplier -> supplierAccounts.contains(supplier.getElsAccount())).collect(Collectors.toList());
        saleBiddingHeads.forEach(supplier -> {
            if (new Date().before(supplier.getBidEndTime())) {
                if ("1".equals(supplier.getEnableTalkPrice())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RdX[0]IGRJFIuShKmhA_caffceb7", (String)"\u4f9b\u5e94\u5546[${0}]\u5df2\u8bbe\u7f6e\u8c08\u5224\u8bae\u4ef7 \uff0c\u65e0\u6cd5\u518d\u6b21\u53d1\u8d77", (String[])new String[]{supplier.getElsAccount()}));
                }
                if (!"1".equals(supplier.getOpenPrice())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RdX[0]suLvAShKmhAOVsu_5084967d", (String)"\u4f9b\u5e94\u5546[${0}]\u62a5\u4ef7\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u518d\u6b21\u53d1\u8d77\u591a\u4f26\u62a5\u4ef7", (String[])new String[]{supplier.getElsAccount()}));
                }
            }
            supplier.setEnableTalkPrice("1");
            supplier.setBidEndTime(purchaseBiddingHeadVO.getBidEndTime());
            supplier.setBiddingStatus(BiddingStatusEnum.TALK_PRICE.getValue());
            supplier.setOpenPrice("0");
            supplier.setStage(this.getStage(purchaseBiddingHeadVO.getId()));
        });
        this.saleBiddingHeadService.updateBatchById(saleBiddingHeads);
        PurchaseBiddingHead purchaseBiddingHead = (PurchaseBiddingHead)((Object)this.getById((Serializable)((Object)purchaseBiddingHeadVO.getId())));
        purchaseBiddingHead.setBiddingStatus(BiddingStatusEnum.TALK_PRICE.getValue());
        this.updateById((Object)purchaseBiddingHead);
        this.saveTalkPriceContiune(purchaseBiddingHeadVO, saleBiddingHeads.size());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void openTalkPrice(PurchaseBiddingHeadVO purchaseBiddingHeadPage) {
        String stage = purchaseBiddingHeadPage.getStage();
        List toElsAccounts = purchaseBiddingHeadPage.getBiddingSupplierList().stream().map(BiddingSupplier::getToElsAccount).collect(Collectors.toList());
        List<PurchaseBiddingItem> purchaseBiddingItems = this.purchaseBiddingItemService.selectByMainId(purchaseBiddingHeadPage.getId());
        List<SaleBiddingHead> saleBiddingHeadList = this.saleBiddingHeadService.selectByMainId(purchaseBiddingHeadPage.getId());
        saleBiddingHeadList = saleBiddingHeadList.stream().filter(x -> toElsAccounts.contains(x.getElsAccount())).collect(Collectors.toList());
        List<String> saleIds = saleBiddingHeadList.stream().map(ParentEntity::getId).collect(Collectors.toList());
        List<SaleBiddingItem> saleItemList = this.saleBiddingItemService.selectByMainIds(saleIds);
        for (String toElsAccount : toElsAccounts) {
            List<SaleBiddingItem> salePreFinalItem;
            List<PurchaseBiddingItem> preFinalItem = purchaseBiddingItems.stream().filter(x -> toElsAccount.equals(x.getToElsAccount()) && stage.equals(String.valueOf(x.getTalkPriceStage()))).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(preFinalItem)) {
                List<PurchaseBiddingItem> finalClearItem = purchaseBiddingItems.stream().filter(x -> toElsAccount.equals(x.getToElsAccount()) && "1".equals(String.valueOf(x.getFinalPrice()))).collect(Collectors.toList());
                finalClearItem.forEach(x -> x.setFinalPrice("0"));
                this.purchaseBiddingItemService.updateBatchById(finalClearItem);
                preFinalItem.forEach(x -> x.setFinalPrice("1"));
                this.purchaseBiddingItemService.updateBatchById(preFinalItem);
            }
            if (!CollectionUtil.isNotEmpty(salePreFinalItem = saleItemList.stream().filter(x -> toElsAccount.equals(x.getElsAccount()) && stage.equals(String.valueOf(x.getTalkPriceStage()))).collect(Collectors.toList()))) continue;
            List<SaleBiddingItem> saleFinalClearItem = saleItemList.stream().filter(x -> toElsAccount.equals(x.getElsAccount()) && "1".equals(x.getFinalPrice())).collect(Collectors.toList());
            saleFinalClearItem.forEach(x -> x.setFinalPrice("0"));
            this.saleBiddingItemService.updateBatchById(saleFinalClearItem);
            salePreFinalItem.forEach(x -> x.setFinalPrice("1"));
            this.saleBiddingItemService.updateBatchById(salePreFinalItem);
        }
        saleBiddingHeadList.stream().forEach(x -> x.setOpenPrice("1"));
        this.saleBiddingHeadService.updateBatchById(saleBiddingHeadList);
        List<PurchaseBiddingTalkPriceContinue> talkPriceRecode = this.talkPriceContinueService.selectByMainId(purchaseBiddingHeadPage.getId());
        List priceContinues = talkPriceRecode.stream().filter(x -> stage.equals(String.valueOf(x.getTalkPriceStage()))).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(priceContinues)) {
            PurchaseBiddingTalkPriceContinue priceContinue = (PurchaseBiddingTalkPriceContinue)((Object)priceContinues.get(priceContinues.size() - 1));
            priceContinue.setOpenFlg("1");
            this.talkPriceContinueService.updateById((Object)priceContinue);
        }
    }

    private void saveTalkPriceContiune(PurchaseBiddingHead purchaseBiddingHead, Integer size) {
        PurchaseBiddingTalkPriceContinue talkPriceContinue = new PurchaseBiddingTalkPriceContinue();
        String stage = this.getStage(purchaseBiddingHead.getId());
        talkPriceContinue.setTalkPriceStage(stage);
        talkPriceContinue.setHeadId(purchaseBiddingHead.getId());
        talkPriceContinue.setEndTime(purchaseBiddingHead.getBidEndTime());
        talkPriceContinue.setQuotaNumber(String.valueOf(size));
        if ("1".equals(stage)) {
            talkPriceContinue.setOpenFlg("1");
        }
        this.talkPriceContinueService.save((Object)talkPriceContinue);
    }

    private String getStage(String id) {
        List<PurchaseBiddingTalkPriceContinue> talkPriceList = this.talkPriceContinueService.selectByMainId(id);
        Integer talkPriceStage = 1;
        if (CollectionUtil.isNotEmpty(talkPriceList)) {
            Integer max = talkPriceList.stream().map(PurchaseBiddingTalkPriceContinue::getTalkPriceStage).mapToInt(Integer::parseInt).max().orElse(999);
            talkPriceStage = max + 1;
        } else {
            List<PurchaseBiddingItem> saleBiddingItems = this.purchaseBiddingItemService.selectByMainId(id);
            if (CollectionUtil.isNotEmpty(saleBiddingItems)) {
                for (PurchaseBiddingItem purchaseBiddingItem : saleBiddingItems) {
                    if (purchaseBiddingItem.getTalkPriceStage() != null) continue;
                    purchaseBiddingItem.setTalkPriceStage(talkPriceStage);
                }
                talkPriceStage = saleBiddingItems.stream().mapToInt(PurchaseBiddingItem::getTalkPriceStage).max().getAsInt();
                talkPriceStage = talkPriceStage + 1;
            }
        }
        return String.valueOf(talkPriceStage);
    }
}

