/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.job.utils.EbiddingJobUtil;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.ebidding.service.impl.PurchaseEbiddingHeadServiceImpl;
import com.els.modules.ebidding.service.impl.SaleEbiddingHeadServiceImpl;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RpcService(value="srmEbiddingBeginJobServiceImpl")
public class SrmEbiddingBeginJobDubboServiceImpl
implements JobRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SrmEbiddingBeginJobDubboServiceImpl.class);

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void execute(String parameter) {
        log.info("\u7ade\u4ef7\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1 SrmEbiddingBeginJobDubboServiceImpl \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        if (StrUtil.isEmpty((CharSequence)parameter)) {
            log.error("parameter must not be null.");
            return;
        }
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String id = paramObj.getString("id");
        if (StrUtil.isEmpty((CharSequence)id)) {
            log.error("parameter must contain id.");
            return;
        }
        String tenantId = StrUtil.isBlank((CharSequence)paramObj.getString("tenantId")) ? "100000" : paramObj.getString("tenantId");
        TenantContext.setTenant((String)tenantId);
        SaleEbiddingHeadService saleEbiddingHeadService = (SaleEbiddingHeadService)SpringContextUtils.getBean(SaleEbiddingHeadServiceImpl.class);
        List<SaleEbiddingHead> saleEbiddingHeadList = saleEbiddingHeadService.getByRelationId(id);
        if (saleEbiddingHeadList != null && saleEbiddingHeadList.size() > 0) {
            List waitBiddingList = saleEbiddingHeadList.stream().filter(x -> EbiddingStatusEnum.WAIT_BIDDING.getValue().equals(x.getEbiddingStatus())).collect(Collectors.toList());
            if (waitBiddingList != null && waitBiddingList.size() > 0) {
                PurchaseEbiddingHeadService purchaseEbiddingHeadService = (PurchaseEbiddingHeadService)SpringContextUtils.getBean(PurchaseEbiddingHeadServiceImpl.class);
                purchaseEbiddingHeadService.startBidding(id);
                String jobKey = paramObj.getString("jobKey");
                EbiddingJobUtil.deleteJob(jobKey);
            } else {
                log.error("\u7ade\u4ef7\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1\uff0c\u67e5\u8be2\u7684\u4f9b\u5e94\u5546\u5f85\u7ade\u4ef7\u6570\u636e\u4e3a0\uff0c\u505c\u6b62\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u5bf9\u5e94\u7684\u7ade\u4ef7\u5355\u5934ID\u4e3a\uff1a" + id);
            }
        } else {
            log.error("\u7ade\u4ef7\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1\uff0c\u67e5\u8be2\u53c2\u52a0\u7ade\u4ef7\u7684\u4f9b\u5e94\u5546\u6570\u636e\u4e3a0\uff0c\u505c\u6b62\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u5bf9\u5e94\u7684\u7ade\u4ef7\u5355\u5934ID\u4e3a\uff1a" + id);
        }
        log.info("\u7ade\u4ef7\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1 SrmEbiddingBeginJobDubboServiceImpl \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
    }
}

