/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.api.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmRpcUtil;
import com.els.modules.account.api.service.AccountInfoRpcService;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.modules.im.api.dto.GroupChatRecordDto;
import com.els.modules.im.api.dto.RecordUserDto;
import com.els.modules.im.api.service.GroupChatRecordUserRpcService;
import com.els.modules.im.enums.ImBusinessTypeEnum;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

@RpcService(value="purchaseEnquiryImUserRecordServiceImpl")
public class PurchaseEnquiryUserRecordInvokeDubboServiceImpl
implements GroupChatRecordUserRpcService {
    @Resource
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Resource
    private SaleEnquiryHeadService saleEnquiryHeadService;
    @Resource
    private EnquirySupplierListService enquirySupplierListService;

    public List<RecordUserDto> loadGroupChatUserByRecord(GroupChatRecordDto imRecordDto) {
        AccountInfoRpcService accountInfoRpcService = (AccountInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountInfoRpcService.class);
        ArrayList<RecordUserDto> resultList = new ArrayList<RecordUserDto>();
        if (ImBusinessTypeEnum.PURCHASE_ENQUIRY.getValue().equals(imRecordDto.getBusinessType())) {
            PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)imRecordDto.getBusinessId())));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_hsutWWWWxMK_ab6b9588", (String)"\u8be2\u62a5\u4ef7\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getBusinessId()));
            Assert.isTrue((!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_VIzEWShRe_3e411e67", (String)"\u65b0\u5efa\u72b6\u6001\uff0c\u65e0\u6cd5\u6c9f\u901a"));
            List<EnquirySupplierList> supplierList = this.enquirySupplierListService.selectByMainId(imRecordDto.getBusinessId());
            return this.queryAllUserWithGroupChat(accountInfoRpcService, supplierList.stream().map(EnquirySupplierList::getToElsAccount).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList()));
        }
        if (ImBusinessTypeEnum.SALE_ENQUIRY.getValue().equals(imRecordDto.getBusinessType())) {
            SaleEnquiryHead dbHead = (SaleEnquiryHead)((Object)this.saleEnquiryHeadService.getById((Serializable)((Object)imRecordDto.getBusinessId())));
            Assert.isTrue((null != dbHead ? 1 : 0) != 0, (String)String.format(I18nUtil.translate((String)"i18n_alert_hsutWWWWxMK_ab6b9588", (String)"\u8be2\u62a5\u4ef7\u5355[%s]\u4e0d\u5b58\u5728"), imRecordDto.getBusinessId()));
            String toElsAccount = dbHead.getToElsAccount();
            String subAccount = dbHead.getPublishUser().split("_")[0];
            RecordUserDto e = new RecordUserDto();
            e.setElsAccount(toElsAccount + "_" + subAccount);
            resultList.add(e);
        }
        return resultList;
    }
}

