/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.controller;

import cn.hutool.core.util.StrUtil;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.util.I18nUtil;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.service.PublicEnquiryService;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.vo.PurchaseEnquiryHeadVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openApi/enquiry"})
@Tag(name="\u516c\u5f00\u8be2\u4ef7")
public class PublicEnquiryController
extends BaseController<PurchaseEnquiryHead, PurchaseEnquiryHeadService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PublicEnquiryController.class);
    @Autowired
    private PublicEnquiryService publicEnquiryService;

    @AutoLog(value="\u516c\u5f00\u8be2\u4ef7-B2B\u5e73\u53f0\u62a5\u4ef7")
    @Operation(summary="B2B\u5e73\u53f0\u62a5\u4ef7\u63a5\u53e3", description="B2B\u5e73\u53f0\u62a5\u4ef7\u63a5\u53e3")
    @PostMapping(value={"/quote"})
    @SrmValidated
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:quote"})
    public Result<?> quote(@RequestBody PurchaseEnquiryHeadVO headVO) {
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.publicEnquiryService.getById((Serializable)((Object)headVO.getId())));
        Assert.isTrue((boolean)new Date().before(dbHead.getQuoteEndTime()), (String)I18nUtil.translate((String)"i18n_alert_suIyRWxqsu_b5b56248", (String)"\u62a5\u4ef7\u5df2\u622a\u6b62\uff0c\u4e0d\u53ef\u62a5\u4ef7"));
        List<EnquirySupplierList> supplierList = headVO.getEnquirySupplierListList();
        supplierList.forEach(supplier -> Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)supplier.getToElsAccount()), (String)I18nUtil.translate((String)"i18n_alert_empty_notElsAccount", (String)"\u4f9b\u5e94\u5546\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a")));
        Assert.notEmpty(supplierList, (String)I18nUtil.translate((String)"i18n_alert_empty_notElsAccount", (String)"\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        List<PurchaseEnquiryItem> itemList = headVO.getPurchaseEnquiryItemList();
        Assert.notEmpty(itemList, (String)I18nUtil.translate((String)"i18n_alert_hucVHxOLV_a992f015", (String)"\u8be2\u4ef7\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        this.publicEnquiryService.B2BQuote(dbHead, itemList, supplierList);
        return this.commonSuccessResult(2);
    }
}

