/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.cost.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import cn.hutool.poi.excel.style.StyleUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.FormulaUtil;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateGroupDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.enquiry.cost.service.CostExcelService;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class CostExcelServiceImpl
implements CostExcelService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CostExcelServiceImpl.class);
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    private final String HEAD = "head";
    private final String PURCHASE = "purchase";
    private String account;
    private String templateNumber;
    private String templateVersion;
    private String busAccount;
    private String role = "purchase";

    private void setParams(HttpServletRequest request) {
        String account = request.getParameter("account");
        String templateNumber = request.getParameter("templateNumber");
        String templateVersion = request.getParameter("templateVersion");
        String busAccount = request.getParameter("busAccount");
        Assert.hasText((String)account, (String)I18nUtil.translate((String)"i18n_alert_WWWWWWWxOLV_58e1afbd", (String)"account\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)templateNumber, (String)I18nUtil.translate((String)"i18n_alert_WWWWWWWWWWWWWWxOLV_804b6b3d", (String)"templateNumber\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)templateVersion, (String)I18nUtil.translate((String)"i18n_alert_WWWWWWWWWWWWWWWxOLV_12b4200e", (String)"templateVersion\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)busAccount, (String)I18nUtil.translate((String)"i18n_alert_WWWWWWWWWWxOLV_a9e1c91d", (String)"busAccount\u4e0d\u80fd\u4e3a\u7a7a"));
        this.account = account;
        this.templateNumber = templateNumber;
        this.templateVersion = templateVersion;
        this.busAccount = busAccount;
        String role = request.getParameter("role");
        this.role = StrUtil.isBlank((CharSequence)role) ? this.role : role;
    }

    private TemplateHeadDTO getConfig() {
        return this.invokeBaseRpcService.getTemplateConfig(this.account, this.templateNumber, this.templateVersion);
    }

    private void setRedFont(ExcelWriter writer, int x) {
        Font redFont = writer.createFont();
        redFont.setColor((short)10);
        CellStyle cellStyle = StyleUtil.createDefaultCellStyle((Workbook)writer.getWorkbook());
        cellStyle.setFont(redFont);
        writer.setStyle(cellStyle, x, 1);
    }

    private List<DictDTO> getDictList(String dictCode) {
        String code = "";
        String text = null;
        String table = null;
        String valueText = null;
        if (dictCode.contains("#") || dictCode.contains(",")) {
            String[] dictCodeArray = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
            switch (dictCodeArray.length) {
                case 4: {
                    code = dictCodeArray[3];
                    break;
                }
                case 3: {
                    valueText = dictCodeArray[2];
                    text = dictCodeArray[1];
                    table = dictCodeArray[0];
                    break;
                }
            }
        } else {
            code = dictCode;
        }
        List dictList = this.invokeBaseRpcService.queryDictItemsByCode(code, this.busAccount);
        return dictList;
    }

    private void setSelect(ExcelWriter writer, int lastRow, int col, String dictCode) {
        CellRangeAddressList cellRange = new CellRangeAddressList(2, lastRow, col, col);
        List<DictDTO> dictList = this.getDictList(dictCode);
        List<String> dictTextList = dictList.stream().map(DictDTO::getText).distinct().collect(Collectors.toList());
        String[] distTexts = dictTextList.toArray(new String[0]);
        writer.addSelect(cellRange, distTexts);
    }

    private List<TemplateConfigHeadDTO> getHeadConfig(TemplateHeadDTO headVO, String groupCode) {
        List<Object> headList = "purchase".equals(this.role) ? headVO.getTemplateConfigHeadList().stream().filter(head -> "1".equals(head.getPurchaseShow())).filter(head -> groupCode.equals(head.getGroupCode())).collect(Collectors.toList()) : headVO.getTemplateConfigHeadList().stream().filter(head -> "1".equals(head.getSaleShow())).filter(head -> groupCode.equals(head.getGroupCode())).collect(Collectors.toList());
        return headList;
    }

    private List<TemplateConfigItemDTO> getItemConfig(TemplateHeadDTO headVO, String groupCode) {
        List<Object> itemList = "purchase".equals(this.role) ? headVO.getTemplateConfigItemList().stream().filter(item -> "1".equals(item.getPurchaseShow())).filter(item -> groupCode.equals(item.getGroupCode())).collect(Collectors.toList()) : headVO.getTemplateConfigItemList().stream().filter(item -> "1".equals(item.getSaleShow())).filter(item -> groupCode.equals(item.getGroupCode())).collect(Collectors.toList());
        return itemList;
    }

    private boolean isEdit(TemplateConfigHeadDTO head) {
        return "purchase".equals(this.role) ? "1".equals(head.getPurchaseEdit()) : "1".equals(head.getSaleEdit());
    }

    private boolean isEdit(TemplateConfigItemDTO item) {
        return "purchase".equals(this.role) ? "1".equals(item.getPurchaseEdit()) : "1".equals(item.getSaleEdit());
    }

    private boolean isRequired(TemplateConfigHeadDTO head) {
        return this.isEdit(head) && "1".equals(head.getRequired());
    }

    private boolean isRequired(TemplateConfigItemDTO item) {
        return this.isEdit(item) && "1".equals(item.getRequired());
    }

    @Override
    public void downloadTemplate(HttpServletRequest request, HttpServletResponse response) {
        this.export(request, response, null);
    }

    private void export(HttpServletRequest request, HttpServletResponse response, SaleEnquiryItem enquiryItem) {
        this.setParams(request);
        TemplateHeadDTO headVO = this.getConfig();
        List groupList = headVO.getTemplateGroupList();
        ExcelWriter writer = new ExcelWriter(true, ((TemplateGroupDTO)groupList.get(0)).getGroupName());
        for (int i = 0; i < groupList.size(); ++i) {
            Map<String, String> dictCodeMap;
            TemplateGroupDTO group = (TemplateGroupDTO)groupList.get(i);
            if (i != 0) {
                writer.setSheet(group.getGroupName());
            }
            String groupCode = group.getGroupCode();
            LinkedHashMap<String, Object> excelMap = new LinkedHashMap<String, Object>();
            ArrayList<Integer> requiredList = new ArrayList<Integer>();
            if ("head".equals(group.getGroupType())) {
                List<TemplateConfigHeadDTO> headList = this.getHeadConfig(headVO, groupCode);
                for (index = 0; index < headList.size(); ++index) {
                    TemplateConfigHeadDTO head2 = headList.get(index);
                    fieldLabel = head2.getFieldLabel();
                    if (this.isRequired(head2)) {
                        fieldLabel = "<*\u5fc5\u586b>" + (String)fieldLabel;
                        requiredList.add(index);
                    }
                    if (StrUtil.isNotBlank((CharSequence)head2.getDictCode())) {
                        this.setSelect(writer, 2, index, head2.getDictCode());
                    }
                    excelMap.put(head2.getFieldName(), fieldLabel);
                    writer.setColumnWidth(index, 20);
                }
                dictCodeMap = headList.stream().filter(head -> StrUtil.isNotBlank((CharSequence)head.getDictCode())).collect(Collectors.toMap(TemplateConfigHeadDTO::getFieldName, TemplateConfigHeadDTO::getDictCode));
            } else {
                List<TemplateConfigItemDTO> itemList = this.getItemConfig(headVO, groupCode);
                for (index = 0; index < itemList.size(); ++index) {
                    TemplateConfigItemDTO item2 = itemList.get(index);
                    fieldLabel = item2.getFieldLabel();
                    if (this.isRequired(item2)) {
                        fieldLabel = "<*\u5fc5\u586b>" + (String)fieldLabel;
                        requiredList.add(index);
                    }
                    if (StrUtil.isNotBlank((CharSequence)item2.getDictCode())) {
                        this.setSelect(writer, 1000, index, item2.getDictCode());
                    }
                    excelMap.put(item2.getFieldName(), fieldLabel);
                    writer.setColumnWidth(index, 20);
                }
                dictCodeMap = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getDictCode())).collect(Collectors.toMap(TemplateConfigItemDTO::getFieldName, TemplateConfigItemDTO::getDictCode));
            }
            ArrayList exportList = CollUtil.newArrayList((Object[])new Map[]{excelMap});
            if (enquiryItem != null) {
                exportList.addAll(this.getData(enquiryItem, excelMap, groupCode, dictCodeMap));
                log.info("exportList:{}", (Object)JSON.toJSONString((Object)exportList));
            }
            writer.write((Iterable)exportList);
            for (Integer x : requiredList) {
                this.setRedFont(writer, x);
            }
        }
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u5bfc\u5165\u6a21\u677f.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        try (ServletOutputStream out = response.getOutputStream();){
            writer.flush((OutputStream)out);
            writer.close();
        }
        catch (IOException e) {
            log.error("IO\u5f02\u5e38:", (Throwable)e);
        }
    }

    private List<Map<String, Object>> getData(SaleEnquiryItem item, Map<String, Object> excelMap, String groupCode, Map<String, String> dictCodeMap) {
        log.info("getData-groupCode:{}", (Object)groupCode);
        log.info("getData-excelMap:{}", (Object)JSONObject.toJSONString(excelMap));
        String costFormJson = item.getCostFormJson();
        JSONObject costJSON = StrUtil.isBlank((CharSequence)costFormJson) ? new JSONObject() : JSONObject.parseObject((String)costFormJson);
        JSONObject costData = costJSON.getJSONObject("data") == null ? new JSONObject() : costJSON.getJSONObject("data");
        JSONArray array = costData.getJSONArray(groupCode) == null ? new JSONArray() : costData.getJSONArray(groupCode);
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        for (Object e : array) {
            JSONObject groupData = (JSONObject)e;
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            for (String key : groupData.keySet()) {
                if (!excelMap.containsKey(key)) continue;
                dataMap.put(key, groupData.get((Object)key));
            }
            data.add(dataMap);
        }
        for (Map map : data) {
            for (String fieldName : map.keySet()) {
                if (!dictCodeMap.containsKey(fieldName)) continue;
                String text = this.getText(dictCodeMap.get(fieldName), map.get(fieldName));
                map.put(fieldName, text);
            }
        }
        return data;
    }

    private String getText(String dictCode, Object value) {
        if (value != null && StrUtil.isNotBlank((CharSequence)value.toString())) {
            List<DictDTO> dictList = this.getDictList(dictCode);
            for (DictDTO dict : dictList) {
                if (!value.toString().equals(dict.getValue())) continue;
                return dict.getText();
            }
        }
        return null;
    }

    @Override
    public void exportExcel(HttpServletRequest request, HttpServletResponse response) {
        String itemId = request.getParameter("id");
        SaleEnquiryItem item = (SaleEnquiryItem)((Object)this.saleEnquiryItemService.getById((Serializable)((Object)itemId)));
        this.export(request, response, item);
    }

    @Override
    public JSONObject importExcel(HttpServletRequest request) {
        this.setParams(request);
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        String fileName = (String)multipartRequest.getFileNames().next();
        MultipartFile multipartFile = multipartRequest.getFile(fileName);
        Assert.notNull((Object)multipartFile, (String)I18nUtil.translate((String)"i18n_alert_ViFQI_f75526c6", (String)"\u8bf7\u9009\u62e9\u6587\u4ef6"));
        TemplateHeadDTO headVO = this.getConfig();
        JSONObject result = new JSONObject();
        List groupList = headVO.getTemplateGroupList();
        for (int index = 0; index < groupList.size(); ++index) {
            try (InputStream input = multipartFile.getInputStream();){
                TemplateGroupDTO group = (TemplateGroupDTO)groupList.get(index);
                String groupCode = group.getGroupCode();
                ExcelReader reader = ExcelUtil.getReader((InputStream)input, (int)index);
                List sheetData = reader.read(0, 2, 1000);
                Assert.notEmpty((Collection)sheetData, (String)I18nUtil.translate((String)"i18n_alert_VImnWWWWWWmWWWWWCcKQLV_1220228c", (String)("\u8bf7\u68c0\u67e5\u7b2c" + (index + 1) + "\u4e2asheet\u5185\u5bb9\u662f\u5426\u4e3a\u7a7a"), (String[])new String[]{"" + (index + 1)}));
                if ("head".equals(group.getGroupType())) {
                    Map data = (Map)sheetData.get(0);
                    this.assembleHead(this.getHeadConfig(headVO, groupCode), data, index);
                    result.put(groupCode, (Object)data);
                    continue;
                }
                List<TemplateConfigItemDTO> itemList = this.getItemConfig(headVO, groupCode);
                List formulaList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getFormula())).map(TemplateConfigItemDTO::getFormula).collect(Collectors.toList());
                List computeField = FormulaUtil.getComputeFieldList(formulaList);
                Map<String, String> formulaMap = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getFormula())).collect(Collectors.toMap(TemplateConfigItemDTO::getFieldName, TemplateConfigItemDTO::getFormula));
                for (Map data : sheetData) {
                    this.assembleItem(itemList, data, index);
                    this.compute(computeField, formulaMap, data);
                }
                result.put(groupCode, (Object)sheetData);
                continue;
            }
            catch (IOException e) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_uNKm_2b0d38bd", (String)"\u5bfc\u5165\u5931\u8d25"), (Throwable)e, new String[0]);
            }
        }
        return result;
    }

    private void assembleHead(List<TemplateConfigHeadDTO> headList, Map<String, Object> data, int sheetIndex) {
        Map<String, String> dictCodeMap = headList.stream().filter(head -> StrUtil.isNotBlank((CharSequence)head.getDictCode())).collect(Collectors.toMap(TemplateConfigHeadDTO::getFieldName, TemplateConfigHeadDTO::getDictCode));
        List<String> editList = headList.stream().filter(this::isEdit).map(TemplateConfigHeadDTO::getFieldName).collect(Collectors.toList());
        Map<String, String> requiredMap = headList.stream().filter(this::isRequired).collect(Collectors.toMap(TemplateConfigHeadDTO::getFieldName, TemplateConfigHeadDTO::getFieldLabel));
        this.checkData(requiredMap, data, sheetIndex);
        this.cleanData(editList, data);
        this.translateDict(dictCodeMap, data);
    }

    private void assembleItem(List<TemplateConfigItemDTO> itemList, Map<String, Object> data, int sheetIndex) {
        List<String> editList = itemList.stream().filter(this::isEdit).map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        Map<String, String> dictCodeMap = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getDictCode())).collect(Collectors.toMap(TemplateConfigItemDTO::getFieldName, TemplateConfigItemDTO::getDictCode));
        Map<String, String> requiredMap = itemList.stream().filter(this::isRequired).collect(Collectors.toMap(TemplateConfigItemDTO::getFieldName, TemplateConfigItemDTO::getFieldLabel));
        this.checkData(requiredMap, data, sheetIndex);
        this.cleanData(editList, data);
        this.translateDict(dictCodeMap, data);
    }

    private void checkData(Map<String, String> requiredMap, Map<String, Object> data, int sheetIndex) {
        for (String fieldName : requiredMap.keySet()) {
            Object value = data.get(fieldName);
            if (value != null && !StrUtil.isBlank((CharSequence)value.toString())) continue;
            int temp = sheetIndex + 1;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nWWWWWWWWmWWWWWWWWWWWWWWWWWWWWxOLV_20583366", (String)("\u7b2c" + temp + "\u4e2aSheet\uff1a" + requiredMap.get(fieldName) + "(" + fieldName + ")\u4e0d\u80fd\u4e3a\u7a7a"), (String[])new String[]{"" + temp, requiredMap.get(fieldName), fieldName}));
        }
    }

    private void cleanData(List<String> editList, Map<String, Object> data) {
        for (String key : data.keySet()) {
            if (!editList.contains(key)) continue;
            data.put(key, null);
        }
    }

    private void translateDict(Map<String, String> dictCodeMap, Map<String, Object> data) {
        block0: for (String key : data.keySet()) {
            String text;
            if (!dictCodeMap.containsKey(key) || !StrUtil.isNotBlank((CharSequence)(text = (String)data.get(key)))) continue;
            String dictCode = dictCodeMap.get(key);
            List<DictDTO> dictList = this.getDictList(dictCode);
            for (DictDTO model : dictList) {
                if (!text.equals(model.getText())) continue;
                data.put(key, model.getValue());
                continue block0;
            }
        }
    }

    private void compute(List<String> computeField, Map<String, String> formulaMap, Map<String, Object> data) {
        for (String field : computeField) {
            FormulaUtil.compute((String)field, formulaMap, data);
        }
    }
}

