/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.utils;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.service.DictTranslateOldService;
import com.els.common.util.ConvertUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CostTranslateDictUtil {
    private String HEAD = "head";
    private String type;

    private CostTranslateDictUtil() {
    }

    public static CostTranslateDictUtil build() {
        return new CostTranslateDictUtil();
    }

    public void translatePurchase(List<PurchaseEnquiryItem> itemList) {
        for (PurchaseEnquiryItem item : itemList) {
            String costJsonString = item.getCostFormJson();
            if (!EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay()) || !StrUtil.isNotBlank((CharSequence)costJsonString)) continue;
            item.setCostFormJson(this.translate(costJsonString).toJSONString());
        }
    }

    public void translateSale(List<SaleEnquiryItem> itemList) {
        for (SaleEnquiryItem item : itemList) {
            String costJsonString = item.getCostFormJson();
            if (!EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay()) || !StrUtil.isNotBlank((CharSequence)costJsonString)) continue;
            item.setCostFormJson(this.translate(costJsonString).toJSONString());
        }
    }

    private JSONObject translate(String costJsonString) {
        JSONObject costJson = JSONObject.parseObject((String)costJsonString);
        String templateAccount = costJson.getString("templateAccount");
        String busAccount = costJson.getString("busAccount");
        String templateNumber = costJson.getString("templateNumber");
        String templateVersion = costJson.getString("templateVersion");
        JSONObject data = costJson.getJSONObject("data") == null ? new JSONObject() : costJson.getJSONObject("data");
        TemplateVO vo = new TemplateVO();
        vo.setTemplateAccount(templateAccount);
        vo.setBusAccount(busAccount);
        vo.setTemplateNumber(templateNumber);
        vo.setTemplateVersion(templateVersion);
        for (String groupCode : data.keySet()) {
            vo.setGroupCode(groupCode);
            Object value = data.get((Object)groupCode);
            if (value instanceof JSONArray) {
                this.type = "item";
                JSONArray array = (JSONArray)value;
                this.translate(array, vo);
                continue;
            }
            if (!(value instanceof JSONObject)) continue;
            this.type = this.HEAD;
            JSONObject result = this.translate((JSONObject)value, vo);
            data.put(groupCode, (Object)result);
        }
        return costJson;
    }

    private void translate(JSONArray array, TemplateVO vo) {
        for (int i = 0; i < array.size(); ++i) {
            JSONObject result = this.translate(array.getJSONObject(i), vo);
            array.set(i, (Object)result);
        }
    }

    private JSONObject translate(JSONObject object, TemplateVO vo) {
        String busAccount = StrUtil.isBlank((CharSequence)vo.getBusAccount()) ? TenantContext.getTenant() : vo.getBusAccount();
        String account = StrUtil.isBlank((CharSequence)vo.getTemplateAccount()) ? busAccount : vo.getTemplateAccount();
        InvokeBaseRpcService baseRpcService = (InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class);
        Map dictMap = this.HEAD.equals(this.type) ? baseRpcService.getHeadDictMap(account, vo.getTemplateNumber(), vo.getTemplateVersion(), vo.getGroupCode()) : baseRpcService.getItemDictMap(account, vo.getTemplateNumber(), vo.getTemplateVersion(), vo.getGroupCode());
        JSONObject result = new JSONObject();
        for (String fieldName : object.keySet()) {
            result.put(fieldName, object.get((Object)fieldName));
            String dictCode = (String)dictMap.get(fieldName);
            if (!StrUtil.isNotBlank((CharSequence)dictCode)) continue;
            String code = "";
            String text = null;
            String table = null;
            String valueText = null;
            if (dictCode.contains(",") || dictCode.contains("#")) {
                String[] dictCodeArray = dictCode.contains("#") ? dictCode.split("#") : dictCode.split(",");
                switch (dictCodeArray.length) {
                    case 4: {
                        code = dictCodeArray[3];
                        break;
                    }
                    case 3: {
                        valueText = dictCodeArray[2];
                        break;
                    }
                    case 2: {
                        text = dictCodeArray[1];
                        break;
                    }
                    case 1: {
                        table = dictCodeArray[0];
                        break;
                    }
                }
            } else {
                code = dictCode;
            }
            String value = result.getString(fieldName);
            if (ConvertUtils.isEmpty((Object)value)) {
                result.put(fieldName + "_dictText", null);
                continue;
            }
            String textValue = this.getDictValue(code, text, table, value, busAccount, valueText);
            result.put(fieldName + "_dictText", (Object)textValue);
        }
        return result;
    }

    private String getDictValue(String code, String text, String table, String value, String busAccount, String valueText) {
        String[] values;
        DictTranslateOldService dictTranslateService = (DictTranslateOldService)SpringContextUtils.getBean(DictTranslateOldService.class);
        StringBuilder textValue = new StringBuilder();
        for (String val : values = value.split(",")) {
            String tmpValue;
            if (val.trim().length() == 0 || (tmpValue = dictTranslateService.queryDictTextByKey(code, val.trim(), busAccount)) == null) continue;
            if (StrUtil.isNotBlank((CharSequence)textValue)) {
                textValue.append(",");
            }
            textValue.append(tmpValue);
        }
        return textValue.toString();
    }

    private class TemplateVO {
        private String templateAccount;
        private String busAccount;
        private String templateNumber;
        private String templateVersion;
        private String groupCode;

        private TemplateVO() {
        }

        @Generated
        public String getTemplateAccount() {
            return this.templateAccount;
        }

        @Generated
        public String getBusAccount() {
            return this.busAccount;
        }

        @Generated
        public String getTemplateNumber() {
            return this.templateNumber;
        }

        @Generated
        public String getTemplateVersion() {
            return this.templateVersion;
        }

        @Generated
        public String getGroupCode() {
            return this.groupCode;
        }

        @Generated
        public void setTemplateAccount(String templateAccount) {
            this.templateAccount = templateAccount;
        }

        @Generated
        public void setBusAccount(String busAccount) {
            this.busAccount = busAccount;
        }

        @Generated
        public void setTemplateNumber(String templateNumber) {
            this.templateNumber = templateNumber;
        }

        @Generated
        public void setTemplateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
        }

        @Generated
        public void setGroupCode(String groupCode) {
            this.groupCode = groupCode;
        }
    }
}

