/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.forecast.arima;

import com.alibaba.fastjson.JSON;
import com.els.modules.forecast.arima.AR;
import com.els.modules.forecast.arima.ARMA;
import com.els.modules.forecast.arima.ARMAMath;
import com.els.modules.forecast.arima.MA;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class ARIMA {
    double[] originalData = new double[0];
    ARMAMath armamath = new ARMAMath();
    double stderrDara = 0.0;
    double avgsumData = 0.0;
    Vector<double[]> armaARMAcoe = new Vector();
    Vector<double[]> bestarmaARMAcoe = new Vector();

    public ARIMA(double[] originalData) {
        this.originalData = originalData;
    }

    public double[] preDealDif() {
        double[] tempData = new double[this.originalData.length - 7];
        for (int i = 0; i < this.originalData.length - 7; ++i) {
            tempData[i] = this.originalData[i + 7] - this.originalData[i];
        }
        return tempData;
    }

    public double[] preDealNor(double[] tempData) {
        this.avgsumData = this.armamath.avgData(tempData);
        this.stderrDara = this.armamath.stderrData(tempData);
        for (int i = 0; i < tempData.length; ++i) {
            tempData[i] = (tempData[i] - this.avgsumData) / this.stderrDara;
        }
        return tempData;
    }

    public int[] getARIMAmodel() {
        double[] stdoriginalData = this.preDealDif();
        int paraType = 0;
        double minAIC = 9999999.0;
        int bestModelindex = 0;
        int[][] model = new int[][]{{0, 1}, {1, 0}, {1, 1}, {0, 2}, {2, 0}, {2, 2}, {1, 2}, {2, 1}};
        for (int i = 0; i < model.length; ++i) {
            if (model[i][0] == 0) {
                MA ma = new MA(stdoriginalData, model[i][1]);
                this.armaARMAcoe = ma.MAmodel();
                paraType = 1;
            } else if (model[i][1] == 0) {
                AR ar = new AR(stdoriginalData, model[i][0]);
                this.armaARMAcoe = ar.ARmodel();
                paraType = 2;
            } else {
                ARMA arma = new ARMA(stdoriginalData, model[i][0], model[i][1]);
                this.armaARMAcoe = arma.ARMAmodel();
                paraType = 3;
            }
            double temp = this.getmodelAIC(this.armaARMAcoe, stdoriginalData, paraType);
            System.out.println("AIC of these model=" + temp);
            if (!(temp < minAIC)) continue;
            bestModelindex = i;
            minAIC = temp;
            this.bestarmaARMAcoe = this.armaARMAcoe;
        }
        return model[bestModelindex];
    }

    public double getmodelAIC(Vector<double[]> para, double[] stdoriginalData, int type) {
        double temp = 0.0;
        double temp2 = 0.0;
        double sumerr = 0.0;
        int p = 0;
        int q = 0;
        int n = stdoriginalData.length;
        Random random = new Random();
        if (type == 1) {
            double[] maPara = para.get(0);
            q = maPara.length;
            double[] err = new double[q];
            for (int k = q - 1; k < n; ++k) {
                temp = 0.0;
                for (int i = 1; i < q; ++i) {
                    temp += maPara[i] * err[i];
                }
                for (int j = q - 1; j > 0; --j) {
                    err[j] = err[j - 1];
                }
                err[0] = random.nextGaussian() * Math.sqrt(maPara[0]);
                sumerr += (stdoriginalData[k] - temp) * (stdoriginalData[k] - temp);
            }
            return (double)(n - (q - 1)) * Math.log(sumerr / (double)(n - (q - 1))) + (double)((q + 1) * 2);
        }
        if (type == 2) {
            double[] arPara = para.get(0);
            p = arPara.length;
            for (int k = p - 1; k < n; ++k) {
                temp = 0.0;
                for (int i = 0; i < p - 1; ++i) {
                    temp += arPara[i] * stdoriginalData[k - i - 1];
                }
                sumerr += (stdoriginalData[k] - temp) * (stdoriginalData[k] - temp);
            }
            return (double)(n - (q - 1)) * Math.log(sumerr / (double)(n - (q - 1))) + (double)((p + 1) * 2);
        }
        double[] arPara = para.get(0);
        double[] maPara = para.get(1);
        p = arPara.length;
        q = maPara.length;
        double[] err = new double[q];
        for (int k = p - 1; k < n; ++k) {
            int i;
            temp = 0.0;
            temp2 = 0.0;
            for (i = 0; i < p - 1; ++i) {
                temp += arPara[i] * stdoriginalData[k - i - 1];
            }
            for (i = 1; i < q; ++i) {
                temp2 += maPara[i] * err[i];
            }
            for (int j = q - 1; j > 0; --j) {
                err[j] = err[j - 1];
            }
            err[0] = random.nextGaussian() * Math.sqrt(maPara[0]);
            sumerr += (stdoriginalData[k] - (temp2 + temp)) * (stdoriginalData[k] - (temp2 + temp));
        }
        return (double)(n - (q - 1)) * Math.log(sumerr / (double)(n - (q - 1))) + (double)((p + q) * 2);
    }

    public int aftDeal(int predictValue) {
        return (int)((double)predictValue + this.originalData[this.originalData.length - 7]);
    }

    public int predictValue(int p, int q) {
        int predict = 0;
        double[] stdoriginalData = this.preDealDif();
        int n = stdoriginalData.length;
        double temp = 0.0;
        double temp2 = 0.0;
        double[] err = new double[q + 1];
        Random random = new Random();
        if (p == 0) {
            double[] maPara = this.bestarmaARMAcoe.get(0);
            for (int k = q; k < n; ++k) {
                temp = 0.0;
                for (int i = 1; i <= q; ++i) {
                    temp += maPara[i] * err[i];
                }
                for (int j = q; j > 0; --j) {
                    err[j] = err[j - 1];
                }
                err[0] = random.nextGaussian() * Math.sqrt(maPara[0]);
            }
            predict = (int)temp;
        } else if (q == 0) {
            double[] arPara = this.bestarmaARMAcoe.get(0);
            for (int k = p; k < n; ++k) {
                temp = 0.0;
                for (int i = 0; i < p; ++i) {
                    temp += arPara[i] * stdoriginalData[k - i - 1];
                }
            }
            predict = (int)temp;
        } else {
            double[] arPara = this.bestarmaARMAcoe.get(0);
            double[] maPara = this.bestarmaARMAcoe.get(1);
            err = new double[q + 1];
            for (int k = p; k < n; ++k) {
                int i;
                temp = 0.0;
                temp2 = 0.0;
                for (i = 0; i < p; ++i) {
                    temp += arPara[i] * stdoriginalData[k - i - 1];
                }
                for (i = 1; i <= q; ++i) {
                    temp2 += maPara[i] * err[i];
                }
                for (int j = q; j > 0; --j) {
                    err[j] = err[j - 1];
                }
                err[0] = random.nextGaussian() * Math.sqrt(maPara[0]);
            }
            predict = (int)(temp2 + temp);
        }
        return predict;
    }

    public double[] getMApara(double[] autocorData, int q) {
        double[] maPara;
        double[] tempmaPara = maPara = new double[q + 1];
        double temp = 0.0;
        boolean iterationFlag = true;
        System.out.println("autocorData[0]" + autocorData[0]);
        while (iterationFlag) {
            int i;
            for (i = 1; i < maPara.length; ++i) {
                temp += maPara[i] * maPara[i];
            }
            tempmaPara[0] = autocorData[0] / (1.0 + temp);
            for (i = 1; i < maPara.length; ++i) {
                temp = 0.0;
                for (int j = 1; j < maPara.length - i; ++j) {
                    temp += maPara[j] * maPara[j + i];
                }
                tempmaPara[i] = -(autocorData[i] / tempmaPara[0] - temp);
            }
            iterationFlag = false;
            for (i = 0; i < maPara.length; ++i) {
                if (maPara[i] == tempmaPara[i]) continue;
                iterationFlag = true;
                break;
            }
            maPara = tempmaPara;
        }
        return maPara;
    }

    public static int[] generator(int size, List<Double> arraylist) {
        int[] returnArray = new int[size];
        for (int i = 0; i < size; ++i) {
            double[] dataArray = new double[arraylist.size()];
            for (int j = 0; j < arraylist.size() - 1; ++j) {
                dataArray[j] = arraylist.get(j);
            }
            ARIMA arima = new ARIMA(dataArray);
            int[] model = arima.getARIMAmodel();
            System.out.println("Best model is [p,q]=[" + model[0] + " " + model[1] + "]");
            System.out.println("\u6700\u4f73\u6a21\u578b\u662f[p,q]=[" + model[0] + " " + model[1] + "]");
            int deal = arima.aftDeal(arima.predictValue(model[0], model[1]));
            System.out.println("Predict value=" + deal);
            System.out.println("\u9884\u6d4b\u503c=" + deal);
            System.out.println("Predict error=" + ((double)deal - arraylist.get(arraylist.size() - 1)) / arraylist.get(arraylist.size() - 1) * 100.0 + "%");
            System.out.println("\u9884\u6d4b\u5dee\u503c=" + ((double)deal - arraylist.get(arraylist.size() - 1)) / arraylist.get(arraylist.size() - 1) * 100.0 + "%");
            arraylist.add((double)deal + 0.0);
            returnArray[i] = deal;
        }
        System.out.println(JSON.toJSON(arraylist));
        System.out.println(JSON.toJSON((Object)returnArray));
        return returnArray;
    }
}

