/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.base.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.logisticspurchase.base.entity.LineFile;
import com.els.modules.logisticspurchase.base.excel.LineFileExportServiceImpl;
import com.els.modules.logisticspurchase.base.service.LineFileService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Tag(name="\u7ebf\u8def\u6863\u6848\u4fe1\u606f")
@RestController
@RequestMapping(value={"/lpbase/lineFile"})
public class LineFileController
extends BaseController<LineFile, LineFileService> {
    @Autowired
    private LineFileService lineFileService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"lpbase#lineFile:list"})
    public Result<?> queryPageList(LineFile lineFile, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)lineFile), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.lineFileService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u7ebf\u8def\u6863\u6848\u4fe1\u606f-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"lpbase#lineFile:add"})
    public Result<?> add(@RequestBody LineFile lineFile) {
        this.lineFileService.saveLineFile(lineFile);
        return Result.ok((Object)((Object)lineFile));
    }

    @AutoLog(value="\u7ebf\u8def\u6863\u6848\u4fe1\u606f-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"lpbase#lineFile:add"})
    public Result<?> edit(@RequestBody LineFile lineFile) {
        this.lineFileService.updateLineFile(lineFile);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7ebf\u8def\u6863\u6848\u4fe1\u606f-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"lpbase#lineFile:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.lineFileService.delLineFile(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7ebf\u8def\u6863\u6848\u4fe1\u606f-\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"lpbase#lineFile:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.lineFileService.delBatchLineFile(idList);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"lpbase#lineFile:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        LineFile lineFile = (LineFile)((Object)this.lineFileService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)lineFile));
    }

    @AutoLog(value="\u7ebf\u8def\u6863\u6848\u4fe1\u606f-\u901a\u8fc7id\u89e3\u51bb")
    @Operation(summary="\u901a\u8fc7id\u89e3\u51bb", description="\u901a\u8fc7id\u89e3\u51bb")
    @GetMapping(value={"/thaw"})
    @RequiresPermissions(value={"lpbase#lineFile:thaw"})
    public Result<?> thaw(@RequestParam(name="id") String id) {
        this.lineFileService.thawLineFile(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7ebf\u8def\u6863\u6848\u4fe1\u606f-\u901a\u8fc7id\u51bb\u7ed3")
    @Operation(summary="\u901a\u8fc7id\u51bb\u7ed3", description="\u901a\u8fc7id\u51bb\u7ed3")
    @GetMapping(value={"/frozen"})
    @RequiresPermissions(value={"lpbase#lineFile:frozen"})
    public Result<?> frozen(@RequestParam(name="id") String id) {
        this.lineFileService.frozenLineFile(id);
        return this.commonSuccessResult(3);
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"lpbase#lineFile:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, LineFileExportServiceImpl.class);
    }
}

