/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.ebidding.utils;

import com.els.modules.ebidding.enumerate.EbiddingShowEnum;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemHisLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.enumerate.EbiddingLpStatusEnum;
import com.els.modules.logisticspurchase.ebidding.enumerate.LpEbiddingTypeEnum;
import com.els.modules.logisticspurchase.ebidding.enumerate.LpEbiddingTypeHisEnum;
import java.util.Comparator;
import java.util.List;

public class LpEbiddingShowUtil {
    public static void purchaseShow(List<PurchaseEbiddingItemLp> itemList, PurchaseEbiddingHeadLp head, boolean rank) {
        String purchaseShow;
        String ebiddingWay = head.getEbiddingWay();
        String ebiddingType = head.getEbiddingType();
        String string = purchaseShow = head.getPurchaseShow() == null ? "" : head.getPurchaseShow();
        if (EbiddingLpStatusEnum.BIDDING.getValue().equals(head.getEbiddingStatus())) {
            if (purchaseShow.contains(EbiddingShowEnum.RANK.getValue()) && rank) {
                LpEbiddingShowUtil.rank(itemList, ebiddingWay, ebiddingType);
            }
            if (!purchaseShow.contains(EbiddingShowEnum.PRICE.getValue())) {
                itemList.forEach(item -> {
                    item.setPrice(null);
                    item.setNetPrice(null);
                    item.setTotalAmount(null);
                    item.setNetTotalAmount(null);
                    item.setTaxAmount(null);
                    item.setNetAmount(null);
                });
            }
            if (!purchaseShow.contains(EbiddingShowEnum.NAME.getValue())) {
                itemList.forEach(item -> item.setSupplierName(null));
            }
        } else if (rank) {
            LpEbiddingShowUtil.rank(itemList, ebiddingWay, ebiddingType);
        }
    }

    private static void rank(List<PurchaseEbiddingItemLp> itemList, String ebiddingWay, String ebiddingType) {
        List<PurchaseEbiddingItemLp> sortList = LpEbiddingTypeEnum.getEnumByValue(ebiddingType).sort(ebiddingWay, itemList);
        block0: for (int i = 0; i < sortList.size(); ++i) {
            for (PurchaseEbiddingItemLp item : itemList) {
                if (!item.getId().equals(sortList.get(i).getId())) continue;
                int rank = i + 1;
                item.setQuoteRank(rank);
                continue block0;
            }
        }
        itemList.sort(Comparator.comparing(PurchaseEbiddingItemLp::getQuoteRank, Comparator.nullsLast(Integer::compareTo)));
    }

    public static void purchaseShowHis(List<PurchaseEbiddingItemHisLp> itemList, PurchaseEbiddingHeadLp head, boolean rank) {
        String purchaseShow;
        String ebiddingWay = head.getEbiddingWay();
        String ebiddingType = head.getEbiddingType();
        String string = purchaseShow = head.getPurchaseShow() == null ? "" : head.getPurchaseShow();
        if (EbiddingLpStatusEnum.BIDDING.getValue().equals(head.getEbiddingStatus())) {
            if (purchaseShow.contains(EbiddingShowEnum.RANK.getValue()) && rank) {
                LpEbiddingShowUtil.rankHis(itemList, ebiddingWay, ebiddingType);
            }
            if (!purchaseShow.contains(EbiddingShowEnum.PRICE.getValue())) {
                itemList.forEach(item -> {
                    item.setPrice(null);
                    item.setNetPrice(null);
                    item.setTotalAmount(null);
                    item.setNetTotalAmount(null);
                    item.setTaxAmount(null);
                    item.setNetAmount(null);
                });
            }
            if (!purchaseShow.contains(EbiddingShowEnum.NAME.getValue())) {
                itemList.forEach(item -> item.setSupplierName(null));
            }
        } else if (rank) {
            LpEbiddingShowUtil.rankHis(itemList, ebiddingWay, ebiddingType);
        }
    }

    private static void rankHis(List<PurchaseEbiddingItemHisLp> itemList, String ebiddingWay, String ebiddingType) {
        List<PurchaseEbiddingItemHisLp> sortList = LpEbiddingTypeHisEnum.getEnumByValue(ebiddingType).sort(ebiddingWay, itemList);
        block0: for (int i = 0; i < sortList.size(); ++i) {
            for (PurchaseEbiddingItemHisLp item : itemList) {
                if (!item.getId().equals(sortList.get(i).getId())) continue;
                int rank = i + 1;
                item.setQuoteRank(rank);
                continue block0;
            }
        }
        itemList.sort(Comparator.comparing(PurchaseEbiddingItemHisLp::getQuoteRank, Comparator.nullsLast(Integer::compareTo)));
    }
}

