/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.priceEvaluationManagement.job.utils;

import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.modules.inquiry.rpc.service.InquriyInvokeJobRpcService;
import com.els.modules.job.api.dto.QuartzJobDTO;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceEvaluationJobUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PriceEvaluationJobUtil.class);
    private static InquriyInvokeJobRpcService inquriyInvokeJobRpcService = (InquriyInvokeJobRpcService)SpringContextUtils.getBean(InquriyInvokeJobRpcService.class);
    private static final String PRICE_EVALUATION_STANDER_END_JOB = "srmPriceEvaluationStandardEndJobBeanServiceImpl";

    private static void createJob(String elsAccount, String jobId, String documentNumber, Date time, String jobName) {
        String cron = DateUtils.formatDate((Date)time, (String)"ss mm HH dd MM ? yyyy");
        QuartzJobDTO job = new QuartzJobDTO();
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        job.setJobNameKey(jobName + "_" + documentNumber + "_" + elsAccount);
        JSONObject paramObj = new JSONObject();
        paramObj.put("id", (Object)jobId);
        paramObj.put("jobKey", (Object)job.getJobNameKey());
        paramObj.put("tenantId", (Object)elsAccount);
        paramObj.put("jobImplName", (Object)jobName);
        job.setParameter(paramObj.toJSONString());
        job.setElsAccount(elsAccount);
        inquriyInvokeJobRpcService.deleteJob(job);
        inquriyInvokeJobRpcService.createJob(job);
    }

    public static void createEndJob(String elsAccount, String jobId, String documentNumber, Date time) {
        PriceEvaluationJobUtil.createJob(elsAccount, jobId, documentNumber, time, PRICE_EVALUATION_STANDER_END_JOB);
    }
}

