/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.priceEvaluationManagement.service.impl;

import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.priceEvaluationManagement.entity.PurchaseBaseMaterialPrice;
import com.els.modules.priceEvaluationManagement.enumerate.PurchaseBaseMaterialPriceStatusEnum;
import com.els.modules.priceEvaluationManagement.mapper.PurchaseBaseMaterialPriceMapper;
import com.els.modules.priceEvaluationManagement.service.PurchaseBaseMaterialPriceService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseBaseMaterialPriceServiceImpl
extends BaseServiceImpl<PurchaseBaseMaterialPriceMapper, PurchaseBaseMaterialPrice>
implements PurchaseBaseMaterialPriceService {
    @Resource
    private InvokeBaseRpcService baseRpcService;

    @Override
    public void add(PurchaseBaseMaterialPrice purchaseBaseMaterialPrice) {
        purchaseBaseMaterialPrice.setDocumentNumber(this.baseRpcService.getNextCode("purchaseBaseMaterialPriceNumber", (Object)purchaseBaseMaterialPrice));
        ((PurchaseBaseMaterialPriceMapper)this.baseMapper).insert((Object)purchaseBaseMaterialPrice);
    }

    @Override
    public void edit(PurchaseBaseMaterialPrice purchaseBaseMaterialPrice) {
        int count = ((PurchaseBaseMaterialPriceMapper)this.baseMapper).updateById((Object)purchaseBaseMaterialPrice);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PurchaseBaseMaterialPriceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseBaseMaterialPriceMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void submit(PurchaseBaseMaterialPrice purchaseBaseMaterialPrice) {
        PurchaseBaseMaterialPrice baseMaterialPrice = new PurchaseBaseMaterialPrice();
        baseMaterialPrice.setDocumentStatus(PurchaseBaseMaterialPriceStatusEnum.START.getValue());
        baseMaterialPrice.setId(purchaseBaseMaterialPrice.getId());
        baseMaterialPrice.setDataVersion(purchaseBaseMaterialPrice.getDataVersion());
        int count = ((PurchaseBaseMaterialPriceMapper)this.baseMapper).updateById((Object)baseMaterialPrice);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void start(PurchaseBaseMaterialPrice purchaseBaseMaterialPrice) {
        PurchaseBaseMaterialPrice dbBaseMaterialPrice = (PurchaseBaseMaterialPrice)((Object)((PurchaseBaseMaterialPriceMapper)this.baseMapper).selectById((Serializable)((Object)purchaseBaseMaterialPrice.getId())));
        if (dbBaseMaterialPrice == null) {
            throw new ELSBootException("\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        String documentStatus = PurchaseBaseMaterialPriceStatusEnum.START.getValue().equals(dbBaseMaterialPrice.getDocumentStatus()) ? PurchaseBaseMaterialPriceStatusEnum.NOT.getValue() : PurchaseBaseMaterialPriceStatusEnum.START.getValue();
        PurchaseBaseMaterialPrice baseMaterialPrice = new PurchaseBaseMaterialPrice();
        baseMaterialPrice.setDocumentStatus(documentStatus);
        baseMaterialPrice.setId(purchaseBaseMaterialPrice.getId());
        baseMaterialPrice.setDataVersion(purchaseBaseMaterialPrice.getDataVersion());
        int count = ((PurchaseBaseMaterialPriceMapper)this.baseMapper).updateById((Object)baseMaterialPrice);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }
}

