/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.abnormal.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.util.WorkFlowUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.tender.abnormal.entity.PurchaseTenderSubpackageTerminateHead;
import com.els.modules.tender.abnormal.enumerate.SubpackageTerminateHeadStatusEnum;
import com.els.modules.tender.abnormal.mapper.PurchaseTenderSubpackageTerminateHeadMapper;
import com.els.modules.tender.abnormal.service.PurchaseTenderSubpackageTerminateHeadService;
import com.els.modules.tender.abnormal.vo.PurchaseTenderSubpackageTerminateHeadVo;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.calibration.enumerate.BidWinningAffirmNoticeEnum;
import com.els.modules.tender.common.utils.TenderAuditSubjectUtils;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaHeadService;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.enumerate.TenderSubpackageDiscardTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectInfoVO;
import com.els.modules.workflow.modules.dto.SubmitAuditDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderSubpackageTerminateHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderSubpackageTerminateHeadMapper, PurchaseTenderSubpackageTerminateHead>
implements PurchaseTenderSubpackageTerminateHeadService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Resource
    private PurchaseTenderProjectHeadService projectHeadService;
    @Resource
    @Lazy
    private PurchaseTenderProjectBidEvaHeadService bidEvaHeadService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void add(PurchaseTenderSubpackageTerminateHead terminateHead, List<PurchaseAttachmentDTO> purchaseAttachmentDTOList) {
        this.buildParam(terminateHead);
        ((PurchaseTenderSubpackageTerminateHeadMapper)this.baseMapper).insert((Object)terminateHead);
        this.insertData(terminateHead, purchaseAttachmentDTOList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void edit(PurchaseTenderSubpackageTerminateHead headVo, List<PurchaseAttachmentDTO> purchaseAttachmentDTOList) {
        if ("1".equals(headVo.getAudited())) {
            headVo.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            headVo.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        PurchaseTenderSubpackageTerminateHead terminateHead = (PurchaseTenderSubpackageTerminateHead)((Object)SysUtil.copyProperties((Object)((Object)headVo), PurchaseTenderSubpackageTerminateHead.class));
        int count = ((PurchaseTenderSubpackageTerminateHeadMapper)this.baseMapper).updateById((Object)terminateHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.insertData(terminateHead, purchaseAttachmentDTOList);
    }

    @Override
    public void delete(String id) {
        ((PurchaseTenderSubpackageTerminateHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseTenderSubpackageTerminateHeadMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public PurchaseTenderSubpackageTerminateHeadVo selectBySubpackageId(String subpackageId) {
        PurchaseTenderSubpackageTerminateHead head = ((PurchaseTenderSubpackageTerminateHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId);
        if (null == head) {
            return null;
        }
        PurchaseTenderSubpackageTerminateHeadVo headVo = (PurchaseTenderSubpackageTerminateHeadVo)((Object)SysUtil.copyProperties((Object)((Object)head), PurchaseTenderSubpackageTerminateHeadVo.class));
        List purchaseAttachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(head.getId());
        headVo.setPurchaseAttachmentDTOList(purchaseAttachmentDTOList);
        return headVo;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveOrUpdatePublish(PurchaseTenderSubpackageTerminateHead terminateHead, List<PurchaseAttachmentDTO> purchaseAttachmentDTOList) {
        if (StrUtil.isBlank((CharSequence)terminateHead.getId())) {
            this.add(terminateHead, purchaseAttachmentDTOList);
        } else {
            this.edit(terminateHead, purchaseAttachmentDTOList);
        }
        this.checkParam(terminateHead);
        if ("1".equals(terminateHead.getAudited())) {
            PurchaseTenderProjectInfoVO purchaseTenderProjectInfoVO = this.projectHeadService.queryProjectInfoBySubpackageId(terminateHead.getSubpackageId());
            String subject = TenderAuditSubjectUtils.getTenderAuditSubject("tenderTermination", "\u62db\u6807\u7ec8\u6b62", purchaseTenderProjectInfoVO.getTenderProjectNumber(), null, purchaseTenderProjectInfoVO.getSubpackageName());
            SubmitAuditDTO dto = SubmitAuditDTO.builder().businessId(terminateHead.getId()).businessType("tenderTermination").processTitle(subject).businessObj((Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)terminateHead)))).build();
            WorkFlowUtil.submit((SubmitAuditDTO)dto);
        } else {
            this.publish(terminateHead);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseTenderSubpackageTerminateHead terminateHead) {
        terminateHead.setStatus(BidWinningAffirmNoticeEnum.ISSUE.getValue());
        ((PurchaseTenderSubpackageTerminateHeadMapper)this.baseMapper).updateById((Object)terminateHead);
        PurchaseTenderProjectSubpackageInfo projectSubpackageInfo = this.subpackageInfoService.selectById(terminateHead.getSubpackageId());
        projectSubpackageInfo.setStatus(TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED.getValue());
        projectSubpackageInfo.setInvalid("1");
        projectSubpackageInfo.setInvalidType(TenderSubpackageDiscardTypeEnum.TERMINATED.getValue());
        this.subpackageInfoService.updateById((Object)projectSubpackageInfo);
        this.bidEvaHeadService.terminationBySubpackageInfo(terminateHead.getSubpackageId());
        List purchaseAttachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(terminateHead.getId());
        ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentDTOS, terminateHead.getId(), terminateHead.getSubpackageId(), terminateHead.getProjectId(), TenderProjectArchiveAttachmentEnum.TERMINATE_TENDER.getValue());
    }

    private void checkParam(PurchaseTenderSubpackageTerminateHead terminateHead) {
        Assert.hasText((String)terminateHead.getTerminationReasonDetail(), (String)I18nUtil.translate((String)"i18n_field_sRjWtHxOLVW_7f3fccf1", (String)"\u7ec8\u6b62\u539f\u56e0\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)terminateHead.getTerminationReason(), (String)I18nUtil.translate((String)"i18n_field_sRjWxOLVW_acfcecb6", (String)"\u7ec8\u6b62\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a"));
    }

    private void insertData(PurchaseTenderSubpackageTerminateHead terminateHead, List<PurchaseAttachmentDTO> purchaseAttachmentDTOList) {
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(terminateHead.getId());
        if (CollectionUtil.isEmpty(purchaseAttachmentDTOList)) {
            return;
        }
        purchaseAttachmentDTOList.parallelStream().forEach(attachment -> attachment.setHeadId(terminateHead.getId()));
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentDTOList);
    }

    private void buildParam(PurchaseTenderSubpackageTerminateHead subpackageTerminateHead) {
        subpackageTerminateHead.setTerminationNumber(this.invokeBaseRpcService.getNextCode("tenderTerminateNumber", (Object)subpackageTerminateHead));
        subpackageTerminateHead.setStatus(SubpackageTerminateHeadStatusEnum.NEW.getValue());
        subpackageTerminateHead.setDeleted(CommonConstant.DEL_FLAG_0);
        if ("1".equals(subpackageTerminateHead.getAudited())) {
            subpackageTerminateHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            subpackageTerminateHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
    }
}

