/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.archive.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SysUtil;
import com.els.modules.tender.archive.entity.TenderProjectArchiveAttachmentHead;
import com.els.modules.tender.archive.entity.TenderProjectArchiveAttachmentInfo;
import com.els.modules.tender.archive.service.TenderProjectArchiveAttachmentHeadService;
import com.els.modules.tender.archive.service.TenderProjectArchiveAttachmentInfoService;
import com.els.modules.tender.archive.vo.TenderProjectArchiveAttachmentHeadVo;
import com.els.modules.tender.archive.vo.TenderProjectArchiveAttachmentInfoVo;
import com.els.modules.tender.common.aspect.TenderPermissions;
import com.els.modules.tender.project.enumerate.TenderRoleEnum;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u6587\u4ef6\u5f52\u6863\u4e3b\u8868")
@RestController
@RequestMapping(value={"/tender/archive/tenderProjectArchiveAttachmentHead"})
public class TenderProjectArchiveAttachmentHeadController
extends BaseController<TenderProjectArchiveAttachmentHead, TenderProjectArchiveAttachmentHeadService> {
    @Autowired
    private TenderProjectArchiveAttachmentHeadService tenderProjectArchiveAttachmentHeadService;
    @Autowired
    private TenderProjectArchiveAttachmentInfoService tenderProjectArchiveAttachmentinfoService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    public Result<?> queryPageList(TenderProjectArchiveAttachmentHead tenderProjectArchiveAttachmentHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)tenderProjectArchiveAttachmentHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.tenderProjectArchiveAttachmentHeadService.page((IPage)page, (Wrapper)queryWrapper);
        Page viewPage = new Page();
        List resultPageList = this.tenderProjectArchiveAttachmentHeadService.queryProjectArchiveInfo(pageList.getRecords());
        if (resultPageList == null) {
            resultPageList = Collections.EMPTY_LIST;
        }
        BeanUtils.copyProperties((Object)pageList, (Object)viewPage);
        viewPage.setRecords(resultPageList);
        return Result.ok((Object)viewPage);
    }

    @AutoLog(value="\u6587\u4ef6\u5f52\u6863\u4fe1\u606f-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"tender#tenderProjectArchiveAttachmentHead:add"})
    @SrmValidated
    public Result<?> add(@RequestBody TenderProjectArchiveAttachmentHeadVo headVo) {
        TenderProjectArchiveAttachmentHead archiveAttachmentHead = (TenderProjectArchiveAttachmentHead)((Object)SysUtil.copyProperties((Object)((Object)headVo), TenderProjectArchiveAttachmentHead.class));
        List<TenderProjectArchiveAttachmentInfo> archiveAttachmentInfoList = headVo.getArchiveAttachmentInfoList();
        this.tenderProjectArchiveAttachmentHeadService.add(archiveAttachmentHead, archiveAttachmentInfoList);
        return Result.ok((Object)3);
    }

    @AutoLog(value="\u6587\u4ef6\u5f52\u6863\u4fe1\u606f-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"tender#tenderProjectArchiveAttachmentHead:edit"})
    @SrmValidated
    public Result<?> edit(@RequestBody TenderProjectArchiveAttachmentHeadVo headVo) {
        TenderProjectArchiveAttachmentHead archiveAttachmentHead = (TenderProjectArchiveAttachmentHead)((Object)SysUtil.copyProperties((Object)((Object)headVo), TenderProjectArchiveAttachmentHead.class));
        List<TenderProjectArchiveAttachmentInfo> archiveAttachmentInfoList = headVo.getArchiveAttachmentInfoList();
        this.tenderProjectArchiveAttachmentHeadService.edit(archiveAttachmentHead, archiveAttachmentInfoList);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6587\u4ef6\u5f52\u6863\u4fe1\u606f-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/deleteInfoById"})
    @RequiresPermissions(value={"tender#tenderProjectArchiveAttachmentHead:deleteInfoById"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.tenderProjectArchiveAttachmentinfoService.deleteBatchByIds(Arrays.asList(id));
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6587\u4ef6\u5f52\u6863\u4fe1\u606f-\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"tender#tenderProjectArchiveAttachmentHead:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.tenderProjectArchiveAttachmentHeadService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2", description="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2")
    @GetMapping(value={"/queryBySubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryBySubpackageId(@RequestParam(name="subpackageId") String subpackageId) {
        List<TenderProjectArchiveAttachmentInfoVo> infoVoList = this.tenderProjectArchiveAttachmentHeadService.queryBySubpackageId(subpackageId);
        return Result.ok(infoVoList);
    }

    @Operation(summary="\u901a\u8fc7\u9879\u76eeid\u67e5\u8be2", description="\u901a\u8fc7\u9879\u76eeid\u67e5\u8be2")
    @GetMapping(value={"/queryByProjectId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryByProjectId(@RequestParam(name="projectId") String projectId) {
        List<TenderProjectArchiveAttachmentInfoVo> infoVoList = this.tenderProjectArchiveAttachmentHeadService.queryByProjectId(projectId);
        return Result.ok(infoVoList);
    }

    @AutoLog(value="\u6587\u4ef6\u5f52\u6863\u4fe1\u606f-\u79fb\u4ea4")
    @Operation(summary="\u79fb\u4ea4", description="\u79fb\u4ea4")
    @PostMapping(value={"/transfer"})
    @RequiresPermissions(value={"tender#tenderProjectArchiveAttachmentHead:transfer"})
    @SrmValidated
    public Result<?> transfer(@RequestBody TenderProjectArchiveAttachmentHeadVo headVo) {
        this.tenderProjectArchiveAttachmentHeadService.transfer(headVo);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u6587\u4ef6\u5f52\u6863\u4fe1\u606f-\u5f52\u6863")
    @Operation(summary="\u5f52\u6863", description="\u5f52\u6863")
    @PostMapping(value={"/archive"})
    @RequiresPermissions(value={"tender#tenderProjectArchiveAttachmentHead:archive"})
    @SrmValidated
    public Result<?> archive(@RequestBody TenderProjectArchiveAttachmentHeadVo headVo) {
        this.tenderProjectArchiveAttachmentHeadService.archive(headVo);
        return this.commonSuccessResult(3);
    }

    @Operation(summary="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2\u8865\u5145\u6750\u6599", description="\u901a\u8fc7\u5206\u5305id\u67e5\u8be2\u8865\u5145\u6750\u6599")
    @GetMapping(value={"/queryBySubpackageIdSupplement"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryBySubpackageIdSupplement(@RequestParam(name="subpackageId") String subpackageId) {
        List<TenderProjectArchiveAttachmentInfo> infoVoList = this.tenderProjectArchiveAttachmentHeadService.queryBySubpackageIdSupplement(subpackageId);
        return Result.ok(infoVoList);
    }

    @Operation(summary="\u901a\u8fc7\u9879\u76eeid\u67e5\u8be2", description="\u901a\u8fc7\u9879\u76eeid\u67e5\u8be2")
    @GetMapping(value={"/queryByProjectIdSupplement"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryByProjectIdSupplement(@RequestParam(name="projectId") String projectId) {
        List<TenderProjectArchiveAttachmentInfo> infoVoList = this.tenderProjectArchiveAttachmentHeadService.queryByProjectIdSupplement(projectId);
        return Result.ok(infoVoList);
    }
}

