/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.ParentEntityDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.BusMessageVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.tender.clarification.entity.PurchaseTenderClarificationInfo;
import com.els.modules.tender.clarification.entity.SaleTenderClarificationInfo;
import com.els.modules.tender.clarification.enumerate.SaleTenderClarificationStatusEnum;
import com.els.modules.tender.clarification.mapper.SaleTenderClarificationInfoMapper;
import com.els.modules.tender.clarification.service.PurchaseTenderClarificationInfoService;
import com.els.modules.tender.clarification.service.SaleTenderClarificationInfoService;
import com.els.modules.tender.clarification.vo.SaleTenderClarificationInfoVO;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.FastJsonUtils;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.utils.TenderProjectMemberUtils;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleTenderClarificationInfoServiceImpl
extends BaseServiceImpl<SaleTenderClarificationInfoMapper, SaleTenderClarificationInfo>
implements SaleTenderClarificationInfoService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private TenderProjectSupplierService tenderProjectSupplierService;
    @Autowired
    private PurchaseTenderClarificationInfoService purchaseTenderClarificationInfoService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    @Lazy
    private PurchaseTenderProjectHeadService projectHeadService;
    @Resource
    private RedisUtil redisUtil;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void batchAdd(PurchaseTenderClarificationInfo purchaseTenderClarificationInfo, List<PurchaseAttachmentDTO> purchaseAttachmentDTOS) {
        SaleTenderClarificationInfo saleTenderClarificationInfo = (SaleTenderClarificationInfo)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderClarificationInfo), SaleTenderClarificationInfo.class));
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.eq(TenderProjectSupplier::getSubpackageId, (Object)saleTenderClarificationInfo.getSubpackageId())).eq(TenderProjectSupplier::getEffective, (Object)"1");
        List tenderProjectSuppliers = this.tenderProjectSupplierService.list((Wrapper)qw);
        if (CollectionUtil.isEmpty((Collection)tenderProjectSuppliers)) {
            return;
        }
        ArrayList saleTenderClarificationInfos = new ArrayList();
        ArrayList saleAttachmentDTOS = new ArrayList();
        tenderProjectSuppliers.forEach(supplier -> {
            SaleTenderClarificationInfo tenderClarificationInfo = new SaleTenderClarificationInfo();
            saleTenderClarificationInfo.setElsAccount(supplier.getSupplierAccount());
            this.bulidSaleTenderClarificationInfoParam(tenderClarificationInfo, saleTenderClarificationInfo);
            saleTenderClarificationInfos.add(tenderClarificationInfo);
            this.bulidSaleAttachmentDTOParam(saleAttachmentDTOS, purchaseAttachmentDTOS, tenderClarificationInfo);
        });
        this.saveBatch(saleTenderClarificationInfos);
        if (CollectionUtil.isEmpty(saleAttachmentDTOS)) {
            return;
        }
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentDTOS);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public SaleTenderClarificationInfo add(PurchaseTenderClarificationInfo purchaseTenderClarificationInfo, List<PurchaseAttachmentDTO> purchaseAttachmentDTOS) {
        SaleTenderClarificationInfo saleTenderClarificationInfo = (SaleTenderClarificationInfo)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderClarificationInfo), SaleTenderClarificationInfo.class));
        ArrayList<SaleAttachmentDTO> saleAttachmentDTOS = new ArrayList<SaleAttachmentDTO>();
        SaleTenderClarificationInfo tenderClarificationInfo = new SaleTenderClarificationInfo();
        saleTenderClarificationInfo.setElsAccount(TenantContext.getTenant());
        this.bulidSaleTenderClarificationInfoParam(tenderClarificationInfo, saleTenderClarificationInfo);
        this.bulidSaleAttachmentDTOParam(saleAttachmentDTOS, purchaseAttachmentDTOS, tenderClarificationInfo);
        this.save((Object)tenderClarificationInfo);
        if (CollectionUtil.isEmpty(saleAttachmentDTOS)) {
            return tenderClarificationInfo;
        }
        saleAttachmentDTOS.forEach(saleAttachmentDTO -> saleAttachmentDTO.setHeadId(tenderClarificationInfo.getId()));
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentDTOS);
        return tenderClarificationInfo;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public SaleTenderClarificationInfo confirm(String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SaleTenderClarificationInfo::getRelationId, (Object)id);
        queryWrapper.eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        List list = this.list((Wrapper)queryWrapper);
        SaleTenderClarificationInfo saleTenderClarificationInfo = null;
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            saleTenderClarificationInfo = (SaleTenderClarificationInfo)((Object)list.get(0));
        }
        if (saleTenderClarificationInfo == null) {
            PurchaseTenderClarificationInfo purchaseTenderClarificationInfo = (PurchaseTenderClarificationInfo)((Object)this.purchaseTenderClarificationInfoService.getById((Serializable)((Object)id)));
            Assert.notNull((Object)((Object)purchaseTenderClarificationInfo), (String)I18nUtil.translate((String)"i18n_alert_uhtkWVXVsKW_7413de8f", (String)"\u975e\u6cd5\u64cd\u4f5c\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5!"));
            List purchaseAttachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
            saleTenderClarificationInfo = this.add(purchaseTenderClarificationInfo, purchaseAttachmentDTOS);
        }
        Assert.isTrue((boolean)StrUtil.isBlank((CharSequence)saleTenderClarificationInfo.getRelationId()), (String)I18nUtil.translate((String)"i18n_alert_WFIHWVKHRvjW_e5feb3d4", (String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!"));
        Assert.isTrue((boolean)SaleTenderClarificationStatusEnum.NOT_CONFIRM.getValue().equals(saleTenderClarificationInfo.getStatus()), (String)I18nUtil.translate((String)"i18n_alert_xqVBRLW_40b96ac9", (String)"\u4e0d\u53ef\u91cd\u590d\u786e\u8ba4!"));
        this.purchaseTenderClarificationInfoService.addConfirmNumber(saleTenderClarificationInfo.getRelationId());
        saleTenderClarificationInfo.setStatus(SaleTenderClarificationStatusEnum.CONFIRM.getValue());
        ((SaleTenderClarificationInfoMapper)this.baseMapper).updateById((Object)saleTenderClarificationInfo);
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.subpackageInfoService.selectById(saleTenderClarificationInfo.getSubpackageId());
        String operation = "preConfirmClarification";
        if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(saleTenderClarificationInfo.getCheckType())) {
            operation = "confirmClarification";
        }
        List<ElsSubAccountDTO> accountDTOList = TenderProjectMemberUtils.getTenderProjectMember(saleTenderClarificationInfo.getTenderProjectId());
        StringBuilder urlParams = new StringBuilder("tenderProjectId=").append(saleTenderClarificationInfo.getTenderProjectId()).append("&subpackageId=").append(saleTenderClarificationInfo.getSubpackageId());
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        Map params = FastJsonUtils.toMap((Object)saleTenderClarificationInfo);
        params.put("subpackageName", subpackageInfo.getSubpackageName());
        params.put("tenderProjectName", subpackageInfo.getTenderProjectName());
        params.put("supplierName", loginUser.getCompanySet().get((Object)"companyName"));
        List collect = accountDTOList.stream().map(ParentEntityDTO::getId).distinct().collect(Collectors.toList());
        BusMessageVO messageVO = BusMessageVO.builder().businessId(saleTenderClarificationInfo.getTenderProjectId()).msgConfigCode("tender_" + operation).businessBean("tenderBusDataServiceImpl").receiveSubAccountIdList(collect).build();
        super.sendMessage(messageVO);
        return saleTenderClarificationInfo;
    }

    private void bulidSaleTenderClarificationInfoParam(SaleTenderClarificationInfo saleTenderClarificationInfo, SaleTenderClarificationInfo dataSource) {
        saleTenderClarificationInfo.setId(IdWorker.getIdStr());
        saleTenderClarificationInfo.setSubpackageId(dataSource.getSubpackageId());
        saleTenderClarificationInfo.setTenderProjectId(dataSource.getTenderProjectId());
        saleTenderClarificationInfo.setRelationId(dataSource.getId());
        saleTenderClarificationInfo.setClarificationNumber(dataSource.getClarificationNumber());
        saleTenderClarificationInfo.setTitle(dataSource.getTitle());
        saleTenderClarificationInfo.setPublishTime(dataSource.getPublishTime());
        saleTenderClarificationInfo.setConfirmNumber(0);
        saleTenderClarificationInfo.setTotal(0);
        saleTenderClarificationInfo.setCheckType(dataSource.getCheckType());
        saleTenderClarificationInfo.setStatus(SaleTenderClarificationStatusEnum.NOT_CONFIRM.getValue());
        saleTenderClarificationInfo.setFileClarificationEndTime(dataSource.getFileClarificationEndTime());
        saleTenderClarificationInfo.setOpenBiddingTime(dataSource.getOpenBiddingTime());
        saleTenderClarificationInfo.setFileSubmitEndTime(dataSource.getFileSubmitEndTime());
        saleTenderClarificationInfo.setContent(dataSource.getContent());
        saleTenderClarificationInfo.setDeleted(CommonConstant.DEL_FLAG_0);
        Date nowData = new Date();
        saleTenderClarificationInfo.setUpdateBy(dataSource.getUpdateBy());
        saleTenderClarificationInfo.setUpdateTime(nowData);
        saleTenderClarificationInfo.setCreateBy(dataSource.getCreateBy());
        saleTenderClarificationInfo.setCreateTime(nowData);
    }

    private void bulidSaleAttachmentDTOParam(List<SaleAttachmentDTO> SaleAttachmentDTOS, List<PurchaseAttachmentDTO> purchaseAttachmentDTOS, SaleTenderClarificationInfo saleTenderClarificationInfo) {
        if (CollectionUtil.isEmpty(purchaseAttachmentDTOS)) {
            return;
        }
        ArrayList saleAttachmentDTOS = SysUtil.copyProperties(purchaseAttachmentDTOS, SaleAttachmentDTO.class);
        saleAttachmentDTOS.forEach(saleAttachmentDTO -> {
            saleAttachmentDTO.setId(IdWorker.getIdStr());
            saleAttachmentDTO.setHeadId(saleTenderClarificationInfo.getId());
        });
        SaleAttachmentDTOS.addAll(saleAttachmentDTOS);
    }

    @Override
    public List<SaleTenderClarificationInfo> selectByMainId(SaleTenderClarificationInfo saleTenderClarificationInfo) {
        return ((SaleTenderClarificationInfoMapper)this.baseMapper).selectByMainId(saleTenderClarificationInfo);
    }

    @Override
    public List<SaleTenderClarificationInfoVO> selectByMainId(String subpackageId) {
        SaleTenderClarificationInfo saleTenderClarificationInfo = new SaleTenderClarificationInfo();
        saleTenderClarificationInfo.setSubpackageId(subpackageId);
        saleTenderClarificationInfo.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
        saleTenderClarificationInfo.setElsAccount(TenantContext.getTenant());
        List<SaleTenderClarificationInfo> clarificationInfoList = ((SaleTenderClarificationInfoMapper)this.baseMapper).selectByMainId(saleTenderClarificationInfo);
        ArrayList saleTenderClarificationInfoVOList = SysUtil.copyProperties(clarificationInfoList, SaleTenderClarificationInfoVO.class);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(TenderProjectSupplier::getSubpackageId, (Object)subpackageId)).eq(TenderProjectSupplier::getSupplierAccount, (Object)TenantContext.getTenant());
        List supplierList = this.tenderProjectSupplierService.list((Wrapper)queryWrapper);
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty((Collection)supplierList), (String)I18nUtil.translate((String)"i18n_alert_APeyLsUmmYB_1655988d", (String)"\u5f53\u524d\u8d26\u53f7\u672a\u53c2\u4e0e\u6b64\u6b21\u62db\u6807\uff01"));
        String responseStatus = "0";
        if (CollectionUtil.isNotEmpty((Collection)supplierList)) {
            TenderProjectSupplier supplier = (TenderProjectSupplier)((Object)supplierList.get(0));
            responseStatus = SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(TenderFlagInjectionContext.getTenderCheckType()) ? supplier.getPreResponseStatus() : supplier.getResponseStatus();
        }
        for (SaleTenderClarificationInfoVO saleTenderClarificationInfoVO : saleTenderClarificationInfoVOList) {
            saleTenderClarificationInfoVO.setResponseStatus(responseStatus);
        }
        return saleTenderClarificationInfoVOList;
    }
}

