/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.project.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectHeadVO;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;

@RpcService(value="purchaseTenderAuditCallBackServiceImpl")
public class PurchaseTenderProjectAdapter
implements WorkflowAuditOptCallBackService {
    @Resource
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;
    @Resource
    private PurchaseTenderProjectSubpackageInfoService purchaseTenderProjectSubpackageInfoService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        List<PurchaseTenderProjectSubpackageInfo> PurchaseTenderProjectSubpackageInfoList = this.purchaseTenderProjectSubpackageInfoService.selectByMainId(flowCallbackDTO.getBusinessId());
        PurchaseTenderProjectSubpackageInfoList.parallelStream().forEach(item -> item.setStatus(TenderProjectSubpackageStatusEnum.AUDIT_DOING.getValue()));
        this.purchaseTenderProjectSubpackageInfoService.updateBatchById(PurchaseTenderProjectSubpackageInfoList);
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        this.purchaseTenderProjectHeadService.publish(flowCallbackDTO.getBusinessId());
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
        List<PurchaseTenderProjectSubpackageInfo> PurchaseTenderProjectSubpackageInfoList = this.purchaseTenderProjectSubpackageInfoService.selectByMainId(flowCallbackDTO.getBusinessId());
        PurchaseTenderProjectSubpackageInfoList.parallelStream().forEach(item -> item.setStatus(TenderProjectSubpackageStatusEnum.AUDIT_REJECT.getValue()));
        this.purchaseTenderProjectSubpackageInfoService.updateBatchById(PurchaseTenderProjectSubpackageInfoList);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
        List<PurchaseTenderProjectSubpackageInfo> PurchaseTenderProjectSubpackageInfoList = this.purchaseTenderProjectSubpackageInfoService.selectByMainId(flowCallbackDTO.getBusinessId());
        PurchaseTenderProjectSubpackageInfoList.parallelStream().forEach(item -> item.setStatus(TenderProjectSubpackageStatusEnum.NEW.getValue()));
        this.purchaseTenderProjectSubpackageInfoService.updateBatchById(PurchaseTenderProjectSubpackageInfoList);
    }

    public Map<String, Object> getById(String id) {
        PurchaseTenderProjectHeadVO head = this.purchaseTenderProjectHeadService.queryById(id);
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseTenderProjectHeadVO updateHead = this.purchaseTenderProjectHeadService.queryById(flowCallbackDTO.getBusinessId());
        updateHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        updateHead.setAuditStatus(auditStatus);
        this.purchaseTenderProjectHeadService.updateById((Object)updateHead);
    }
}

