/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.sale.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.tender.sale.enumerate.TenderProjectSourceTypeEnum;
import com.els.modules.tender.sale.vo.TenderProjectSignUpVO;
import com.els.modules.tender.supplier.entity.TenderProjectSignUp;
import com.els.modules.tender.supplier.entity.TenderProjectSignUpExamine;
import com.els.modules.tender.supplier.service.TenderProjectSignUpRejectService;
import com.els.modules.tender.supplier.service.TenderProjectSignUpService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u4f9b\u5e94\u5546\u6295\u6807\u9879\u76ee\u62a5\u540d\u8868")
@RestController
@RequestMapping(value={"/tender/sale/supplierTenderProjectSignUp"})
public class SaleTenderProjectSignUpController
extends BaseController<TenderProjectSignUp, TenderProjectSignUpService> {
    @Autowired
    private TenderProjectSignUpService tenderProjectSignUpService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private TenderProjectSignUpRejectService tenderProjectSignUpRejectService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    public Result<?> queryPageList(TenderProjectSignUp tenderProjectSignUp, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)tenderProjectSignUp), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.tenderProjectSignUpService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u6295\u6807\u9879\u76ee\u62a5\u540d\u8868-\u63d0\u4ea4")
    @Operation(summary="\u62a5\u540d-\u63d0\u4ea4", description="\u62a5\u540d-\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @SrmValidated
    public Result<?> submit(@RequestBody TenderProjectSignUpVO supplierTenderProjectSignUpVO) {
        TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)SysUtil.copyProperties((Object)((Object)supplierTenderProjectSignUpVO), TenderProjectSignUp.class));
        this.build(tenderProjectSignUp);
        this.tenderProjectSignUpService.saveOrUpdatePublish(tenderProjectSignUp, supplierTenderProjectSignUpVO.getAttachmentList());
        return Result.ok((Object)((Object)tenderProjectSignUp));
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u6295\u6807\u9879\u76ee\u62a5\u540d\u8868-\u65b0\u589e")
    @Operation(summary="\u65b0\u589e", description="\u65b0\u589e")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @SrmValidated
    public Result<?> add(@RequestBody TenderProjectSignUpVO supplierTenderProjectSignUpVO) {
        TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)SysUtil.copyProperties((Object)((Object)supplierTenderProjectSignUpVO), TenderProjectSignUp.class));
        this.build(tenderProjectSignUp);
        this.tenderProjectSignUpService.add(tenderProjectSignUp, supplierTenderProjectSignUpVO.getAttachmentList());
        return Result.ok((Object)((Object)tenderProjectSignUp));
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u6295\u6807\u9879\u76ee\u62a5\u540d\u8868-\u62a5\u540d")
    @Operation(summary="\u4fee\u6539", description="\u4fee\u6539")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @SrmValidated
    public Result<?> edit(@RequestBody TenderProjectSignUpVO supplierTenderProjectSignUpVO) {
        TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)SysUtil.copyProperties((Object)((Object)supplierTenderProjectSignUpVO), TenderProjectSignUp.class));
        this.build(tenderProjectSignUp);
        this.tenderProjectSignUpService.edit(tenderProjectSignUp, supplierTenderProjectSignUpVO.getAttachmentList());
        String id = tenderProjectSignUp.getId();
        return this.queryById(id);
    }

    @Operation(summary="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    public Result<?> queryTabsCount() {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        List<CountVO> countVOList = this.tenderProjectSignUpService.queryTabsCount(TenantContext.getTenant());
        Map<String, Long> countMap = countVOList.stream().collect(Collectors.toMap(o -> o.getValue(), o -> o.getTotal()));
        long totalCount = countVOList.stream().mapToLong(CountVO::getTotal).sum();
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "status", null, totalCount));
        List dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("tenderProjectSignUpStatus", TenantContext.getTenant());
        Collections.sort(dictDTOList, (firstObj, secondObj) -> Integer.valueOf(firstObj.getValue()) - Integer.valueOf(secondObj.getValue()));
        for (DictDTO status : dictDTOList) {
            long count = countMap.get(status.getValue()) == null ? 0L : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "status", status.getValue(), count));
        }
        return Result.ok(result);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TenderProjectSignUpVO tenderProjectSignUpVO = this.getById(id);
        return Result.ok((Object)((Object)tenderProjectSignUpVO));
    }

    private TenderProjectSignUpVO getById(String id) {
        TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)this.tenderProjectSignUpService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        List saleAttachmentDemandDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        TenderProjectSignUpVO tenderProjectSignUpVO = (TenderProjectSignUpVO)((Object)SysUtil.copyProperties((Object)((Object)tenderProjectSignUp), TenderProjectSignUpVO.class));
        tenderProjectSignUpVO.setAttachmentList(saleAttachmentDemandDTOS);
        List<TenderProjectSignUpExamine> tenderProjectSignUpRejects = this.tenderProjectSignUpRejectService.selectByMainId(tenderProjectSignUp.getId());
        tenderProjectSignUpVO.setTenderProjectSignUpRejectList(tenderProjectSignUpRejects);
        tenderProjectSignUpVO.setBusAccount(tenderProjectSignUp.getPurchaseEnterpriseAccount());
        return tenderProjectSignUpVO;
    }

    @Operation(summary="\u67e5\u8be2\u62a5\u540d\u4fe1\u606f", description="\u67e5\u8be2\u62a5\u540d\u4fe1\u606f")
    @GetMapping(value={"/queryBySubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryBySubpackageId(@RequestParam(name="subpackageId") String subpackageId) {
        TenderProjectSignUpVO tenderProjectSignUpVO = this.tenderProjectSignUpService.querySignInfo(subpackageId);
        return Result.ok((Object)((Object)tenderProjectSignUpVO));
    }

    @Operation(summary="\u5220\u9664", description="\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.tenderProjectSignUpService.delete(id);
        return Result.ok();
    }

    private void build(TenderProjectSignUp tenderProjectSignUp) {
        tenderProjectSignUp.setSourceType(TenderProjectSourceTypeEnum.ON_LINE.getValue());
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        tenderProjectSignUp.setSupplierAccount(loginUser.getElsAccount());
        tenderProjectSignUp.setSupplierName(loginUser.getCompanyName());
        tenderProjectSignUp.setSupplierSubAccount(loginUser.getSubAccount());
        tenderProjectSignUp.setElsAccount(tenderProjectSignUp.getSupplierAccount());
    }
}

