/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.aspect.DictTranslateAspect;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SrmRpcUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.ebidding.utils.CompareIPUtils;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.entity.PurchaseEnquiryItemHis;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.mapper.PurchaseEnquiryItemMapper;
import com.els.modules.enquiry.service.EnquirySubstituteItemService;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemHisService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.enquiry.vo.EnquiryItemPriceVO;
import com.els.modules.enquiry.vo.SupplierEnquiryItemAmountVO;
import com.els.modules.enquiry.vo.SupplierEnquiryItemPriceVO;
import com.els.modules.enquiry.vo.SupplierEnquiryItemQuantityVO;
import com.els.modules.exchange.rpc.dto.BpExchangeRateDTO;
import com.els.modules.inquiry.enumerate.QuoteTypeEnum;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMainDataRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialUnitNewDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PurchaseEnquiryItemServiceImpl
extends ServiceImpl<PurchaseEnquiryItemMapper, PurchaseEnquiryItem>
implements PurchaseEnquiryItemService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseEnquiryItemServiceImpl.class);
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    @Autowired
    private EnquirySupplierListService enquirySupplierListService;
    @Autowired
    @Lazy
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private EnquirySubstituteItemService enquirySubstituteItemService;
    @Autowired
    private PurchaseEnquiryItemHisService purchaseEnquiryItemHisService;
    @Autowired
    private PurchaseEnquiryItemHisService enquiryItemHisService;
    @Autowired
    private InquiryInvokeMainDataRpcService mainDataRpcService;

    @Override
    public List<PurchaseEnquiryItem> selectByMainId(String mainId) {
        return ((PurchaseEnquiryItemMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseEnquiryItemMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public void deleteStatus(String mainId, String itemStatus) {
        ((PurchaseEnquiryItemMapper)this.baseMapper).deleteStatus(mainId, itemStatus);
    }

    @Override
    public void hideQuotePrice(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItem> itemList) {
        boolean showPrice;
        boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
        if (!showPrice) {
            for (PurchaseEnquiryItem item : itemList) {
                item.setPrice(null);
                item.setNetPrice(null);
                item.setTaxAmount(null);
                item.setNetAmount(null);
                item.setLadderPriceJson(this.hideLadderInfo(item.getQuotePriceWay(), item.getLadderPriceJson()));
                item.setCostFormJson(this.hideCostFormInfo(item.getQuotePriceWay(), item.getCostFormJson()));
            }
        }
    }

    private String hideLadderInfo(String quotePriceWay, String ladderPriceJson) {
        if (EnquiryQuoteWayEnum.LADDER.getValue().equals(quotePriceWay)) {
            JSONArray ladderPriceJsonArray = StrUtil.isNotBlank((CharSequence)ladderPriceJson) ? JSONArray.parseArray((String)ladderPriceJson) : new JSONArray();
            for (Object object : ladderPriceJsonArray) {
                JSONObject ladderItem = (JSONObject)object;
                ladderItem.put("price", null);
                ladderItem.put("netPrice", null);
                ladderItem.put("taxAmount", null);
                ladderItem.put("netAmount", null);
            }
            return ladderPriceJsonArray.toJSONString();
        }
        return ladderPriceJson;
    }

    private String hideCostFormInfo(String quotePriceWay, String costFormJson) {
        if (EnquiryQuoteWayEnum.COST.getValue().equals(quotePriceWay)) {
            JSONObject costFormJsonObject = StrUtil.isNotBlank((CharSequence)costFormJson) ? JSONObject.parseObject((String)costFormJson) : new JSONObject();
            JSONArray groups = costFormJsonObject.getJSONArray("groups") == null ? new JSONArray() : costFormJsonObject.getJSONArray("groups");
            for (Object object : groups) {
                JSONObject group = (JSONObject)object;
                group.put("totalValue", null);
            }
            JSONObject data = costFormJsonObject.getJSONObject("data") == null ? new JSONObject() : costFormJsonObject.getJSONObject("data");
            for (String key : data.keySet()) {
                data.put(key, (Object)new JSONArray());
            }
            return costFormJsonObject.toJSONString();
        }
        return costFormJson;
    }

    @Override
    public void replenishMaterialNumber(PurchaseEnquiryItem webItem) {
        List<PurchaseEnquiryItem> itemList = this.selectByMainId(webItem.getHeadId());
        this.checkMaterialNumber(webItem, itemList);
        List<PurchaseEnquiryItem> items = this.handlePurchaseEnquiryItemList(webItem, itemList);
        this.updateBatchById(items);
        this.saleEnquiryItemService.replenishMaterialNumber(items);
        this.enquirySubstituteItemService.replenishMaterialNumber(items);
        PurchaseEnquiryItem item = items.get(0);
        if (SourceTypeEnum.REQUEST.getValue().equals(item.getSourceType()) && StrUtil.isNotBlank((CharSequence)item.getSourceItemId())) {
            this.purchaseRequestItemService.replenishMaterial(item.getSourceItemId(), item.getMaterialNumber(), item.getMaterialDesc(), item.getMaterialGroup(), item.getMaterialSpec());
        }
        this.purchaseEnquiryItemHisService.replenishMaterialNumber(items);
    }

    private List<PurchaseEnquiryItem> handlePurchaseEnquiryItemList(PurchaseEnquiryItem webItem, List<PurchaseEnquiryItem> itemList) {
        List<PurchaseEnquiryItem> items = itemList.stream().filter(item -> item.getItemNumber().equals(webItem.getItemNumber())).collect(Collectors.toList());
        items.forEach(item -> {
            item.setMaterialNumber(webItem.getMaterialNumber());
            item.setMaterialName(webItem.getMaterialName());
            item.setMaterialDesc(webItem.getMaterialDesc());
            item.setMaterialGroup(webItem.getMaterialGroup());
            item.setMaterialSpec(webItem.getMaterialSpec());
            item.setMaterialGroupName(webItem.getMaterialGroupName());
            item.setMaterialId(webItem.getMaterialId());
        });
        return items;
    }

    private void checkMaterialNumber(PurchaseEnquiryItem webItem, List<PurchaseEnquiryItem> itemList) {
        List materialNumbers = itemList.stream().map(PurchaseEnquiryItem::getMaterialNumber).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(materialNumbers)) {
            return;
        }
        boolean b = materialNumbers.stream().anyMatch(item -> item.equals(webItem.getMaterialNumber()));
        if (b) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n__SLAoxOVB_f1d5e3eb", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u91cd\u590d"));
        }
    }

    @Override
    public void exportCompare(PurchaseEnquiryHead dbHead, HttpServletResponse response) {
        List<PurchaseEnquiryItem> itemList = ((PurchaseEnquiryItemMapper)this.baseMapper).selectByMainId(dbHead.getId());
        List itemHisList = this.purchaseEnquiryItemHisService.list((Wrapper)new LambdaQueryWrapper().eq(PurchaseEnquiryItemHis::getHeadId, (Object)dbHead.getId()));
        List toElsAccountList = itemHisList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getToElsAccount())).map(PurchaseEnquiryItemHis::getToElsAccount).distinct().collect(Collectors.toList());
        this.hidePriceHis(dbHead, itemHisList);
        this.hideQuotePrice(dbHead, itemList);
        Map<String, List<PurchaseEnquiryItemHis>> groupItem = itemHisList.stream().collect(Collectors.groupingBy(item -> item.getMaterialNumber() + "_" + item.getQuoteCount()));
        Comparator<PurchaseEnquiryItemHis> comparing = Comparator.comparing(PurchaseEnquiryItemHis::getQuoteCount);
        Map<String, Optional<PurchaseEnquiryItemHis>> eldestByClass = itemHisList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHis::getToElsAccount, Collectors.reducing(BinaryOperator.maxBy(comparing))));
        itemHisList.clear();
        for (Map.Entry<String, List<PurchaseEnquiryItemHis>> entry : groupItem.entrySet()) {
            this.enquiryItemHisService.initCompareMsg(dbHead, entry.getValue());
            itemHisList.addAll((Collection)entry.getValue());
        }
        Result dbResult = Result.ok((Object)((Object)dbHead));
        ((DictTranslateAspect)SpringContextUtils.getBean(DictTranslateAspect.class)).dictTranslate((Object)dbResult);
        JSONObject headObject = (JSONObject)dbResult.getResult();
        List<PurchaseEnquiryItem> distinctList = itemList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEnquiryItem>(Comparator.comparing(PurchaseEnquiryItem::getItemNumber))), ArrayList::new));
        List<EnquirySupplierList> supplierList = this.enquirySupplierListService.selectByMainId(dbHead.getId()).stream().filter(item -> toElsAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
        ExcelWriter writer = new ExcelWriter(true, "\u5e38\u89c4\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, eldestByClass, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u540d\u79f0", "\u7269\u6599\u63cf\u8ff0", "\u7269\u6599\u89c4\u683c", "\u9700\u6c42\u6570\u91cf", "\u91c7\u8d2d\u5355\u4f4d", "\u76ee\u6807\u5355\u4ef7", "\u5de5\u5382", "\u5e93\u5b58\u5730\u70b9", "\u5bf9\u6bd4\u9879"));
        int firstRow = 1;
        List<PurchaseEnquiryItem> normalItemList = distinctList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> EnquiryQuoteWayEnum.NORMAL.getValue().equals(item.getQuotePriceWay())).collect(Collectors.toList());
        List<JSONObject> data = this.getDictJsonObjects(normalItemList);
        int i = 0;
        for (PurchaseEnquiryItem item2 : normalItemList) {
            JSONObject jsonObject = data.get(i);
            writer.merge(firstRow, firstRow + 16, 0, 0, (Object)item2.getEnquiryNumber(), false);
            writer.merge(firstRow, firstRow + 16, 1, 1, (Object)item2.getItemNumber(), false);
            writer.merge(firstRow, firstRow + 16, 2, 2, (Object)item2.getMaterialNumber(), false);
            writer.merge(firstRow, firstRow + 16, 3, 3, (Object)item2.getMaterialName(), false);
            writer.merge(firstRow, firstRow + 16, 4, 4, (Object)item2.getMaterialDesc(), false);
            writer.merge(firstRow, firstRow + 16, 5, 5, (Object)item2.getMaterialSpec(), false);
            writer.merge(firstRow, firstRow + 16, 6, 6, (Object)item2.getRequireQuantity(), false);
            writer.merge(firstRow, firstRow + 16, 7, 7, (Object)jsonObject.getString("purchaseUnit_dictText"), false);
            writer.merge(firstRow, firstRow + 16, 8, 8, (Object)item2.getFuturePrice(), false);
            writer.merge(firstRow, firstRow + 16, 9, 9, (Object)jsonObject.getString("factory_dictText"), false);
            writer.merge(firstRow, firstRow + 16, 10, 10, (Object)jsonObject.getString("storageLocation_dictText"), false);
            ++i;
            writer.writeCellValue(11, firstRow, (Object)"\u542b\u7a0e\u4ef7");
            writer.writeCellValue(11, firstRow + 1, (Object)"\u672a\u7a0e\u5355\u4ef7");
            writer.writeCellValue(11, firstRow + 2, (Object)"\u7a0e\u7387");
            writer.writeCellValue(11, firstRow + 3, (Object)"\u4ea4\u8d27\u65e5\u671f");
            writer.writeCellValue(11, firstRow + 4, (Object)"\u62a5\u4ef7\u65f6\u95f4");
            writer.writeCellValue(11, firstRow + 5, (Object)"\u6700\u5c0f\u5305\u88c5\u91cf");
            writer.writeCellValue(11, firstRow + 6, (Object)"\u6700\u5c0f\u8ba2\u5355\u91cf");
            writer.writeCellValue(11, firstRow + 7, (Object)"\u4ef7\u683c\u751f\u6548\u65f6\u95f4");
            writer.writeCellValue(11, firstRow + 8, (Object)"\u4ef7\u683c\u5931\u6548\u65f6\u95f4");
            writer.writeCellValue(11, firstRow + 9, (Object)"\u62a5\u4ef7\u8f6e\u6b21");
            writer.writeCellValue(11, firstRow + 10, (Object)"\u4ed8\u6b3e\u6761\u4ef6");
            writer.writeCellValue(11, firstRow + 11, (Object)"\u56fd\u8d38\u6761\u4ef6");
            writer.writeCellValue(11, firstRow + 12, (Object)"\u5386\u53f2\u6700\u4f4e\u4ef7");
            writer.writeCellValue(11, firstRow + 13, (Object)"\u4f9b\u5e94\u5546\u5386\u53f2\u6700\u4f4e\u4ef7");
            writer.writeCellValue(11, firstRow + 14, (Object)"\u7d2f\u8ba1\u91c7\u8d2d\u989d");
            writer.writeCellValue(11, firstRow + 15, (Object)"\u7d2f\u8ba1\u91c7\u8d2d\u91cf");
            writer.writeCellValue(11, firstRow + 16, (Object)"\u8fd1\u4e09\u4e2a\u6708\u603b\u91c7\u8d2d\u989d");
            firstRow += 17;
        }
        Map<String, Integer> collect = normalItemList.stream().collect(Collectors.toMap(PurchaseEnquiryItem::getItemNumber, item -> normalItemList.indexOf(item)));
        AtomicInteger x = new AtomicInteger(12);
        if (!CollectionUtils.isEmpty(normalItemList)) {
            for (EnquirySupplierList supplier : supplierList) {
                List dataList = itemHisList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).filter(item -> EnquiryQuoteWayEnum.NORMAL.getValue().equals(item.getQuotePriceWay())).collect(Collectors.toList());
                Map<String, List<PurchaseEnquiryItemHis>> itemByNumberMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHis::getItemNumber));
                AtomicReference<AtomicInteger> y = new AtomicReference<AtomicInteger>(new AtomicInteger(1));
                int[] row = new int[]{0};
                itemByNumberMap.forEach((itemNumber, v) -> {
                    if (v.size() > row[0]) {
                        row[0] = v.size();
                    }
                    y.set(new AtomicInteger((Integer)collect.get(itemNumber) * 17 + 1));
                    AtomicInteger finalX = new AtomicInteger(x.get());
                    v.stream().sorted(Comparator.comparing(PurchaseEnquiryItemHis::getQuoteCount)).forEach(item -> {
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get(), (Object)item.getPrice().setScale(6));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 1, (Object)item.getNetPrice().setScale(6));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 2, (Object)item.getTaxRate());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 3, item.getDeliveryDate() == null ? null : DateUtil.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 4, item.getQuoteTime() == null ? null : DateUtil.format((Date)item.getQuoteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 5, (Object)item.getMinPackQuantity());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 6, (Object)item.getMinOrderQuantity());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 7, item.getEffectiveDate() == null ? null : DateUtil.format((Date)item.getEffectiveDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 8, item.getExpiryDate() == null ? null : DateUtil.format((Date)item.getExpiryDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 9, (Object)item.getQuoteCount());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 10, headObject.get((Object)"payTermsCode_dictText"));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 11, headObject.get((Object)"tradeCondition_dictText"));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 12, (Object)item.getHisMinPrice());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 13, (Object)item.getSupplierHisMinPrice());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 14, (Object)item.getSupplierSumAmount());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 15, (Object)item.getSumQuantity());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + 16, (Object)item.getThreeMonthsSumAmount());
                        writer.setColumnWidth(finalX.get(), 16);
                        finalX.getAndIncrement();
                    });
                });
                if (row[0] > 1) {
                    writer.merge(0, 0, x.get(), x.addAndGet(row[0]) - 1, (Object)supplier.getSupplierName(), true);
                    continue;
                }
                x.addAndGet(row[0]);
            }
        }
        distinctList = distinctList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).collect(Collectors.toList());
        this.ladderCompare(headObject, writer, itemHisList, distinctList, supplierList);
        this.costCompare(headObject, writer, itemHisList, itemList, supplierList);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u6bd4\u4ef7\u62a5\u8868.xlsx".getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        try (ServletOutputStream out = response.getOutputStream();){
            writer.flush((OutputStream)out);
            writer.close();
        }
        catch (IOException e) {
            log.error("IO\u5f02\u5e38:", (Throwable)e);
        }
    }

    private void hidePriceHis(PurchaseEnquiryHead dbHead, List<PurchaseEnquiryItemHis> itemHisList) {
        boolean showPrice;
        boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
        if (!showPrice) {
            for (PurchaseEnquiryItemHis itemHis : itemHisList) {
                itemHis.setPrice(null);
                itemHis.setNetPrice(null);
                itemHis.setTaxAmount(null);
                itemHis.setNetAmount(null);
                itemHis.setLadderPriceJson(this.hideLadderInfo(itemHis.getQuotePriceWay(), itemHis.getLadderPriceJson()));
                itemHis.setCostFormJson(this.hideCostFormInfo(itemHis.getQuotePriceWay(), itemHis.getCostFormJson()));
            }
        }
    }

    @Override
    public Map<String, Long> getSupplierPortraitCount(String toElsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEnquiryItem::getToElsAccount, (Object)toElsAccount);
        queryWrapper.eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        List allList = this.list((Wrapper)queryWrapper);
        long participationCount = allList.stream().map(PurchaseEnquiryItem::getHeadId).distinct().count();
        long biddingWinCount = allList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).map(PurchaseEnquiryItem::getHeadId).distinct().count();
        HashMap<String, Long> returnMap = new HashMap<String, Long>();
        returnMap.put("participationCount", participationCount);
        returnMap.put("biddingWinCount", biddingWinCount);
        return returnMap;
    }

    @Override
    public List<PurchaseEnquiryItem> queryEnquiryByDesc(List<String> materialDescs) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(PurchaseEnquiryItem::getItemStatus, new Object[]{EnquiryStatusEnum.ACCEPT.getValue(), EnquiryStatusEnum.PRICED.getValue()});
        lambdaQueryWrapper.in(PurchaseEnquiryItem::getMaterialDesc, materialDescs);
        lambdaQueryWrapper.and(qw -> ((LambdaQueryWrapper)qw.isNull(PurchaseEnquiryItem::getMaterialNumber)).or(qw1 -> qw1.eq(PurchaseEnquiryItem::getMaterialNumber, (Object)"")));
        return ((PurchaseEnquiryItemMapper)this.baseMapper).selectList((Wrapper)lambdaQueryWrapper);
    }

    private void ladderCompare(JSONObject headObject, ExcelWriter writer, List<PurchaseEnquiryItemHis> itemHisList, List<PurchaseEnquiryItem> distinctList, List<EnquirySupplierList> supplierList) {
        Comparator<PurchaseEnquiryItemHis> comparing = Comparator.comparing(PurchaseEnquiryItemHis::getQuoteCount);
        Map<String, Optional<PurchaseEnquiryItemHis>> eldestByClass = itemHisList.stream().filter(item -> EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())).collect(Collectors.groupingBy(PurchaseEnquiryItemHis::getToElsAccount, Collectors.reducing(BinaryOperator.maxBy(comparing))));
        writer.setSheet("\u9636\u68af\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, eldestByClass, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u540d\u79f0", "\u7269\u6599\u63cf\u8ff0", "\u7269\u6599\u89c4\u683c", "\u9700\u6c42\u6570\u91cf", "\u91c7\u8d2d\u5355\u4f4d", "\u76ee\u6807\u5355\u4ef7", "\u5de5\u5382", "\u5e93\u5b58\u5730\u70b9", "\u9636\u68af\u7ea7", ""));
        writer.merge(0, 0, 11, 12, (Object)"\u9636\u68af\u6bd4\u4ef7", true);
        int firstRow = 1;
        List<JSONObject> data = this.getDictJsonObjects(distinctList);
        int i = 0;
        List collect2 = itemHisList.stream().map(PurchaseEnquiryItemHis::getItemNumber).collect(Collectors.toList());
        for (PurchaseEnquiryItem item2 : distinctList) {
            JSONObject jsonObject = data.get(i);
            if (EnquiryQuoteWayEnum.LADDER.getValue().equals(item2.getQuotePriceWay()) && StrUtil.isNotBlank((CharSequence)item2.getLadderPriceJson())) {
                JSONArray array = JSONArray.parseArray((String)item2.getLadderPriceJson());
                this.mergeCell(writer, firstRow, array, item2, jsonObject);
                for (int index = 0; index < array.size(); ++index) {
                    JSONObject ladder = array.getJSONObject(index);
                    writer.writeCellValue(12, firstRow + index, (Object)ladder.getString("ladder"));
                }
                int index2 = 0;
                for (int index = array.size(); index < array.size() * 2; ++index) {
                    JSONObject ladder = array.getJSONObject(index2);
                    writer.writeCellValue(12, firstRow + index, (Object)ladder.getString("ladder"));
                    ++index2;
                }
                int rows = array.size() * 2 + 15;
                firstRow += rows;
            }
            ++i;
        }
        List collect1 = distinctList.stream().filter(item -> EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay()) && StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson())).sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).collect(Collectors.toList());
        List collect3 = collect1.stream().filter(item -> collect2.contains(item.getItemNumber())).sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).collect(Collectors.toList());
        Map<String, Integer> collect = collect3.stream().collect(Collectors.toMap(PurchaseEnquiryItem::getItemNumber, item -> collect3.indexOf(item)));
        HashMap<String, Integer> stringHashMap = new HashMap<String, Integer>();
        for (PurchaseEnquiryItemHis item3 : itemHisList) {
            if (!StrUtil.isNotBlank((CharSequence)item3.getLadderPriceJson()) || !collect.containsKey(item3.getItemNumber()) || stringHashMap.containsKey(item3.getItemNumber())) continue;
            JSONArray array1 = JSONArray.parseArray((String)item3.getLadderPriceJson());
            stringHashMap.put(item3.getItemNumber(), array1.size());
        }
        HashMap<String, Integer> itemRow = new HashMap<String, Integer>();
        for (i = 0; i < collect.size(); ++i) {
            for (String s : collect.keySet()) {
                Integer integer = collect.get(s);
                if (i != integer) continue;
                if (i == 0) {
                    itemRow.put(s, 1);
                    continue;
                }
                int y = 1;
                for (String next : collect.keySet()) {
                    if (Integer.valueOf(next) >= Integer.valueOf(s)) continue;
                    Integer integer1 = (Integer)stringHashMap.get(next);
                    y = y + integer1 * 2 + 15;
                }
                itemRow.put(s, y);
            }
        }
        AtomicInteger x = new AtomicInteger(13);
        for (EnquirySupplierList supplier : supplierList) {
            List dataList = itemHisList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> StrUtil.isNotBlank((CharSequence)item.getLadderPriceJson())).filter(item -> EnquiryQuoteWayEnum.LADDER.getValue().equals(item.getQuotePriceWay())).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
            Map<String, List<PurchaseEnquiryItemHis>> itemByNumberMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHis::getItemNumber));
            AtomicReference<AtomicInteger> y = new AtomicReference<AtomicInteger>(new AtomicInteger(1));
            int[] row = new int[]{0};
            AtomicInteger finalX1 = x;
            itemByNumberMap.forEach((itemNumber, v) -> {
                if (v.size() > row[0]) {
                    row[0] = v.size();
                }
                JSONArray array1 = JSONArray.parseArray((String)((PurchaseEnquiryItemHis)((Object)((Object)v.get(0)))).getLadderPriceJson());
                int size = array1.size();
                int rows = size * 2 + 15;
                AtomicInteger finalX = new AtomicInteger(finalX1.get());
                y.set(new AtomicInteger((Integer)itemRow.get(itemNumber)));
                v.stream().sorted(Comparator.comparing(PurchaseEnquiryItemHis::getQuoteCount)).forEach(item -> {
                    JSONArray array = JSONArray.parseArray((String)item.getLadderPriceJson());
                    for (int index = 0; index < array.size(); ++index) {
                        JSONObject ladder = array.getJSONObject(index);
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + index, (Object)ladder.getBigDecimal("price").setScale(6));
                    }
                    int index2 = 0;
                    for (int index = array.size(); index < array.size() * 2; ++index) {
                        JSONObject ladder = array.getJSONObject(index2);
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + index, (Object)ladder.getBigDecimal("netPrice").setScale(6));
                        ++index2;
                    }
                    writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + array.size() * 2, (Object)item.getTaxRate());
                    writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + array.size() * 2 + 1, item.getDeliveryDate() == null ? null : DateUtil.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd"));
                    writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + array.size() * 2 + 2, item.getQuoteTime() == null ? null : DateUtil.format((Date)item.getQuoteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + array.size() * 2 + 3, (Object)item.getMinPackQuantity());
                    writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + array.size() * 2 + 4, (Object)item.getMinOrderQuantity());
                    writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + array.size() * 2 + 5, item.getEffectiveDate() == null ? null : DateUtil.format((Date)item.getEffectiveDate(), (String)"yyyy-MM-dd"));
                    writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + array.size() * 2 + 6, item.getExpiryDate() == null ? null : DateUtil.format((Date)item.getExpiryDate(), (String)"yyyy-MM-dd"));
                    writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + array.size() * 2 + 7, (Object)item.getQuoteCount());
                    writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + array.size() * 2 + 8, headObject.get((Object)"payTermsCode_dictText"));
                    writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + array.size() * 2 + 9, headObject.get((Object)"tradeCondition_dictText"));
                    writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + array.size() * 2 + 10, (Object)item.getHisMinPrice());
                    writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + array.size() * 2 + 11, (Object)item.getSupplierHisMinPrice());
                    writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + array.size() * 2 + 12, (Object)item.getSupplierSumAmount());
                    writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + array.size() * 2 + 13, (Object)item.getSumQuantity());
                    writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + array.size() * 2 + 14, (Object)item.getThreeMonthsSumAmount());
                    writer.setColumnWidth(finalX.get(), 16);
                    finalX.getAndIncrement();
                });
            });
            if (row[0] > 1) {
                writer.merge(0, 0, x.get(), x.addAndGet(row[0]) - 1, (Object)supplier.getSupplierName(), true);
                continue;
            }
            x.addAndGet(row[0]);
        }
    }

    private List<JSONObject> getDictJsonObjects(List<PurchaseEnquiryItem> distinctList) {
        ArrayList itemList1 = new ArrayList();
        distinctList.forEach(e -> {
            PurchaseEnquiryItem item = new PurchaseEnquiryItem();
            BeanUtils.copyProperties((Object)e, (Object)((Object)item));
            itemList1.add(item);
        });
        Result dbResult = Result.ok(itemList1);
        ((DictTranslateAspect)SpringContextUtils.getBean(DictTranslateAspect.class)).dictTranslate((Object)dbResult);
        return (List)dbResult.getResult();
    }

    private void costCompare(JSONObject headObject, ExcelWriter writer, List<PurchaseEnquiryItemHis> itemHisList, List<PurchaseEnquiryItem> distinctList, List<EnquirySupplierList> supplierList) {
        Comparator<PurchaseEnquiryItemHis> comparing = Comparator.comparing(PurchaseEnquiryItemHis::getQuoteCount);
        Map<String, Optional<PurchaseEnquiryItemHis>> eldestByClass = itemHisList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHis::getToElsAccount, Collectors.reducing(BinaryOperator.maxBy(comparing))));
        writer.setSheet("\u6210\u672c\u6bd4\u4ef7");
        writer.writeHeadRow(this.getHeaderList(supplierList, eldestByClass, "\u8be2\u4ef7\u5355\u53f7", "\u8be2\u4ef7\u5355\u884c\u53f7", "\u7269\u6599\u7f16\u53f7", "\u7269\u6599\u540d\u79f0", "\u7269\u6599\u63cf\u8ff0", "\u7269\u6599\u89c4\u683c", "\u9700\u6c42\u6570\u91cf", "\u91c7\u8d2d\u5355\u4f4d", "\u76ee\u6807\u5355\u4ef7", "\u5de5\u5382", "\u5e93\u5b58\u5730\u70b9", "\u6210\u672c\u9879", ""));
        writer.merge(0, 0, 11, 12, (Object)"\u6210\u672c\u9879", true);
        int firstRow = 1;
        int i = 0;
        List collect2 = itemHisList.stream().map(PurchaseEnquiryItemHis::getItemNumber).collect(Collectors.toList());
        List distinctList1 = distinctList.stream().filter(item -> EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay()) && collect2.contains(item.getItemNumber()) && CharSequenceUtil.isNotBlank((CharSequence)item.getCostFormJson()) && !ObjectUtils.isEmpty((Object)JSON.parseObject((String)item.getCostFormJson()).getJSONArray("groups"))).sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEnquiryItem>(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber())))), ArrayList::new));
        if (CollectionUtils.isEmpty((Collection)distinctList1)) {
            return;
        }
        List<JSONObject> data = this.getDictJsonObjects(distinctList1);
        for (PurchaseEnquiryItem item2 : distinctList1) {
            JSONObject dictJsonObject = data.get(i);
            if (EnquiryQuoteWayEnum.COST.getValue().equals(item2.getQuotePriceWay()) && CharSequenceUtil.isNotBlank((CharSequence)item2.getCostFormJson())) {
                JSONObject jsonObject = JSON.parseObject((String)item2.getCostFormJson());
                log.info("costCompare-jsonObject:{}", (Object)jsonObject.toJSONString());
                JSONArray groups = jsonObject.getJSONArray("groups");
                if (groups != null) {
                    this.mergeCell(writer, firstRow, groups, item2, dictJsonObject);
                    for (int index = 0; index < groups.size(); ++index) {
                        JSONObject group = groups.getJSONObject(index);
                        writer.writeCellValue(12, firstRow + index, (Object)group.getString("groupName"));
                    }
                    int index2 = 0;
                    for (int index = groups.size(); index < groups.size() * 2; ++index) {
                        JSONObject group = groups.getJSONObject(index2);
                        writer.writeCellValue(12, firstRow + index, (Object)group.getString("groupName"));
                        ++index2;
                    }
                    int rows = groups.size() * 2 + 15;
                    firstRow += rows;
                }
            }
            ++i;
        }
        List collect1 = distinctList.stream().filter(item -> EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay()) && collect2.contains(item.getItemNumber()) && !ObjectUtils.isEmpty((Object)JSON.parseObject((String)item.getCostFormJson()).getJSONArray("groups"))).sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseEnquiryItem>(Comparator.comparing(PurchaseEnquiryItem::getItemNumber))), ArrayList::new));
        List collect3 = collect1.stream().filter(item -> collect2.contains(item.getItemNumber())).sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).collect(Collectors.toList());
        Map<String, Integer> collect = collect3.stream().collect(Collectors.toMap(PurchaseEnquiryItem::getItemNumber, item -> collect3.indexOf(item)));
        HashMap<String, Integer> stringHashMap = new HashMap<String, Integer>();
        for (PurchaseEnquiryItemHis item3 : itemHisList) {
            if (!StrUtil.isNotBlank((CharSequence)item3.getCostFormJson()) || !JSONObject.parseObject((String)item3.getCostFormJson()).containsKey((Object)"groups") || !collect.containsKey(item3.getItemNumber()) || stringHashMap.containsKey(item3.getItemNumber())) continue;
            JSONObject object = JSONObject.parseObject((String)item3.getCostFormJson());
            JSONArray groups1 = object.getJSONArray("groups") == null ? new JSONArray() : object.getJSONArray("groups");
            stringHashMap.put(item3.getItemNumber(), groups1.size());
        }
        HashMap<String, Integer> itemRow = new HashMap<String, Integer>();
        for (i = 0; i < collect.size(); ++i) {
            for (String s : collect.keySet()) {
                Integer integer = collect.get(s);
                if (i != integer) continue;
                if (i == 0) {
                    itemRow.put(s, 1);
                    continue;
                }
                int y = 1;
                for (String next : collect.keySet()) {
                    if (Integer.valueOf(next) >= Integer.valueOf(s)) continue;
                    Integer integer1 = (Integer)stringHashMap.get(next);
                    y = y + integer1 * 2 + 15;
                }
                itemRow.put(s, y);
            }
        }
        AtomicInteger x = new AtomicInteger(13);
        for (EnquirySupplierList supplier : supplierList) {
            List dataList = itemHisList.stream().sorted(Comparator.comparing(item -> Integer.valueOf(item.getItemNumber()))).filter(item -> StrUtil.isNotBlank((CharSequence)item.getCostFormJson())).filter(item -> !ObjectUtils.isEmpty((Object)JSON.parseObject((String)item.getCostFormJson()).getJSONArray("groups"))).filter(item -> EnquiryQuoteWayEnum.COST.getValue().equals(item.getQuotePriceWay())).filter(item -> supplier.getToElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
            Map<String, List<PurchaseEnquiryItemHis>> itemByNumberMap = dataList.stream().collect(Collectors.groupingBy(PurchaseEnquiryItemHis::getItemNumber));
            AtomicReference<AtomicInteger> y = new AtomicReference<AtomicInteger>(new AtomicInteger(1));
            int[] row = new int[]{0};
            AtomicInteger finalX1 = x;
            itemByNumberMap.forEach((itemNumber, v) -> {
                JSONArray groups1;
                if (v.size() > row[0]) {
                    row[0] = v.size();
                }
                List groups2 = v.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getCostFormJson()) && JSONObject.parseObject((String)item.getCostFormJson()).containsKey((Object)"groups")).collect(Collectors.toList());
                JSONObject jsonObject1 = JSONObject.parseObject((String)((PurchaseEnquiryItemHis)((Object)((Object)v.get(0)))).getCostFormJson());
                JSONArray jSONArray = groups1 = jsonObject1.getJSONArray("groups") == null ? new JSONArray() : jsonObject1.getJSONArray("groups");
                if (!CollectionUtils.isEmpty(groups2)) {
                    JSONObject object = JSONObject.parseObject((String)((PurchaseEnquiryItemHis)((Object)((Object)groups2.get(0)))).getCostFormJson());
                    groups1 = object.getJSONArray("groups") == null ? new JSONArray() : object.getJSONArray("groups");
                }
                int size = groups1.size();
                AtomicInteger finalX = new AtomicInteger(finalX1.get());
                int rows = size * 2 + 15;
                y.set(new AtomicInteger((Integer)itemRow.get(itemNumber)));
                v.stream().sorted(Comparator.comparing(PurchaseEnquiryItemHis::getQuoteCount)).forEach(item -> {
                    JSONObject jsonObject = JSONObject.parseObject((String)item.getCostFormJson());
                    JSONArray groups = jsonObject.getJSONArray("groups") == null ? new JSONArray() : jsonObject.getJSONArray("groups");
                    for (int index = 0; index < groups.size(); ++index) {
                        JSONObject group = groups.getJSONObject(index);
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + index, (Object)group.getBigDecimal("totalValue"));
                    }
                    int index2 = 0;
                    for (int index = groups.size(); index < groups.size() * 2; ++index) {
                        JSONObject group = groups.getJSONObject(index2);
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + index, (Object)group.getBigDecimal("netPrice").setScale(6));
                        ++index2;
                    }
                    if (!groups.isEmpty()) {
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + groups.size() * 2, (Object)item.getTaxRate());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + groups.size() * 2 + 1, item.getDeliveryDate() == null ? null : DateUtil.format((Date)item.getDeliveryDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + groups.size() * 2 + 2, item.getQuoteTime() == null ? null : DateUtil.format((Date)item.getQuoteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + groups.size() * 2 + 3, (Object)item.getMinPackQuantity());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + groups.size() * 2 + 4, (Object)item.getMinOrderQuantity());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + groups.size() * 2 + 5, item.getEffectiveDate() == null ? null : DateUtil.format((Date)item.getEffectiveDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + groups.size() * 2 + 6, item.getExpiryDate() == null ? null : DateUtil.format((Date)item.getExpiryDate(), (String)"yyyy-MM-dd"));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + groups.size() * 2 + 7, (Object)item.getQuoteCount());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + groups.size() * 2 + 8, headObject.get((Object)"payTermsCode_dictText"));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + groups.size() * 2 + 9, headObject.get((Object)"tradeCondition_dictText"));
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + groups.size() * 2 + 10, (Object)item.getHisMinPrice());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + groups.size() * 2 + 11, (Object)item.getSupplierHisMinPrice());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + groups.size() * 2 + 12, (Object)item.getSupplierSumAmount());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + groups.size() * 2 + 13, (Object)item.getSumQuantity());
                        writer.writeCellValue(finalX.get(), ((AtomicInteger)y.get()).get() + groups.size() * 2 + 14, (Object)item.getThreeMonthsSumAmount());
                        writer.setColumnWidth(finalX.get(), 16);
                    }
                    finalX.getAndIncrement();
                });
            });
            if (row[0] > 1) {
                writer.merge(0, 0, x.get(), x.addAndGet(row[0]) - 1, (Object)supplier.getSupplierName(), true);
                continue;
            }
            x.addAndGet(row[0]);
        }
    }

    private void mergeCell(ExcelWriter writer, int firstRow, JSONArray ladderOrGroups, PurchaseEnquiryItem item, JSONObject jsonObject) {
        writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 0, 0, (Object)item.getEnquiryNumber(), false);
        writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 1, 1, (Object)item.getItemNumber(), false);
        writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 2, 2, (Object)item.getMaterialNumber(), false);
        writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 3, 3, (Object)item.getMaterialName(), false);
        writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 4, 4, (Object)item.getMaterialDesc(), false);
        writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 5, 5, (Object)item.getMaterialSpec(), false);
        writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 6, 6, (Object)item.getRequireQuantity(), false);
        writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 7, 7, (Object)jsonObject.getString("purchaseUnit_dictText"), false);
        writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 8, 8, (Object)item.getFuturePrice(), false);
        writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 9, 9, (Object)jsonObject.getString("factory_dictText"), false);
        writer.merge(firstRow, 15 + firstRow + ladderOrGroups.size() * 2 - 1, 10, 10, (Object)jsonObject.getString("storageLocation_dictText"), false);
        this.getWriteRows(writer, firstRow, ladderOrGroups);
    }

    private void getWriteRows(ExcelWriter writer, int firstRow, JSONArray ladderOrGroups) {
        int row = ladderOrGroups.size() * 2;
        if (ladderOrGroups.size() > 1) {
            writer.merge(firstRow, firstRow + ladderOrGroups.size() - 1, 11, 11, (Object)"\u542b\u7a0e\u4ef7", false);
            writer.merge(firstRow + ladderOrGroups.size(), firstRow + ladderOrGroups.size() * 2 - 1, 11, 11, (Object)"\u672a\u7a0e\u4ef7", false);
        } else {
            writer.writeCellValue(11, firstRow, (Object)"\u542b\u7a0e\u4ef7");
            writer.writeCellValue(11, firstRow + ladderOrGroups.size(), (Object)"\u672a\u7a0e\u4ef7");
        }
        writer.merge(firstRow + row, firstRow + row, 11, 12, (Object)"\u7a0e\u7387", false);
        writer.merge(firstRow + row + 1, firstRow + row + 1, 11, 12, (Object)"\u4ea4\u8d27\u65e5\u671f", false);
        writer.merge(firstRow + row + 2, firstRow + row + 2, 11, 12, (Object)"\u62a5\u4ef7\u65f6\u95f4", false);
        writer.merge(firstRow + row + 3, firstRow + row + 3, 11, 12, (Object)"\u6700\u5c0f\u5305\u88c5\u91cf", false);
        writer.merge(firstRow + row + 4, firstRow + row + 4, 11, 12, (Object)"\u6700\u5c0f\u8ba2\u5355\u91cf", false);
        writer.merge(firstRow + row + 5, firstRow + row + 5, 11, 12, (Object)"\u4ef7\u683c\u751f\u6548\u65f6\u95f4", false);
        writer.merge(firstRow + row + 6, firstRow + row + 6, 11, 12, (Object)"\u4ef7\u683c\u5931\u6548\u65f6\u95f4", false);
        writer.merge(firstRow + row + 7, firstRow + row + 7, 11, 12, (Object)"\u62a5\u4ef7\u8f6e\u6b21", false);
        writer.merge(firstRow + row + 8, firstRow + row + 8, 11, 12, (Object)"\u4ed8\u6b3e\u6761\u4ef6", false);
        writer.merge(firstRow + row + 9, firstRow + row + 9, 11, 12, (Object)"\u56fd\u8d38\u6761\u4ef6", false);
        writer.merge(firstRow + row + 10, firstRow + row + 10, 11, 12, (Object)"\u5386\u53f2\u6700\u4f4e\u4ef7", false);
        writer.merge(firstRow + row + 11, firstRow + row + 11, 11, 12, (Object)"\u4f9b\u5e94\u5546\u5386\u53f2\u6700\u4f4e\u4ef7", false);
        writer.merge(firstRow + row + 12, firstRow + row + 12, 11, 12, (Object)"\u7d2f\u8ba1\u91c7\u8d2d\u989d", false);
        writer.merge(firstRow + row + 13, firstRow + row + 13, 11, 12, (Object)"\u7d2f\u8ba1\u91c7\u8d2d\u91cf", false);
        writer.merge(firstRow + row + 14, firstRow + row + 14, 11, 12, (Object)"\u8fd1\u4e09\u4e2a\u6708\u603b\u91c7\u8d2d\u989d", false);
    }

    private List<String> getHeaderList(List<EnquirySupplierList> supplierList, Map<String, Optional<PurchaseEnquiryItemHis>> eldestByClass, String ... headText) {
        ArrayList<String> excelHeader = new ArrayList<String>(Arrays.asList(headText));
        for (EnquirySupplierList supplier : supplierList) {
            if (eldestByClass.containsKey(supplier.getToElsAccount())) {
                Optional<PurchaseEnquiryItemHis> purchaseEnquiryItemHis = eldestByClass.get(supplier.getToElsAccount());
                Integer quoteCount = purchaseEnquiryItemHis.get().getQuoteCount();
                for (int i = 0; i < quoteCount; ++i) {
                    excelHeader.add(supplier.getSupplierName());
                }
                continue;
            }
            excelHeader.add(supplier.getSupplierName());
        }
        return excelHeader;
    }

    @Override
    public List<SupplierRelationFindResultVO> probeIP(List<PurchaseEnquiryItem> purchaseBiddingItemList) {
        ArrayList<SupplierRelationFindResultVO> result = new ArrayList<SupplierRelationFindResultVO>();
        List accountIpList = purchaseBiddingItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getQuoteIp())).map(item -> item.getToElsAccount() + "_" + item.getQuoteIp()).distinct().collect(Collectors.toList());
        Map<String, PurchaseEnquiryItem> supplierMap = purchaseBiddingItemList.stream().collect(Collectors.toMap(PurchaseEnquiryItem::getToElsAccount, Function.identity(), (supplier1, supplier2) -> supplier2));
        for (String sourceAccountIp : accountIpList) {
            for (String targetAccountIp : accountIpList) {
                if (sourceAccountIp.equals(targetAccountIp)) continue;
                CompareIPUtils.compareEnquiryIp(sourceAccountIp, targetAccountIp, supplierMap, result);
            }
        }
        return result;
    }

    @Override
    public List<PurchaseEnquiryItem> findBySourceItemId(List<String> headIdList, List<String> sourceIdList) {
        return ((PurchaseEnquiryItemMapper)this.baseMapper).findBySourceItemId(headIdList, sourceIdList);
    }

    private void initHeadMsg(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> items) {
        items.forEach(item -> {
            item.setPayTermsCode(head.getPayTermsCode());
            item.setTradeCondition(head.getTradeCondition());
        });
    }

    private void initHisMinPrice(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> items, Date pricedTime) {
        List<EnquiryItemPriceVO> priceVOs = ((PurchaseEnquiryItemMapper)this.baseMapper).hisMinPrice(head.getQuoteType(), items.get(0).getMaterialNumber(), pricedTime);
        if (QuoteTypeEnum.TAX_INCLUDING.getValue().equals(head.getQuoteType())) {
            List<String> currencies = priceVOs.stream().filter(priceVO -> StrUtil.isNotBlank((CharSequence)priceVO.getItemCurrency()) && !Objects.equals(priceVO.getItemCurrency(), head.getCurrency())).map(EnquiryItemPriceVO::getItemCurrency).collect(Collectors.toList());
            List<BpExchangeRateDTO> rates = this.mainDataRpcService.getRateByCurrencys(currencies, head.getCurrency());
            for (BpExchangeRateDTO rateDTO : rates) {
                if (rateDTO.getExchanged() == null) continue;
                for (EnquiryItemPriceVO priceVO2 : priceVOs) {
                    if (!Objects.equals(rateDTO.getOriginalCurrency(), priceVO2.getItemCurrency())) continue;
                    BigDecimal tempPrice = priceVO2.getPrice() == null ? BigDecimal.ZERO : priceVO2.getPrice();
                    BigDecimal result = tempPrice.multiply(rateDTO.getExchanged()).setScale(6, 4).stripTrailingZeros();
                    priceVO2.setPrice(result);
                }
            }
            priceVOs = priceVOs.stream().sorted(Comparator.comparing(EnquiryItemPriceVO::getPrice)).collect(Collectors.toList());
        }
        BigDecimal price = CollectionUtils.isEmpty(priceVOs) || priceVOs.get(0).getPrice() == null ? null : priceVOs.get(0).getPrice().stripTrailingZeros();
        for (PurchaseEnquiryItem item : items) {
            item.setHisMinPrice(price);
        }
    }

    private void initSupplierHisMinPrice(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> items, Date pricedTime) {
        List<String> toElsAccounts = items.stream().map(PurchaseEnquiryItem::getToElsAccount).collect(Collectors.toList());
        List<SupplierEnquiryItemPriceVO> priceVOS = ((PurchaseEnquiryItemMapper)this.baseMapper).supplierHisMinPrice(head.getQuoteType(), toElsAccounts, items.get(0).getMaterialNumber(), pricedTime);
        if (QuoteTypeEnum.TAX_INCLUDING.getValue().equals(head.getQuoteType())) {
            List<String> currencies = priceVOS.stream().filter(priceVO -> StrUtil.isNotBlank((CharSequence)priceVO.getItemCurrency()) && !Objects.equals(priceVO.getItemCurrency(), head.getCurrency())).map(SupplierEnquiryItemPriceVO::getItemCurrency).distinct().collect(Collectors.toList());
            List<BpExchangeRateDTO> rates = this.mainDataRpcService.getRateByCurrencys(currencies, head.getCurrency());
            for (BpExchangeRateDTO rateDTO : rates) {
                if (rateDTO.getExchanged() == null) continue;
                for (SupplierEnquiryItemPriceVO priceVO2 : priceVOS) {
                    if (!Objects.equals(rateDTO.getOriginalCurrency(), priceVO2.getItemCurrency())) continue;
                    BigDecimal tempPrice = priceVO2.getPrice() == null ? BigDecimal.ZERO : priceVO2.getPrice();
                    BigDecimal result = tempPrice.multiply(rateDTO.getExchanged()).setScale(6, 4).stripTrailingZeros();
                    priceVO2.setPrice(result);
                }
            }
        }
        Map<String, List<SupplierEnquiryItemPriceVO>> groupVOS = priceVOS.stream().collect(Collectors.groupingBy(item -> item.getToElsAccount()));
        for (PurchaseEnquiryItem item2 : items) {
            List<SupplierEnquiryItemPriceVO> tempVOS = groupVOS.get(item2.getToElsAccount());
            if (CollectionUtils.isEmpty(tempVOS)) continue;
            BigDecimal min = tempVOS.stream().map(SupplierEnquiryItemPriceVO::getPrice).min(BigDecimal::compareTo).get();
            item2.setSupplierHisMinPrice(min);
        }
    }

    private void sumAmount(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> items, String startTimeStr, Date pricedTime) {
        List<String> toElsAccounts = items.stream().map(PurchaseEnquiryItem::getToElsAccount).collect(Collectors.toList());
        DateTime startTime = null;
        if (StrUtil.isNotBlank((CharSequence)startTimeStr)) {
            startTime = DateUtil.parseDateTime((CharSequence)startTimeStr);
        }
        List<SupplierEnquiryItemAmountVO> amountVOS = ((PurchaseEnquiryItemMapper)this.baseMapper).supplierSumAmount(head.getQuoteType(), toElsAccounts, items.get(0).getMaterialNumber(), (Date)startTime, pricedTime);
        if (QuoteTypeEnum.TAX_INCLUDING.getValue().equals(head.getQuoteType())) {
            List<String> currencies = amountVOS.stream().filter(priceVO -> StrUtil.isNotBlank((CharSequence)priceVO.getItemCurrency()) && !Objects.equals(priceVO.getItemCurrency(), head.getCurrency())).map(SupplierEnquiryItemAmountVO::getItemCurrency).distinct().collect(Collectors.toList());
            List<BpExchangeRateDTO> rates = this.mainDataRpcService.getRateByCurrencys(currencies, head.getCurrency());
            for (BpExchangeRateDTO rateDTO : rates) {
                if (rateDTO.getExchanged() == null) continue;
                for (SupplierEnquiryItemAmountVO amountVO : amountVOS) {
                    if (!Objects.equals(rateDTO.getOriginalCurrency(), amountVO.getItemCurrency())) continue;
                    BigDecimal tempPrice = amountVO.getSumAmount() == null ? BigDecimal.ZERO : amountVO.getSumAmount();
                    BigDecimal result = tempPrice.multiply(rateDTO.getExchanged()).setScale(6, 4).stripTrailingZeros();
                    amountVO.setSumAmount(result);
                }
            }
        }
        Map<String, BigDecimal> sumGroup = amountVOS.stream().collect(Collectors.groupingBy(SupplierEnquiryItemAmountVO::getToElsAccount, Collectors.mapping(SupplierEnquiryItemAmountVO::getSumAmount, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        for (PurchaseEnquiryItem item : items) {
            BigDecimal sumAmount;
            BigDecimal bigDecimal = sumAmount = sumGroup.get(item.getToElsAccount()) == null ? null : sumGroup.get(item.getToElsAccount()).stripTrailingZeros();
            if (startTime == null) {
                item.setSupplierSumAmount(sumAmount);
                continue;
            }
            item.setThreeMonthsSumAmount(sumAmount);
        }
    }

    private void threeMonthsSumAmount(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> items, Date pricedTime) {
        LocalDateTime localDateTime = LocalDateTimeUtil.of((Date)pricedTime);
        String startTime = LocalDateTimeUtil.format((LocalDateTime)localDateTime.minusMonths(3L), (String)"yyyy-MM-dd HH:mm:ss");
        this.sumAmount(head, items, startTime, pricedTime);
    }

    private void sumQuantity(List<PurchaseEnquiryItem> items, Date pricedTime) {
        List<String> toElsAccounts = items.stream().map(PurchaseEnquiryItem::getToElsAccount).collect(Collectors.toList());
        List<SupplierEnquiryItemQuantityVO> quantityVOS = ((PurchaseEnquiryItemMapper)this.baseMapper).supplierSumQuantity(toElsAccounts, items.get(0).getMaterialNumber(), pricedTime);
        List<PurchaseMaterialUnitNewDTO> materialUnits = this.mainDataRpcService.getByMaterialNumber(items.get(0).getMaterialNumber());
        for (SupplierEnquiryItemQuantityVO quantityVO : quantityVOS) {
            if (Objects.equals(quantityVO.getPurchaseUnit(), items.get(0).getPurchaseUnit())) continue;
            for (PurchaseMaterialUnitNewDTO dto : materialUnits) {
                BigDecimal basicAmount;
                BigDecimal quantity = quantityVO.getQuantities() == null ? BigDecimal.ZERO : quantityVO.getQuantities();
                BigDecimal objectAmount = dto.getObjectAmount() == null ? BigDecimal.ONE : dto.getObjectAmount();
                BigDecimal bigDecimal = basicAmount = dto.getBasicAmount() == null ? BigDecimal.ONE : dto.getBasicAmount();
                if (Objects.equals(quantityVO.getPurchaseUnit(), dto.getObjectUnit()) && Objects.equals(items.get(0).getPurchaseUnit(), dto.getBasicUnit())) {
                    quantity = quantity.multiply(basicAmount).divide(objectAmount, 6, RoundingMode.HALF_UP);
                }
                if (Objects.equals(quantityVO.getPurchaseUnit(), dto.getBasicUnit()) && Objects.equals(items.get(0).getPurchaseUnit(), dto.getObjectUnit())) {
                    quantity = quantity.multiply(objectAmount).divide(basicAmount, 6, RoundingMode.HALF_UP);
                }
                quantityVO.setQuantities(quantity);
            }
        }
        Map<String, BigDecimal> sumGroup = quantityVOS.stream().collect(Collectors.groupingBy(SupplierEnquiryItemQuantityVO::getToElsAccount, Collectors.mapping(SupplierEnquiryItemQuantityVO::getQuantities, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        for (PurchaseEnquiryItem item : items) {
            BigDecimal sumQuantity = sumGroup.get(item.getToElsAccount()) == null ? null : sumGroup.get(item.getToElsAccount()).stripTrailingZeros();
            item.setSumQuantity(sumQuantity);
        }
    }

    @Override
    public void initCompareMsg(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> items) {
        if (CollectionUtils.isEmpty(items) || StrUtil.isBlank((CharSequence)items.get(0).getMaterialNumber())) {
            return;
        }
        Date pricedTime = head.getPricedTime() != null ? head.getPricedTime() : new Date();
        this.initHeadMsg(head, items);
        this.initHisMinPrice(head, items, pricedTime);
        this.initSupplierHisMinPrice(head, items, pricedTime);
        this.sumAmount(head, items, null, pricedTime);
        this.threeMonthsSumAmount(head, items, pricedTime);
        this.sumQuantity(items, pricedTime);
    }

    @Override
    public void initPackageCompareMsg(PurchaseEnquiryHead head, List<PurchaseEnquiryItem> items) {
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        this.initHeadMsg(head, items);
        List toElsAccounts = items.stream().map(PurchaseEnquiryItem::getToElsAccount).collect(Collectors.toList());
        List dtos = ((SupplierMasterDataRpcService)SrmRpcUtil.getExecuteServiceImpl(SupplierMasterDataRpcService.class)).selectSupplerList(TenantContext.getTenant(), toElsAccounts);
        block0: for (PurchaseEnquiryItem item : items) {
            for (SupplierMasterDataDTO dto : dtos) {
                if (!Objects.equals(item.getToElsAccount(), dto.getToElsAccount())) continue;
                item.setSupplierStatus(dto.getSupplierStatus());
                continue block0;
            }
        }
    }
}

